/*
 * Decompiled with CFR 0.152.
 */
package com.yy.videoplayer;

import android.os.Build;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Message;
import com.yy.videoplayer.decoder.Coordinate;
import com.yy.videoplayer.decoder.SmoothnessCounter;
import com.yy.videoplayer.decoder.StateMonitor;
import com.yy.videoplayer.decoder.ViewLiveStatManager;
import com.yy.videoplayer.decoder.YYVideoLibMgr;
import com.yy.videoplayer.render.VideoRenderNotify;
import com.yy.videoplayer.stat.VideoDataStatHelper;
import com.yy.videoplayer.stat.VideoPlayerDataStat;
import com.yy.videoplayer.utils.TimeUtil;
import com.yy.videoplayer.utils.YMFLog;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

public class YMFEventManager {
    private static String TAG = "YMFEventManager";
    private static YMFEventManager mInstance = new YMFEventManager();
    private static final long NOTIFY_TIME_GAP = 500L;
    private static final long NOTIFY_SIZE_GAP = 15L;
    private static final int MSG_QUIT = 0;
    private static final int MSG_NOTIFY_RENDER = 1;
    private static final int MSG_NOTIFY_SIZE = 2;
    private boolean mNotifyRenderInfoByInterval = false;
    private Handler mHandler;
    private HandlerThread mThread;
    private ArrayList<VideoRenderNotify> mVideoRenderNotifys;
    private HashMap<Long, Boolean> mStreamFirstRenderFlagMap;
    private HashMap<Long, Integer> mStreamRenderCountMap;
    private HashMap<Long, Long> mStreamRtsMap;
    private HashMap<Long, Coordinate.Size> mStreamSizeMap;
    private SmoothnessCounter mSmoothnessCounter = new SmoothnessCounter(5000L);

    public static YMFEventManager instance() {
        return mInstance;
    }

    public void notifyStreamStart(long streamId) {
        this.mStreamFirstRenderFlagMap.put(streamId, false);
        this.mStreamRenderCountMap.put(streamId, 0);
        this.mStreamRtsMap.put(streamId, 0L);
    }

    public void notifyStreamEnd(long streamId) {
        this.mStreamFirstRenderFlagMap.remove(streamId);
        this.mStreamRenderCountMap.remove(streamId);
        this.mStreamRtsMap.remove(streamId);
        this.mStreamSizeMap.remove(streamId);
        VideoPlayerDataStat.getInstance().clearVideoRenderPtsStatistics(streamId);
        ViewLiveStatManager.getInstace().notifyEventTime(4, 5);
    }

    public void notifyRenderEvnet(long streamId, long pts, long dts, long rts, int rct) {
        VideoRenderNotify notify = new VideoRenderNotify(0L, streamId, pts, rts, dts);
        Message msg = this.mHandler.obtainMessage(1);
        msg.what = 1;
        msg.obj = notify;
        msg.arg1 = rct;
        this.mHandler.sendMessage(msg);
    }

    private void notifyRenderFrameRate(long streamId, long rts) {
        if (this.mStreamRenderCountMap.containsKey(streamId)) {
            int renderCount = this.mStreamRenderCountMap.get(streamId) + 1;
            this.mStreamRenderCountMap.put(streamId, renderCount);
            if (!this.mStreamRtsMap.containsKey(streamId)) {
                this.mStreamRtsMap.put(streamId, rts);
            }
            if (rts - this.mStreamRtsMap.get(streamId) >= 1000L) {
                StateMonitor.instance().NotifyRenderFrameRate(streamId, renderCount);
                this.mStreamRtsMap.put(streamId, rts);
                this.mStreamRenderCountMap.put(streamId, 0);
            }
        }
    }

    private void onRenderEventNotify(VideoRenderNotify notify, int rct) {
        long streamId = notify.mStreamId;
        long rts = notify.mRenderStamp;
        long pts = notify.mPts;
        this.mVideoRenderNotifys.add(notify);
        if (this.mNotifyRenderInfoByInterval) {
            Iterator<VideoRenderNotify> it = this.mVideoRenderNotifys.iterator();
            if (!it.hasNext()) {
                return;
            }
            long firstPts = it.next().mPts;
            if (notify.mPts - firstPts < 500L && (long)this.mVideoRenderNotifys.size() < 15L) {
                return;
            }
        }
        YYVideoLibMgr.instance().onVideoRenderNotify(this.mVideoRenderNotifys);
        this.mVideoRenderNotifys.clear();
        YYVideoLibMgr.instance().onUpdatePts(streamId, pts);
        StateMonitor.NotifyPts(streamId, pts);
        VideoDataStatHelper.putRenderTime(rct);
        this.notifyRenderFrameRate(streamId, rts);
        Boolean render = this.mStreamFirstRenderFlagMap.get(streamId);
        if (render != null && !render.booleanValue()) {
            YYVideoLibMgr.instance().onFirstFrameRenderNotify(0L, streamId, rts, notify.mRenderStamp - (long)notify.mDecodeStamp, 0);
            YMFLog.info(this, "[Render  ]", "onFirstFrameRenderNotify streamId:" + streamId + ",now " + TimeUtil.getTickCountLong() + ",pts:" + pts);
            StateMonitor.NotifyFirstFrameRendered(streamId, rts);
            Coordinate.Size size = this.mStreamSizeMap.get(streamId);
            if (size != null) {
                ViewLiveStatManager.getInstace().notifyEventTime(2, 5, new ViewLiveStatManager.StatVideoHeaderInfo(size.getWidth(), size.getHeight()));
            }
            this.mStreamFirstRenderFlagMap.put(streamId, true);
        }
        if (this.mSmoothnessCounter.RenderOneFrame(streamId, rts)) {
            double coef = this.mSmoothnessCounter.ComputeCoefficientOfVariationAndReset();
            YYVideoLibMgr.instance().onCoefficientOfVariationOfRenderInterval(0L, streamId, this.mSmoothnessCounter.GetIntervalMilliTs(), coef);
        }
    }

    public void notifyVideoSize(long streamId, int width, int height) {
        Message msg = this.mHandler.obtainMessage(2);
        msg.what = 2;
        msg.arg1 = width;
        msg.arg2 = height;
        msg.obj = streamId;
        this.mHandler.sendMessage(msg);
    }

    private void onVideoSizeChange(long streamId, int width, int height) {
        YYVideoLibMgr.instance().onUpdateVideoSizeChanged(streamId, width, height);
        this.mStreamSizeMap.put(streamId, new Coordinate.Size(width, height));
    }

    public YMFEventManager() {
        this.mVideoRenderNotifys = new ArrayList();
        this.mStreamFirstRenderFlagMap = new HashMap();
        this.mStreamRenderCountMap = new HashMap();
        this.mStreamRtsMap = new HashMap();
        this.mStreamSizeMap = new HashMap();
        this.mSmoothnessCounter.ResetToInitialState();
        this.mThread = new HandlerThread(TAG);
        this.mThread.start();
        this.mHandler = new Handler(this.mThread.getLooper()){

            public void handleMessage(Message msg) {
                try {
                    switch (msg.what) {
                        case 1: {
                            YMFEventManager.this.onRenderEventNotify((VideoRenderNotify)msg.obj, msg.arg1);
                            break;
                        }
                        case 2: {
                            YMFEventManager.this.onVideoSizeChange((Long)msg.obj, msg.arg1, msg.arg2);
                            break;
                        }
                    }
                }
                catch (Exception e) {
                    YMFLog.error((Object)this, "[Render  ]", "YMFEventManager handler exception:" + e.getMessage());
                }
            }
        };
    }

    public void release() {
        if (this.mHandler != null) {
            this.mHandler.removeCallbacksAndMessages(null);
            if (Build.VERSION.SDK_INT >= 18) {
                this.mThread.quitSafely();
            } else {
                this.mThread.quit();
            }
            this.mHandler = null;
            this.mThread = null;
        }
    }
}

