/*
 * Decompiled with CFR 0.152.
 */
package com.yy.videoplayer.vr.util;

import android.graphics.PointF;
import android.hardware.SensorEvent;
import android.hardware.SensorManager;
import android.opengl.Matrix;
import android.os.Looper;
import com.yy.videoplayer.utils.YMFLog;

public class VRUtil {
    private static final String TAG = "VRUtil";
    private static float[] sUIThreadTmp = new float[16];
    private static float[] sGLThreadTmp = new float[16];
    public static final float sNotHit = Float.MAX_VALUE;
    private static float[] sTruncatedVector = new float[4];
    private static boolean sIsTruncated = false;

    public static void sensorRotationVector2Matrix(SensorEvent event, int rotation, float[] output) {
        if (!sIsTruncated) {
            try {
                SensorManager.getRotationMatrixFromVector((float[])sUIThreadTmp, (float[])event.values);
            }
            catch (Exception e) {
                YMFLog.error((Object)TAG, "maybe SamSung Android 4.3 bug , will truncate vector");
                sIsTruncated = true;
            }
        }
        float[] values = null;
        if (sIsTruncated) {
            System.arraycopy(event.values, 0, sTruncatedVector, 0, 4);
            SensorManager.getRotationMatrixFromVector((float[])sUIThreadTmp, (float[])sTruncatedVector);
            values = sTruncatedVector;
        } else {
            values = event.values;
        }
        try {
            switch (rotation) {
                case 0: 
                case 2: {
                    SensorManager.getRotationMatrixFromVector((float[])output, (float[])values);
                    break;
                }
                case 1: {
                    SensorManager.getRotationMatrixFromVector((float[])sUIThreadTmp, (float[])values);
                    SensorManager.remapCoordinateSystem((float[])sUIThreadTmp, (int)2, (int)129, (float[])output);
                    break;
                }
                case 3: {
                    SensorManager.getRotationMatrixFromVector((float[])sUIThreadTmp, (float[])values);
                    SensorManager.remapCoordinateSystem((float[])sUIThreadTmp, (int)130, (int)1, (float[])output);
                }
            }
            Matrix.rotateM((float[])output, (int)0, (float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        }
        catch (Exception e) {
            YMFLog.error((Object)TAG, "[VR] SensorManager.getRotationMatrixFromVector occurred exception!!!!!!!!");
        }
    }

    public static void notNull(Object object, String error) {
        if (object == null) {
            throw new RuntimeException(error);
        }
    }

    public static void checkMainThread(String error) {
        if (Looper.getMainLooper() != Looper.myLooper()) {
            throw new RuntimeException(error);
        }
    }

    public static void checkGLThread(String error) {
        if (Looper.getMainLooper() == Looper.myLooper()) {
            throw new RuntimeException(error);
        }
    }

    public static void barrelDistortion(double paramA, double paramB, double paramC, PointF src) {
        double paramD = 1.0 - paramA - paramB - paramC;
        float d = 1.0f;
        double centerX = 0.0;
        double centerY = 0.0;
        if ((double)src.x == centerX && (double)src.y == centerY) {
            return;
        }
        double deltaX = ((double)src.x - centerX) / (double)d;
        double deltaY = ((double)src.y - centerY) / (double)d;
        double dstR = Math.sqrt(deltaX * deltaX + deltaY * deltaY);
        double srcR = (paramA * dstR * dstR * dstR + paramB * dstR * dstR + paramC * dstR + paramD) * dstR;
        double factor = Math.abs(dstR / srcR);
        float xResult = (float)(centerX + deltaX * factor * (double)d);
        float yResult = (float)(centerY + deltaY * factor * (double)d);
        src.set(xResult, yResult);
    }

    public static boolean invertM(float[] output, float[] input) {
        if (input == output) {
            return false;
        }
        return Matrix.invertM((float[])output, (int)0, (float[])input, (int)0);
    }
}

