/*
 * Decompiled with CFR 0.152.
 */
package com.yy.videoplayer.vr.util;

import android.app.ActivityManager;
import android.content.Context;
import android.content.pm.ConfigurationInfo;
import android.opengl.GLES20;
import android.opengl.GLUtils;
import com.yy.videoplayer.utils.YMFLog;
import com.yy.videoplayer.vr.VRAbsObject3D;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.util.ArrayList;

public class GLUtil {
    private static final String TAG = "GLUtil";

    public static boolean supportsEs2(Context context) {
        ActivityManager activityManager = (ActivityManager)context.getSystemService("activity");
        ConfigurationInfo configurationInfo = activityManager.getDeviceConfigurationInfo();
        boolean supportsEs2 = configurationInfo.reqGlEsVersion >= 131072;
        return supportsEs2;
    }

    public static void glCheck(String op) {
        int error;
        while ((error = GLES20.glGetError()) != 0) {
            YMFLog.error((Object)TAG, op + ": glError " + GLUtils.getEGLErrorString((int)error));
        }
    }

    public static String readTextFileFromRaw(Context context, int resourceId) {
        InputStream inputStream = context.getResources().openRawResource(resourceId);
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
        BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
        StringBuilder body = new StringBuilder();
        try {
            String nextLine;
            while ((nextLine = bufferedReader.readLine()) != null) {
                body.append(nextLine);
                body.append('\n');
            }
        }
        catch (IOException e) {
            return null;
        }
        return body.toString();
    }

    public static void loadObject3D(Context context, int resourceId, VRAbsObject3D output) {
        ArrayList<String> vertexes = new ArrayList<String>();
        ArrayList<String> textures = new ArrayList<String>();
        ArrayList<String> faces = new ArrayList<String>();
        InputStream iStream = context.getResources().openRawResource(resourceId);
        InputStreamReader isr = new InputStreamReader(iStream);
        BufferedReader bReader = new BufferedReader(isr);
        try {
            String line;
            while ((line = bReader.readLine()) != null) {
                if (line.startsWith("v ")) {
                    vertexes.add(line.substring(2));
                }
                if (line.startsWith("vt ")) {
                    textures.add(line.substring(3));
                }
                if (!line.startsWith("f ")) continue;
                faces.add(line.substring(2));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        float[] vertexBuffer = new float[faces.size() * 3 * 3];
        float[] textureBuffer = new float[faces.size() * 3 * 2];
        short[] indexBuffer = new short[faces.size() * 3];
        int vertexIndex = 0;
        int textureIndex = 0;
        int faceIndex = 0;
        for (String i : faces) {
            for (String j : i.split(" ")) {
                indexBuffer[faceIndex] = (short)faceIndex++;
                String[] faceComponent = j.split("/");
                String vertex = (String)vertexes.get(Integer.parseInt(faceComponent[0]) - 1);
                String texture = (String)textures.get(Integer.parseInt(faceComponent[1]) - 1);
                String[] vertexComp = vertex.split(" ");
                String[] textureComp = texture.split(" ");
                for (String v : vertexComp) {
                    vertexBuffer[vertexIndex++] = Float.parseFloat(v);
                }
                for (String t : textureComp) {
                    textureBuffer[textureIndex++] = Float.parseFloat(t);
                }
            }
        }
        FloatBuffer vertex = ByteBuffer.allocateDirect(vertexBuffer.length * 4).order(ByteOrder.nativeOrder()).asFloatBuffer().put(vertexBuffer);
        vertex.position(0);
        FloatBuffer texture = ByteBuffer.allocateDirect(textureBuffer.length * 4).order(ByteOrder.nativeOrder()).asFloatBuffer().put(textureBuffer);
        texture.position(0);
        output.setVerticesBuffer(0, vertex);
        output.setVerticesBuffer(1, vertex);
        output.setTexCoordinateBuffer(0, texture);
        output.setTexCoordinateBuffer(1, texture);
        output.setNumIndices(indexBuffer.length);
    }

    public static int compileShader(int shaderType, String shaderSource) {
        int shaderHandle = GLES20.glCreateShader((int)shaderType);
        if (shaderHandle != 0) {
            GLES20.glShaderSource((int)shaderHandle, (String)shaderSource);
            GLES20.glCompileShader((int)shaderHandle);
            int[] compileStatus = new int[1];
            GLES20.glGetShaderiv((int)shaderHandle, (int)35713, (int[])compileStatus, (int)0);
            if (compileStatus[0] == 0) {
                YMFLog.error((Object)TAG, "Error compiling shader: " + GLES20.glGetShaderInfoLog((int)shaderHandle));
                GLES20.glDeleteShader((int)shaderHandle);
                shaderHandle = 0;
            }
        }
        if (shaderHandle == 0) {
            throw new RuntimeException("Error creating shader.");
        }
        return shaderHandle;
    }

    public static int createAndLinkProgram(int vertexShaderHandle, int fragmentShaderHandle, String[] attributes) {
        int programHandle = GLES20.glCreateProgram();
        if (programHandle != 0) {
            GLES20.glAttachShader((int)programHandle, (int)vertexShaderHandle);
            GLES20.glAttachShader((int)programHandle, (int)fragmentShaderHandle);
            if (attributes != null) {
                int size = attributes.length;
                for (int i = 0; i < size; ++i) {
                    GLES20.glBindAttribLocation((int)programHandle, (int)i, (String)attributes[i]);
                }
            }
            GLES20.glLinkProgram((int)programHandle);
            int[] linkStatus = new int[1];
            GLES20.glGetProgramiv((int)programHandle, (int)35714, (int[])linkStatus, (int)0);
            if (linkStatus[0] == 0) {
                YMFLog.error((Object)TAG, "Error compiling program: " + GLES20.glGetProgramInfoLog((int)programHandle));
                GLES20.glDeleteProgram((int)programHandle);
                programHandle = 0;
            }
        }
        if (programHandle == 0) {
            throw new RuntimeException("Error creating program.");
        }
        return programHandle;
    }
}

