/*
 * Decompiled with CFR 0.152.
 */
package com.yy.videoplayer.vr;

import android.os.Looper;
import com.yy.videoplayer.utils.YMFLog;
import com.yy.videoplayer.vr.VRDirector;
import java.util.Queue;
import java.util.concurrent.LinkedBlockingQueue;

public class VRGLHandler {
    private boolean died;
    private Queue<Runnable> mAddQueue = new LinkedBlockingQueue<Runnable>();
    private Queue<Runnable> mWorkQueue = new LinkedBlockingQueue<Runnable>();
    private final Object addLock = new Object();
    private static volatile VRGLHandler mInstance;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static synchronized VRGLHandler getInstance() {
        if (mInstance != null) return mInstance;
        Class<VRDirector> clazz = VRDirector.class;
        synchronized (VRDirector.class) {
            if (mInstance != null) return mInstance;
            mInstance = new VRGLHandler();
            // ** MonitorExit[var0] (shouldn't be in output)
            return mInstance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void post(Runnable runnable) {
        if (this.died) {
            return;
        }
        if (runnable == null) {
            return;
        }
        if (Looper.getMainLooper() == Looper.myLooper()) {
            Object object = this.addLock;
            synchronized (object) {
                this.mAddQueue.remove(runnable);
                this.mAddQueue.offer(runnable);
            }
        } else {
            runnable.run();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dealMessage() {
        Object object = this.addLock;
        synchronized (object) {
            this.mWorkQueue.addAll(this.mAddQueue);
            this.mAddQueue.clear();
        }
        while (this.mWorkQueue.size() > 0) {
            Runnable runnable = this.mWorkQueue.poll();
            runnable.run();
        }
    }

    public void markAsDestroy() {
        YMFLog.info(this, "[Render][VR]--markAsDestroy");
        this.died = true;
    }

    public void markAsInitialize() {
        YMFLog.info(this, "[Render][VR]--markAsInitialize");
        this.died = false;
    }
}

