/*
 * Decompiled with CFR 0.152.
 */
package com.yy.videoplayer.vr;

import android.content.Context;
import android.content.res.Resources;
import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import android.opengl.Matrix;
import android.view.WindowManager;
import com.yy.videoplayer.utils.YMFLog;
import com.yy.videoplayer.vr.VRDirector;
import com.yy.videoplayer.vr.VRGLHandler;
import com.yy.videoplayer.vr.util.VRUtil;

public class MotionWithTouchStrategy
implements SensorEventListener {
    private static final String TAG = "MotionWithTouchStrategy";
    private static final float sDensity = Resources.getSystem().getDisplayMetrics().density;
    private static final float sDamping = 0.2f;
    private boolean mRegistered = false;
    private Boolean mIsSupport = null;
    private int mDeviceRotation;
    private Context context;
    private float[] mSensorMatrix = new float[16];
    private float[] mTmpMatrix = new float[16];
    private float[] mResultMatrix = new float[16];
    private final Object mMatrixLock = new Object();

    public MotionWithTouchStrategy(Context context) {
        this.context = context.getApplicationContext();
        VRDirector.getInstance().setMotionWithTouchStrategy(this);
        Matrix.setIdentityM((float[])this.mSensorMatrix, (int)0);
        Matrix.setIdentityM((float[])this.mTmpMatrix, (int)0);
        Matrix.setIdentityM((float[])this.mResultMatrix, (int)0);
    }

    public void enableSensor() {
        YMFLog.info(this, "[VR] enableSensor");
        this.registerSensor();
        this.resetDirectorMatrix();
    }

    public void disableSensor() {
        YMFLog.info(this, "[VR] disableSensor");
        this.unregisterSensor();
    }

    protected void registerSensor() {
        if (this.mRegistered) {
            return;
        }
        SensorManager mSensorManager = (SensorManager)this.context.getSystemService("sensor");
        Sensor sensor = mSensorManager.getDefaultSensor(11);
        if (sensor == null) {
            YMFLog.error((Object)TAG, "[VR]TYPE_ROTATION_VECTOR sensor not support!");
            return;
        }
        mSensorManager.registerListener((SensorEventListener)this, sensor, 0);
        this.mRegistered = true;
    }

    protected void unregisterSensor() {
        if (!this.mRegistered) {
            return;
        }
        SensorManager mSensorManager = (SensorManager)this.context.getSystemService("sensor");
        mSensorManager.unregisterListener((SensorEventListener)this);
        this.mRegistered = false;
    }

    public boolean isSensorSupport() {
        if (this.mIsSupport == null) {
            SensorManager mSensorManager = (SensorManager)this.context.getSystemService("sensor");
            Sensor sensor = mSensorManager.getDefaultSensor(11);
            this.mIsSupport = sensor != null;
            YMFLog.info(TAG, "[VR] TYPE_ROTATION_VECTOR sensor support: " + this.mIsSupport);
        }
        return this.mIsSupport;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onSensorChanged(SensorEvent event) {
        this.mDeviceRotation = ((WindowManager)this.context.getSystemService("window")).getDefaultDisplay().getRotation();
        if (event.accuracy != 0) {
            int type = event.sensor.getType();
            switch (type) {
                case 11: {
                    VRUtil.sensorRotationVector2Matrix(event, this.mDeviceRotation, this.mSensorMatrix);
                    Object object = this.mMatrixLock;
                    synchronized (object) {
                        System.arraycopy(this.mSensorMatrix, 0, this.mTmpMatrix, 0, 16);
                        break;
                    }
                }
            }
        }
    }

    public void onAccuracyChanged(Sensor sensor, int accuracy) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float[] getSensorMatrix() {
        Object object = this.mMatrixLock;
        synchronized (object) {
            System.arraycopy(this.mTmpMatrix, 0, this.mResultMatrix, 0, 16);
        }
        return this.mResultMatrix;
    }

    public void handleDrag(final float distanceX, final float distanceY) {
        VRGLHandler.getInstance().post(new Runnable(){

            @Override
            public void run() {
                VRDirector.getInstance().setDeltaX(VRDirector.getInstance().getDeltaX() - distanceX / sDensity * 0.2f);
                VRDirector.getInstance().setDeltaY(VRDirector.getInstance().getDeltaY() - distanceY / sDensity * 0.2f);
            }
        });
    }

    public void handlePinch(final float scale) {
        VRGLHandler.getInstance().post(new Runnable(){

            @Override
            public void run() {
                VRDirector.getInstance().updateProjectionNearScale(scale);
            }
        });
    }

    public boolean isSensorEnabled() {
        return this.mRegistered;
    }

    public void resetDirectorMatrix() {
        VRDirector.getInstance().resetMatrix();
    }

    public void setDirectorScaleParam(float scale) {
        VRDirector.getInstance().setScaleParam(scale);
    }

    public float getVrScaleParam() {
        return VRDirector.getInstance().getScaleParam();
    }
}

