/*
 * Decompiled with CFR 0.152.
 */
package com.yy.videoplayer.videoview;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Rect;
import android.graphics.RectF;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.util.AttributeSet;
import android.view.Surface;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import com.yy.videoplayer.decoder.PlayNotify;
import com.yy.videoplayer.decoder.StateMonitor;
import com.yy.videoplayer.decoder.VideoConstant;
import com.yy.videoplayer.decoder.YYVideoLibMgr;
import com.yy.videoplayer.render.YYRenderFrameBuffer;
import com.yy.videoplayer.utils.TimeUtil;
import com.yy.videoplayer.utils.YMFLog;
import com.yy.videoplayer.videoview.IVideoInfoCallback;
import com.yy.videoplayer.videoview.VideoPosition;
import com.yy.videoplayer.videoview.VsyncRelay;
import com.yy.videoplayer.videoview.YMultiVideoViewParams;
import com.yy.videoplayer.videoview.YSpVideoView;
import com.yy.videoplayer.videoview.YspVideoViewInfo;
import java.lang.ref.WeakReference;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

public class YVideoViewMultiVideo
extends SurfaceView
implements SurfaceHolder.Callback,
Runnable,
VsyncRelay.VsyncNotifier,
YSpVideoView {
    public static final String TAG = "YVideoViewMultiVideo";
    public static final int MSG_QUIT = 0;
    private static final int MSG_SURFACE_REDRAWNEEDED = 1;
    private static final int MSG_SURFACE_CREATED = 2;
    private static final int MSG_SURFACE_CHANGED = 3;
    private static final int MSG_SURFACE_DESTROYED = 4;
    private static final int MSG_SET_SCALEMODE = 5;
    private static final int MSG_GET_SCREENSHOT = 6;
    private static final int MSG_SET_PLAYLISTENER = 7;
    private static final int MSG_LINKTOSTREAM = 8;
    private static final int MSG_UNLINKTOSTREAM = 9;
    private static final int MSG_SET_ORIENTATION = 10;
    private static final int MSG_VSYNC_ARRIVED = 11;
    private static final int MSG_LINKTOSTREAMEXT = 12;
    private static final int MSG_UNLINKTOSTREAMEXT = 13;
    private long[] context;
    private int bgColor = 0;
    private Bitmap[] drawBmp;
    private ByteBuffer[] bmpByteBuffer;
    protected int picWidth = 0;
    protected int picHeight = 0;
    PlayNotify playNotify;
    VideoConstant.ScaleMode[] mScaleMode;
    boolean mAutoOrientation = false;
    boolean mIsReleased = false;
    private long[] mStreamId;
    private long[] mGroupId;
    private int[] mRenderCnt;
    private long[] mCurTime;
    private long[] mLastTime;
    private IVideoInfoCallback mVideoInfoCallback = null;
    private int mViewWidth;
    private int mViewHeight;
    private int mRowCnt;
    private int mColCnt;
    private int mTotalVideoCnt;
    private VideoPosition[] mDrawPosition;
    private boolean[] mFrameArrived;
    private int[] picRealWidth;
    private Object[] mLock;
    private Thread mThread;
    private RenderHandler mHandler;
    private AtomicBoolean mReady = new AtomicBoolean(false);
    private final Object mStartLock = new Object();
    private final Object mQuitLock = new Object();
    private final Object mScreenShotLock = new Object();
    private Bitmap mBackgroundBitmap = null;
    Canvas mDrawCanvas = null;
    private VideoPosition mBackgroundPosition;
    private Rect mBackgroundSrc;
    private Rect mBackgroundDst;
    private boolean[] mFirstFrameSeeFlag;
    private long[] mFirstFrameArrivedTime;
    private long[] mLastStatisticsTime;
    private AtomicInteger[] mMissRenderFrameCount;
    private AtomicBoolean[] mFrameRendered;
    long vsyncT = 0L;
    long vsyncCnt = 0L;
    long index = 0L;
    public static final int kScaleModeFillParent = 0;
    public static final int kScaleModeAspectFit = 1;
    public static final int kScaleModeClipToBounds = 2;
    public static final int kRotateAngle0 = 0;
    public static final int kRotateAngle90 = 1;
    public static final int kRotateAngle180 = 2;
    public static final int kRotateAngle270 = 3;
    private static final int kSurfaceCreated = 0;
    private static final int kSurfaceDestroyed = 1;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            Looper.prepare();
            this.mHandler = new RenderHandler(this);
            this.init(null, true);
            this.mReady.set(true);
            YMFLog.info(this, "[Render]YVideoViewMultiVideo construct done ");
            Object object = this.mStartLock;
            synchronized (object) {
                this.mStartLock.notifyAll();
            }
            Looper.loop();
            this.mReady.set(false);
        }
        catch (Throwable t) {
            YMFLog.error((Object)this, "[Render]YVideoViewMultiVideo end looper throwable " + t.getMessage());
        }
        finally {
            YMFLog.info(this, "[Render]YVideoViewMultiVideo end ");
            try {
                this.deInit();
            }
            catch (Throwable t) {
                YMFLog.error((Object)this, "[Render]YVideoViewMultiVideo throwable " + t.getMessage());
            }
            Object t = this.mQuitLock;
            synchronized (t) {
                this.mQuitLock.notifyAll();
            }
        }
    }

    boolean checkFrameArrived() {
        for (int i = 0; i < this.mTotalVideoCnt; ++i) {
            if (!this.mFrameArrived[i]) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleOnVsyncArrived(long frameTimeNanos) {
        ++this.vsyncCnt;
        long t1 = System.currentTimeMillis();
        if (t1 - this.vsyncT > 6000L) {
            this.vsyncT = t1;
            YMFLog.debug((Object)this, "[Render]YVideoViewMultiVideo vsync count in 6 seconds " + this.vsyncCnt);
            this.vsyncCnt = 0L;
        }
        ++this.index;
        if (this.index % 2L == 0L) {
            this.mDrawCanvas = this.getHolder().lockCanvas();
            if (this.mDrawCanvas != null && this.mBackgroundBitmap != null) {
                this.mDrawCanvas.drawBitmap(this.mBackgroundBitmap, this.mBackgroundSrc, this.mBackgroundDst, null);
            }
            for (int i = 0; i < this.mTotalVideoCnt; ++i) {
                YVideoViewMultiVideo yVideoViewMultiVideo = this;
                synchronized (yVideoViewMultiVideo) {
                    if (this.mStreamId[i] != -1L) {
                        this.handleVsync(i, this.mDrawCanvas);
                        this.mFrameArrived[i] = false;
                    }
                    continue;
                }
            }
            if (this.mDrawCanvas != null) {
                this.getHolder().unlockCanvasAndPost(this.mDrawCanvas);
                this.mDrawCanvas = null;
            }
        }
    }

    public void updateVideoPosition() {
        int width_offset = this.mViewWidth / this.mRowCnt;
        int height_offset = this.mViewHeight / this.mColCnt;
        int x = 0;
        int y = 0;
        int width = width_offset;
        int height = height_offset;
        int videoIndex = 0;
        YMFLog.info(TAG, "updateVideoPosition mViewWidth " + this.mViewWidth + " mViewHeight " + this.mViewHeight + " x " + x + " y " + y + " width " + width + " height " + height);
        for (int i = 0; i < this.mColCnt; ++i) {
            for (int j = 0; j < this.mRowCnt; ++j) {
                this.mDrawPosition[videoIndex].mIndex = videoIndex;
                this.mDrawPosition[videoIndex].mX = x;
                this.mDrawPosition[videoIndex].mY = y;
                this.mDrawPosition[videoIndex].mWidth = width;
                this.mDrawPosition[videoIndex].mHeight = height;
                YMFLog.info(TAG, "updateVideoPosition videoIndex " + videoIndex + " x " + this.mDrawPosition[videoIndex].mX + " y " + this.mDrawPosition[videoIndex].mY + " w " + this.mDrawPosition[videoIndex].mWidth + " h " + this.mDrawPosition[videoIndex].mHeight);
                ++videoIndex;
                x += width_offset;
            }
            x = 0;
            y += height_offset;
        }
    }

    @Override
    public void stopRender() {
    }

    public YVideoViewMultiVideo(Context ctx, YMultiVideoViewParams params) {
        super(ctx.getApplicationContext());
        this.mTotalVideoCnt = params.mTotalVideoCnt;
        this.mDrawPosition = new VideoPosition[this.mTotalVideoCnt];
        this.bmpByteBuffer = new ByteBuffer[this.mTotalVideoCnt];
        this.drawBmp = new Bitmap[this.mTotalVideoCnt];
        this.context = new long[this.mTotalVideoCnt];
        this.mStreamId = new long[this.mTotalVideoCnt];
        this.mGroupId = new long[this.mTotalVideoCnt];
        this.mRenderCnt = new int[this.mTotalVideoCnt];
        this.picRealWidth = new int[this.mTotalVideoCnt];
        this.mFrameArrived = new boolean[this.mTotalVideoCnt];
        this.mViewWidth = this.getWidth();
        this.mViewHeight = this.getHeight();
        this.mCurTime = new long[this.mTotalVideoCnt];
        this.mLastTime = new long[this.mTotalVideoCnt];
        this.mFirstFrameSeeFlag = new boolean[this.mTotalVideoCnt];
        this.mFirstFrameArrivedTime = new long[this.mTotalVideoCnt];
        this.mLastStatisticsTime = new long[this.mTotalVideoCnt];
        this.mMissRenderFrameCount = new AtomicInteger[this.mTotalVideoCnt];
        this.mFrameRendered = new AtomicBoolean[this.mTotalVideoCnt];
        this.mScaleMode = new VideoConstant.ScaleMode[this.mTotalVideoCnt];
        for (int i = 0; i < this.mTotalVideoCnt; ++i) {
            this.mDrawPosition[i] = new VideoPosition();
            YMultiVideoViewParams.clonePosition(params.mDrawPosition[i], this.mDrawPosition[i]);
            this.mCurTime[i] = 0L;
            this.mLastTime[i] = 0L;
            this.mScaleMode[i] = VideoConstant.ScaleMode.AspectFit;
            this.mFirstFrameSeeFlag[i] = false;
            this.mFirstFrameArrivedTime[i] = 0L;
            this.mLastStatisticsTime[i] = 0L;
            this.mMissRenderFrameCount[i] = new AtomicInteger(0);
            this.mFrameRendered[i] = new AtomicBoolean(false);
        }
        this.mBackgroundBitmap = params.background;
        if (this.mBackgroundBitmap != null) {
            this.mBackgroundSrc = new Rect(0, 0, this.mBackgroundBitmap.getWidth(), this.mBackgroundBitmap.getHeight());
        }
        this.mBackgroundPosition = new VideoPosition();
        YMultiVideoViewParams.clonePosition(params.backgroudPosition, this.mBackgroundPosition);
        this.mBackgroundDst = new Rect(this.mBackgroundPosition.mX, this.mBackgroundPosition.mY, this.mBackgroundPosition.mWidth + this.mBackgroundPosition.mX, this.mBackgroundPosition.mHeight + this.mBackgroundPosition.mY);
        YMFLog.info(TAG, "YVideoViewMultiVideo : mBackgroundSrc " + this.mBackgroundSrc.toString() + "-> mBackgroundDst " + this.mBackgroundDst.toString());
        StateMonitor.NotifyMultiVideoOriginPosition(this.mDrawPosition, this.mBackgroundPosition);
        this.initThread();
    }

    public YVideoViewMultiVideo(Context ctx, int row_count, int col_count, Bitmap bitmap) {
        super(ctx.getApplicationContext());
        this.mRowCnt = row_count;
        this.mColCnt = col_count;
        this.mTotalVideoCnt = this.mRowCnt * this.mColCnt;
        this.mCurTime = new long[this.mTotalVideoCnt];
        this.mLastTime = new long[this.mTotalVideoCnt];
        this.mDrawPosition = new VideoPosition[this.mTotalVideoCnt];
        this.mScaleMode = new VideoConstant.ScaleMode[this.mTotalVideoCnt];
        this.mFirstFrameSeeFlag = new boolean[this.mTotalVideoCnt];
        this.mFirstFrameArrivedTime = new long[this.mTotalVideoCnt];
        for (int i = 0; i < this.mTotalVideoCnt; ++i) {
            this.mDrawPosition[i] = new VideoPosition();
            this.mCurTime[i] = 0L;
            this.mLastTime[i] = 0L;
            this.mScaleMode[i] = VideoConstant.ScaleMode.AspectFit;
            this.mFirstFrameSeeFlag[i] = false;
            this.mFirstFrameArrivedTime[i] = 0L;
        }
        this.bmpByteBuffer = new ByteBuffer[this.mTotalVideoCnt];
        this.drawBmp = new Bitmap[this.mTotalVideoCnt];
        this.context = new long[this.mTotalVideoCnt];
        this.mStreamId = new long[this.mTotalVideoCnt];
        this.mGroupId = new long[this.mTotalVideoCnt];
        this.mRenderCnt = new int[this.mTotalVideoCnt];
        this.picRealWidth = new int[this.mTotalVideoCnt];
        this.mFrameArrived = new boolean[this.mTotalVideoCnt];
        this.mViewWidth = this.getWidth();
        this.mViewHeight = this.getHeight();
        this.updateVideoPosition();
        this.mBackgroundBitmap = bitmap;
        this.initThread();
    }

    public YVideoViewMultiVideo(Context context, AttributeSet attrs) {
        super(context.getApplicationContext(), attrs);
        this.initThread();
    }

    public YVideoViewMultiVideo(Context context, boolean useCanvas) {
        super(context.getApplicationContext());
        this.initThread();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initThread() {
        this.mThread = new Thread(this);
        this.mThread.setName(TAG);
        Object object = this.mStartLock;
        synchronized (object) {
            try {
                this.mThread.start();
                this.mStartLock.wait(100L);
            }
            catch (Throwable e) {
                YMFLog.error((Object)this, e.getMessage());
            }
        }
    }

    private void init(Context ctx, boolean useCanvas) {
        if (!YYVideoLibMgr.instance().isLibraryLoaded()) {
            YMFLog.error((Object)this, "[call] LoadLibarary failed, YVideoViewMultiVideo.init .");
            for (int i = 0; i < this.mTotalVideoCnt && this.context != null; ++i) {
                this.context[i] = 0L;
            }
            return;
        }
        this.getHolder().addCallback((SurfaceHolder.Callback)this);
        this.setFocusable(true);
        for (int i = 0; i < this.mTotalVideoCnt && this.mDrawPosition != null; ++i) {
            if (this.mDrawPosition[i] == null || this.context == null) continue;
            this.context[i] = this.CreateView(this.mDrawPosition[i].mWidth, this.mDrawPosition[i].mHeight, i, useCanvas);
        }
        try {
            this.playNotify = new PlayNotify();
            this.playNotify.Init();
            this.mIsReleased = false;
        }
        catch (Exception e) {
            YMFLog.error((Object)this, "[call] failed to init notifier");
        }
        for (int i = 0; i < this.mTotalVideoCnt && this.context != null; ++i) {
            YMFLog.info(this, "[call] YVideoViewMultiVideo.init context: %d", this.context[i]);
        }
        VsyncRelay.getInstance().RegisterVsyncNotifier(this);
    }

    @Override
    public void OnVsyncArrived(long frameTimeNanos) {
        if (this.mReady.get()) {
            this.mHandler.sendMessage(this.mHandler.obtainMessage(11, frameTimeNanos));
        }
    }

    @Override
    public YSpVideoView.ViewType getViewType() {
        return YSpVideoView.ViewType.SFView;
    }

    @Override
    public boolean setScaleMode(VideoConstant.ScaleMode scaleMode) {
        if (this.mReady.get()) {
            ScaleModeInfo modeInfo = new ScaleModeInfo(scaleMode, 0);
            this.mHandler.sendMessage(this.mHandler.obtainMessage(5, modeInfo));
        }
        return true;
    }

    @Override
    public boolean setScaleModeEx(int videoIndex, VideoConstant.ScaleMode scaleMode) {
        if (this.mReady.get()) {
            ScaleModeInfo modeInfo = new ScaleModeInfo(scaleMode, videoIndex);
            this.mHandler.sendMessage(this.mHandler.obtainMessage(5, modeInfo));
        }
        return true;
    }

    public boolean handleSetScaleModeEx(int videoIndex, VideoConstant.ScaleMode scaleMode) {
        this.mScaleMode[videoIndex] = scaleMode;
        YMFLog.info(TAG, "handleSetScaleModeEx mScaleMode[ " + videoIndex + "] scaleMode: " + (Object)((Object)scaleMode));
        if (scaleMode == VideoConstant.ScaleMode.AspectFit) {
            return this.SetScaleMode(this.context[videoIndex], 1);
        }
        if (scaleMode == VideoConstant.ScaleMode.ClipToBounds) {
            return this.SetScaleMode(this.context[videoIndex], 2);
        }
        if (scaleMode == VideoConstant.ScaleMode.FillParent) {
            return this.SetScaleMode(this.context[videoIndex], 0);
        }
        return false;
    }

    @Override
    public VideoConstant.ScaleMode getScaleMode() {
        return this.mScaleMode[0];
    }

    @Override
    public VideoConstant.ScaleMode getScaleModeEx(int videoIndex) {
        return this.mScaleMode[videoIndex];
    }

    @Override
    public void setPlayListner(PlayNotify.PlayListner pl) {
        if (this.mReady.get()) {
            this.mHandler.sendMessage(this.mHandler.obtainMessage(7, pl));
        }
    }

    public void handleSetPlayListner(PlayNotify.PlayListner pl) {
        this.playNotify.setPlayListner(pl);
    }

    @Override
    public void linkToStream(long userGroupId, long streamId) {
        this.linkToStreamExt(userGroupId, streamId, 0);
    }

    @Override
    public void linkToStreamExt(long userGroupId, long streamId, int videoIndex) {
        if (videoIndex >= this.mTotalVideoCnt) {
            YMFLog.error((Object)TAG, "video Index error : " + videoIndex);
            return;
        }
        YMFLog.info(TAG, " linkToStreamExt streamID " + streamId + " videoIndex " + videoIndex);
        StreamInfo si = new StreamInfo();
        si.userGroupId = userGroupId;
        si.streamId = streamId;
        si.videoIndex = videoIndex;
        this.mHandler.sendMessage(this.mHandler.obtainMessage(12, si));
    }

    public void handleLinktoStreamExt(long userGroupId, long streamId, int videoIndex) {
        this.linkToVideo(userGroupId, streamId, videoIndex);
    }

    @Override
    public void unLinkFromStream(long userGroupId, long streamId) {
        this.unLinkFromStreamExt(userGroupId, streamId, 0);
    }

    @Override
    public void unLinkFromStream() {
    }

    @Override
    public void unLinkFromStreamExt(long userGroupId, long streamId, int videoIndex) {
        if (videoIndex >= this.mTotalVideoCnt) {
            YMFLog.error((Object)TAG, "video Index error : " + videoIndex);
            return;
        }
        YMFLog.info(TAG, " unLinkFromStreamExt streamID " + streamId + " videoIndex " + videoIndex);
        StreamInfo si = new StreamInfo();
        si.userGroupId = userGroupId;
        si.streamId = streamId;
        si.videoIndex = videoIndex;
        this.mHandler.sendMessage(this.mHandler.obtainMessage(13, si));
    }

    public void handleUnlinkFromStreamExt(long userGroupId, long streamId, int videoIndex) {
        this.unlinkFromVideo(userGroupId, streamId, videoIndex);
    }

    @Override
    public void init() {
        if (this.mThread == null) {
            this.initThread();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void release() {
        this.getHolder().removeCallback((SurfaceHolder.Callback)this);
        if (this.mReady.get()) {
            Object object = this.mQuitLock;
            synchronized (object) {
                try {
                    this.mHandler.sendMessage(this.mHandler.obtainMessage(0));
                    this.mQuitLock.wait(500L);
                    YMFLog.info(this, "[Render]YVideoViewMultiVideo Quit");
                }
                catch (Throwable e) {
                    YMFLog.error((Object)this, "[Render]YVideoViewMultiVideo Quit throwable " + e.getMessage());
                }
            }
        }
    }

    public void deInit() {
        block13: {
            if (!YYVideoLibMgr.instance().isLibraryLoaded()) {
                YMFLog.error((Object)this, "[call] LoadLibarary failed, YVideoViewMultiVideo.deInit");
                for (int i = 0; i < this.mTotalVideoCnt; ++i) {
                    if (this.context == null) continue;
                    this.context[i] = 0L;
                }
                return;
            }
            for (int i = 0; i < this.mTotalVideoCnt && this.context != null; ++i) {
                YMFLog.info(this, "[call] YVideoViewMultiVideo.release context: %d", this.context[i]);
            }
            try {
                this.mIsReleased = true;
                if (this.playNotify != null) {
                    this.playNotify.Release();
                    this.playNotify = null;
                }
            }
            catch (Exception e) {
                if (e == null) break block13;
                YMFLog.error((Object)this, e.getMessage());
            }
        }
        try {
            this.getHolder().removeCallback((SurfaceHolder.Callback)this);
            for (int i = 0; i < this.mTotalVideoCnt; ++i) {
                if (this.drawBmp != null && this.drawBmp[i] != null) {
                    this.drawBmp[i].recycle();
                    this.drawBmp[i] = null;
                }
                if (this.bmpByteBuffer != null) {
                    this.bmpByteBuffer[i] = null;
                }
                if (this.context == null) continue;
                this.ReleaseView(this.context[i]);
                this.context[i] = 0L;
            }
            this.drawBmp = null;
            this.bmpByteBuffer = null;
            this.context = null;
        }
        finally {
            VsyncRelay.getInstance().UnRegisterVsyncNotifier(this);
            if (this.mDrawCanvas != null) {
                this.getHolder().unlockCanvasAndPost(this.mDrawCanvas);
                this.mDrawCanvas = null;
            }
            this.mThread = null;
        }
    }

    @Override
    public void onPause() {
    }

    @Override
    public void onResume() {
    }

    @Override
    public void setOrientation(YSpVideoView.OrientationType orientationType, int rotateAngle, boolean adjustImmediately) {
    }

    @Override
    public void onParentSizeChanged(int w, int h) {
    }

    @Override
    public boolean isReleased() {
        return this.mIsReleased;
    }

    @Override
    public YYRenderFrameBuffer getRenderFrameBuffer() {
        return null;
    }

    @Override
    public void setVrStream(boolean vrStream) {
    }

    public long getViewContext() {
        return this.context[0];
    }

    public boolean setScaleMode(int scaleMode) {
        if (!YYVideoLibMgr.instance().isLibraryLoaded()) {
            YMFLog.error(this, "[call] LoadLibarary failed, YVideoViewMultiVideo.setScaleMode, mode %d", scaleMode);
            return false;
        }
        YMFLog.info(this, "[call] YVideoViewMultiVideo.setScaleMode, mode %d", scaleMode);
        for (int i = 0; i < this.mTotalVideoCnt; ++i) {
            this.SetScaleMode(this.context[i], scaleMode);
        }
        return true;
    }

    public boolean setRotateAngle(int rotateAngle) {
        if (!YYVideoLibMgr.instance().isLibraryLoaded()) {
            YMFLog.error(this, "[call] LoadLibarary failed, YVideoViewMultiVideo.setRotateAngle, rotateAngle %d", rotateAngle);
            return false;
        }
        YMFLog.info(this, "[call] YVideoViewMultiVideo.setRotateAngle, rotateAngle %d", rotateAngle);
        for (int i = 0; i < this.mTotalVideoCnt; ++i) {
            this.SetRotageAngle(this.context[i], rotateAngle);
        }
        return true;
    }

    public boolean setClearColor(int color) {
        if (!YYVideoLibMgr.instance().isLibraryLoaded()) {
            YMFLog.error(this, "[call] LoadLibarary failed, YVideoViewMultiVideo.setClearColor, color %d", color);
            return false;
        }
        YMFLog.error(this, "[call] YVideoViewMultiVideo setClearColor, color %d", color);
        this.bgColor = color;
        for (int i = 0; i < this.mTotalVideoCnt; ++i) {
            this.SetClearColor(this.context[i], (byte)Color.red((int)color), (byte)Color.green((int)color), (byte)Color.blue((int)color));
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean linkToVideo(long userGroupId, long streamId, int videoIndex) {
        YVideoViewMultiVideo yVideoViewMultiVideo = this;
        synchronized (yVideoViewMultiVideo) {
            if (!YYVideoLibMgr.instance().isLibraryLoaded()) {
                YMFLog.error(this, "[call] LoadLibarary failed, YVideoViewMultiVideo.linkToVideo groupId %d %d, streamId %d %d, context %d", userGroupId >> 32, userGroupId & 0xFFFFFFFFFFFFFFFFL, streamId >> 32, streamId & 0xFFFFFFFFFFFFFFFFL, this.context[videoIndex]);
                return false;
            }
            this.mGroupId[videoIndex] = userGroupId;
            this.mStreamId[videoIndex] = streamId;
            int result = this.LinkToVideoStream(this.context[videoIndex], userGroupId, streamId);
            YMFLog.info(this, "[call] YVideoViewMultiVideo.linkFromVideo groupId %d %d, streamId %d %d, res %d, context %d", userGroupId >> 32, userGroupId & 0xFFFFFFFFFFFFFFFFL, streamId >> 32, streamId & 0xFFFFFFFFFFFFFFFFL, result, this.context[videoIndex]);
            this.playNotify.EndPlay(false);
            this.playNotify.setVideoIds(userGroupId, streamId);
            StateMonitor.instance().NotifyAddView(streamId, videoIndex, VideoConstant.ViewType.NO_GL_VIDEO_VIEW_MULTIVIDEO, TAG);
            return result == 0;
        }
    }

    public boolean unlinkFromVideo(long userGroupId, long streamId, int videoIndex) {
        if (!YYVideoLibMgr.instance().isLibraryLoaded()) {
            YMFLog.error(this, "[call] LoadLibarary failed, YVideoViewMultiVideo.unlinkFromVideo groupId %d %d, streamId %d %d, context %d", userGroupId >> 32, userGroupId & 0xFFFFFFFFFFFFFFFFL, streamId >> 32, streamId & 0xFFFFFFFFFFFFFFFFL, this.context[videoIndex]);
            return false;
        }
        StateMonitor.instance().NotifyRemoveView(streamId);
        int result = this.UnlinkFromVideoStream(this.context[videoIndex], userGroupId, streamId);
        this.mGroupId[videoIndex] = -1L;
        this.mStreamId[videoIndex] = -1L;
        if (this.playNotify != null) {
            this.playNotify.EndPlay(true);
        }
        YMFLog.info(this, "[call] YVideoViewMultiVideo.unlinkFromVideo groupId %d %d, streamId %d %d, res %d context %d", userGroupId >> 32, userGroupId & 0xFFFFFFFFFFFFFFFFL, streamId >> 32, streamId & 0xFFFFFFFFFFFFFFFFL, result, this.context[videoIndex]);
        return result == 0;
    }

    public boolean isLinkToVideo(long userGroupId, long streamId, int videoIndex) {
        if (!YYVideoLibMgr.instance().isLibraryLoaded()) {
            YMFLog.error((Object)this, "[call] LoadLibarary failed, YVideoViewMultiVideo.IsLinkToVideoStream");
            return false;
        }
        return this.IsLinkToVideoStream(this.context[videoIndex], userGroupId, streamId);
    }

    public void surfaceCreated(SurfaceHolder holder) {
        YMFLog.info(TAG, "[Render]surface created");
        if (this.mReady.get()) {
            this.mHandler.sendMessage(this.mHandler.obtainMessage(2, holder.getSurface()));
        }
    }

    public void handleSurfaceCreated(Surface surface) {
        int i;
        if (!YYVideoLibMgr.instance().isLibraryLoaded()) {
            YMFLog.error(this, "[call] LoadLibarary failed, YVideoViewMultiVideo.SetSurfaceState, context %d, state %d", this.context[0], 0);
            return;
        }
        for (i = 0; i < this.mTotalVideoCnt && this.context != null; ++i) {
            this.ChangeSurface(this.context[i], surface);
        }
        for (i = 0; i < this.mTotalVideoCnt && this.context != null; ++i) {
            this.SetSurfaceState(this.context[i], 0);
            YMFLog.info(this, "[call] YVideoViewMultiVideo.SetSurfaceState, context %d, state %d", this.context[i], 0);
        }
    }

    public void surfaceChanged(SurfaceHolder holder, int format, int width, int height) {
        YMFLog.info(TAG, "[Render]surface changed width height " + width + " " + height);
        if (this.mReady.get()) {
            this.mHandler.sendMessage(this.mHandler.obtainMessage(3, width, height, holder.getSurface()));
        }
    }

    public void handleSurfaceChanged(Surface surface, int width, int height) {
        if (!YYVideoLibMgr.instance().isLibraryLoaded()) {
            YMFLog.error((Object)this, "[call] LoadLibarary failed, YVideoViewMultiVideo.ChangeFrame");
            return;
        }
        YMFLog.info(this, "[call] YVideoViewMultiVideo.ChangeFrame, width: %d, height: %d ", width, height);
        this.mViewWidth = width;
        this.mViewHeight = height;
        if (this.mTotalVideoCnt == 1 && this.mDrawPosition[0].mHeight == -2 && this.mDrawPosition[0].mWidth == -2) {
            this.mDrawPosition[0].mX = 0;
            this.mDrawPosition[0].mY = 0;
            this.mDrawPosition[0].mWidth = width;
            this.mDrawPosition[0].mHeight = height;
            this.mBackgroundDst = new Rect(0, 0, width, height);
        }
        StateMonitor.NotifyMultiVideoSurfaceChangePosition(this.mDrawPosition, this.mBackgroundPosition);
        for (int i = 0; i < this.mTotalVideoCnt; ++i) {
            this.ChangeFrame(this.context[i], this.mDrawPosition[i].mX, this.mDrawPosition[i].mY, this.mDrawPosition[i].mWidth, this.mDrawPosition[i].mHeight);
        }
    }

    public void surfaceDestroyed(SurfaceHolder holder) {
        YMFLog.info(TAG, "[Render]surface destroyed");
        if (this.mReady.get()) {
            this.mHandler.sendMessage(this.mHandler.obtainMessage(4, holder.getSurface()));
        }
    }

    public void handleSurfaceDestroyed(Surface surface) {
        if (!YYVideoLibMgr.instance().isLibraryLoaded()) {
            YMFLog.error(this, "[call] LoadLibarary failed, YYVideoView.SetSurfaceState, state %d.", 1);
            return;
        }
        for (int i = 0; i < this.mTotalVideoCnt; ++i) {
            this.SetSurfaceState(this.context[i], 1);
            YMFLog.info(this, "[call] YYVideoView.SetSurfaceState, context: %d state %d.", this.context[i], 1);
        }
    }

    public void newRenderFrameArrived(int index) {
        long T1;
        if (this.mLastStatisticsTime[index] == 0L) {
            this.mLastStatisticsTime[index] = System.currentTimeMillis();
        }
        if (!this.mFrameRendered[index].get()) {
            this.mMissRenderFrameCount[index].getAndIncrement();
        }
        if ((T1 = System.currentTimeMillis()) - this.mLastStatisticsTime[index] >= 6000L) {
            StateMonitor.NotifyRenderLostRate(this.mStreamId[index], (float)(this.mMissRenderFrameCount[index].getAndSet(0) * 1000) / (float)(T1 - this.mLastStatisticsTime[index]));
            this.mLastStatisticsTime[index] = T1;
        }
        this.mFrameRendered[index].set(false);
    }

    public ByteBuffer createByteBuffer(int videoIndex, int width, int height, int bits) {
        block8: {
            if (this.drawBmp[videoIndex] != null) {
                this.drawBmp[videoIndex].recycle();
                this.drawBmp[videoIndex] = null;
                this.bmpByteBuffer[videoIndex] = null;
            }
            this.picWidth = width;
            this.picHeight = height;
            try {
                if (bits == 32) {
                    this.drawBmp[videoIndex] = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
                    break block8;
                }
                if (bits == 16) {
                    this.drawBmp[videoIndex] = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.RGB_565);
                    break block8;
                }
                return null;
            }
            catch (OutOfMemoryError oom) {
                YMFLog.error((Object)this, "[call] createBitmap out of memory! YYVideoView.createByteBuffer");
                return null;
            }
        }
        if (this.bmpByteBuffer[videoIndex] != null) {
            return this.bmpByteBuffer[videoIndex];
        }
        try {
            this.bmpByteBuffer[videoIndex] = ByteBuffer.allocateDirect(bits / 8 * width * height);
        }
        catch (Throwable e) {
            YMFLog.error((Object)this, e.getMessage());
        }
        this.mFirstFrameArrivedTime[videoIndex] = System.currentTimeMillis();
        return this.bmpByteBuffer[videoIndex];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Bitmap getVideoScreenshotExt(int videoIndex) {
        Bitmap bmp = null;
        ScreenShotInfo info = new ScreenShotInfo();
        info.isSuccess = false;
        info.videoIndex = videoIndex;
        if (this.mReady.get()) {
            Object object = this.mScreenShotLock;
            synchronized (object) {
                this.mHandler.sendMessage(this.mHandler.obtainMessage(6, info));
                try {
                    this.mScreenShotLock.wait(500L);
                }
                catch (Throwable t) {
                    YMFLog.info(this, t.getMessage());
                }
            }
        }
        if (info.isSuccess) {
            bmp = Bitmap.createBitmap((int)info.width, (int)info.height, (Bitmap.Config)Bitmap.Config.RGB_565);
            if (bmp != null) {
                bmp.copyPixelsFromBuffer(info.pixelBuffer);
            } else {
                YMFLog.error((Object)this, " Bitmap.createBitmap failed!");
            }
        } else if (this.mStreamId[info.videoIndex] == 0L) {
            bmp = Bitmap.createBitmap((int)this.mDrawPosition[info.videoIndex].mWidth, (int)this.mDrawPosition[info.videoIndex].mHeight, (Bitmap.Config)Bitmap.Config.RGB_565);
            if (bmp != null) {
                bmp.eraseColor(-16777216);
            } else {
                YMFLog.error((Object)this, " Bitmap.createBitmap failed!");
            }
            YMFLog.info(TAG, "[Render]handleGetVideoScreenshotExt black ");
        } else {
            YMFLog.error((Object)this, "[Render]YCustomGLVideoView GetScreenShot something wrong " + this.mStreamId[info.videoIndex]);
        }
        YMFLog.info(this, "[Render]YVideoViewMultiVideo GetScreenShot isSuccess " + info.isSuccess + " width " + info.width + " height " + info.height);
        return bmp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleGetScreenShot(ScreenShotInfo info) {
        try {
            info.isSuccess = false;
            if (info.videoIndex < this.mTotalVideoCnt && this.drawBmp != null && this.bmpByteBuffer != null && this.mStreamId[info.videoIndex] != 0L && this.drawBmp[info.videoIndex] != null && this.bmpByteBuffer[info.videoIndex] != null) {
                info.height = this.drawBmp[info.videoIndex].getHeight();
                info.width = this.drawBmp[info.videoIndex].getWidth();
                info.pixelBuffer = ByteBuffer.wrap(this.bmpByteBuffer[info.videoIndex].array());
                info.isSuccess = true;
            }
        }
        catch (Throwable t) {
            YMFLog.error((Object)this, "[Render]YVideoViewMultiVideo handleGetScreenShot throwable " + t.getMessage());
        }
        Object object = this.mScreenShotLock;
        synchronized (object) {
            this.mScreenShotLock.notifyAll();
        }
    }

    @Override
    public Bitmap getVideoScreenshot() {
        return this.getVideoScreenshotExt(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawCanvas(int videoIndex, int x, int y, int width, int height, int picRealW) {
        YVideoViewMultiVideo yVideoViewMultiVideo = this;
        synchronized (yVideoViewMultiVideo) {
            this.mFrameArrived[videoIndex] = true;
            this.picRealWidth[videoIndex] = picRealW;
            this.mDrawPosition[videoIndex].mX = x;
            this.mDrawPosition[videoIndex].mY = y;
            this.mDrawPosition[videoIndex].mWidth = width;
            this.mDrawPosition[videoIndex].mHeight = height;
        }
    }

    public void handleVsync(int videoIndex, Canvas canvas) {
        if (canvas == null || videoIndex >= this.mTotalVideoCnt) {
            YMFLog.error((Object)this, "[call] Invalid parameter!");
            return;
        }
        if (this.bmpByteBuffer[videoIndex] == null) {
            return;
        }
        if (this.drawBmp[videoIndex] == null || this.drawBmp[videoIndex].isRecycled()) {
            return;
        }
        Rect srcRect = new Rect(0, 0, this.picRealWidth[videoIndex], this.picHeight);
        RectF dstRect = new RectF((float)this.mDrawPosition[videoIndex].mX, (float)this.mDrawPosition[videoIndex].mY, (float)(this.mDrawPosition[videoIndex].mX + this.mDrawPosition[videoIndex].mWidth), (float)(this.mDrawPosition[videoIndex].mY + this.mDrawPosition[videoIndex].mHeight));
        try {
            this.bmpByteBuffer[videoIndex].rewind();
            this.drawBmp[videoIndex].copyPixelsFromBuffer((Buffer)this.bmpByteBuffer[videoIndex]);
            this.playNotify.DrawNotify();
            if (!this.mFirstFrameSeeFlag[videoIndex]) {
                YYVideoLibMgr.instance().onFirstFrameSeeNotify(this.mGroupId[videoIndex], this.mStreamId[videoIndex], System.currentTimeMillis() - this.mFirstFrameArrivedTime[videoIndex]);
                this.mFirstFrameSeeFlag[videoIndex] = true;
            }
            if (this.mAutoOrientation && this.picRealWidth[videoIndex] < this.picHeight != canvas.getWidth() < canvas.getHeight()) {
                this.caculateNewRenderDstRect(dstRect);
                canvas.rotate(90.0f, (dstRect.left + dstRect.right) / 2.0f, (dstRect.top + dstRect.bottom) / 2.0f);
            }
            canvas.drawBitmap(this.drawBmp[videoIndex], srcRect, dstRect, null);
            if (this.mFrameArrived[videoIndex]) {
                int n = videoIndex;
                this.mRenderCnt[n] = this.mRenderCnt[n] + 1;
                this.mCurTime[videoIndex] = TimeUtil.getTickCount();
                if (this.mLastTime[videoIndex] == 0L) {
                    this.mLastTime[videoIndex] = this.mCurTime[videoIndex];
                    StateMonitor.NotifyFirstFrameRendered(this.mStreamId[videoIndex], this.mCurTime[videoIndex]);
                }
                if (this.mCurTime[videoIndex] - this.mLastTime[videoIndex] >= 1000L) {
                    StateMonitor.instance().NotifyRenderFrameRate(this.mStreamId[videoIndex], this.mRenderCnt[videoIndex]);
                    this.mLastTime[videoIndex] = this.mCurTime[videoIndex];
                    this.mRenderCnt[videoIndex] = 0;
                }
            }
            this.mFrameRendered[videoIndex].set(true);
        }
        catch (Throwable e) {
            YMFLog.error((Object)this, e.getMessage());
        }
    }

    private void caculateNewRenderDstRect(RectF rec) {
        float videoWidth = rec.bottom - rec.top;
        float videoHeight = rec.right - rec.left;
        float canvasWidth = this.getWidth();
        float canvasHeight = this.getHeight();
        float wRatio = videoWidth / canvasWidth;
        float hRatio = videoHeight / canvasHeight;
        float renderWidth = canvasWidth;
        float renderHeight = canvasHeight;
        if (wRatio >= hRatio) {
            renderWidth = canvasWidth;
            renderHeight = videoHeight / wRatio;
        } else {
            renderWidth = videoWidth / hRatio;
            renderHeight = canvasHeight;
        }
        float tmp = renderWidth;
        renderWidth = renderHeight;
        renderHeight = tmp;
        float renderX = (canvasWidth - renderWidth) / 2.0f;
        float renderY = (canvasHeight - renderHeight) / 2.0f;
        rec.left = renderX;
        rec.right = renderX + renderWidth;
        rec.top = renderY;
        rec.bottom = renderY + renderHeight;
    }

    @Override
    public void setVideoInfoCallback(IVideoInfoCallback iVideoInfoCallback) {
        this.mVideoInfoCallback = iVideoInfoCallback;
    }

    private native long CreateView(int var1, int var2, int var3, boolean var4);

    private native void ReleaseView(long var1);

    private native void ChangeSurface(long var1, Object var3);

    private native void SetSurfaceState(long var1, int var3);

    private native void ChangeFrame(long var1, int var3, int var4, int var5, int var6);

    private native boolean SetScaleMode(long var1, int var3);

    private native boolean SetRotageAngle(long var1, int var3);

    private native boolean SetClearColor(long var1, byte var3, byte var4, byte var5);

    private native boolean IsLinkToVideoStream(long var1, long var3, long var5);

    private native int LinkToVideoStream(long var1, long var3, long var5);

    private native int UnlinkFromVideoStream(long var1, long var3, long var5);

    public static native int LoadTest();

    @Override
    public YspVideoViewInfo getVideoViewInfo(long streamid) {
        return null;
    }

    private static class RenderHandler
    extends Handler {
        private WeakReference<YVideoViewMultiVideo> mWeakWay;

        public RenderHandler(YVideoViewMultiVideo MultiVideoRender) {
            this.mWeakWay = new WeakReference<YVideoViewMultiVideo>(MultiVideoRender);
        }

        public void handleMessage(Message msg) {
            int what = msg.what;
            if (0 == what) {
                Looper loop = Looper.myLooper();
                if (null != loop) {
                    loop.quit();
                    this.removeCallbacksAndMessages(null);
                }
                return;
            }
            YVideoViewMultiVideo customGLVideoView = (YVideoViewMultiVideo)this.mWeakWay.get();
            if (customGLVideoView == null) {
                YMFLog.warn(YVideoViewMultiVideo.TAG, "[Render]YVideoViewMultiVideo RenderHandler.handleMessage: MultiVideoRender is null");
                return;
            }
            switch (what) {
                case 11: {
                    customGLVideoView.handleOnVsyncArrived((Long)msg.obj);
                    break;
                }
                case 5: {
                    ScaleModeInfo info = (ScaleModeInfo)msg.obj;
                    customGLVideoView.handleSetScaleModeEx(info.videoIndex, info.mode);
                    break;
                }
                case 7: {
                    customGLVideoView.handleSetPlayListner((PlayNotify.PlayListner)msg.obj);
                    break;
                }
                case 12: {
                    StreamInfo si = (StreamInfo)msg.obj;
                    customGLVideoView.handleLinktoStreamExt(si.userGroupId, si.streamId, si.videoIndex);
                    break;
                }
                case 13: {
                    StreamInfo sie = (StreamInfo)msg.obj;
                    customGLVideoView.handleUnlinkFromStreamExt(sie.userGroupId, sie.streamId, sie.videoIndex);
                    break;
                }
                case 2: {
                    customGLVideoView.handleSurfaceCreated((Surface)msg.obj);
                    break;
                }
                case 3: {
                    customGLVideoView.handleSurfaceChanged((Surface)msg.obj, msg.arg1, msg.arg2);
                    break;
                }
                case 4: {
                    customGLVideoView.handleSurfaceDestroyed((Surface)msg.obj);
                    break;
                }
                case 6: {
                    customGLVideoView.handleGetScreenShot((ScreenShotInfo)msg.obj);
                    break;
                }
            }
        }
    }

    private class ScaleModeInfo {
        public VideoConstant.ScaleMode mode;
        public int videoIndex;

        public ScaleModeInfo(VideoConstant.ScaleMode mode, int videoIndex) {
            this.mode = mode;
            this.videoIndex = videoIndex;
        }
    }

    private static class ScreenShotInfo {
        public boolean isSuccess;
        public Buffer pixelBuffer;
        public int width;
        public int height;
        public int videoIndex;

        private ScreenShotInfo() {
        }
    }

    private static class StreamInfo {
        public long userGroupId;
        public long streamId;
        public int videoIndex;

        private StreamInfo() {
        }
    }
}

