/*
 * Decompiled with CFR 0.152.
 */
package com.yy.videoplayer.videoview;

import android.content.Context;
import android.graphics.Bitmap;
import android.opengl.GLSurfaceView;
import android.util.AttributeSet;
import android.util.Log;
import com.yy.videoplayer.decoder.PlayNotify;
import com.yy.videoplayer.decoder.StateMonitor;
import com.yy.videoplayer.decoder.VideoConstant;
import com.yy.videoplayer.decoder.ViewLiveStatManager;
import com.yy.videoplayer.render.GLVideoRenderMultiVideo;
import com.yy.videoplayer.render.YYRenderFrameBuffer;
import com.yy.videoplayer.utils.YMFLog;
import com.yy.videoplayer.videoview.IVideoInfoCallback;
import com.yy.videoplayer.videoview.YMultiVideoViewParams;
import com.yy.videoplayer.videoview.YSpVideoView;
import com.yy.videoplayer.videoview.YspVideoViewInfo;

public class YGLVideoViewMultiVideo
extends GLSurfaceView
implements YSpVideoView {
    private static final String TAG = "YGLVideoViewMultiVideo";
    private GLVideoRenderMultiVideo mVideoRender = null;
    PlayNotify playNotify = null;
    boolean mIsReleased = false;
    private IVideoInfoCallback mVideoInfoCallback = null;
    private long mStreamId;
    private int mRowCnt;
    private int mColCnt;
    private int mTotalVideoCnt;
    private Bitmap mBackgroundBitmap;
    private boolean mStopRender = false;

    @Override
    public void stopRender() {
        YMFLog.info(TAG, "stopRender :" + this.mStopRender + " VideoRender " + this.mVideoRender);
        if (!this.mStopRender && this.mVideoRender != null) {
            this.mStopRender = true;
            this.mVideoRender.stopRender();
            this.onDetachedFromWindow();
        }
    }

    public YGLVideoViewMultiVideo(Context context, YMultiVideoViewParams params) {
        super(context.getApplicationContext());
        this.mTotalVideoCnt = params.mTotalVideoCnt;
        YMFLog.info(TAG, " mTotalVideoCnt :" + this.mTotalVideoCnt);
        this.init(true, params);
    }

    private void init(boolean GPUFormatConvert, YMultiVideoViewParams params) {
        YMFLog.info(this, "[Render]YGLVideoView init");
        this.playNotify = new PlayNotify();
        this.playNotify.Init();
        if (this.mVideoRender == null) {
            this.setEGLContextClientVersion(2);
            this.mVideoRender = new GLVideoRenderMultiVideo(this.playNotify, GPUFormatConvert, params);
            this.setRenderer(this.mVideoRender);
            this.mStopRender = false;
        } else {
            this.mVideoRender.init(this.playNotify, GPUFormatConvert);
        }
        this.mIsReleased = false;
    }

    public YGLVideoViewMultiVideo(Context context, int row_count, int col_count, Bitmap bitmap) {
        super(context.getApplicationContext());
        this.mRowCnt = row_count;
        this.mColCnt = col_count;
        this.mTotalVideoCnt = this.mRowCnt * this.mColCnt;
        this.mBackgroundBitmap = bitmap;
        YMFLog.info(TAG, " row_count " + row_count + " col_count " + col_count);
        this.init(true);
    }

    public YGLVideoViewMultiVideo(Context context, AttributeSet attrs) {
        super(context.getApplicationContext(), attrs);
        this.init(true);
    }

    public YGLVideoViewMultiVideo(Context context, boolean GPUFormatConvert) {
        super(context.getApplicationContext());
        this.init(GPUFormatConvert);
    }

    @Override
    public void linkToStream(long userGroupId, long streamId) {
        this.linkToStreamExt(userGroupId, streamId, 0);
    }

    @Override
    public void linkToStreamExt(long userGroupId, long streamId, int videoIndex) {
        if (videoIndex >= this.mTotalVideoCnt) {
            YMFLog.error((Object)TAG, "video Index error : " + videoIndex);
            return;
        }
        YMFLog.info(TAG, " linkToStreamExt streamID " + streamId + " videoIndex " + videoIndex);
        if (this.mVideoRender != null) {
            this.mVideoRender.linkToStream(userGroupId, streamId, videoIndex);
        }
        if (this.playNotify != null) {
            this.playNotify.EndPlay(false);
            this.playNotify.setVideoIds(userGroupId, streamId);
        }
        StateMonitor.instance().NotifyAddView(streamId, videoIndex, VideoConstant.ViewType.GL_VIDEO_VIEW_MULTIVIDEO, TAG);
        ViewLiveStatManager.getInstace().notifyEventTime(0, 4);
    }

    @Override
    public void unLinkFromStream(long userGroupId, long streamId) {
        this.unLinkFromStreamExt(userGroupId, streamId, 0);
    }

    @Override
    public void unLinkFromStream() {
    }

    @Override
    public void unLinkFromStreamExt(long userGroupId, long streamId, int videoIndex) {
        if (videoIndex >= this.mTotalVideoCnt) {
            YMFLog.error((Object)TAG, "video Index error : " + videoIndex);
            return;
        }
        YMFLog.info(TAG, " unLinkFromStreamExt streamID " + streamId + " videoIndex " + videoIndex);
        if (this.mVideoRender != null) {
            this.mVideoRender.unLinkFromStream(userGroupId, streamId, videoIndex);
        }
        if (this.playNotify != null) {
            this.playNotify.EndPlay(true);
        }
        StateMonitor.instance().NotifyRemoveView(streamId);
        ViewLiveStatManager.getInstace().notifyEventTime(4, 4);
    }

    @Override
    public void init() {
        this.init(true);
    }

    @Override
    public void release() {
        this.mIsReleased = true;
        this.stopRender();
        if (this.mVideoRender != null) {
            this.mVideoRender.release();
            this.mVideoRender = null;
        }
        if (this.playNotify != null) {
            this.playNotify.Release();
            this.playNotify = null;
        }
        YMFLog.info(this, "[Render]YGLVideoViewMultiVideo release");
    }

    @Override
    public void onPause() {
    }

    @Override
    public void setOrientation(YSpVideoView.OrientationType orientationType, int rotateAngle, boolean adjustImmediately) {
        if (this.mVideoRender != null) {
            this.mVideoRender.setOrientation(orientationType, rotateAngle, adjustImmediately);
        }
    }

    @Override
    public void onParentSizeChanged(int w, int h) {
    }

    @Override
    public boolean isReleased() {
        return this.mIsReleased;
    }

    @Override
    public YSpVideoView.ViewType getViewType() {
        return YSpVideoView.ViewType.GLView;
    }

    @Override
    public boolean setScaleMode(VideoConstant.ScaleMode scaleMode) {
        if (this.mVideoRender == null) {
            Log.e((String)TAG, (String)"not init yet, cannot set scale mode now.");
            return false;
        }
        return this.mVideoRender.setScaleMode(scaleMode);
    }

    @Override
    public VideoConstant.ScaleMode getScaleMode() {
        return this.mVideoRender.getScaleMode();
    }

    @Override
    public boolean setScaleModeEx(int videoIndex, VideoConstant.ScaleMode scaleMode) {
        if (this.mVideoRender == null) {
            Log.e((String)TAG, (String)"not init yet, cannot set scale mode now.");
            return false;
        }
        YMFLog.info(this, " setScaleModeEx videoIndex " + videoIndex + " mode " + (Object)((Object)scaleMode));
        return this.mVideoRender.setScaleModeEx(videoIndex, scaleMode);
    }

    @Override
    public VideoConstant.ScaleMode getScaleModeEx(int videoIndex) {
        return this.mVideoRender.getScaleModeEx(videoIndex);
    }

    @Override
    public Bitmap getVideoScreenshotExt(int videoIndex) {
        if (videoIndex >= this.mTotalVideoCnt || this.mVideoRender == null) {
            return null;
        }
        return this.mVideoRender.getBitmapExt(videoIndex);
    }

    @Override
    public Bitmap getVideoScreenshot() {
        return this.mVideoRender.getBitmap();
    }

    @Override
    public void setPlayListner(PlayNotify.PlayListner pl) {
        this.playNotify.setPlayListner(pl);
    }

    private void init(boolean GPUFormatConvert) {
        YMFLog.info(this, "[Render]YGLVideoView init");
        this.playNotify = new PlayNotify();
        this.playNotify.Init();
        if (this.mVideoRender == null) {
            this.setEGLContextClientVersion(2);
            this.mVideoRender = new GLVideoRenderMultiVideo(this.playNotify, GPUFormatConvert, this.mRowCnt, this.mColCnt, this.mBackgroundBitmap);
            this.setRenderer(this.mVideoRender);
        } else {
            this.mVideoRender.init(this.playNotify, GPUFormatConvert);
        }
        this.mIsReleased = false;
    }

    @Override
    public YYRenderFrameBuffer getRenderFrameBuffer() {
        if (this.mVideoRender != null) {
            return this.mVideoRender.getRenderFrameBuffer();
        }
        return null;
    }

    @Override
    public void setVrStream(boolean vrStream) {
    }

    @Override
    public void setVideoInfoCallback(IVideoInfoCallback iVideoInfoCallback) {
        this.mVideoInfoCallback = iVideoInfoCallback;
    }

    @Override
    public YspVideoViewInfo getVideoViewInfo(long streamid) {
        return null;
    }
}

