/*
 * Decompiled with CFR 0.152.
 */
package com.yy.videoplayer.videoview;

import android.content.Context;
import android.graphics.Bitmap;
import android.opengl.GLSurfaceView;
import android.util.AttributeSet;
import android.util.Log;
import com.yy.videoplayer.decoder.PlayNotify;
import com.yy.videoplayer.decoder.StateMonitor;
import com.yy.videoplayer.decoder.VideoConstant;
import com.yy.videoplayer.decoder.ViewLiveStatManager;
import com.yy.videoplayer.render.GLVideoRender;
import com.yy.videoplayer.render.YYRenderFrameBuffer;
import com.yy.videoplayer.utils.YMFLog;
import com.yy.videoplayer.videoview.IVideoInfoCallback;
import com.yy.videoplayer.videoview.YSpVideoView;
import com.yy.videoplayer.videoview.YspVideoViewInfo;

public class YGLVideoViewExt
extends GLSurfaceView
implements YSpVideoView {
    private static final String TAG = "YGLVideoViewExt";
    private GLVideoRender mVideoRender = null;
    PlayNotify playNotify = null;
    boolean mIsReleased = false;
    boolean mStopRender = false;
    private IVideoInfoCallback mVideoInfoCallback = null;
    private long mStreamId;
    private long mUserGroupId;

    @Override
    public void stopRender() {
        YMFLog.info(TAG, "stopRender :" + this.mStopRender + " VideoRender " + this.mVideoRender);
        if (!this.mStopRender && this.mVideoRender != null) {
            this.mStopRender = true;
            this.mVideoRender.stopRender();
            this.onDetachedFromWindow();
        }
    }

    public YGLVideoViewExt(Context context) {
        super(context.getApplicationContext());
        this.init(true);
    }

    public YGLVideoViewExt(Context context, AttributeSet attrs) {
        super(context.getApplicationContext(), attrs);
        this.init(true);
    }

    public YGLVideoViewExt(Context context, boolean GPUFormatConvert) {
        super(context.getApplicationContext());
        this.init(GPUFormatConvert);
    }

    @Override
    public void linkToStream(long userGroupId, long streamId) {
        this.mUserGroupId = userGroupId;
        this.mStreamId = streamId;
        if (this.mVideoRender != null) {
            this.mVideoRender.linkToStream(userGroupId, streamId);
        }
        if (this.playNotify != null) {
            this.playNotify.EndPlay(false);
            this.playNotify.setVideoIds(userGroupId, streamId);
        }
        StateMonitor.instance().NotifyAddView(streamId, 0, VideoConstant.ViewType.GL_VIDEO_VIEW, TAG);
        ViewLiveStatManager.getInstace().notifyEventTime(0, 4);
    }

    @Override
    public void unLinkFromStreamExt(long userGroupId, long streamId, int videoIndex) {
        this.unLinkFromStream(userGroupId, streamId);
    }

    @Override
    public void unLinkFromStream(long userGroupId, long streamId) {
        if (this.mVideoRender != null) {
            this.mVideoRender.unLinkFromStream(userGroupId, streamId);
        }
        if (this.playNotify != null) {
            this.playNotify.EndPlay(true);
        }
        StateMonitor.instance().NotifyRemoveView(streamId);
        ViewLiveStatManager.getInstace().notifyEventTime(4, 4);
    }

    @Override
    public void unLinkFromStream() {
        if (this.mVideoRender != null) {
            this.mVideoRender.unLinkFromStream(this.mUserGroupId, this.mStreamId);
        }
        if (this.playNotify != null) {
            this.playNotify.EndPlay(true);
        }
        StateMonitor.instance().NotifyRemoveView(this.mStreamId);
        ViewLiveStatManager.getInstace().notifyEventTime(4, 4);
    }

    @Override
    public void init() {
        this.init(true);
    }

    @Override
    public void release() {
        this.mIsReleased = true;
        this.stopRender();
        if (this.mVideoRender != null) {
            this.mVideoRender.release();
            this.mVideoRender = null;
        }
        if (this.playNotify != null) {
            this.playNotify.Release();
            this.playNotify = null;
        }
        YMFLog.info(this, "[Render]YGLVideoView release");
    }

    @Override
    public void onPause() {
        super.onPause();
    }

    @Override
    public void setOrientation(YSpVideoView.OrientationType orientationType, int rotateAngle, boolean adjustImmediately) {
        if (this.mVideoRender != null) {
            this.mVideoRender.setOrientation(orientationType, rotateAngle, adjustImmediately);
        }
    }

    @Override
    public void onParentSizeChanged(int w, int h) {
    }

    @Override
    public boolean isReleased() {
        return this.mIsReleased;
    }

    @Override
    public YSpVideoView.ViewType getViewType() {
        return YSpVideoView.ViewType.GLView;
    }

    @Override
    public boolean setScaleMode(VideoConstant.ScaleMode scaleMode) {
        if (this.mVideoRender == null) {
            Log.e((String)TAG, (String)"not init yet, cannot set scale mode now.");
            return false;
        }
        return this.mVideoRender.setScaleMode(scaleMode);
    }

    @Override
    public VideoConstant.ScaleMode getScaleMode() {
        return this.mVideoRender.getScaleMode();
    }

    @Override
    public boolean setScaleModeEx(int videoIndex, VideoConstant.ScaleMode scaleMode) {
        if (this.mVideoRender == null) {
            Log.e((String)TAG, (String)"not init yet, cannot set scale mode now.");
            return false;
        }
        return this.mVideoRender.setScaleMode(scaleMode);
    }

    @Override
    public VideoConstant.ScaleMode getScaleModeEx(int videoIndex) {
        return this.mVideoRender.getScaleMode();
    }

    @Override
    public Bitmap getVideoScreenshotExt(int videoIndex) {
        return this.getVideoScreenshot();
    }

    @Override
    public Bitmap getVideoScreenshot() {
        return this.mVideoRender.getBitmap();
    }

    @Override
    public void setPlayListner(PlayNotify.PlayListner pl) {
        this.playNotify.setPlayListner(pl);
    }

    private void init(boolean GPUFormatConvert) {
        YMFLog.info(this, "[Render]YGLVideoView init");
        this.playNotify = new PlayNotify();
        this.playNotify.Init();
        if (this.mVideoRender == null) {
            this.setEGLContextClientVersion(2);
            this.mVideoRender = new GLVideoRender(this.playNotify, GPUFormatConvert);
            this.setRenderer(this.mVideoRender);
            this.mStopRender = false;
        } else {
            this.mVideoRender.init(this.playNotify, GPUFormatConvert);
        }
        this.mIsReleased = false;
    }

    @Override
    public YYRenderFrameBuffer getRenderFrameBuffer() {
        if (this.mVideoRender != null) {
            return this.mVideoRender.getRenderFrameBuffer();
        }
        return null;
    }

    @Override
    public void setVrStream(boolean vrStream) {
    }

    @Override
    public void setVideoInfoCallback(IVideoInfoCallback iVideoInfoCallback) {
        this.mVideoInfoCallback = iVideoInfoCallback;
    }

    @Override
    public void linkToStreamExt(long userGroupId, long streamId, int videoIndex) {
    }

    @Override
    public YspVideoViewInfo getVideoViewInfo(long streamid) {
        return null;
    }
}

