/*
 * Decompiled with CFR 0.152.
 */
package com.yy.videoplayer.videoview;

import android.content.Context;
import android.graphics.Bitmap;
import android.opengl.EGLSurface;
import android.opengl.GLES20;
import android.opengl.Matrix;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.util.AttributeSet;
import android.view.Surface;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import android.view.View;
import com.yy.videoplayer.decoder.PlayNotify;
import com.yy.videoplayer.decoder.SmoothnessCounter;
import com.yy.videoplayer.decoder.StateMonitor;
import com.yy.videoplayer.decoder.VideoConstant;
import com.yy.videoplayer.decoder.VideoSizeUtils;
import com.yy.videoplayer.decoder.ViewLiveStatManager;
import com.yy.videoplayer.decoder.YYVideoLibMgr;
import com.yy.videoplayer.decoder.gles_decoder.EglCore;
import com.yy.videoplayer.decoder.gles_decoder.FullFrameRect;
import com.yy.videoplayer.decoder.gles_decoder.Texture2dProgram;
import com.yy.videoplayer.decoder.gles_decoder.WindowSurface;
import com.yy.videoplayer.render.VideoRenderNotify;
import com.yy.videoplayer.render.YYRenderFrameBuffer;
import com.yy.videoplayer.stat.PlayerExceptionDataStat;
import com.yy.videoplayer.stat.VideoDataStatHelper;
import com.yy.videoplayer.utils.TimeUtil;
import com.yy.videoplayer.utils.VideoEntities;
import com.yy.videoplayer.utils.YMFLog;
import com.yy.videoplayer.videoview.IVideoInfoCallback;
import com.yy.videoplayer.videoview.VsyncRelay;
import com.yy.videoplayer.videoview.YSpVideoView;
import com.yy.videoplayer.videoview.YspVideoViewInfo;
import com.yy.videoplayer.vr.VRLibrary;
import java.lang.ref.WeakReference;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantLock;

public class YCustomGLVideoViewHighEGLExt
extends SurfaceView
implements Runnable,
VsyncRelay.VsyncNotifier,
SurfaceHolder.Callback2,
YSpVideoView {
    private static final String TAG = "YCustomGLVideoViewHighEGLExt";
    private static final int MSG_QUIT = 0;
    private static final int MSG_SURFACE_REDRAWNEEDED = 1;
    private static final int MSG_SURFACE_CREATED = 2;
    private static final int MSG_SURFACE_CHANGED = 3;
    private static final int MSG_SURFACE_DESTROYED = 4;
    private static final int MSG_SET_SCALEMODE = 5;
    private static final int MSG_GET_SCREENSHOT = 6;
    private static final int MSG_SET_PLAYLISTENER = 7;
    private static final int MSG_LINKTOSTREAM = 8;
    private static final int MSG_UNLINKTOSTREAM = 9;
    private static final int MSG_SET_ORIENTATION = 10;
    private static final int MSG_VSYNC_ARRIVED = 11;
    private static final int MSG_SETVIDEINFOCALLBACK = 12;
    private static final int MSG_NEW_YUV_FRAME_ARRIVE = 13;
    private AtomicBoolean mReady = new AtomicBoolean(false);
    private final Object mStartLock = new Object();
    private final Object mQuitLock = new Object();
    private final Object mScreenShotLock = new Object();
    private final Object mSurfaceDestroyLock = new Object();
    private RenderHandler mHandler;
    private EglCore mEglCore;
    private EGLSurface mEnvSurface;
    private FullFrameRect mVideoScreen;
    private WindowSurface mVideoWindowSurface;
    private TexturePack mYChannel;
    private TexturePack mUChannel;
    private TexturePack mVChannel;
    private int mImageWidth = 64;
    private int mImageHeight = 64;
    private int mImageStrideWidth = 64;
    private float[] mSrcTransform;
    private float[] mTransform;
    private VideoEntities.VideoSizes mVideoSizes = new VideoEntities.VideoSizes();
    private SurfaceScaleInfo mSurfaceScaleInfo = new SurfaceScaleInfo();
    private boolean mIsImageLoaded = false;
    private Thread mThread;
    private PlayNotify mPlayNotify;
    private YYRenderFrameBuffer mFrameBuffer;
    private YYRenderFrameBuffer.newYUVFrameArrivedCallBack callback;
    private long mUserGroupId = 0L;
    private long mStreamId = 0L;
    private SmoothnessCounter mSmoothnessCounter = new SmoothnessCounter(5000L);
    private ArrayList<VideoRenderNotify> mVideoRenderNotifys = new ArrayList();
    private IVideoInfoCallback mVideoInfoCallback = null;
    private static final int VIDEO_DATA_LOG = 500;
    private long mVideoDataCnt = 0L;
    private long mRenderFailCnt = 0L;
    private VRLibrary mVRLibrary;
    private boolean mIsVrStream = false;
    private boolean mStopRender = false;
    private boolean mFirstFrameRendered = false;
    private long mFirstFrameTs = 0L;
    private int mFrames = -1;
    private int mRenderCnt = 0;
    private long mCurTime = 0L;
    private long mLastTime = 0L;
    private ReentrantLock mSurfaceDestoryedLock = new ReentrantLock(true);
    private AtomicBoolean mSurfaceDestoryedState = new AtomicBoolean(false);
    private boolean mFirstFrameSeeFlag = false;
    private YspVideoViewInfo mViewVideoInfo = new YspVideoViewInfo();
    private int mViewPortX = 0;
    private int mViewPortY = 0;
    private int mViewPortW = 0;
    private int mViewPortH = 0;
    private int mClearCount = 0;
    static final long kNotifyTimeGap = 500L;
    static final int kNofifySizeGap = 15;
    long vsyncT = 0L;
    long vsyncCnt = 0L;

    @Override
    public void stopRender() {
        this.mStopRender = true;
    }

    public YCustomGLVideoViewHighEGLExt(Context context) {
        super(context.getApplicationContext());
        this.InitThread();
    }

    public YCustomGLVideoViewHighEGLExt(Context context, AttributeSet attrs) {
        super(context.getApplicationContext(), attrs);
        this.InitThread();
    }

    public YCustomGLVideoViewHighEGLExt(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context.getApplicationContext(), attrs, defStyleAttr);
        this.InitThread();
    }

    public YCustomGLVideoViewHighEGLExt(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context.getApplicationContext(), attrs, defStyleAttr, defStyleRes);
        this.InitThread();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void InitThread() {
        this.getHolder().addCallback((SurfaceHolder.Callback)this);
        YMFLog.infoWithoutLineNum(this, "[Render]YCustomGLVideoView construct", new Object[0]);
        this.mThread = new Thread(this);
        this.mThread.setPriority(10);
        this.mThread.setName("YCustomGLVideoView");
        Object object = this.mStartLock;
        synchronized (object) {
            try {
                this.mThread.start();
                this.mStartLock.wait(500L);
            }
            catch (Throwable e) {
                YMFLog.error((Object)this, e.getMessage());
            }
        }
        YMFLog.info(this, "[Render]YCustomGLVideoView construct done Stack, usevsync:false");
    }

    @Override
    public YYRenderFrameBuffer getRenderFrameBuffer() {
        return this.mFrameBuffer;
    }

    @Override
    public void setVrStream(boolean vrStream) {
        this.mIsVrStream = vrStream;
    }

    @Override
    public YSpVideoView.ViewType getViewType() {
        return YSpVideoView.ViewType.CustomGLView;
    }

    @Override
    public boolean setScaleMode(VideoConstant.ScaleMode scaleMode) {
        if (this.mReady.get()) {
            this.mHandler.sendMessage(this.mHandler.obtainMessage(5, (Object)scaleMode));
        }
        return true;
    }

    @Override
    public VideoConstant.ScaleMode getScaleMode() {
        return this.mSurfaceScaleInfo.scaleMode;
    }

    @Override
    public boolean setScaleModeEx(int videoIndex, VideoConstant.ScaleMode scaleMode) {
        if (this.mReady.get()) {
            this.mHandler.sendMessage(this.mHandler.obtainMessage(5, (Object)scaleMode));
        }
        return true;
    }

    @Override
    public VideoConstant.ScaleMode getScaleModeEx(int videoIndex) {
        return this.mSurfaceScaleInfo.scaleMode;
    }

    @Override
    public Bitmap getVideoScreenshotExt(int videoIndex) {
        return this.getVideoScreenshot();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Bitmap getVideoScreenshot() {
        Bitmap bmp = null;
        ScreenShotInfo info = new ScreenShotInfo();
        info.isSuccess = false;
        if (this.mReady.get()) {
            Object object = this.mScreenShotLock;
            synchronized (object) {
                this.mHandler.sendMessage(this.mHandler.obtainMessage(6, info));
                try {
                    this.mScreenShotLock.wait(500L);
                }
                catch (Throwable t) {
                    YMFLog.info(this, t.getMessage());
                }
            }
        }
        if (info.isSuccess) {
            bmp = Bitmap.createBitmap((int)info.width, (int)info.height, (Bitmap.Config)Bitmap.Config.RGB_565);
            if (bmp != null) {
                bmp.copyPixelsFromBuffer(info.pixelBuffer);
            } else {
                YMFLog.error((Object)this, " Bitmap.createBitmap failed!");
            }
        }
        YMFLog.info(this, "[Render]YCustomGLVideoView GetScreenShot isSuccess " + info.isSuccess + " width " + info.width + " height " + info.height);
        return bmp;
    }

    @Override
    public void setPlayListner(PlayNotify.PlayListner pl) {
        if (this.mReady.get()) {
            this.mHandler.sendMessage(this.mHandler.obtainMessage(7, pl));
        }
    }

    @Override
    public void linkToStream(long userGroupId, long streamId) {
        YMFLog.info(this, "[Render][fastVideo]YCustomGLVideoView linktostream streamId = " + streamId + ", userGroupId = " + userGroupId);
        if (this.mReady.get()) {
            ViewLiveStatManager.getInstace().notifyEventTime(0, 3);
            StateMonitor.instance().NotifyAddView(streamId, 0, VideoConstant.ViewType.CUSTOM_GL_VIDEO_VIEW_HIGH, TAG);
            StreamInfo si = new StreamInfo();
            si.userGroupId = userGroupId;
            si.streamId = streamId;
            this.mHandler.sendMessage(this.mHandler.obtainMessage(8, si));
        }
    }

    @Override
    public void unLinkFromStreamExt(long userGroupId, long streamId, int videoIndex) {
        this.unLinkFromStream(userGroupId, streamId);
    }

    @Override
    public void unLinkFromStream(long userGroupId, long streamId) {
        YMFLog.info(this, "[Render][fastVideo]YCustomGLVideoView unlinktostream streamId = " + streamId + ", userGroupId = " + userGroupId);
        if (this.mReady.get()) {
            StreamInfo si = new StreamInfo();
            si.userGroupId = userGroupId;
            si.streamId = streamId;
            this.mHandler.sendMessage(this.mHandler.obtainMessage(9, si));
            StateMonitor.instance().NotifyRemoveView(streamId);
            ViewLiveStatManager.getInstace().notifyEventTime(4, 3);
        }
    }

    @Override
    public void unLinkFromStream() {
        YMFLog.info(this, "[Render][fastVideo]YCustomGLVideoView unlinktostream no param, streamId = " + this.mStreamId + ", userGroupId = " + this.mUserGroupId);
        if (this.mReady.get()) {
            StreamInfo si = new StreamInfo();
            si.userGroupId = this.mUserGroupId;
            si.streamId = this.mStreamId;
            this.mHandler.sendMessage(this.mHandler.obtainMessage(9, si));
            StateMonitor.instance().NotifyRemoveView(this.mStreamId);
            ViewLiveStatManager.getInstace().notifyEventTime(4, 3);
        }
    }

    @Override
    public void init() {
        if (this.mThread == null) {
            this.InitThread();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void release() {
        YMFLog.info(this, "YCustomGLVideoViewHighEGLExtrelease...");
        this.getHolder().removeCallback((SurfaceHolder.Callback)this);
        if (this.mReady.get()) {
            Object object = this.mQuitLock;
            synchronized (object) {
                try {
                    this.mHandler.removeCallbacksAndMessages(11);
                    this.mHandler.removeCallbacksAndMessages(13);
                    this.mHandler.sendMessage(this.mHandler.obtainMessage(0));
                    this.mQuitLock.wait(500L);
                    YMFLog.info(this, "[Render]YCustomGLVideoView Quit");
                }
                catch (Throwable e) {
                    YMFLog.error((Object)this, "[Render]YCustomGLVideoView Quit throwable " + e.getMessage());
                }
            }
            this.mThread = null;
        }
    }

    @Override
    public void onPause() {
    }

    @Override
    public void onResume() {
    }

    @Override
    public void setOrientation(YSpVideoView.OrientationType orientationType, int rotateAngle, boolean adjustImmediately) {
        if (this.mReady.get()) {
            this.mHandler.sendMessage(this.mHandler.obtainMessage(10, rotateAngle, adjustImmediately ? 1 : 0, (Object)orientationType));
        }
    }

    @Override
    public void onParentSizeChanged(int w, int h) {
    }

    @Override
    public boolean isReleased() {
        return this.mThread == null;
    }

    @Override
    public void OnVsyncArrived(long frameTimeNanos) {
        if (this.mReady.get()) {
            this.mHandler.sendMessage(this.mHandler.obtainMessage(11, frameTimeNanos));
        }
    }

    public void surfaceRedrawNeeded(SurfaceHolder holder) {
        if (this.mReady.get()) {
            this.mHandler.sendMessage(this.mHandler.obtainMessage(1, holder.getSurface()));
        }
    }

    public void surfaceCreated(SurfaceHolder holder) {
        YMFLog.info(TAG, "[Render]surface created");
        if (this.mReady.get()) {
            this.mHandler.sendMessage(this.mHandler.obtainMessage(2, holder.getSurface()));
        }
    }

    public void surfaceChanged(SurfaceHolder holder, int format, int width, int height) {
        YMFLog.info(TAG, "[Render]surface changed width height " + width + " " + height);
        if (this.mReady.get()) {
            this.mHandler.sendMessage(this.mHandler.obtainMessage(3, width, height, holder.getSurface()));
        }
    }

    public void surfaceDestroyed(SurfaceHolder holder) {
        YMFLog.info(TAG, "[Render]surface destroyed");
        if (this.mReady.get()) {
            this.tryLockSurfaceDestoryLock();
            this.mSurfaceDestoryedState.set(true);
            this.tryUnlockSurfaceDestroyLock();
            this.mHandler.sendMessage(this.mHandler.obtainMessage(4, holder.getSurface()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            Looper.prepare();
            this.mHandler = new RenderHandler(this);
            this.mReady.set(true);
            this.InitEGL();
            YMFLog.info(this, "[Render]YCustomGLVideoView construct done GLThread");
            Object object = this.mStartLock;
            synchronized (object) {
                this.mStartLock.notifyAll();
            }
            Looper.loop();
            this.mReady.set(false);
        }
        catch (Throwable t) {
            PlayerExceptionDataStat.getInstance().pushPlayerExceptionDataStat(this.mStreamId, "2", "101", t.getMessage());
            YMFLog.error((Object)this, "[Render]YCustomGLVideoView end looper throwable " + t.getMessage());
        }
        finally {
            YMFLog.info(this, "[Render]YCustomGLVideoView end GLThread");
            try {
                this.DeInitEGL();
            }
            catch (Throwable t) {
                PlayerExceptionDataStat.getInstance().pushPlayerExceptionDataStat(this.mStreamId, "2", "103", t.getMessage());
                YMFLog.error((Object)this, "[Render]YCustomGLVideoView DeInitEGL throwable " + t.getMessage());
            }
            Object t = this.mQuitLock;
            synchronized (t) {
                this.mQuitLock.notifyAll();
            }
        }
    }

    private void tryLockSurfaceDestoryLock() {
        if (this.mSurfaceDestoryedLock.getHoldCount() == 0) {
            this.mSurfaceDestoryedLock.lock();
        }
    }

    private void tryUnlockSurfaceDestroyLock() {
        try {
            while (this.mSurfaceDestoryedLock.getHoldCount() != 0) {
                this.mSurfaceDestoryedLock.unlock();
            }
        }
        catch (IllegalMonitorStateException e) {
            YMFLog.warn(TAG, "tryUnlockSurfaceDestroyLock more than once");
        }
    }

    private void onVideoRenderNotify(long userGroupId, long streamId, long pts, long renderTimeStamp, long decodeStamp) {
        if (this.mVideoRenderNotifys == null) {
            return;
        }
        this.mVideoRenderNotifys.add(new VideoRenderNotify(userGroupId, streamId, pts, renderTimeStamp, decodeStamp));
        Iterator<VideoRenderNotify> it = this.mVideoRenderNotifys.iterator();
        if (!it.hasNext()) {
            return;
        }
        long firstPts = it.next().mPts;
        if (pts - firstPts < 500L && this.mVideoRenderNotifys.size() < 15 && this.mFirstFrameRendered) {
            return;
        }
        if (!this.mFirstFrameRendered) {
            YMFLog.info(TAG, "first frame finish decode,onVideoRenderNotify");
        }
        YYVideoLibMgr.instance().onVideoRenderNotify(this.mVideoRenderNotifys);
        this.mVideoRenderNotifys.clear();
    }

    public void handleNewYUVFrameArrived() {
        this.handleVsync(0L);
        if (this.mFrameBuffer != null) {
            this.mFrameBuffer.setFrameRendered();
        }
    }

    public void handleOnVsyncArrived(long frameTimeNanos) {
        ++this.vsyncCnt;
        long t1 = System.currentTimeMillis();
        if (t1 - this.vsyncT > 6000L) {
            this.vsyncT = t1;
            YMFLog.debug((Object)this, "[Render]YCustomGLVideoView vsync count in 6 seconds " + this.vsyncCnt);
            this.vsyncCnt = 0L;
        }
        this.handleVsync(frameTimeNanos);
    }

    private void handleVsync(long frameTimeNanos) {
        if (this.mStopRender) {
            YMFLog.error((Object)this, "YCustomGLVideoViewHighEGL Render stopped ...");
            return;
        }
        boolean frameChanged = this.mFrameBuffer.hasFrame();
        ByteBuffer frame = this.mFrameBuffer.getFrame();
        int pts = this.mFrameBuffer.getCurFramePts();
        if (null != frame && frameChanged) {
            long currentTs;
            StateMonitor.NotifyPts(this.mStreamId, pts);
            ViewLiveStatManager.getInstace().reportFrameEvent(0);
            if (this.mVideoDataCnt++ % 500L == 0L) {
                YMFLog.info(this, "[Decoder]YCustomGLVideoView handleVsync frame count " + this.mVideoDataCnt);
            }
            if (!this.mFirstFrameRendered) {
                this.mFirstFrameTs = System.currentTimeMillis();
            }
            if (!this.mFrameBuffer.getMissRenderFlag()) {
                this.onVideoRenderNotify(this.mUserGroupId, this.mStreamId, pts, TimeUtil.getTickCountLong(), this.mFrameBuffer.getLastDecodeTimeStamp());
            } else {
                YMFLog.info(this, "[Decoder]YCustomGLVideoView getMissRenderFlag true pts : " + pts + " decode:" + this.mFrameBuffer.getLastDecodeTimeStamp() + "/" + TimeUtil.getTickCountLong());
            }
            if (this.mImageWidth != this.mFrameBuffer.getPixWidth() || this.mImageHeight != this.mFrameBuffer.getHeight() || this.mImageStrideWidth != this.mFrameBuffer.getWidth()) {
                this.mImageWidth = this.mFrameBuffer.getPixWidth();
                this.mImageHeight = this.mFrameBuffer.getHeight();
                this.mImageStrideWidth = this.mFrameBuffer.getWidth();
                this.mSrcTransform = this.calcSrcTransform(this.mImageWidth, this.mImageHeight, this.mImageStrideWidth, this.mImageHeight);
                System.arraycopy(this.mSrcTransform, 0, this.mTransform, 0, 16);
                this.mVideoSizes.mVideoWidth = this.mImageWidth;
                this.mVideoSizes.mVideoHeight = this.mImageHeight;
                this.updateDisplayRegion();
                if (this.mVideoInfoCallback != null) {
                    this.mVideoInfoCallback.onUpdateVideoSizeChanged(this.mStreamId, this.mImageWidth, this.mImageHeight);
                }
            }
            if (this.mVideoDataCnt == 1L) {
                ViewLiveStatManager.getInstace().notifyEventTime(2, 3, new ViewLiveStatManager.StatVideoHeaderInfo(this.mImageStrideWidth, this.mImageHeight));
            }
            this.loadDataToTexture(this.mYChannel, frame.position(this.mFrameBuffer.getOffsetY()), this.mFrameBuffer.getWidthY(), this.mFrameBuffer.getHeightY());
            this.loadDataToTexture(this.mUChannel, frame.position(this.mFrameBuffer.getOffsetU()), this.mFrameBuffer.getWidthUV(), this.mFrameBuffer.getHeightUV());
            this.loadDataToTexture(this.mVChannel, frame.position(this.mFrameBuffer.getOffsetV()), this.mFrameBuffer.getWidthUV(), this.mFrameBuffer.getHeightUV());
            this.mIsImageLoaded = true;
            this.drawCurrentFrame();
            ViewLiveStatManager.getInstace().reportFrameEvent(1);
            if (this.mVideoDataCnt == 1L) {
                ViewLiveStatManager.getInstace().notifyEventTime(3, 3);
            }
            if (this.mSmoothnessCounter.RenderOneFrame(this.mStreamId, currentTs = System.currentTimeMillis())) {
                double coef = this.mSmoothnessCounter.ComputeCoefficientOfVariationAndReset();
                YYVideoLibMgr.instance().onCoefficientOfVariationOfRenderInterval(this.mUserGroupId, this.mStreamId, this.mSmoothnessCounter.GetIntervalMilliTs(), coef);
            }
            ++this.mFrames;
            if (!this.mFirstFrameRendered) {
                YMFLog.info(this, "[Decoder][fastVideo]YCustomGLVideoViewHighEGL handleVsync notify first frame out, cost = " + (currentTs - this.mFirstFrameTs));
                YYVideoLibMgr.instance().onFirstFrameRenderNotify(this.mUserGroupId, this.mStreamId, currentTs, currentTs - this.mFirstFrameTs, this.mFrames);
                StateMonitor.instance();
                StateMonitor.NotifyFirstFrameRendered(this.mStreamId, TimeUtil.getTickCount());
                this.mFirstFrameRendered = true;
            }
            ++this.mRenderCnt;
            this.mCurTime = System.currentTimeMillis();
            if (this.mLastTime == 0L) {
                this.mLastTime = this.mCurTime;
            }
            if (this.mCurTime - this.mLastTime >= 1000L) {
                StateMonitor.instance().NotifyRenderFrameRate(this.mStreamId, this.mRenderCnt);
                this.mLastTime = this.mCurTime;
                this.mRenderCnt = 0;
            }
        } else if (frame == null) {
            ViewLiveStatManager.getInstace().reportDecError(0);
            if (this.mRenderFailCnt++ % 500L == 0L) {
                YMFLog.info(this, "[Decoder]YCustomGLVideoView handleVsync failed, frameChanged:" + frameChanged + ", count " + this.mRenderFailCnt);
            }
        }
    }

    private void loadDataToTexture(TexturePack texturePack, Buffer data, int width, int height) {
        if (data == null || texturePack.textureId <= 0 || width <= 0 || height <= 0) {
            YMFLog.error((Object)TAG, "loadDataToTexture invalid parameter");
            return;
        }
        GLES20.glBindTexture((int)3553, (int)texturePack.textureId);
        if (texturePack.width != width || texturePack.height != height) {
            if ((width & 3) != 0) {
                YMFLog.info(TAG, "glTexImage2D width:" + width + " GL_UNPACK_ALIGNMENT: 1");
                GLES20.glPixelStorei((int)3317, (int)1);
            } else {
                GLES20.glPixelStorei((int)3317, (int)4);
            }
            GLES20.glTexImage2D((int)3553, (int)0, (int)6409, (int)width, (int)height, (int)0, (int)6409, (int)5121, (Buffer)data);
            texturePack.height = height;
            texturePack.width = width;
        } else {
            GLES20.glTexSubImage2D((int)3553, (int)0, (int)0, (int)0, (int)width, (int)height, (int)6409, (int)5121, (Buffer)data);
        }
    }

    private float[] calcSrcTransform(int imageWidth, int imageHeight, int frameWidth, int frameHeight) {
        float[] mt = new float[]{1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f};
        Matrix.scaleM((float[])mt, (int)0, (float)(1.0f * (float)(--imageWidth) / (float)frameWidth), (float)(1.0f * (float)(--imageHeight) / (float)frameHeight), (float)1.0f);
        Matrix.rotateM((float[])mt, (int)0, (float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        Matrix.translateM((float[])mt, (int)0, (float)0.0f, (float)-1.0f, (float)0.0f);
        return mt;
    }

    private void drawCurrentFrame() {
        this.tryLockSurfaceDestoryLock();
        long drawStartTime = System.currentTimeMillis();
        if (this.mVideoWindowSurface != null && this.mIsImageLoaded && !this.mSurfaceDestoryedState.get()) {
            try {
                if (this.mPlayNotify != null) {
                    this.mPlayNotify.DrawNotify();
                }
                if (!this.mFirstFrameSeeFlag) {
                    YYVideoLibMgr.instance().onFirstFrameSeeNotify(this.mUserGroupId, this.mStreamId, System.currentTimeMillis() - this.mFirstFrameTs);
                    this.mFirstFrameSeeFlag = true;
                }
                if (this.mVideoInfoCallback != null) {
                    this.mVideoInfoCallback.onUpdatePts(this.mStreamId, this.mFrameBuffer.getCurFramePts());
                }
                GLES20.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                GLES20.glClear((int)16640);
                GLES20.glViewport((int)this.mVideoSizes.mViewX, (int)this.mVideoSizes.mViewY, (int)this.mVideoSizes.mViewWidth, (int)this.mVideoSizes.mViewHeight);
                if (!this.mIsVrStream) {
                    this.mVideoScreen.drawFrame(this.mYChannel.textureId, this.mUChannel.textureId, this.mVChannel.textureId, this.mTransform);
                } else {
                    this.mVRLibrary.drawFrame(-1, this.mTransform, this.mYChannel.textureId, this.mUChannel.textureId, this.mVChannel.textureId);
                }
                this.mVideoWindowSurface.swapBuffers();
            }
            catch (Throwable t) {
                PlayerExceptionDataStat.getInstance().pushPlayerExceptionDataStat(this.mStreamId, "2", "102", t.getMessage());
                YMFLog.error((Object)this, t.getMessage());
                this.tryUnlockSurfaceDestroyLock();
                this.handleSurfaceDestroyed(this.mSurfaceScaleInfo.surface);
            }
        }
        long renderTime = System.currentTimeMillis() - drawStartTime;
        VideoDataStatHelper.putRenderTime(renderTime);
        this.tryUnlockSurfaceDestroyLock();
    }

    private void InitEGL() {
        this.mEglCore = new EglCore();
        this.mEnvSurface = this.mEglCore.createOffscreenSurface(320, 240);
        this.mEglCore.makeCurrent(this.mEnvSurface);
        this.mVideoScreen = new FullFrameRect(new Texture2dProgram(Texture2dProgram.ProgramType.TEXTURE_YUV));
        this.mVRLibrary = new VRLibrary(this.getContext().getApplicationContext());
        this.mVRLibrary.initLibrary(false);
        this.mSrcTransform = new float[]{1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f};
        Matrix.rotateM((float[])this.mSrcTransform, (int)0, (float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        Matrix.translateM((float[])this.mSrcTransform, (int)0, (float)0.0f, (float)-1.0f, (float)0.0f);
        this.mTransform = new float[16];
        System.arraycopy(this.mSrcTransform, 0, this.mTransform, 0, 16);
        this.mYChannel = new TexturePack();
        this.mYChannel.textureId = this.genTexture();
        this.mUChannel = new TexturePack();
        this.mUChannel.textureId = this.genTexture();
        this.mVChannel = new TexturePack();
        this.mVChannel.textureId = this.genTexture();
        this.callback = new YYRenderFrameBuffer.newYUVFrameArrivedCallBack(){

            @Override
            public void onNewYUVFrameArrive() {
                if (YCustomGLVideoViewHighEGLExt.this.mReady.get()) {
                    YCustomGLVideoViewHighEGLExt.this.mHandler.sendMessage(YCustomGLVideoViewHighEGLExt.this.mHandler.obtainMessage(13));
                } else if (YCustomGLVideoViewHighEGLExt.this.mFrameBuffer != null) {
                    YCustomGLVideoViewHighEGLExt.this.mFrameBuffer.setFrameRendered();
                }
            }
        };
        this.mFrameBuffer = new YYRenderFrameBuffer(true);
        this.mFrameBuffer.setYUVFrameArriveCallback(this.callback);
        this.mPlayNotify = new PlayNotify();
        this.mPlayNotify.Init();
        this.mVideoRenderNotifys.clear();
    }

    private int genTexture() {
        int[] textures = new int[1];
        GLES20.glGenTextures((int)1, (int[])textures, (int)0);
        GLES20.glBindTexture((int)3553, (int)textures[0]);
        GLES20.glTexParameterf((int)3553, (int)10241, (float)9729.0f);
        GLES20.glTexParameterf((int)3553, (int)10240, (float)9729.0f);
        GLES20.glTexParameteri((int)3553, (int)10242, (int)33071);
        GLES20.glTexParameteri((int)3553, (int)10243, (int)33071);
        return textures[0];
    }

    private void releaseTexture(TexturePack texturePack) {
        if (texturePack.textureId >= 0) {
            int[] textures = new int[]{texturePack.textureId};
            GLES20.glDeleteTextures((int)1, (int[])textures, (int)0);
            texturePack.textureId = -1;
            texturePack.width = -1;
            texturePack.height = -1;
        }
    }

    private void DeInitEGL() {
        YMFLog.info(this, "[Render]YCustomGLVideoView DeInitEGL");
        VsyncRelay.getInstance().UnRegisterVsyncNotifier(this);
        this.tryLockSurfaceDestoryLock();
        if (this.mFrameBuffer != null) {
            this.mFrameBuffer.release();
        }
        if (this.mPlayNotify != null) {
            this.mPlayNotify.Release();
            this.mPlayNotify = null;
        }
        if (this.mSurfaceScaleInfo != null) {
            this.mSurfaceScaleInfo.videoView = null;
            this.mSurfaceScaleInfo.surface = null;
            this.mSurfaceScaleInfo = null;
        }
        if (this.mYChannel != null) {
            this.releaseTexture(this.mYChannel);
        }
        if (this.mUChannel != null) {
            this.releaseTexture(this.mUChannel);
        }
        if (this.mVChannel != null) {
            this.releaseTexture(this.mVChannel);
        }
        if (this.mVideoScreen != null) {
            this.mVideoScreen.release(true);
            this.mVideoScreen = null;
        }
        if (this.mVRLibrary != null) {
            this.mVRLibrary.destroyLibrary();
        }
        if (this.mVideoWindowSurface != null) {
            this.mVideoWindowSurface.release();
            this.mVideoWindowSurface = null;
        }
        if (this.mEnvSurface != null) {
            this.mEglCore.makeNothingCurrent();
            this.mEglCore.releaseSurface(this.mEnvSurface);
            this.mEnvSurface = null;
        }
        this.tryUnlockSurfaceDestroyLock();
        if (this.mEglCore != null) {
            this.mEglCore.release();
            this.mEglCore = null;
        }
    }

    private void updateDisplayRegion() {
        VideoSizeUtils.Size si;
        if (this.mSurfaceScaleInfo == null) {
            return;
        }
        if (this.mSurfaceScaleInfo.orientationType == YSpVideoView.OrientationType.Force || this.mSurfaceScaleInfo.orientationType == YSpVideoView.OrientationType.Auto && this.mVideoSizes.mVideoWidth < this.mVideoSizes.mVideoHeight != this.mVideoSizes.mVideoSurfaceWidth < this.mVideoSizes.mVideoSurfaceHeight) {
            si = this.mSurfaceScaleInfo.rotateAngle != 0 && this.mSurfaceScaleInfo.rotateAngle != 180 ? VideoSizeUtils.CalcFitSize(this.mVideoSizes.mVideoHeight, this.mVideoSizes.mVideoWidth, this.mVideoSizes.mVideoSurfaceWidth, this.mVideoSizes.mVideoSurfaceHeight, this.mSurfaceScaleInfo.scaleMode) : VideoSizeUtils.CalcFitSize(this.mVideoSizes.mVideoWidth, this.mVideoSizes.mVideoHeight, this.mVideoSizes.mVideoSurfaceWidth, this.mVideoSizes.mVideoSurfaceHeight, this.mSurfaceScaleInfo.scaleMode);
            Matrix.translateM((float[])this.mTransform, (int)0, (float[])this.mSrcTransform, (int)0, (float)0.5f, (float)0.5f, (float)0.0f);
            Matrix.rotateM((float[])this.mTransform, (int)0, (float)this.mSurfaceScaleInfo.rotateAngle, (float)0.0f, (float)0.0f, (float)1.0f);
            Matrix.translateM((float[])this.mTransform, (int)0, (float)-0.5f, (float)-0.5f, (float)0.0f);
        } else {
            si = VideoSizeUtils.CalcFitSize(this.mVideoSizes.mVideoWidth, this.mVideoSizes.mVideoHeight, this.mVideoSizes.mVideoSurfaceWidth, this.mVideoSizes.mVideoSurfaceHeight, this.mSurfaceScaleInfo.scaleMode);
        }
        this.mVideoSizes.mViewX = si.x;
        this.mVideoSizes.mViewY = si.y;
        this.mVideoSizes.mViewWidth = si.width;
        this.mVideoSizes.mViewHeight = si.height;
        this.mViewVideoInfo.viewX = this.mVideoSizes.mViewX;
        this.mViewVideoInfo.viewY = this.mVideoSizes.mViewY;
    }

    private void handleSurfaceRedrawNeeded(Surface surface) {
        this.drawCurrentFrame();
    }

    private void handleSurfaceCreated(Surface surface) {
        this.tryLockSurfaceDestoryLock();
        if (this.mVideoWindowSurface != null) {
            this.mEglCore.makeCurrent(this.mEnvSurface);
            this.mVideoWindowSurface.release();
            this.mVideoWindowSurface = null;
        }
        try {
            this.mSurfaceScaleInfo.surface = surface;
            this.mVideoWindowSurface = new WindowSurface(this.mEglCore, this.mSurfaceScaleInfo.surface, false);
            this.mVideoWindowSurface.makeCurrent();
        }
        catch (Throwable t) {
            this.tryUnlockSurfaceDestroyLock();
            YMFLog.error((Object)this, "[Render]YCustomGLVideoView handleSurfaceCreated throwable " + t.getMessage());
        }
        this.mSurfaceDestoryedState.set(false);
        this.tryUnlockSurfaceDestroyLock();
        this.mSmoothnessCounter.ResetToInitialState();
        VsyncRelay.getInstance().RegisterVsyncNotifier(this);
    }

    private void handleSurfaceChanged(Surface surface, int width, int height) {
        this.mVideoSizes.mVideoSurfaceWidth = width;
        this.mVideoSizes.mVideoSurfaceHeight = height;
        if (this.mVRLibrary != null) {
            this.mVRLibrary.updateViewport(this.mVideoSizes.mVideoSurfaceWidth, this.mVideoSizes.mVideoSurfaceHeight);
        }
        this.updateDisplayRegion();
        for (int i = 0; i < 2; ++i) {
            this.drawCurrentFrame();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleSurfaceDestroyed(Surface surface) {
        VsyncRelay.getInstance().UnRegisterVsyncNotifier(this);
        this.tryLockSurfaceDestoryLock();
        if (this.mVideoWindowSurface != null) {
            this.mEglCore.makeCurrent(this.mEnvSurface);
            this.mVideoWindowSurface.release();
            this.mVideoWindowSurface = null;
        }
        if (this.mSurfaceScaleInfo != null) {
            this.mSurfaceScaleInfo.videoView = null;
            this.mSurfaceScaleInfo.surface = null;
        }
        this.tryUnlockSurfaceDestroyLock();
        Object object = this.mSurfaceDestroyLock;
        synchronized (object) {
            this.mSurfaceDestroyLock.notifyAll();
        }
    }

    private void handleSetScaleMode(VideoConstant.ScaleMode scaleMode) {
        this.mSurfaceScaleInfo.scaleMode = scaleMode;
        this.updateDisplayRegion();
        this.drawCurrentFrame();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleGetScreenShot(ScreenShotInfo info) {
        try {
            info.isSuccess = false;
            YYRenderFrameBuffer.RGB565ImageWithNoPadding img = new YYRenderFrameBuffer.RGB565ImageWithNoPadding();
            if (this.mFrameBuffer.GetCurrentPictureDataRGB565(img)) {
                info.height = img.mHeight;
                info.width = img.mWidth;
                info.pixelBuffer = ByteBuffer.wrap(img.mData);
                info.isSuccess = true;
            }
        }
        catch (Throwable t) {
            YMFLog.error((Object)this, "[Render]YCustomGLVideoView handleGetScreenShot throwable " + t.getMessage());
        }
        Object object = this.mScreenShotLock;
        synchronized (object) {
            this.mScreenShotLock.notifyAll();
        }
    }

    private void handleSetPlayListner(PlayNotify.PlayListner playListner) {
        this.mPlayNotify.setPlayListner(playListner);
    }

    private void handleLinktoStream(long userGroupId, long streamId) {
        this.mUserGroupId = userGroupId;
        this.mStreamId = streamId;
        this.mFrameBuffer.linkToStream(userGroupId, streamId);
        this.mPlayNotify.EndPlay(false);
        this.mPlayNotify.setVideoIds(userGroupId, streamId);
    }

    private void handleUnlinktoStream(long userGroupId, long streamId) {
        StateMonitor.NotifyClearPts(streamId);
        this.mFrameBuffer.unLinkFromStream(userGroupId, streamId);
        if (this.mPlayNotify != null) {
            this.mPlayNotify.EndPlay(true);
        }
    }

    private void handleSetOrientation(int rotateAngle, YSpVideoView.OrientationType orientationType) {
        this.mSurfaceScaleInfo.rotateAngle = rotateAngle;
        this.mSurfaceScaleInfo.orientationType = orientationType;
        this.updateDisplayRegion();
        this.drawCurrentFrame();
    }

    public void handleSetVideoInfoCallback(IVideoInfoCallback callback) {
        this.mVideoInfoCallback = callback;
        YMFLog.info(this, " handleSetVideoInfoCallback ");
    }

    @Override
    public void setVideoInfoCallback(IVideoInfoCallback iVideoInfoCallback) {
        if (this.mReady.get()) {
            YMFLog.info(this, " setVideoInfoCallback ");
            this.mHandler.sendMessage(this.mHandler.obtainMessage(12, iVideoInfoCallback));
        }
    }

    @Override
    public void linkToStreamExt(long userGroupId, long streamId, int videoIndex) {
    }

    @Override
    public YspVideoViewInfo getVideoViewInfo(long streamid) {
        if (streamid == this.mStreamId && this.mViewVideoInfo != null) {
            return this.mViewVideoInfo;
        }
        return null;
    }

    private static class RenderHandler
    extends Handler {
        private WeakReference<YCustomGLVideoViewHighEGLExt> mWeakWay;

        public RenderHandler(YCustomGLVideoViewHighEGLExt hardDecodeWay) {
            this.mWeakWay = new WeakReference<YCustomGLVideoViewHighEGLExt>(hardDecodeWay);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void handleMessage(Message msg) {
            int what = msg.what;
            if (0 == what) {
                Looper loop = Looper.myLooper();
                if (null == loop) return;
                loop.quit();
                this.removeCallbacksAndMessages(null);
                return;
            }
            YCustomGLVideoViewHighEGLExt customGLVideoView = (YCustomGLVideoViewHighEGLExt)this.mWeakWay.get();
            if (customGLVideoView == null) {
                YMFLog.warn(YCustomGLVideoViewHighEGLExt.TAG, "[Render]YCustomGLVideoView RenderHandler.handleMessage: hardDecodeWay is null");
                return;
            }
            try {
                switch (what) {
                    case 1: {
                        customGLVideoView.handleSurfaceRedrawNeeded((Surface)msg.obj);
                        return;
                    }
                    case 2: {
                        customGLVideoView.handleSurfaceCreated((Surface)msg.obj);
                        return;
                    }
                    case 3: {
                        customGLVideoView.handleSurfaceChanged((Surface)msg.obj, msg.arg1, msg.arg2);
                        return;
                    }
                    case 4: {
                        customGLVideoView.handleSurfaceDestroyed((Surface)msg.obj);
                        return;
                    }
                    case 5: {
                        customGLVideoView.handleSetScaleMode((VideoConstant.ScaleMode)((Object)msg.obj));
                        return;
                    }
                    case 6: {
                        customGLVideoView.handleGetScreenShot((ScreenShotInfo)msg.obj);
                        return;
                    }
                    case 7: {
                        customGLVideoView.handleSetPlayListner((PlayNotify.PlayListner)msg.obj);
                        return;
                    }
                    case 8: {
                        StreamInfo si = (StreamInfo)msg.obj;
                        customGLVideoView.handleLinktoStream(si.userGroupId, si.streamId);
                        return;
                    }
                    case 9: {
                        StreamInfo si1 = (StreamInfo)msg.obj;
                        customGLVideoView.handleUnlinktoStream(si1.userGroupId, si1.streamId);
                        return;
                    }
                    case 10: {
                        customGLVideoView.handleSetOrientation(msg.arg1, (YSpVideoView.OrientationType)((Object)msg.obj));
                        return;
                    }
                    case 11: {
                        customGLVideoView.handleOnVsyncArrived((Long)msg.obj);
                        return;
                    }
                    case 12: {
                        customGLVideoView.handleSetVideoInfoCallback((IVideoInfoCallback)msg.obj);
                        return;
                    }
                    case 13: {
                        customGLVideoView.handleNewYUVFrameArrived();
                        return;
                    }
                }
                return;
            }
            catch (Exception e) {
                YMFLog.error((Object)YCustomGLVideoViewHighEGLExt.TAG, " handleMessage error:" + YMFLog.stackTraceOf(e));
                return;
            }
            finally {
                customGLVideoView.tryUnlockSurfaceDestroyLock();
            }
        }
    }

    private static class TexturePack {
        public int textureId = -1;
        public int width = -1;
        public int height = -1;

        private TexturePack() {
        }
    }

    private static class StreamInfo {
        public long userGroupId;
        public long streamId;

        private StreamInfo() {
        }
    }

    private static class ScreenShotInfo {
        public boolean isSuccess;
        public Buffer pixelBuffer;
        public int width;
        public int height;

        private ScreenShotInfo() {
        }
    }

    private static class SurfaceScaleInfo {
        public View videoView;
        public Surface surface;
        public int width = 64;
        public int height = 64;
        public int parentWidth = 64;
        public int parentHeight = 64;
        public int rotateAngle = 0;
        public YSpVideoView.OrientationType orientationType = YSpVideoView.OrientationType.Normal;
        public VideoConstant.ScaleMode scaleMode = VideoConstant.ScaleMode.AspectFit;

        private SurfaceScaleInfo() {
        }
    }
}

