/*
 * Decompiled with CFR 0.152.
 */
package com.yy.videoplayer.utils;

import android.os.Process;
import android.util.Log;
import com.yy.videoplayer.utils.BasicFileUtils;
import com.yy.videoplayer.utils.ILog;
import com.yy.videoplayer.utils.LogToES;
import com.yy.videoplayer.utils.StringUtils;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.IllegalFormatException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicReference;

public class YMFLog {
    private static ILog mLogger = null;
    private static boolean mIsDebug = false;
    private static boolean mIsSaveToFile = false;
    private static boolean mCloseLog = false;
    private static String mLogPath = null;
    private static long LEN_128K = 131072L;
    private static long LEN_256K = 262144L;
    private static ExecutorService mSingleThreadPool = Executors.newSingleThreadExecutor(new YMFLogThreadFactory());
    private static AtomicReference<String> mThreadStacksKeyword = new AtomicReference<String>("com.duowan.mobile");

    private static String tag() {
        return "[yyvideoplayer]";
    }

    private static boolean isDebuggable() {
        return mIsDebug;
    }

    private static boolean isSaveToFile() {
        return mIsSaveToFile;
    }

    public static void CloseLog() {
        mCloseLog = true;
    }

    public static void OpenLog() {
        mCloseLog = false;
    }

    public static void setFilePath(String path) {
        mLogPath = path;
        LogToES.setLogPath(path);
    }

    public static void setDebug(boolean enable) {
        mIsDebug = enable;
    }

    public static void setSaveToFile(boolean enable) {
        mIsSaveToFile = enable;
    }

    public static void registerLogger(Object logger) {
        mLogger = (ILog)logger;
    }

    public static void verbose(Object obj, String format, Object ... args) {
        if (mCloseLog) {
            return;
        }
        if (YMFLog.isDebuggable()) {
            try {
                String msg = String.format(format, args);
                int line = YMFLog.getCallerLineNumber();
                String filename = YMFLog.getCallerFilename();
                String logText = YMFLog.msgForTextLog(1, obj, filename, line, msg);
                if (mLogger != null) {
                    mLogger.verbose(YMFLog.tag(), logText);
                } else {
                    Log.v((String)YMFLog.tag(), (String)logText);
                }
            }
            catch (IllegalFormatException e) {
                Log.e((String)YMFLog.tag(), (String)"IllegalFormatException happened: ", (Throwable)e);
            }
            catch (NullPointerException e) {
                Log.e((String)YMFLog.tag(), (String)"NullPointerException happened: ", (Throwable)e);
            }
        }
    }

    public static void verbose(Object obj, String msg) {
        if (mCloseLog) {
            return;
        }
        if (YMFLog.isDebuggable()) {
            int line = YMFLog.getCallerLineNumber();
            String filename = YMFLog.getCallerFilename();
            String logText = YMFLog.msgForTextLog(1, obj, filename, line, msg);
            if (mLogger != null) {
                mLogger.verbose(YMFLog.tag(), logText);
            } else {
                Log.v((String)YMFLog.tag(), (String)logText);
            }
        }
    }

    public static void debug(Object obj, String format, Object ... args) {
        if (mCloseLog) {
            return;
        }
        if (YMFLog.isDebuggable()) {
            try {
                String msg = String.format(format, args);
                String logText = YMFLog.msgForTextLog(2, obj, "", 0, msg);
                if (mLogger != null) {
                    mLogger.debug(YMFLog.tag(), logText);
                } else {
                    Log.d((String)YMFLog.tag(), (String)logText);
                }
                if (YMFLog.isSaveToFile() && BasicFileUtils.externalStorageExist()) {
                    YMFLog.logToFile(logText);
                }
            }
            catch (IllegalFormatException e) {
                Log.e((String)YMFLog.tag(), (String)"IllegalFormatException happened: ", (Throwable)e);
            }
            catch (NullPointerException e) {
                Log.e((String)YMFLog.tag(), (String)"NullPointerException happened: ", (Throwable)e);
            }
        }
    }

    public static String debug(Object obj, String msg) {
        if (mCloseLog) {
            return null;
        }
        if (YMFLog.isDebuggable()) {
            String logText = YMFLog.msgForTextLog(2, obj, "", 0, msg);
            if (mLogger != null) {
                mLogger.debug(YMFLog.tag(), logText);
            } else {
                Log.d((String)YMFLog.tag(), (String)logText);
            }
        }
        return msg;
    }

    public static void debug(Object obj, Throwable t) {
        if (mCloseLog) {
            return;
        }
        if (YMFLog.isDebuggable()) {
            String logText = YMFLog.msgForException(obj, "", "", 0);
            if (mLogger != null) {
                mLogger.debug(YMFLog.tag(), logText);
            } else {
                Log.d((String)YMFLog.tag(), (String)logText, (Throwable)t);
            }
            if (YMFLog.isSaveToFile() && BasicFileUtils.externalStorageExist()) {
                YMFLog.logToFile(logText, t);
            }
        }
    }

    public static void info(Object obj, String format, Object ... args) {
        if (mCloseLog) {
            return;
        }
        try {
            String msg = String.format(format, args);
            String logText = YMFLog.msgForTextLog(3, obj, "", 0, msg);
            if (mLogger != null) {
                mLogger.info(YMFLog.tag(), logText);
            } else {
                Log.i((String)YMFLog.tag(), (String)logText);
                YMFLog.logToFile(logText);
            }
        }
        catch (IllegalFormatException e) {
            Log.e((String)YMFLog.tag(), (String)"IllegalFormatException happened: ", (Throwable)e);
        }
        catch (NullPointerException e) {
            Log.e((String)YMFLog.tag(), (String)"NullPointerException happened: ", (Throwable)e);
        }
    }

    public static void infoWithoutLineNum(Object obj, String format, Object ... args) {
        if (mCloseLog) {
            return;
        }
        try {
            String msg = String.format(format, args);
            String logText = YMFLog.msgForTextLog(3, obj, "", 0, msg);
            if (mLogger != null) {
                mLogger.info(YMFLog.tag(), logText);
            } else {
                Log.i((String)YMFLog.tag(), (String)logText);
                YMFLog.logToFile(logText);
            }
        }
        catch (IllegalFormatException e) {
            Log.e((String)YMFLog.tag(), (String)"IllegalFormatException happened: ", (Throwable)e);
        }
        catch (NullPointerException e) {
            Log.e((String)YMFLog.tag(), (String)"NullPointerException happened: ", (Throwable)e);
        }
    }

    public static void info(Object obj, String msg) {
        if (mCloseLog) {
            return;
        }
        String logText = YMFLog.msgForTextLog(3, obj, "", 0, msg);
        if (mLogger != null) {
            mLogger.info(YMFLog.tag(), logText);
        } else {
            Log.i((String)YMFLog.tag(), (String)logText);
            YMFLog.logToFile(logText);
        }
    }

    public static void info(String clz, String msg) {
        if (mCloseLog) {
            return;
        }
        String logText = YMFLog.msgForTextLog(3, clz, "", 0, msg);
        if (mLogger != null) {
            mLogger.info(YMFLog.tag(), logText);
        } else {
            Log.i((String)YMFLog.tag(), (String)logText);
            YMFLog.logToFile(logText);
        }
    }

    public static void warnWithoutLineNum(Object obj, String format, Object ... args) {
        if (mCloseLog) {
            return;
        }
        try {
            String msg = String.format(format, args);
            String logText = YMFLog.msgForTextLog(4, obj, "", 0, msg);
            if (mLogger != null) {
                mLogger.warn(YMFLog.tag(), logText);
            } else {
                Log.w((String)YMFLog.tag(), (String)logText);
            }
        }
        catch (IllegalFormatException e) {
            Log.e((String)YMFLog.tag(), (String)"IllegalFormatException happened: ", (Throwable)e);
        }
        catch (NullPointerException e) {
            Log.e((String)YMFLog.tag(), (String)"NullPointerException happened: ", (Throwable)e);
        }
    }

    public static void warn(Object obj, String format, Object ... args) {
        if (mCloseLog) {
            return;
        }
        try {
            String msg = String.format(format, args);
            String logText = YMFLog.msgForTextLog(4, obj, "", 0, msg);
            if (mLogger != null) {
                mLogger.warn(YMFLog.tag(), logText);
            } else {
                Log.w((String)YMFLog.tag(), (String)logText);
            }
        }
        catch (IllegalFormatException e) {
            Log.e((String)YMFLog.tag(), (String)"IllegalFormatException happened: ", (Throwable)e);
        }
        catch (NullPointerException e) {
            Log.e((String)YMFLog.tag(), (String)"NullPointerException happened: ", (Throwable)e);
        }
    }

    public static void warn(Object obj, String msg) {
        if (mCloseLog) {
            return;
        }
        String logText = YMFLog.msgForTextLog(4, obj, "", 0, msg);
        if (mLogger != null) {
            mLogger.warn(YMFLog.tag(), logText);
        } else {
            Log.w((String)YMFLog.tag(), (String)logText);
        }
    }

    public static void errorWithoutLineNum(Object obj, String format, Object ... args) {
        if (mCloseLog) {
            return;
        }
        try {
            String msg = String.format(format, args);
            String logText = YMFLog.msgForTextLog(5, obj, "", 0, msg);
            if (mLogger != null) {
                mLogger.error(YMFLog.tag(), logText);
            } else {
                Log.e((String)YMFLog.tag(), (String)logText);
                YMFLog.logToFile(logText);
            }
        }
        catch (IllegalFormatException e) {
            Log.e((String)YMFLog.tag(), (String)"IllegalFormatException happened: ", (Throwable)e);
        }
        catch (NullPointerException e) {
            Log.e((String)YMFLog.tag(), (String)"NullPointerException happened: ", (Throwable)e);
        }
    }

    public static void error(Object obj, String format, Object ... args) {
        if (mCloseLog) {
            return;
        }
        try {
            String msg = String.format(format, args);
            int line = YMFLog.getCallerLineNumber();
            String filename = YMFLog.getCallerFilename();
            String logText = YMFLog.msgForTextLog(5, obj, filename, line, msg);
            if (mLogger != null) {
                mLogger.error(YMFLog.tag(), logText);
            } else {
                Log.e((String)YMFLog.tag(), (String)logText);
                YMFLog.logToFile(logText);
            }
        }
        catch (IllegalFormatException e) {
            Log.e((String)YMFLog.tag(), (String)"IllegalFormatException happened: ", (Throwable)e);
        }
        catch (NullPointerException e) {
            Log.e((String)YMFLog.tag(), (String)"NullPointerException happened: ", (Throwable)e);
        }
    }

    public static void error(Object obj, String msg) {
        int line = YMFLog.getCallerLineNumber();
        String filename = YMFLog.getCallerFilename();
        String logText = YMFLog.msgForTextLog(5, obj, filename, line, msg);
        if (mLogger != null) {
            mLogger.error(YMFLog.tag(), logText);
        } else {
            Log.e((String)YMFLog.tag(), (String)logText);
            YMFLog.logToFile(logText);
        }
    }

    public static void error(Object obj, Throwable t) {
        int line = YMFLog.getCallerLineNumber();
        String filename = YMFLog.getCallerFilename();
        String methodname = YMFLog.getCallerMethodName();
        String logText = YMFLog.msgForException(obj, methodname, filename, line);
        if (mLogger != null) {
            mLogger.error(YMFLog.tag(), logText, t);
        } else {
            Log.e((String)YMFLog.tag(), (String)logText, (Throwable)t);
            YMFLog.logToFile(logText);
        }
    }

    private static String objClassName(Object obj) {
        if (obj instanceof String) {
            return (String)obj;
        }
        return obj.getClass().getSimpleName();
    }

    private static void logToFile(String logText) {
        YMFLog.writeToLog(logText);
    }

    private static void writeToLog(final String logText) {
        if (mCloseLog) {
            return;
        }
        if (mLogPath == null) {
            return;
        }
        mSingleThreadPool.execute(new Runnable(){

            @Override
            public void run() {
                if (BasicFileUtils.externalStorageExist()) {
                    try {
                        LogToES.writeLogToFile(LogToES.getAbsolutionLogPath(), "yyvideoplayer.txt", logText);
                    }
                    catch (Throwable e) {
                        Log.e((String)"YMFLogs", (String)("writeLogToFile fail, " + e));
                    }
                }
            }
        });
    }

    private static void logToFile(String logText, Throwable t) {
        if (mCloseLog) {
            return;
        }
        StringWriter sw = new StringWriter();
        sw.write(logText);
        sw.write("\n");
        PrintWriter pw = new PrintWriter(sw);
        pw.println(t.getMessage());
        YMFLog.writeToLog(sw.toString());
    }

    private static String msgForException(Object obj, String methodname, String filename, int line) {
        StringBuilder sb = new StringBuilder();
        sb.append("E/: ");
        sb.append(YMFLog.tag());
        if (obj instanceof String) {
            sb.append((String)obj);
        } else {
            sb.append(obj.getClass().getSimpleName());
        }
        sb.append(" Exception occurs at ");
        sb.append("(P:");
        sb.append(Process.myPid());
        sb.append(")");
        sb.append("(T:");
        sb.append(Thread.currentThread().getId());
        sb.append(") at ");
        sb.append(methodname);
        sb.append(" (");
        sb.append(filename);
        sb.append(":");
        sb.append(line);
        sb.append(")");
        String ret = sb.toString();
        return ret;
    }

    private static String msgForTextLog(int logLevel, Object obj, String filename, int line, String msg) {
        StringBuilder sb = new StringBuilder();
        switch (logLevel) {
            case 1: {
                sb.append("V/: ");
                break;
            }
            case 2: {
                sb.append("D/: ");
                break;
            }
            case 3: {
                sb.append("I/: ");
                break;
            }
            case 4: {
                sb.append("W/: ");
                break;
            }
            case 5: {
                sb.append("E/: ");
                break;
            }
            default: {
                sb.append("I/: ");
            }
        }
        sb.append(YMFLog.tag());
        sb.append(msg);
        sb.append("(P:");
        sb.append(Process.myPid());
        sb.append(")");
        sb.append("(T:");
        sb.append(Thread.currentThread().getId());
        sb.append(")");
        sb.append("(C:");
        sb.append(YMFLog.objClassName(obj));
        sb.append(")");
        sb.append("at (");
        sb.append(filename);
        sb.append(":");
        sb.append(line);
        sb.append(")");
        return sb.toString();
    }

    private static String msgForTextLog(int logLevel, String tag, String filename, int line, String msg) {
        StringBuilder sb = new StringBuilder();
        sb.append(YMFLog.tag());
        sb.append(msg);
        sb.append("(P:");
        sb.append(Process.myPid());
        sb.append(")");
        sb.append("(T:");
        sb.append(Thread.currentThread().getId());
        sb.append(")");
        sb.append("(C:");
        sb.append(tag);
        sb.append(")");
        sb.append("at (");
        sb.append(filename);
        sb.append(":");
        sb.append(line);
        sb.append(")");
        String ret = sb.toString();
        return ret;
    }

    private static int getCallerLineNumber() {
        return Thread.currentThread().getStackTrace()[4].getLineNumber();
    }

    private static String getCallerFilename() {
        return Thread.currentThread().getStackTrace()[4].getFileName();
    }

    private static String getCallerMethodName() {
        return Thread.currentThread().getStackTrace()[4].getMethodName();
    }

    public static void printThreadStacks() {
        YMFLog.printThreadStacks(YMFLog.tag(), YMFLog.getThreadStacksKeyword(), false, false);
    }

    public static void printThreadStacks(String tag) {
        YMFLog.printThreadStacks(tag, YMFLog.getThreadStacksKeyword(), false, false);
    }

    public static void printThreadStacks(String tag, String keyword) {
        YMFLog.printThreadStacks(tag, keyword, false, false);
    }

    public static void printThreadStacks(String tag, String keyword, boolean fullLog, boolean release) {
        YMFLog.printStackTraces(Thread.currentThread().getStackTrace(), tag, keyword, fullLog, release);
    }

    public static void setThreadStacksKeyword(String keyword) {
        mThreadStacksKeyword.set(keyword);
    }

    public static String getThreadStacksKeyword() {
        return mThreadStacksKeyword.get();
    }

    public static void printStackTraces(StackTraceElement[] traces, String tag) {
        YMFLog.printStackTraces(traces, tag, YMFLog.getThreadStacksKeyword(), false, false);
    }

    public static void printStackTraces(StackTraceElement[] traces, String tag, String keyword, boolean fullLog, boolean release) {
        YMFLog.printLog(tag, "------------------------------------", release);
        for (StackTraceElement e : traces) {
            String info = e.toString();
            if (!fullLog && (StringUtils.isNullOrEmpty(keyword) || !info.contains(keyword))) continue;
            YMFLog.printLog(tag, info, release);
        }
        YMFLog.printLog(tag, "------------------------------------", release);
    }

    private static void printLog(String tag, String log, boolean release) {
        if (release) {
            YMFLog.info(tag, log);
        } else {
            YMFLog.debug((Object)tag, log);
        }
    }

    public static String stackTraceOf(Throwable t) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        t.printStackTrace(pw);
        return sw.toString();
    }

    public static String threadStack() {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        for (StackTraceElement e : Thread.currentThread().getStackTrace()) {
            pw.println(e.toString());
        }
        return sw.toString();
    }

    private static class YMFLogThreadFactory
    implements ThreadFactory {
        private YMFLogThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable r) {
            return new Thread(r, "YY_yyvideolib_YMFLog_Thread");
        }
    }

    public static class LogOptions {
        public static final int LEVEL_VERBOSE = 1;
        public static final int LEVEL_DEBUG = 2;
        public static final int LEVEL_INFO = 3;
        public static final int LEVEL_WARN = 4;
        public static final int LEVEL_ERROR = 5;
    }
}

