/*
 * Decompiled with CFR 0.152.
 */
package com.yy.videoplayer.utils;

import android.os.Parcel;
import android.os.Parcelable;
import com.yy.videoplayer.Constant;
import java.util.Locale;

public class VideoEntities {

    public static class VideoInfo {
        public int width = 0;
        public int height = 0;
        public double frameRate = 0.0;
        public double bitRateInKbps = 0.0;
        public boolean videoStabilization = false;
    }

    public static class CameraItem {
        public int cameraFacing;
        public String showText;

        public CameraItem(int cameraFacing) {
            this.cameraFacing = cameraFacing;
            this.showText = cameraFacing == 1 ? "\u524d\u7f6e" : "\u540e\u7f6e";
        }

        public String toString() {
            return this.showText;
        }
    }

    public static class CodecItem {
        public CodecId codecId;
        public String showText;

        public CodecItem(CodecId codecId) {
            this.codecId = codecId;
            this.showText = "" + (Object)((Object)codecId);
        }

        public String toString() {
            return this.showText;
        }

        public static enum CodecId {
            SOFT_ENCODER_X264,
            HARD_ENCODER_H264,
            HARD_ENCODER_H265;

        }
    }

    public static class FrameRateItem {
        public int frameRate;
        public String showText;

        public FrameRateItem(int frameRate) {
            this.frameRate = frameRate;
            this.showText = "" + frameRate + "fps";
        }

        public String toString() {
            return this.showText;
        }
    }

    public static class BitRateItem {
        public int bitrateInKbps;
        public String showText;

        public BitRateItem(int bitrateInKbps) {
            this.bitrateInKbps = bitrateInKbps;
            this.showText = "" + bitrateInKbps + "Kbps";
        }

        public String toString() {
            return this.showText;
        }
    }

    public static class ResolutionItem {
        public int width;
        public int height;
        public String showText;

        public ResolutionItem(int width, int height) {
            this.width = width;
            this.height = height;
            this.showText = "" + width + "x" + height;
        }

        public String toString() {
            return this.showText;
        }
    }

    public static class WaterMark {
        public byte[] rgba32data;
        public int width;
        public int height;
        public int offsetx;
        public int offsety;
        public Constant.WaterMarkOrigin origin;
    }

    public static class CameraPreviewConfig {
        private int mPreviewWidth = 0;
        private int mPreviewHeight = 0;
        private int mCameraFacing;
        private int mOrientation;

        public CameraPreviewConfig() {
        }

        public CameraPreviewConfig(int width, int height, int cameraFacing, int cameraOrientation) {
            this.mPreviewWidth = width;
            this.mPreviewHeight = height;
            this.mCameraFacing = cameraFacing;
            this.mOrientation = cameraOrientation;
        }

        public void assign(CameraPreviewConfig config) {
            this.mPreviewWidth = config.mPreviewWidth;
            this.mPreviewHeight = config.mPreviewHeight;
            this.mCameraFacing = config.mCameraFacing;
            this.mOrientation = config.mOrientation;
        }

        public void setPreviewSize(int width, int height) {
            this.mPreviewWidth = width;
            this.mPreviewHeight = height;
        }

        public int getWidth() {
            return this.mPreviewWidth;
        }

        public int getHeight() {
            return this.mPreviewHeight;
        }

        public void setCameraFacing(int facing) {
            this.mCameraFacing = facing;
        }

        public void setOrientation(int orientation) {
            this.mOrientation = orientation;
        }

        public int getOrientation() {
            return this.mOrientation;
        }

        public int getCameraFacing() {
            return this.mCameraFacing;
        }

        public String toString() {
            return String.format(Locale.getDefault(), "CameraPreviewConfig: Size(%d x %d), facing\uff1a%d, Orientation: %d", this.mPreviewWidth, this.mPreviewHeight, this.mCameraFacing, this.mOrientation);
        }
    }

    public static class ScreenRecordConfig {
        private int mScreenWidth = 0;
        private int mScreenHeight = 0;

        public void setScreenSize(int width, int height) {
            this.mScreenWidth = width;
            this.mScreenHeight = height;
        }

        public int getWidth() {
            return this.mScreenWidth;
        }

        public int getHeight() {
            return this.mScreenHeight;
        }
    }

    public static class VideoParameters
    implements Parcelable {
        public int width = 720;
        public int height = 1280;
        public int frameRate = 24;
        public int bitRateInKbps = 1200;
        public CodecItem.CodecId codecId = CodecItem.CodecId.HARD_ENCODER_H264;
        public boolean videoStabilization = true;
        public int cameraFacing = 1;
        public boolean saveVideoToFile = false;
        public String videoFileName = "/storage/sdcard0/SimpleCapture.Video.HARD_ENCODER_H264";
        public static final Parcelable.Creator<VideoParameters> CREATOR = new Parcelable.Creator<VideoParameters>(){

            public VideoParameters createFromParcel(Parcel in) {
                return new VideoParameters(in);
            }

            public VideoParameters[] newArray(int size) {
                return new VideoParameters[size];
            }
        };

        public int describeContents() {
            return 0;
        }

        public void writeToParcel(Parcel parcel, int i) {
            parcel.writeInt(this.width);
            parcel.writeInt(this.height);
            parcel.writeInt(this.frameRate);
            parcel.writeInt(this.bitRateInKbps);
            parcel.writeInt(this.cameraFacing);
            parcel.writeString(this.videoFileName);
            parcel.writeValue((Object)this.videoStabilization);
            parcel.writeValue((Object)this.saveVideoToFile);
            parcel.writeValue((Object)this.codecId);
        }

        public VideoParameters() {
        }

        public VideoParameters(Parcel parcel) {
            this.width = parcel.readInt();
            this.height = parcel.readInt();
            this.frameRate = parcel.readInt();
            this.bitRateInKbps = parcel.readInt();
            this.cameraFacing = parcel.readInt();
            this.videoFileName = parcel.readString();
            this.videoStabilization = (Boolean)parcel.readValue(this.getClass().getClassLoader());
            this.saveVideoToFile = (Boolean)parcel.readValue(this.getClass().getClassLoader());
            this.codecId = (CodecItem.CodecId)((Object)parcel.readValue(this.getClass().getClassLoader()));
        }
    }

    public static class VideoSizes {
        public int mViewX;
        public int mViewY;
        public int mViewWidth;
        public int mViewHeight;
        public int mVideoWidth = 64;
        public int mVideoHeight = 64;
        public int mVideoSurfaceWidth = 64;
        public int mVideoSurfaceHeight = 64;
        public int mVideoParentWidth = 64;
        public int mVideoParentHeight = 64;

        public String toString() {
            return String.format(Locale.getDefault(), "mViewX = %d, mViewY = %d, \nmViewWidth = %d, mViewHeight = %d, \nmVideoWidth = %d, mVideoHeight = %d, \nmVideoSurfaceWidth = %d, mVideoSurfaceHeight = %d", this.mViewX, this.mViewY, this.mViewWidth, this.mViewHeight, this.mVideoWidth, this.mVideoHeight, this.mVideoSurfaceWidth, this.mVideoSurfaceHeight);
        }
    }

    public static class RectSize {
        public int mWidth;
        public int mHeight;

        public RectSize(int width, int height) {
            this.mWidth = width;
            this.mHeight = height;
        }
    }

    public static class VideoData {
        public byte[] data;
        public long pts;
    }
}

