/*
 * Decompiled with CFR 0.152.
 */
package com.yy.videoplayer.stat;

import android.os.Build;
import com.yy.videoplayer.VideoPlayer;
import com.yy.videoplayer.decoder.ViewLiveStatManager;
import com.yy.videoplayer.stat.VideoDataStatHelper;
import com.yy.videoplayer.utils.CPUTool;
import com.yy.videoplayer.utils.YMFLog;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;

public class VideoPlayerDataStat {
    private static String TAG = "VideoPlayerDataStat";
    private static VideoPlayerDataStat mInstance;
    private static final int mStaticsCycle = 20;
    private static LinkedHashMap<String, Object> mAudienceHashMap;
    private static HashMap<Long, Object> mRenderMap;
    private static HashMap<Long, Object> mLostRenderMap;
    private static HashMap<Long, Object> mIsBlueRayMap;
    private static HashMap<Long, Object> mBitRateMap;
    private static HashMap<Long, Object> mDecodeDelayFrameCountMap;
    private static HashMap<Long, Object> mFirstFramePreparedDeltaTimeMap;
    private static HashMap<Long, Object> mFirstFrameArrive2RenderDeltaTimeMap;
    private static HashMap<Long, Object> mDecodeIdHashMap;
    private static ConcurrentHashMap<Long, Object> mVideoRenderPtsMeanDiffMap;
    private static ConcurrentHashMap<Long, Object> mVideoRenderPtsMaxDiffMap;
    private static VideoRenderTimeStamp mVideoRenderTimeStamp;
    private Object syncLock = new Object();

    public static VideoPlayerDataStat getInstance() {
        if (mInstance == null) {
            mInstance = new VideoPlayerDataStat();
        }
        return mInstance;
    }

    public void putVideoDecodeIdToStat(long streamId, int VideoDecodeId) {
        YMFLog.info(this, "putAudiencePowerInfo putVideoDecodeIdToStat:" + this);
        mDecodeIdHashMap.put(streamId, VideoDecodeId);
    }

    public String getAudienceVideoData(long streamId) {
        Object renderMaxDiffList;
        Object delayFrameCount;
        Object frameRate;
        Object render = mRenderMap.get(streamId);
        if (render != null) {
            mAudienceHashMap.put("dr2", render);
        }
        if ((frameRate = mLostRenderMap.get(streamId)) != null) {
            mAudienceHashMap.put("dr9", frameRate);
        }
        int isblueray = -1;
        Object object = mIsBlueRayMap.get(streamId);
        if (object != null) {
            isblueray = (Integer)object;
        }
        mAudienceHashMap.put("dr11", isblueray);
        Object mBitRate = mBitRateMap.get(streamId);
        if (mBitRate != null) {
            String bitRate = (String)mBitRate;
            mAudienceHashMap.put("dr10", bitRate);
        }
        if ((delayFrameCount = mDecodeDelayFrameCountMap.get(streamId)) != null) {
            mAudienceHashMap.put("dr18", delayFrameCount);
        }
        mAudienceHashMap.put("dr6", VideoDataStatHelper.toURLEncoded(VideoPlayerDataStat.getAndroidInfo()));
        mAudienceHashMap.put("dr8", VideoPlayer.getInstance().getPlayerInfo(streamId, VideoPlayer.VideoPlayerInfoEnum.RESOLUTION));
        this.getFluencyToStat(streamId);
        HashMap hashMap = ViewLiveStatManager.getInstace().getLiveStatContent();
        if (hashMap != null) {
            mAudienceHashMap.putAll(hashMap);
        }
        mAudienceHashMap.put("dr14", VideoDataStatHelper.getRenderTime());
        mAudienceHashMap.put("dr15", VideoDataStatHelper.getMaxRenderTime());
        mAudienceHashMap.put("dr42", mFirstFramePreparedDeltaTimeMap.get(streamId));
        mAudienceHashMap.put("dr41", mFirstFrameArrive2RenderDeltaTimeMap.get(streamId));
        mAudienceHashMap.put("dr3", CPUTool.getCpuInfo());
        mAudienceHashMap.put("dr4", CPUTool.getCurCpuFreq());
        mAudienceHashMap.put("dr43", CPUTool.getMaxCpuFreq());
        mAudienceHashMap.put("dr44", CPUTool.getMinCpuFreq());
        Object VideoDecodeId = mDecodeIdHashMap.get(streamId);
        if (VideoDecodeId != null) {
            mAudienceHashMap.put("dr1", VideoDecodeId);
        }
        if ((renderMaxDiffList = mVideoRenderPtsMaxDiffMap.get(streamId)) != null) {
            mAudienceHashMap.put("dr47", renderMaxDiffList);
        }
        String videoData = VideoDataStatHelper.getParamsOrderByKey(mAudienceHashMap);
        ViewLiveStatManager.getInstace().clear();
        YMFLog.info(TAG, "upload hiido data, " + videoData);
        return videoData;
    }

    private static String getAndroidInfo() {
        String handSetInfo = "\u7cfb\u7edf\u7248\u672c:" + Build.VERSION.RELEASE;
        return handSetInfo;
    }

    private void getFluencyToStat(long steamId) {
        int fluency = VideoDataStatHelper.getFluency(steamId);
        if (fluency == -1) {
            return;
        }
        mAudienceHashMap.put("dr7", fluency);
    }

    public void putRenderFrameRateToStat(long streamId, int frameCount) {
        if (mRenderMap != null) {
            mRenderMap.put(streamId, frameCount);
        }
    }

    public void putLostRenderFrameToStat(long streamId, float frameRate) {
        if (mLostRenderMap != null) {
            mLostRenderMap.put(streamId, Float.valueOf(frameRate));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearVideoRenderPtsStatistics(long streamId) {
        this.updateVideoRenderPtsDiff(streamId);
        Object object = this.syncLock;
        synchronized (object) {
            VideoPlayerDataStat.mVideoRenderTimeStamp.mVideoRenderPtsMaxDiffList.clear();
            VideoPlayerDataStat.mVideoRenderTimeStamp.mVideoRenderPtsMeanDiffList.clear();
            VideoPlayerDataStat.mVideoRenderTimeStamp.mFpsCount = 0;
            VideoPlayerDataStat.mVideoRenderTimeStamp.mLastStamp = 0L;
            VideoPlayerDataStat.mVideoRenderTimeStamp.mStartStamp = 0L;
            VideoPlayerDataStat.mVideoRenderTimeStamp.mMeanTimeStampDiffPerSecond = 0L;
            VideoPlayerDataStat.mVideoRenderTimeStamp.mMaxTimeStampDiffPerSecond = 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putVideoRenderPtsStatistics(long streamId, long renderTimeStamp, boolean bClean) {
        if (mVideoRenderTimeStamp != null) {
            Object object = this.syncLock;
            synchronized (object) {
                if (VideoPlayerDataStat.mVideoRenderTimeStamp.mStartStamp == 0L || VideoPlayerDataStat.mVideoRenderTimeStamp.mLastStamp == 0L) {
                    VideoPlayerDataStat.mVideoRenderTimeStamp.mFpsCount = 0;
                    VideoPlayerDataStat.mVideoRenderTimeStamp.mLastStamp = renderTimeStamp;
                    VideoPlayerDataStat.mVideoRenderTimeStamp.mStartStamp = renderTimeStamp;
                    VideoPlayerDataStat.mVideoRenderTimeStamp.mMeanTimeStampDiffPerSecond = 0L;
                    VideoPlayerDataStat.mVideoRenderTimeStamp.mMaxTimeStampDiffPerSecond = 0L;
                    return;
                }
                long diff = renderTimeStamp - VideoPlayerDataStat.mVideoRenderTimeStamp.mLastStamp;
                if (diff >= VideoPlayerDataStat.mVideoRenderTimeStamp.mMaxTimeStampDiffPerSecond) {
                    VideoPlayerDataStat.mVideoRenderTimeStamp.mMaxTimeStampDiffPerSecond = diff;
                }
                VideoPlayerDataStat.mVideoRenderTimeStamp.mMeanTimeStampDiffPerSecond += diff;
                VideoPlayerDataStat.mVideoRenderTimeStamp.mLastStamp = renderTimeStamp;
                ++VideoPlayerDataStat.mVideoRenderTimeStamp.mFpsCount;
                if (renderTimeStamp - VideoPlayerDataStat.mVideoRenderTimeStamp.mStartStamp > 1000L && VideoPlayerDataStat.mVideoRenderTimeStamp.mFpsCount != 0) {
                    VideoPlayerDataStat.mVideoRenderTimeStamp.mMeanTimeStampDiffPerSecond /= (long)VideoPlayerDataStat.mVideoRenderTimeStamp.mFpsCount;
                    VideoPlayerDataStat.mVideoRenderTimeStamp.mVideoRenderPtsMeanDiffList.add(VideoPlayerDataStat.mVideoRenderTimeStamp.mMeanTimeStampDiffPerSecond);
                    VideoPlayerDataStat.mVideoRenderTimeStamp.mVideoRenderPtsMaxDiffList.add(VideoPlayerDataStat.mVideoRenderTimeStamp.mMaxTimeStampDiffPerSecond);
                    VideoPlayerDataStat.mVideoRenderTimeStamp.mStartStamp = renderTimeStamp;
                    VideoPlayerDataStat.mVideoRenderTimeStamp.mLastStamp = renderTimeStamp;
                    VideoPlayerDataStat.mVideoRenderTimeStamp.mMeanTimeStampDiffPerSecond = 0L;
                    VideoPlayerDataStat.mVideoRenderTimeStamp.mMaxTimeStampDiffPerSecond = 0L;
                    VideoPlayerDataStat.mVideoRenderTimeStamp.mFpsCount = 0;
                }
            }
            if (VideoPlayerDataStat.mVideoRenderTimeStamp.mVideoRenderPtsMaxDiffList.size() > 19 || bClean) {
                this.updateVideoRenderPtsDiff(streamId);
                object = this.syncLock;
                synchronized (object) {
                    VideoPlayerDataStat.mVideoRenderTimeStamp.mVideoRenderPtsMaxDiffList.clear();
                    VideoPlayerDataStat.mVideoRenderTimeStamp.mVideoRenderPtsMeanDiffList.clear();
                }
                VideoPlayerDataStat.mVideoRenderTimeStamp.mFpsCount = 0;
                VideoPlayerDataStat.mVideoRenderTimeStamp.mLastStamp = 0L;
                VideoPlayerDataStat.mVideoRenderTimeStamp.mStartStamp = 0L;
                VideoPlayerDataStat.mVideoRenderTimeStamp.mMeanTimeStampDiffPerSecond = 0L;
                VideoPlayerDataStat.mVideoRenderTimeStamp.mMaxTimeStampDiffPerSecond = 0L;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateVideoRenderPtsDiff(long streamId) {
        if (mVideoRenderTimeStamp != null) {
            StringBuilder stringBuilderMeanDiff = new StringBuilder();
            StringBuilder stringBuilderMaxDiff = new StringBuilder();
            Object object = this.syncLock;
            synchronized (object) {
                for (Long diff : VideoPlayerDataStat.mVideoRenderTimeStamp.mVideoRenderPtsMeanDiffList) {
                    if (diff == 0L) continue;
                    stringBuilderMeanDiff.append(diff).append("-");
                }
                for (Long diff : VideoPlayerDataStat.mVideoRenderTimeStamp.mVideoRenderPtsMaxDiffList) {
                    if (diff == 0L) continue;
                    stringBuilderMaxDiff.append(diff).append("-");
                }
            }
            mVideoRenderPtsMeanDiffMap.put(streamId, stringBuilderMeanDiff.toString());
            mVideoRenderPtsMaxDiffMap.put(streamId, stringBuilderMaxDiff.toString());
        }
    }

    public void setIsBlueRay(long streamId, int isBlueRay) {
        if (mIsBlueRayMap != null) {
            mIsBlueRayMap.put(streamId, isBlueRay);
        }
    }

    public void setBitRate(long streamId, String bitrate) {
        if (mBitRateMap != null) {
            mBitRateMap.put(streamId, bitrate);
        }
    }

    public void setDecodeDelayFrameCount(long streamId, int count) {
        if (mDecodeDelayFrameCountMap != null) {
            mDecodeDelayFrameCountMap.put(streamId, count);
        }
    }

    public void setFirstFrameDeltaTime(long streamId, long deltaStreamPreparedTime, long deltaFirstFrameArrived2RenderedTime) {
        if (mFirstFramePreparedDeltaTimeMap != null) {
            mFirstFramePreparedDeltaTimeMap.put(streamId, deltaStreamPreparedTime);
        }
        if (mFirstFrameArrive2RenderDeltaTimeMap != null) {
            mFirstFrameArrive2RenderDeltaTimeMap.put(streamId, deltaFirstFrameArrived2RenderedTime);
        }
    }

    static {
        mAudienceHashMap = new LinkedHashMap();
        mRenderMap = new HashMap();
        mLostRenderMap = new HashMap();
        mIsBlueRayMap = new HashMap();
        mBitRateMap = new HashMap();
        mDecodeDelayFrameCountMap = new HashMap();
        mFirstFramePreparedDeltaTimeMap = new HashMap();
        mFirstFrameArrive2RenderDeltaTimeMap = new HashMap();
        mDecodeIdHashMap = new HashMap();
        mVideoRenderPtsMeanDiffMap = new ConcurrentHashMap();
        mVideoRenderPtsMaxDiffMap = new ConcurrentHashMap();
        mVideoRenderTimeStamp = new VideoRenderTimeStamp();
    }

    public static enum BluRayType {
        Non_BluRay,
        BluRay;

    }

    public static interface AudienceHiidoStatInfoKey {
        public static final String VideoDecodeId = "dr1";
        public static final String RenderFrameRate = "dr2";
        public static final String CpuName = "dr3";
        public static final String CpuFrequency = "dr4";
        public static final String OperationSystemInfo = "dr6";
        public static final String Fluency = "dr7";
        public static final String DPI = "dr8";
        public static final String LostRenderFrame = "dr9";
        public static final String BitRate = "dr10";
        public static final String IsBluRay = "dr11";
        public static final String IsRoot = "dr12";
        public static final String ViewType = "dr13";
        public static final String RenderAVGTime = "dr14";
        public static final String RenderMaxTime = "dr15";
        public static final String DecodeAVGTime = "dr16";
        public static final String DecodeMaxTime = "dr17";
        public static final String DecodeDelayFrameCount = "dr18";
        public static final String Decode2Render = "dr41";
        public static final String DecodeCreate2Arrive = "dr42";
        public static final String CpuMaxFrequency = "dr43";
        public static final String CpuMinFrequency = "dr44";
        public static final String VideoRenderPtsMeanDiff = "dr46";
        public static final String VideoRenderPtsMaxDiff = "dr47";
    }

    public static class VideoRenderTimeStamp {
        public List<Long> mVideoRenderPtsMaxDiffList = new ArrayList<Long>(40);
        public List<Long> mVideoRenderPtsMeanDiffList = new ArrayList<Long>(40);
        public long mStartStamp = 0L;
        public long mLastStamp = 0L;
        public int mFpsCount = 0;
        public long mMeanTimeStampDiffPerSecond = 0L;
        public long mMaxTimeStampDiffPerSecond = 0L;
    }
}

