/*
 * Decompiled with CFR 0.152.
 */
package com.yy.videoplayer.stat;

import android.os.Build;
import android.support.annotation.NonNull;
import com.yy.videoplayer.stat.PlayerDataStatCallback;
import com.yy.videoplayer.stat.VideoDataStatHelper;
import com.yy.videoplayer.utils.InfoUtil;
import com.yy.videoplayer.utils.YMFLog;
import java.util.HashMap;
import java.util.LinkedHashMap;

public class PlayerExceptionDataStat {
    private static final String TAG = "PlayerExceptionDataStat";
    private static PlayerExceptionDataStat mInstance;
    private static LinkedHashMap<String, Object> mPlayerExceptionHashMap;
    private static HashMap<Long, Object> mDecodeIdHashMap;
    private static PlayerDataStatCallback mPlayerDataStatCallback;
    private static final String TABLE_NAME = "mobilevideoexceptionstatist";
    public static final String DECODE = "1";
    public static final String REDERN = "2";
    private static final String AUDIENCE = "1";
    private static final int OS = 1;
    private static final int UPLOAD_TIME = 5000;
    private HashMap<String, Long> mHashMap = new HashMap();
    private String mStringId;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static PlayerExceptionDataStat getInstance() {
        if (mInstance != null) return mInstance;
        Class<PlayerExceptionDataStat> clazz = PlayerExceptionDataStat.class;
        synchronized (PlayerExceptionDataStat.class) {
            if (mInstance != null) return mInstance;
            mInstance = new PlayerExceptionDataStat();
            // ** MonitorExit[var0] (shouldn't be in output)
            return mInstance;
        }
    }

    private PlayerExceptionDataStat() {
        this.initInfo();
    }

    public PlayerDataStatCallback getPlayerDataStatCallback() {
        return mPlayerDataStatCallback;
    }

    public void setPlayerDataStatCallback(PlayerDataStatCallback playerDataStatCallback) {
        mPlayerDataStatCallback = playerDataStatCallback;
    }

    public String getStringId() {
        return this.mStringId;
    }

    public void setStringId(String stringId) {
        this.mStringId = stringId;
    }

    public void putVideoDecodeIdToStat(long streamId, int VideoDecodeId) {
        YMFLog.info(this, "putAudiencePowerInfo putVideoDecodeIdToStat:" + this);
        mDecodeIdHashMap.put(streamId, VideoDecodeId);
    }

    @NonNull
    public synchronized void pushPlayerExceptionDataStat(long streamID, HashMap<String, Object> hashMap) {
        if (mPlayerDataStatCallback != null) {
            Object VideoDecodeId = mDecodeIdHashMap.get(streamID);
            mPlayerExceptionHashMap.put("dr14", InfoUtil.getVersionName());
            mPlayerExceptionHashMap.put("dr7", streamID);
            mPlayerExceptionHashMap.put("dr3", "1");
            mPlayerExceptionHashMap.put("dr11", VideoDataStatHelper.getCurrentTime());
            mPlayerExceptionHashMap.put("dr4", VideoDecodeId);
            mPlayerExceptionHashMap.putAll(hashMap);
            mPlayerDataStatCallback.onPushExceptionForHiido(streamID, TABLE_NAME, mPlayerExceptionHashMap);
            YMFLog.error((Object)TAG, "exception data, " + mPlayerExceptionHashMap.toString());
        } else {
            YMFLog.error((Object)TAG, "PlayerDataStatCallback is null");
        }
    }

    @NonNull
    public synchronized void pushPlayerExceptionDataStat(long streamID, String moduleType, String exceptionID, String exceptionReasion) {
        long itme;
        Long object;
        if (this.mHashMap != null && (object = this.mHashMap.get(streamID + exceptionID)) != null && (itme = System.currentTimeMillis() - object) < 5000L) {
            return;
        }
        this.mHashMap.put(streamID + exceptionID, System.currentTimeMillis());
        if (mPlayerDataStatCallback != null) {
            HashMap<String, String> decodeExceptionInfo = new HashMap<String, String>();
            decodeExceptionInfo.put("dr5", exceptionID);
            decodeExceptionInfo.put("dr6", VideoDataStatHelper.toURLEncoded(exceptionReasion));
            mPlayerExceptionHashMap.put("dr7", streamID);
            mPlayerExceptionHashMap.put("dr3", moduleType);
            mPlayerExceptionHashMap.put("dr11", VideoDataStatHelper.getCurrentTime());
            mPlayerExceptionHashMap.putAll(decodeExceptionInfo);
            mPlayerDataStatCallback.onPushExceptionForHiido(streamID, TABLE_NAME, mPlayerExceptionHashMap);
            YMFLog.error((Object)TAG, "exception data, " + mPlayerExceptionHashMap.toString());
        } else {
            YMFLog.error((Object)TAG, "PlayerDataStatCallback is null");
        }
    }

    public void setDecoderID(String decoderID) {
        mPlayerExceptionHashMap.put("dr4", decoderID);
    }

    private void initInfo() {
        mPlayerExceptionHashMap.put("dr1", VideoDataStatHelper.toURLEncoded(VideoDataStatHelper.getAndroidInfo()));
        mPlayerExceptionHashMap.put("dr2", "1");
        mPlayerExceptionHashMap.put("dr13", 1);
        mPlayerExceptionHashMap.put("dr8", VideoDataStatHelper.toURLEncoded(Build.MODEL));
    }

    public void setDecoderPTS(String pts) {
        mPlayerExceptionHashMap.put("dr9", pts);
    }

    public void setDecoderInputPTS(String pts) {
        mPlayerExceptionHashMap.put("dr15", pts);
    }

    public void setDecoderDTS(String dts) {
        mPlayerExceptionHashMap.put("dr10", dts);
    }

    public void setDecoderResolution(long resolution) {
        mPlayerExceptionHashMap.put("dr12", resolution + "");
    }

    static {
        mPlayerExceptionHashMap = new LinkedHashMap();
        mDecodeIdHashMap = new HashMap();
    }

    public static interface RenderExceptionID {
        public static final String INIT_ERROR = "101";
        public static final String RENDER_ERROR = "102";
        public static final String DEINIT_ERROR = "103";
    }

    public static interface DecodeExceptionID {
        public static final String DECODER_BLOCK = "0";
        public static final String DECODER_EXCEPTION = "1";
        public static final String RESET_EXCEPTION = "2";
        public static final String DECODE_HARD_CHANGE_SOFT = "3";
        public static final String DECODE_INIT_CODEC_ERROR = "4";
        public static final String DECODE_DEQUEUE_BUFFER_ERROR = "5";
    }

    public static interface PlayerExceptionInfoKey {
        public static final String DECODER_STATE = "dr0";
        public static final String SYSTEM_INFO = "dr1";
        public static final String VIDEO_TYPE = "dr2";
        public static final String MODULE_TYPE = "dr3";
        public static final String VIDEO_DECODE_ID = "dr4";
        public static final String EXCEPTION_ID = "dr5";
        public static final String EXCEPTION_REASON = "dr6";
        public static final String STREAM_ID = "dr7";
        public static final String MODEL = "dr8";
        public static final String LastOutputPts = "dr9";
        public static final String DTS = "dr10";
        public static final String UPLOAD_TIME = "dr11";
        public static final String RESOLUTION = "dr12";
        public static final String OS = "dr13";
        public static final String APP_VERSION = "dr14";
        public static final String LastInputPts = "dr15";
    }
}

