/*
 * Decompiled with CFR 0.152.
 */
package com.yy.videoplayer.render;

import com.yy.videoplayer.decoder.StateMonitor;
import com.yy.videoplayer.decoder.YYVideoLibMgr;
import com.yy.videoplayer.render.YYSoftDecRender;
import com.yy.videoplayer.stat.VideoPlayerDataStat;
import com.yy.videoplayer.utils.ByteVector;
import com.yy.videoplayer.utils.TimeUtil;
import com.yy.videoplayer.utils.YMFLog;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public class YYRenderFrameBuffer
implements YYSoftDecRender {
    public static final int FORMAT_RGB = 0;
    public static final int FORMAT_NV12 = 1;
    public static final int FORMAT_I420 = 2;
    public static final int FORMAT_RGB565 = 3;
    public static final int FORMAT_UNKNOWN = 4;
    private long mStreamId = -1L;
    private long mGroupId = -1L;
    private long mContext = -1L;
    private ByteBuffer mFrameBuffer = null;
    private int mWidth = 0;
    private int mHeight = 0;
    private int mPixWidth = 0;
    private int mFrameFormat = 4;
    private int mWidthY = 0;
    private int mHeightY = 0;
    private int mWidthUV = 0;
    private int mHeightUV = 0;
    private int mOffsetY = 0;
    private int mOffsetU = 0;
    private int mOffsetV = 0;
    public long mFirstFrameArrivedTime = 0L;
    private AtomicBoolean mFrameRendered = new AtomicBoolean(false);
    private long mLastStatisticsTime = 0L;
    private AtomicInteger mMissRenderFrameCount = new AtomicInteger(0);
    private AtomicLong mLastDecodeTimeStamp = new AtomicLong(0L);
    private AtomicBoolean mMissRenderFlag = new AtomicBoolean(false);
    private AtomicBoolean mFrameReady = new AtomicBoolean(false);
    private newYUVFrameArrivedCallBack mCallback = null;
    public ByteVector mBytesVector = null;

    public void setYUVFrameArriveCallback(newYUVFrameArrivedCallBack callback) {
        this.mCallback = callback;
    }

    public YYRenderFrameBuffer(boolean GPUFormatConvert) {
        if (!YYVideoLibMgr.instance().isLibraryLoaded()) {
            YMFLog.error((Object)this, "[Render][call] LoadLibarary failed, YYRenderFrameBuffer.YYRenderFrameBuffer");
            return;
        }
        if (!GPUFormatConvert) {
            this.mFrameFormat = 3;
        }
        try {
            this.mContext = this.createRenderFrameBufferContext(GPUFormatConvert);
        }
        catch (UnsatisfiedLinkError e) {
            YMFLog.error((Object)this, "[Render][call] LoadLibarary failed, YYRenderFrameBuffer.createRenderFrameBufferContext " + e.getMessage());
        }
    }

    @Override
    public boolean linkToStream(long userGroupId, long streamId) {
        if (!YYVideoLibMgr.instance().isLibraryLoaded()) {
            YMFLog.error((Object)this, "[Render][call] LoadLibarary failed, YYRenderFrameBuffer.linkToStream");
            return false;
        }
        int res = 0;
        try {
            res = this.linkToVideoStream(this.mContext, userGroupId, streamId);
            this.mStreamId = streamId;
            this.mGroupId = userGroupId;
            YMFLog.info(this, "[Render][call] YYRenderFrameBuffer.linkFromVideo groupId %d %d, streamId %d %d, res %d context: %d", userGroupId >> 32, userGroupId & 0xFFFFFFFFFFFFFFFFL, streamId >> 32, streamId & 0xFFFFFFFFFFFFFFFFL, res, this.mContext);
        }
        catch (UnsatisfiedLinkError e) {
            YMFLog.error((Object)this, "[Render][call] LoadLibarary failed, YYRenderFrameBuffer.linkToVideoStream " + e.getMessage());
        }
        return 0 == res;
    }

    @Override
    public boolean unLinkFromStream(long userGroupId, long streamId) {
        if (!YYVideoLibMgr.instance().isLibraryLoaded()) {
            YMFLog.error((Object)this, "[Render][call] LoadLibarary failed, YYRenderFrameBuffer.unLinkFromStream");
            return false;
        }
        int res = 0;
        try {
            res = this.unLinkFromVideoStream(this.mContext, userGroupId, streamId);
            this.mStreamId = -1L;
            this.mGroupId = -1L;
            VideoPlayerDataStat.getInstance().clearVideoRenderPtsStatistics(this.mStreamId);
            YMFLog.info(this, "[Render]YYRenderFrameBuffer.unLinkFromStream groupId %d %d, streamId %d, res %d context: %d", userGroupId >> 32, userGroupId & 0xFFFFFFFFFFFFFFFFL, streamId >> 32, streamId & 0xFFFFFFFFFFFFFFFFL, res, this.mContext);
        }
        catch (UnsatisfiedLinkError e) {
            YMFLog.error((Object)this, "[Render]LoadLibarary failed, YYRenderFrameBuffer.unLinkFromVideoStream " + e.getMessage());
        }
        return 0 == res;
    }

    public boolean render() {
        if (!YYVideoLibMgr.instance().isLibraryLoaded()) {
            YMFLog.error((Object)this, "[Render][call] LoadLibarary failed, YYRenderFrameBuffer.render");
            return false;
        }
        boolean res = false;
        try {
            res = this.renderFrame(this.mContext);
        }
        catch (UnsatisfiedLinkError e) {
            YMFLog.error((Object)this, "[Render][call] LoadLibarary failed, YYRenderFrameBuffer.newFrameArrived " + e.getMessage());
        }
        return res;
    }

    public boolean hasFrame() {
        if (!YYVideoLibMgr.instance().isLibraryLoaded()) {
            YMFLog.error((Object)this, "[Render][call] LoadLibarary failed, YYRenderFrameBuffer.render");
            return false;
        }
        boolean res = false;
        try {
            res = this.newFrameArrived(this.mContext);
        }
        catch (UnsatisfiedLinkError e) {
            YMFLog.error((Object)this, "[Render][call] LoadLibarary failed, YYRenderFrameBuffer.newFrameArrived " + e.getMessage());
        }
        return res;
    }

    public boolean setFrameRendered() {
        if (!YYVideoLibMgr.instance().isLibraryLoaded()) {
            YMFLog.error((Object)this, "[Render][call] LoadLibarary failed, YYRenderFrameBuffer.render");
            return false;
        }
        boolean res = false;
        try {
            res = this.setFrameRendered(this.mContext);
        }
        catch (UnsatisfiedLinkError e) {
            YMFLog.error((Object)this, "[Render][call] LoadLibarary failed, YYRenderFrameBuffer.setFrameRendered " + e.getMessage());
        }
        return res;
    }

    public ByteBuffer getFrame() {
        this.mFrameRendered.set(true);
        return this.mFrameBuffer;
    }

    public long getLastDecodeTimeStamp() {
        return this.mLastDecodeTimeStamp.get();
    }

    public int getCurFramePts() {
        return this.getCurFramePts(this.mContext);
    }

    public int getWidth() {
        return this.mWidth;
    }

    public int getHeight() {
        return this.mHeight;
    }

    public int getPixWidth() {
        return this.mPixWidth;
    }

    public int getFrameFormat() {
        return this.mFrameFormat;
    }

    public int getWidthY() {
        return this.mWidthY;
    }

    public int getHeightY() {
        return this.mHeightY;
    }

    public int getWidthUV() {
        return this.mWidthUV;
    }

    public int getHeightUV() {
        return this.mHeightUV;
    }

    public int getOffsetY() {
        return this.mOffsetY;
    }

    public int getOffsetU() {
        return this.mOffsetU;
    }

    public int getOffsetV() {
        return this.mOffsetV;
    }

    public ByteBuffer createByteBufferIfNeed(int width, int height, int bits, int pixWidth) {
        if (this.mWidth == width && this.mHeight == height && null != this.mFrameBuffer) {
            YMFLog.info("createByteBufferIfNeed", "[Render]width " + width + " height " + height + " pixwidth " + pixWidth + ", orgin pixWidth:" + this.mPixWidth + ", frameBuffer:" + this.mFrameBuffer);
            return this.mFrameBuffer;
        }
        this.mFrameReady.set(false);
        this.mWidth = width;
        this.mHeight = height;
        this.mPixWidth = pixWidth;
        YMFLog.info("createByteBufferIfNeed", "[Render]width " + width + " height " + height + " pixwidth " + pixWidth);
        try {
            this.mFrameBuffer = ByteBuffer.allocateDirect(bits / 8 * width * height);
            if (this.mBytesVector == null) {
                this.mBytesVector = new ByteVector(bits / 8 * width * height);
            }
        }
        catch (Throwable e) {
            YMFLog.error((Object)this, "[Render]allocate frame buffer failed: " + e.getMessage());
        }
        this.mFirstFrameArrivedTime = System.currentTimeMillis();
        return this.mFrameBuffer;
    }

    public boolean checkDataComplete() {
        return this.mFrameReady.get();
    }

    public void setYUVBufferInfo(int format, int widthY, int heightY, int widthUV, int heightUV, int offsetY, int offsetU, int offsetV) {
        long T1;
        this.mFrameFormat = format;
        this.mWidthY = widthY;
        this.mHeightY = heightY;
        this.mWidthUV = widthUV;
        this.mHeightUV = heightUV;
        this.mOffsetY = offsetY;
        this.mOffsetU = offsetU;
        this.mOffsetV = offsetV;
        if (this.mLastStatisticsTime == 0L) {
            this.mLastStatisticsTime = System.currentTimeMillis();
        }
        if (!this.mFrameRendered.get()) {
            this.mMissRenderFrameCount.getAndIncrement();
        }
        if ((T1 = System.currentTimeMillis()) - this.mLastStatisticsTime >= 6000L) {
            StateMonitor.NotifyRenderLostRate(this.mStreamId, (float)(this.mMissRenderFrameCount.getAndSet(0) * 1000) / (float)(T1 - this.mLastStatisticsTime));
            this.mLastStatisticsTime = T1;
        }
        this.mLastDecodeTimeStamp.set(TimeUtil.getTickCountLong());
        this.mFrameRendered.set(false);
        this.mFrameReady.set(true);
    }

    public void release() {
        if (!YYVideoLibMgr.instance().isLibraryLoaded()) {
            YMFLog.error((Object)this, "[Render][call] LoadLibarary failed, YYRenderFrameBuffer.release");
            return;
        }
        YMFLog.info(this, "[Render][call] YYRenderFrameBuffer.release");
        try {
            if (this.mStreamId != -1L || this.mGroupId != -1L) {
                YMFLog.warn(this, "YYRenderFrameBuffer not unlink stream, release first !");
                this.unLinkFromStream(this.mGroupId, this.mStreamId);
            }
            this.release(this.mContext);
        }
        catch (UnsatisfiedLinkError e) {
            YMFLog.error((Object)this, "[Render][call] LoadLibarary failed, YYRenderFrameBuffer.release " + e.getMessage());
        }
        this.mFrameBuffer = null;
        this.mContext = 0L;
    }

    public boolean GetCurrentPictureDataRGB565(RGB565ImageWithNoPadding img) {
        boolean res = false;
        try {
            res = this.GetCurrentPictureDataRGB565(this.mContext, img);
        }
        catch (UnsatisfiedLinkError e) {
            YMFLog.error((Object)this, "[Render][call] LoadLibarary failed, YYRenderFrameBuffer.GetCurrentPictureDataRGB565 " + e.getMessage());
        }
        return res;
    }

    public void setMissRenderFlag(boolean miss, boolean newArrivedFrame) {
        this.mMissRenderFlag.set(miss);
        if (newArrivedFrame && this.mCallback != null) {
            this.mCallback.onNewYUVFrameArrive();
        }
    }

    public boolean getMissRenderFlag() {
        return this.mMissRenderFlag.get();
    }

    @Override
    public long getContext() {
        return this.mContext;
    }

    public void pushVideoFrameOut() {
        this.mBytesVector.reserve(this.mWidth * this.mHeight * 3 / 2);
        this.mFrameBuffer.rewind();
        this.mFrameBuffer.get(this.mBytesVector.getBytes(), 0, this.mWidth * this.mHeight * 3 / 2);
        YYVideoLibMgr.instance().onDecodedFrameData(this.mStreamId >> 32, this.mWidth, this.mHeight, this.mBytesVector.getBytes(), this.mWidth * this.mHeight * 3 / 2, this.getCurFramePts());
        this.setFrameRendered();
    }

    private native boolean GetCurrentPictureDataRGB565(long var1, RGB565ImageWithNoPadding var3);

    private native long createRenderFrameBufferContext(boolean var1);

    private native int getCurFramePts(long var1);

    private native int linkToVideoStream(long var1, long var3, long var5);

    private native int unLinkFromVideoStream(long var1, long var3, long var5);

    private native boolean renderFrame(long var1);

    private native boolean newFrameArrived(long var1);

    private native boolean setFrameRendered(long var1);

    private native void release(long var1);

    public static native int LoadTest();

    public static class RGB565ImageWithNoPadding {
        public byte[] mData;
        public int mWidth;
        public int mHeight;

        public void setImage(byte[] data, int width, int height) {
            this.mData = data;
            this.mWidth = width;
            this.mHeight = height;
        }
    }

    public static interface newYUVFrameArrivedCallBack {
        public void onNewYUVFrameArrive();
    }
}

