/*
 * Decompiled with CFR 0.152.
 */
package com.yy.videoplayer.render;

import android.opengl.GLES20;
import android.opengl.Matrix;

public class Camera {
    private float[] mFrustumMatrix = new float[16];
    private float[] mLookAtMatrix = new float[16];
    private float[] mCurrentMatrix = new float[16];
    private float mTop;
    private float mBottom;
    private float mNear;
    private float mFar;
    private float mEyeZ;

    public Camera(float top, float bottom, float near, float far, float eyeZ) {
        this.mTop = top;
        this.mBottom = bottom;
        this.mNear = near;
        this.mFar = far;
        this.mEyeZ = eyeZ;
    }

    public void sharpFocusing(float left, float right) {
        Matrix.frustumM((float[])this.mFrustumMatrix, (int)0, (float)left, (float)right, (float)this.mBottom, (float)this.mTop, (float)this.mNear, (float)this.mFar);
    }

    public void setUp() {
        Matrix.setLookAtM((float[])this.mLookAtMatrix, (int)0, (float)0.0f, (float)0.0f, (float)this.mEyeZ, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.1f, (float)0.0f);
    }

    public void pressShutter(int projectionMatrixHandle, int viewMatrixHandle, int modelMatrixHandle, float[] modelMatrix) {
        GLES20.glUniformMatrix4fv((int)projectionMatrixHandle, (int)1, (boolean)false, (float[])this.mFrustumMatrix, (int)0);
        GLES20.glUniformMatrix4fv((int)viewMatrixHandle, (int)1, (boolean)false, (float[])this.mLookAtMatrix, (int)0);
        GLES20.glUniformMatrix4fv((int)modelMatrixHandle, (int)1, (boolean)false, (float[])modelMatrix, (int)0);
    }

    public void pressShutter(int matrixHandle) {
        Matrix.multiplyMM((float[])this.mCurrentMatrix, (int)0, (float[])this.mFrustumMatrix, (int)0, (float[])this.mLookAtMatrix, (int)0);
        GLES20.glUniformMatrix4fv((int)matrixHandle, (int)1, (boolean)false, (float[])this.mCurrentMatrix, (int)0);
    }
}

