/*
 * Decompiled with CFR 0.152.
 */
package com.yy.videoplayer.opengles;

import android.content.Context;
import android.graphics.Bitmap;
import android.opengl.GLSurfaceView;
import android.util.AttributeSet;
import android.view.SurfaceHolder;
import com.yy.videoplayer.decoder.PlayNotify;
import com.yy.videoplayer.decoder.SmoothnessCounter;
import com.yy.videoplayer.decoder.StateMonitor;
import com.yy.videoplayer.decoder.VideoConstant;
import com.yy.videoplayer.decoder.VideoSizeUtils;
import com.yy.videoplayer.decoder.ViewLiveStatManager;
import com.yy.videoplayer.decoder.YYVideoLibMgr;
import com.yy.videoplayer.opengles.IRender;
import com.yy.videoplayer.opengles.YMFImageBuffer;
import com.yy.videoplayer.opengles.YMFRender;
import com.yy.videoplayer.render.VideoRenderNotify;
import com.yy.videoplayer.render.YYRenderFrameBuffer;
import com.yy.videoplayer.render.YYSoftDecRender;
import com.yy.videoplayer.utils.GLUtil;
import com.yy.videoplayer.utils.TimeUtil;
import com.yy.videoplayer.utils.YMFLog;
import com.yy.videoplayer.videoview.IVideoInfoCallback;
import com.yy.videoplayer.videoview.YSpVideoView;
import com.yy.videoplayer.videoview.YspVideoViewInfo;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantLock;
import javax.microedition.khronos.egl.EGL10;
import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.egl.EGLDisplay;
import javax.microedition.khronos.opengles.GL10;

public class YMFPlayerView
extends GLSurfaceView
implements GLSurfaceView.Renderer,
SurfaceHolder.Callback,
YSpVideoView {
    private static final String TAG = "YMFPlayerView";
    private static final long NOTIFY_TIME_GAP = 500L;
    private static final long NOTIFY_SIZE_GAP = 15L;
    private int mSurfaceWidth;
    private int mSurfaceHeight;
    private int mVideoWidth;
    private int mVideoHeight;
    private IRender mRender = null;
    private YMFImageBuffer mVideoFrame = null;
    private boolean mSurfaceCreated = false;
    private boolean mFirstFrameRendered = false;
    private boolean mFirstFrameSeeFlag = false;
    private VideoSizeUtils.Size mSize = new VideoSizeUtils.Size();
    private ReentrantLock mRenderLock = new ReentrantLock(true);
    private AtomicBoolean mRenderReady = new AtomicBoolean(false);
    private AtomicBoolean mGlThreadReady = new AtomicBoolean(false);
    private AtomicBoolean mDataArrive = new AtomicBoolean(false);
    private VideoConstant.ScaleMode mScaleMode = VideoConstant.ScaleMode.AspectFit;
    private long mUserGroupId = 0L;
    private long mStreamId = 0L;
    private long mFirstFrameTs = 0L;
    private long mVideoDataCnt = 0L;
    private int mFrames = -1;
    private int mRenderCnt = 0;
    private long mLastTime = 0L;
    private PlayNotify mPlayNotify;
    private YYRenderFrameBuffer mFrameBuffer;
    private SmoothnessCounter mSmoothnessCounter = new SmoothnessCounter(5000L);
    private ArrayList<VideoRenderNotify> mVideoRenderNotifys;
    private IVideoInfoCallback mVideoInfoCallback = null;

    public YMFPlayerView(Context context) {
        super(context);
        this.initEgl();
        this.initFrameBuffer();
    }

    public YMFPlayerView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initEgl();
        this.initFrameBuffer();
    }

    @Override
    public YSpVideoView.ViewType getViewType() {
        return YSpVideoView.ViewType.CustomGLView;
    }

    @Override
    public boolean setScaleMode(VideoConstant.ScaleMode scaleMode) {
        this.mScaleMode = scaleMode;
        this.updateDrawPosition();
        YMFLog.info(TAG, "setScaleMode " + (Object)((Object)scaleMode));
        return true;
    }

    @Override
    public VideoConstant.ScaleMode getScaleMode() {
        return this.mScaleMode;
    }

    @Override
    public boolean setScaleModeEx(int videoIndex, VideoConstant.ScaleMode scaleMode) {
        YMFLog.error((Object)TAG, "setScaleModeEx not supported yet !");
        return false;
    }

    @Override
    public VideoConstant.ScaleMode getScaleModeEx(int videoIndex) {
        YMFLog.error((Object)TAG, "getScaleModeEx not supported yet !");
        return null;
    }

    @Override
    public Bitmap getVideoScreenshot() {
        try {
            YYRenderFrameBuffer.RGB565ImageWithNoPadding img = new YYRenderFrameBuffer.RGB565ImageWithNoPadding();
            if (this.mFrameBuffer != null && this.mFrameBuffer.GetCurrentPictureDataRGB565(img)) {
                Bitmap bmp = Bitmap.createBitmap((int)img.mWidth, (int)img.mHeight, (Bitmap.Config)Bitmap.Config.RGB_565);
                bmp.copyPixelsFromBuffer((Buffer)ByteBuffer.wrap(img.mData));
                return bmp;
            }
        }
        catch (Exception e) {
            YMFLog.error((Object)TAG, "Exception: " + e.getMessage());
        }
        return null;
    }

    @Override
    public void setPlayListner(PlayNotify.PlayListner pl) {
        if (this.mPlayNotify != null) {
            this.mPlayNotify.setPlayListner(pl);
        }
    }

    @Override
    public void linkToStream(final long userGroupId, final long streamId) {
        this.postToGlThread(new Runnable(){

            @Override
            public void run() {
                YMFPlayerView.this.mUserGroupId = userGroupId;
                YMFPlayerView.this.mStreamId = streamId;
                if (YMFPlayerView.this.mFrameBuffer != null) {
                    YMFPlayerView.this.mFrameBuffer.linkToStream(userGroupId, streamId);
                }
                if (YMFPlayerView.this.mPlayNotify != null) {
                    YMFPlayerView.this.mPlayNotify.EndPlay(false);
                    YMFPlayerView.this.mPlayNotify.setVideoIds(userGroupId, streamId);
                }
                StateMonitor.instance().NotifyAddView(streamId, 0, VideoConstant.ViewType.GL_VIDEO_VIEW_GLSURFACE, YMFPlayerView.TAG);
                YMFLog.info(YMFPlayerView.TAG, "linkToStream " + streamId);
            }
        });
    }

    private void unLinkStream(final long userGroupId, final long streamId) {
        this.postToGlThread(new Runnable(){

            @Override
            public void run() {
                StateMonitor.NotifyClearPts(streamId);
                if (YMFPlayerView.this.mFrameBuffer != null) {
                    YMFPlayerView.this.mFrameBuffer.unLinkFromStream(userGroupId, streamId);
                }
                if (YMFPlayerView.this.mPlayNotify != null) {
                    YMFPlayerView.this.mPlayNotify.EndPlay(true);
                }
                StateMonitor.instance().NotifyRemoveView(streamId);
                YMFLog.info(YMFPlayerView.TAG, "unLinkFromStream " + streamId);
            }
        });
    }

    @Override
    public void unLinkFromStream(long userGroupId, long streamId) {
        this.unLinkStream(userGroupId, streamId);
    }

    @Override
    public void unLinkFromStream() {
        this.unLinkStream(this.mUserGroupId, this.mStreamId);
    }

    @Override
    public void init() {
    }

    @Override
    public void release() {
        if (this.mFrameBuffer != null) {
            this.mFrameBuffer.release();
            this.mFrameBuffer = null;
        }
        if (this.mPlayNotify != null) {
            this.mPlayNotify.Release();
            this.mPlayNotify = null;
        }
    }

    @Override
    public void setOrientation(YSpVideoView.OrientationType orientationType, int rotateAngle, boolean adjustImmediately) {
        YMFLog.error((Object)TAG, "setOrientation not supported yet !");
    }

    @Override
    public void onParentSizeChanged(int w, int h) {
    }

    @Override
    public boolean isReleased() {
        return false;
    }

    @Override
    public YYSoftDecRender getRenderFrameBuffer() {
        return this.mFrameBuffer;
    }

    @Override
    public void setVrStream(boolean vrStream) {
        YMFLog.error((Object)TAG, "setVrStream not supported yet !");
    }

    @Override
    public void stopRender() {
        YMFLog.error((Object)TAG, "stopRender not supported yet !");
    }

    @Override
    public void setVideoInfoCallback(IVideoInfoCallback iVideoInfoCallback) {
        this.mVideoInfoCallback = iVideoInfoCallback;
    }

    @Override
    public void linkToStreamExt(long userGroupId, long streamId, int videoIndex) {
        YMFLog.error((Object)TAG, "linkToStreamExt not supported yet !");
    }

    @Override
    public void unLinkFromStreamExt(long userGroupId, long streamId, int videoIndex) {
        YMFLog.error((Object)TAG, "unLinkFromStreamExt not supported yet !");
    }

    @Override
    public Bitmap getVideoScreenshotExt(int videoIndex) {
        YMFLog.error((Object)TAG, "getVideoScreenshotExt not supported yet !");
        return null;
    }

    @Override
    public YspVideoViewInfo getVideoViewInfo(long streamid) {
        YMFLog.error((Object)TAG, "getVideoViewInfo not supported yet !");
        return null;
    }

    private void initEgl() {
        this.setEGLContextClientVersion(2);
        this.setEGLConfigChooser(new ConfigChooser(5, 6, 5, 0, 0, 0));
        this.setRenderer(this);
        this.setRenderMode(0);
        this.getHolder().addCallback((SurfaceHolder.Callback)this);
        this.mGlThreadReady.set(true);
    }

    private void initFrameBuffer() {
        this.mFrameBuffer = new YYRenderFrameBuffer(true);
        YYRenderFrameBuffer.newYUVFrameArrivedCallBack FrameArriveCallBack = new YYRenderFrameBuffer.newYUVFrameArrivedCallBack(){

            @Override
            public void onNewYUVFrameArrive() {
                boolean ret = YMFPlayerView.this.processMediaSample();
                if (!ret) {
                    YMFPlayerView.this.mFrameBuffer.setFrameRendered();
                }
            }
        };
        this.mFrameBuffer.setYUVFrameArriveCallback(FrameArriveCallBack);
        this.mPlayNotify = new PlayNotify();
        this.mPlayNotify.Init();
        this.mVideoRenderNotifys = new ArrayList();
        this.mVideoRenderNotifys.clear();
        YMFLog.info(TAG, this + " init finish. ");
    }

    public void surfaceDestroyed(SurfaceHolder holder) {
        YMFLog.info(TAG, "surfaceDestroyed start.");
        this.mRenderLock.lock();
        this.mSurfaceCreated = false;
        this.mRenderLock.unlock();
        this.postToGlThread(new Runnable(){

            @Override
            public void run() {
                YMFPlayerView.this.releaseRender();
            }
        });
        super.surfaceDestroyed(holder);
        YMFLog.info(TAG, "surfaceDestroyed end.");
    }

    public void onSurfaceCreated(GL10 gl, EGLConfig config) {
        YMFLog.info(TAG, "onSurfaceCreated .");
    }

    public void onSurfaceChanged(GL10 gl, int width, int height) {
        this.mRenderLock.lock();
        this.mSurfaceCreated = true;
        if (this.mSurfaceWidth != width || this.mSurfaceHeight != height) {
            this.mSurfaceWidth = width;
            this.mSurfaceHeight = height;
            this.updateDrawPosition();
        }
        this.mDataArrive.set(false);
        YMFLog.info(TAG, "onSurfaceChanged width " + width + " height " + height);
        this.mRenderLock.unlock();
    }

    private void releaseRender() {
        if (this.mRender != null) {
            this.mRender.release();
            this.mRender = null;
        }
        this.mRenderReady.set(false);
        YMFLog.info(TAG, "releaseRender .");
    }

    private boolean createRender(int width, int height) {
        if (width <= 0 || height <= 0) {
            return false;
        }
        this.mRender = new YMFRender(3);
        YMFLog.info(TAG, " initRender  width " + width + " height " + height + " format I420 .");
        return true;
    }

    public void postToGlThread(Runnable runable) {
        if (this.mGlThreadReady.get()) {
            this.queueEvent(runable);
        }
    }

    private void onVideoRenderNotify(long userGroupId, long streamId, long pts, long renderTimeStamp, long decodeStamp) {
        if (this.mVideoRenderNotifys == null) {
            return;
        }
        this.mVideoRenderNotifys.add(new VideoRenderNotify(userGroupId, streamId, pts, renderTimeStamp, decodeStamp));
        Iterator<VideoRenderNotify> it = this.mVideoRenderNotifys.iterator();
        if (!it.hasNext()) {
            return;
        }
        long firstPts = it.next().mPts;
        if (pts - firstPts < 500L && (long)this.mVideoRenderNotifys.size() < 15L && this.mFirstFrameRendered) {
            return;
        }
        if (!this.mFirstFrameRendered) {
            YMFLog.info(TAG, "first frame finish decode,onVideoRenderNotify");
        }
        YYVideoLibMgr.instance().onVideoRenderNotify(this.mVideoRenderNotifys);
        this.mVideoRenderNotifys.clear();
    }

    private void onVideoEventNotify() {
        long currentTs;
        int pts = this.mFrameBuffer.getCurFramePts();
        StateMonitor.NotifyPts(this.mStreamId, pts);
        ViewLiveStatManager.getInstace().reportFrameEvent(0);
        if (!this.mFirstFrameRendered) {
            this.mFirstFrameTs = System.currentTimeMillis();
        }
        if (!this.mFrameBuffer.getMissRenderFlag()) {
            this.onVideoRenderNotify(this.mUserGroupId, this.mStreamId, pts, TimeUtil.getTickCountLong(), this.mFrameBuffer.getLastDecodeTimeStamp());
        }
        ++this.mVideoDataCnt;
        if (this.mVideoDataCnt == 1L) {
            ViewLiveStatManager.getInstace().notifyEventTime(2, 5, new ViewLiveStatManager.StatVideoHeaderInfo(this.mVideoWidth, this.mVideoHeight));
        }
        if (this.mPlayNotify != null) {
            this.mPlayNotify.DrawNotify();
        }
        if (!this.mFirstFrameSeeFlag) {
            YYVideoLibMgr.instance().onFirstFrameSeeNotify(this.mUserGroupId, this.mStreamId, System.currentTimeMillis() - this.mFirstFrameTs);
            this.mFirstFrameSeeFlag = true;
        }
        if (this.mVideoInfoCallback != null) {
            this.mVideoInfoCallback.onUpdatePts(this.mStreamId, this.mFrameBuffer.getCurFramePts());
        }
        ViewLiveStatManager.getInstace().reportFrameEvent(1);
        if (this.mVideoDataCnt == 1L) {
            ViewLiveStatManager.getInstace().notifyEventTime(3, 5);
        }
        if (this.mSmoothnessCounter.RenderOneFrame(this.mStreamId, currentTs = System.currentTimeMillis())) {
            double coef = this.mSmoothnessCounter.ComputeCoefficientOfVariationAndReset();
            YYVideoLibMgr.instance().onCoefficientOfVariationOfRenderInterval(this.mUserGroupId, this.mStreamId, this.mSmoothnessCounter.GetIntervalMilliTs(), coef);
        }
        ++this.mFrames;
        if (!this.mFirstFrameRendered) {
            YMFLog.info(this, "[Decoder]notify first frame out, cost = " + (currentTs - this.mFirstFrameTs));
            YYVideoLibMgr.instance().onFirstFrameRenderNotify(this.mUserGroupId, this.mStreamId, currentTs, currentTs - this.mFirstFrameTs, this.mFrames);
            StateMonitor.NotifyFirstFrameRendered(this.mStreamId, TimeUtil.getTickCount());
            this.mFirstFrameRendered = true;
        }
        ++this.mRenderCnt;
        long mCurTime = System.currentTimeMillis();
        if (this.mLastTime == 0L) {
            this.mLastTime = mCurTime;
        }
        if (mCurTime - this.mLastTime >= 1000L) {
            StateMonitor.instance().NotifyRenderFrameRate(this.mStreamId, this.mRenderCnt);
            this.mLastTime = mCurTime;
            this.mRenderCnt = 0;
        }
    }

    public void onDrawFrame(GL10 gl) {
        this.mRenderLock.lock();
        GLUtil.checkGlError("YMFPlayerView onDrawFrame enter ");
        if (!this.mRenderReady.get() && this.mSurfaceCreated && this.createRender(this.mVideoWidth, this.mVideoHeight)) {
            this.mRenderReady.set(true);
        }
        if (this.mRenderReady.get() && this.mVideoFrame != null && this.mRender != null && this.mDataArrive.get()) {
            gl.glViewport(this.mSize.x, this.mSize.y, this.mSize.width, this.mSize.height);
            if (this.mScaleMode.compareTo(VideoConstant.ScaleMode.AspectFit) == 0) {
                gl.glClearColor(0.0f, 0.0f, 0.0f, 0.0f);
                gl.glClear(16384);
            }
            if (this.mRender.prepareInputImageData(this.mVideoFrame)) {
                this.mRender.render();
            }
        }
        GLUtil.checkGlError("YMFPlayerView onDrawFrame out ");
        this.mRenderLock.unlock();
        if (this.mFrameBuffer != null) {
            this.mFrameBuffer.setFrameRendered();
            this.onVideoEventNotify();
        }
    }

    private void updateDrawPosition() {
        this.mSize = VideoSizeUtils.CalcFitSize(this.mVideoWidth, this.mVideoHeight, this.mSurfaceWidth, this.mSurfaceHeight, this.mScaleMode);
    }

    private void updateRender(final int w, final int h) {
        if (this.mVideoWidth != w || this.mVideoHeight != h) {
            this.postToGlThread(new Runnable(){

                @Override
                public void run() {
                    YMFPlayerView.this.mDataArrive.set(false);
                    YMFPlayerView.this.releaseRender();
                    YMFPlayerView.this.mVideoWidth = w;
                    YMFPlayerView.this.mVideoHeight = h;
                    YMFPlayerView.this.updateDrawPosition();
                    YMFPlayerView.this.mVideoFrame = new YMFImageBuffer(w, h, 2, false);
                    if (YMFPlayerView.this.mVideoInfoCallback != null) {
                        YMFPlayerView.this.mVideoInfoCallback.onUpdateVideoSizeChanged(YMFPlayerView.this.mStreamId, w, h);
                    }
                }
            });
        }
    }

    public boolean processMediaSample() {
        if (!this.mSurfaceCreated || this.mFrameBuffer == null) {
            return false;
        }
        boolean frameChanged = this.mFrameBuffer.hasFrame();
        ByteBuffer frame = this.mFrameBuffer.getFrame();
        if (frame == null || !frameChanged) {
            return false;
        }
        this.updateRender(this.mFrameBuffer.getWidth(), this.mFrameBuffer.getHeight());
        this.mRenderLock.lock();
        if (this.mVideoFrame != null) {
            this.mVideoFrame.mData = frame;
            this.mDataArrive.set(true);
        }
        this.requestRender();
        this.mRenderLock.unlock();
        return true;
    }

    private static class ConfigChooser
    implements GLSurfaceView.EGLConfigChooser {
        private int mRedSize;
        private int mGreenSize;
        private int mBlueSize;
        private int mAlphaSize;
        private int mDepthSize;
        private int mStencilSize;
        private int EGL_OPENGL_ES2_BIT = 4;
        private int[] mDefaultValue = new int[1];
        private int[] mConfigAttr = new int[]{12324, 4, 12323, 4, 12322, 4, 12352, this.EGL_OPENGL_ES2_BIT, 12344};

        private ConfigChooser(int r, int g, int b, int a, int d, int s) {
            this.mRedSize = r;
            this.mGreenSize = g;
            this.mBlueSize = b;
            this.mAlphaSize = a;
            this.mDepthSize = d;
            this.mStencilSize = s;
        }

        public EGLConfig chooseConfig(EGL10 egl, EGLDisplay display) {
            int[] numConfig = new int[1];
            egl.eglChooseConfig(display, this.mConfigAttr, null, 0, numConfig);
            int num = numConfig[0];
            if (num > 0) {
                EGLConfig[] configs = new EGLConfig[num];
                egl.eglChooseConfig(display, this.mConfigAttr, configs, num, numConfig);
                return this.chooseConfig(egl, display, configs);
            }
            return null;
        }

        private EGLConfig chooseConfig(EGL10 egl, EGLDisplay display, EGLConfig[] configs) {
            for (EGLConfig config : configs) {
                int d = this.findConfigAttrib(egl, display, config, 12325, 0);
                int s = this.findConfigAttrib(egl, display, config, 12326, 0);
                if (d < this.mDepthSize || s < this.mStencilSize) continue;
                int r = this.findConfigAttrib(egl, display, config, 12324, 0);
                int g = this.findConfigAttrib(egl, display, config, 12323, 0);
                int b = this.findConfigAttrib(egl, display, config, 12322, 0);
                int a = this.findConfigAttrib(egl, display, config, 12321, 0);
                if (r != this.mRedSize || g != this.mGreenSize || b != this.mBlueSize || a != this.mAlphaSize) continue;
                return config;
            }
            return null;
        }

        private int findConfigAttrib(EGL10 egl, EGLDisplay display, EGLConfig config, int attribute, int defaultValue) {
            if (egl.eglGetConfigAttrib(display, config, attribute, this.mDefaultValue)) {
                return this.mDefaultValue[0];
            }
            return defaultValue;
        }
    }
}

