/*
 * Decompiled with CFR 0.152.
 */
package com.yy.videoplayer.decoder;

import android.content.Context;
import com.yy.videoplayer.IVideoLibInfoExt;
import com.yy.videoplayer.decoder.GLVersionUtils;
import com.yy.videoplayer.decoder.StateMonitor;
import com.yy.videoplayer.render.VideoRenderNotify;
import com.yy.videoplayer.stat.PlayerExceptionDataStat;
import com.yy.videoplayer.utils.YMFLog;
import java.util.ArrayList;
import java.util.Map;

public class YYVideoLibMgr {
    private static final String TAG = "YYVideoLibMgr";
    private String mAppVersion = "";
    private Context mApplicationContext = null;
    private String mAppName = "";
    private String mDeviceOsVersion = "";
    private String mDeviceModel = "";
    private String mLogPath = null;
    private IVideoLibInfoExt mYYVideoLibInfo = null;
    private static YYVideoLibMgr mInstance = null;
    private static byte[] SYNC_FLAG = new byte[1];

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static YYVideoLibMgr instance() {
        if (mInstance != null) return mInstance;
        byte[] byArray = SYNC_FLAG;
        synchronized (SYNC_FLAG) {
            if (mInstance != null) return mInstance;
            mInstance = new YYVideoLibMgr();
            // ** MonitorExit[var0] (shouldn't be in output)
            return mInstance;
        }
    }

    public void init(Context applicationContext, String strAppVersion, String strAppName, String deviceOsVersion, String deviceModel, String logPath) {
        this.mApplicationContext = applicationContext.getApplicationContext();
        this.mAppVersion = strAppVersion;
        this.mAppName = strAppName;
        this.mDeviceOsVersion = deviceOsVersion;
        this.mDeviceModel = deviceModel;
        this.mLogPath = logPath;
        if (this.mLogPath != null) {
            YMFLog.setFilePath(this.mLogPath);
        }
        GLVersionUtils.holdGLVersion(this.mApplicationContext);
        StateMonitor.instance().init();
        String Info2 = " ********************************************************************\n * YYVideoPlayer Version  : 200.1.0-snapshot.4\n * Application Name    : " + this.mAppName + "\n * Application Version : " + this.mAppVersion + "\n * Device Model        : " + this.mDeviceModel + "\n * Android Version     : " + this.mDeviceOsVersion + "\n * OpenGL ES Version   : " + Integer.toHexString(GLVersionUtils.getGlVersion()) + "\n ********************************************************************";
        YMFLog.info(TAG, Info2);
    }

    public long getUserId() {
        if (this.mYYVideoLibInfo == null) {
            return 0L;
        }
        return this.mYYVideoLibInfo.getUid();
    }

    public long getTopSid() {
        if (this.mYYVideoLibInfo == null) {
            return 0L;
        }
        return this.mYYVideoLibInfo.getTopSid();
    }

    public long getSubSid() {
        if (this.mYYVideoLibInfo == null) {
            return 0L;
        }
        return this.mYYVideoLibInfo.getSubSid();
    }

    public String getLogFilePath() {
        return this.mLogPath;
    }

    public String getAppName() {
        return this.mAppName;
    }

    public String getAppVersion() {
        return this.mAppVersion;
    }

    public Context getAppContext() {
        return this.mApplicationContext;
    }

    public String getDeviceOsVersion() {
        return this.mDeviceOsVersion;
    }

    public String getDeviceModel() {
        return this.mDeviceModel;
    }

    public void setVideoInfoListener(IVideoLibInfoExt listener) {
        this.mYYVideoLibInfo = listener;
    }

    public void onViewPlayEventNotify(long userGroupId, long streamId, int eventType, long happenTime) {
        if (this.mYYVideoLibInfo == null) {
            return;
        }
        this.mYYVideoLibInfo.onViewPlayEventNotify(userGroupId, streamId, eventType, happenTime);
    }

    public void onVideoRenderNotify(ArrayList<VideoRenderNotify> notifys) {
        if (this.mYYVideoLibInfo == null) {
            return;
        }
        this.mYYVideoLibInfo.onVideoRenderNotify(notifys);
    }

    public void onFirstFrameRenderNotify(long userGroupId, long streamId, long currentSystemMilliSecond, long firstFrameToRenderInMilliSec, int eatenFrames) {
        YMFLog.info(TAG, "onFirstFrameRenderNotify userGroupId " + userGroupId + " streamId " + streamId);
        this.mYYVideoLibInfo.onFirstFrameRenderNotify(userGroupId, streamId, currentSystemMilliSecond, firstFrameToRenderInMilliSec, eatenFrames);
    }

    public void onCoefficientOfVariationOfRenderInterval(long userGroupId, long streamId, long intervalMilliTs, double coef) {
        if (this.mYYVideoLibInfo == null) {
            return;
        }
        this.mYYVideoLibInfo.onCoefficientOfVariationOfRenderInterval(userGroupId, streamId, intervalMilliTs, coef);
    }

    public void setConfigs(int appId, Map<Integer, Integer> configs) {
        if (this.mYYVideoLibInfo == null) {
            return;
        }
        this.mYYVideoLibInfo.setConfigs(appId, configs);
    }

    public int getConfig(int configKey) {
        if (this.mYYVideoLibInfo == null) {
            return 0;
        }
        return this.mYYVideoLibInfo.getConfig(configKey);
    }

    public void notifyHardwareCodecConfigured(boolean h264DecodeOn, boolean h264EncodeOn, boolean h265DecodeOn, boolean h265EncodeOn) {
        if (this.mYYVideoLibInfo == null) {
            return;
        }
        this.mYYVideoLibInfo.notifyHardwareCodecConfigured(h264DecodeOn, h264EncodeOn, h265DecodeOn, h265EncodeOn);
    }

    public boolean isLibraryLoaded() {
        if (this.mYYVideoLibInfo == null) {
            return false;
        }
        return this.mYYVideoLibInfo.isLibraryLoaded();
    }

    public Context getmCtx() {
        if (this.mYYVideoLibInfo == null) {
            return null;
        }
        return this.mYYVideoLibInfo.HWCodecConfigGetmCtx();
    }

    public void setRunTimeStamp(String key, long ts) {
        if (this.mYYVideoLibInfo == null) {
            return;
        }
        this.mYYVideoLibInfo.HWCodecConfigSetRunTimeStamp(key, ts);
    }

    public boolean getIsRooted() {
        if (this.mYYVideoLibInfo == null) {
            return false;
        }
        return this.mYYVideoLibInfo.HWCodecConfigGetIsRooted();
    }

    public void onFirstFrameSeeNotify(long userGroupId, long streamId, long happenTime) {
        YMFLog.info(TAG, "onFirstFrameSeeNotify userGroupId " + userGroupId + " streamId " + streamId);
        this.mYYVideoLibInfo.onFirstFrameSeeNotify(userGroupId, streamId, happenTime);
    }

    public void onHardwareDecodeErrorNotify(long userGroupId, long streamId, int errorType) {
        YMFLog.error((Object)TAG, "onHardwareDecodeErrorNotify userGroupId " + userGroupId + " streamId " + streamId + " errorType " + errorType);
        this.mYYVideoLibInfo.onHardwareDecodeErrorNotify(userGroupId, streamId, errorType);
        PlayerExceptionDataStat.getInstance().pushPlayerExceptionDataStat(streamId, "1", "3", "onHardwareDecodeErrorNotify errorType:" + errorType);
    }

    public void onHardwareDecodeWrongFrameNotify(long streamId, String name, byte[] header, byte[] data) {
        YMFLog.error((Object)TAG, "onHardwareDecodeWrongFrameNotify streamID " + streamId + " name " + name);
        this.mYYVideoLibInfo.onHardwareDecodeWrongFrameNotify(streamId, name, header, data);
    }

    public void onDecodedFrameData(long uid, int w, int h, byte[] data, int dateLen, long renderTimeMs) {
        this.mYYVideoLibInfo.onDecodedFrameData(uid, w, h, data, dateLen, renderTimeMs);
    }

    static {
        try {
            System.loadLibrary("Ittiamhevcdec");
            System.loadLibrary("yyvideoplayer");
        }
        catch (Throwable e) {
            YMFLog.error((Object)TAG, " loadLibrary yyvideoplayer  error" + YMFLog.stackTraceOf(e));
        }
    }

    public static class MediaDecodeConfigKey {
        public static final int CCK_H265_HARDWARE_DECODE = 316;
        public static final int CCK_HARDWARE_DECODE = 302;
    }
}

