/*
 * Decompiled with CFR 0.152.
 */
package com.yy.videoplayer.decoder;

import android.opengl.GLES20;
import com.yy.videoplayer.decoder.CatchError;
import com.yy.videoplayer.decoder.ShaderUtils;
import com.yy.videoplayer.utils.YMFLog;

public class VideoShader {
    public int mProgram;
    public int mPositionHandle;
    public int mTextureHandle;
    public int mMatrixHandle;
    public int mFormat;
    public int mSampleY;
    public int mSampleU;
    public int mSampleV;
    private int mVertexShaderHandle;
    private int mFragmentShaderHandle;

    public VideoShader() {
        this.init();
    }

    public void use() {
        GLES20.glUseProgram((int)this.mProgram);
        CatchError.catchError("YUV use");
        this.mPositionHandle = GLES20.glGetAttribLocation((int)this.mProgram, (String)"position_vertex");
        this.mTextureHandle = GLES20.glGetAttribLocation((int)this.mProgram, (String)"texture_vertex");
        this.mMatrixHandle = GLES20.glGetUniformLocation((int)this.mProgram, (String)"matrix");
        this.mFormat = GLES20.glGetUniformLocation((int)this.mProgram, (String)"format");
        this.mSampleY = GLES20.glGetUniformLocation((int)this.mProgram, (String)"tex_y");
        this.mSampleU = GLES20.glGetUniformLocation((int)this.mProgram, (String)"tex_u");
        this.mSampleV = GLES20.glGetUniformLocation((int)this.mProgram, (String)"tex_v");
        CatchError.catchError("YUV use2");
    }

    public void destroy() {
        ShaderUtils.deleteShaderProgram(this.mProgram, this.mVertexShaderHandle, this.mFragmentShaderHandle);
        CatchError.catchError("YUV destroy");
        this.mProgram = -1;
        this.mPositionHandle = -1;
        this.mTextureHandle = -1;
        this.mMatrixHandle = -1;
        this.mFormat = -1;
        this.mVertexShaderHandle = -1;
        this.mFragmentShaderHandle = -1;
        this.mSampleV = -1;
        this.mSampleY = -1;
        this.mSampleU = -1;
    }

    private void init() {
        CatchError.catchError("initVideoShaderYUV0");
        this.mVertexShaderHandle = ShaderUtils.compileShader(35633, "attribute vec4 position_vertex;attribute vec2 texture_vertex;varying vec2 texture_coord;uniform mat4 matrix;void main() {gl_Position = matrix * position_vertex;texture_coord = texture_vertex;}");
        CatchError.catchError("initVideoShaderYUV1");
        this.mFragmentShaderHandle = ShaderUtils.compileShader(35632, "precision highp float;varying vec2 texture_coord;uniform int format;uniform sampler2D tex_y;uniform sampler2D tex_u;uniform sampler2D tex_v;void main() {if(0 == format || 3 == format) {gl_FragColor = texture2D(tex_y, texture_coord);}else if(4 == format) {gl_FragColor = vec4(1,0,0,1);}else {vec3 yuv;yuv.x = texture2D(tex_y, texture_coord).r;yuv.y = texture2D(tex_u, texture_coord).r - 0.5;if(1 == format) {yuv.z = texture2D(tex_u, texture_coord).a - 0.5;}else{yuv.z = texture2D(tex_v, texture_coord).r - 0.5;}yuv.x = 1.1643 * yuv.x - 0.0728;vec3 rgb = vec3(yuv.x + 1.5958 * yuv.z,yuv.x - 0.39173 * yuv.y - 0.8129 * yuv.z,yuv.x + 2.017 * yuv.y);gl_FragColor = vec4(rgb, 1);}}");
        CatchError.catchError("initVideoShaderYUV2");
        this.mProgram = ShaderUtils.linkShader(this.mVertexShaderHandle, this.mFragmentShaderHandle);
        CatchError.catchError("initVideoShaderYUV3");
        ShaderUtils.validateShaderProgram(this.mProgram);
        CatchError.catchError("initVideoShaderYUV4");
        if (0 == this.mVertexShaderHandle || 0 == this.mFragmentShaderHandle || 0 == this.mProgram) {
            YMFLog.error("CatchError", "soft video shader init error vsh %d fsh %d program %d", this.mVertexShaderHandle, this.mFragmentShaderHandle, this.mProgram);
            this.mProgram = -1;
            this.mFragmentShaderHandle = -1;
            this.mVertexShaderHandle = -1;
        }
    }
}

