/*
 * Decompiled with CFR 0.152.
 */
package com.yy.videoplayer.decoder;

import android.media.MediaCodecInfo;
import android.media.MediaCodecList;
import android.view.Surface;
import com.yy.videoplayer.decoder.HardDecRender;
import com.yy.videoplayer.decoder.PlayNotify;
import com.yy.videoplayer.utils.YMFLog;
import java.util.concurrent.atomic.AtomicBoolean;

public class VP8DecRender
extends HardDecRender {
    static final String mCodecType = "video/x-vnd.on2.vp8";
    static String mCodecName = "";
    public static final String crashTsFirst = "VP8DecRenderCrashTsFirst";
    public static final String crashTsSecond = "VP8DecRenderCrashTsSecond";
    private static final String[] supportedHevcHwCodecPrefixes = new String[]{"OMX.qcom.video.", "OMX.MTK."};
    private static final String[] unSupportedHevcHwCodecPrefixes = new String[0];

    public static void getDecodeInfoAsync() {
        DecodeInfoThread decodeInfoThread = new DecodeInfoThread();
        Thread thread = new Thread(decodeInfoThread);
        thread.start();
    }

    private static MediaCodecInfo selectCodec(String mimeType) {
        int numCodecs = MediaCodecList.getCodecCount();
        for (int i = 0; i < numCodecs; ++i) {
            MediaCodecInfo codecInfo = MediaCodecList.getCodecInfoAt((int)i);
            if (codecInfo.isEncoder()) continue;
            for (String type : codecInfo.getSupportedTypes()) {
                if (!type.equalsIgnoreCase(mimeType)) continue;
                YMFLog.info("selectCodec", "SelectCodec : " + codecInfo.getName());
                return codecInfo;
            }
        }
        return null;
    }

    public VP8DecRender(Surface surface, int width, int height) {
        this.mSurface = surface;
        this.mWidth = width;
        this.mHeight = height;
        YMFLog.info(this, "[Decoder]VP8DecRender() init");
        this.InitFields();
        this.reset(this.mSurface, this.mWidth, this.mHeight);
    }

    public VP8DecRender(Surface surface, PlayNotify playNotify) {
        this.mSurface = surface;
        this.InitFields();
        this.reset(this.mSurface, this.mWidth, this.mHeight);
    }

    public static boolean upDateCodecIgnoreCodecWhiteList() {
        mCodecName = VP8DecRender.findCodecName(mCodecType, supportedHevcHwCodecPrefixes, unSupportedHevcHwCodecPrefixes, true);
        return null != mCodecName;
    }

    public static boolean IsAvailable() {
        return VP8DecRender.IsAvailable(mCodecName);
    }

    public static String getCodecName() {
        return mCodecName;
    }

    void InitFields() {
        this.mSecondTsWriten = new AtomicBoolean(false);
        this.mCrashTsFirst = crashTsFirst;
        this.mCrashTsSecond = crashTsSecond;
        this.mNoFrameCnt = 0;
    }

    @Override
    public int reset() {
        return this.reset(this.mSurface, this.mWidth, this.mHeight);
    }

    @Override
    public int reset(Surface surface, int width, int height) {
        return this.reset(surface, mCodecName, mCodecType, width, height);
    }

    @Override
    public long PushFrame(Surface surface, byte[] bf, long pts, boolean isHeader) {
        return this.PushFrame(surface, mCodecName, mCodecType, bf, pts, isHeader);
    }

    static {
        VP8DecRender.getDecodeInfoAsync();
    }

    static class DecodeInfoThread
    implements Runnable {
        DecodeInfoThread() {
        }

        @Override
        public void run() {
            try {
                MediaCodecInfo mediaCodecInfo = VP8DecRender.selectCodec(VP8DecRender.mCodecType);
                if (mediaCodecInfo != null) {
                    mCodecName = mediaCodecInfo.getName();
                    YMFLog.info("YYSDK", "[Decoder]VP8DecRender mediaCodecInfo.getName() mCodecName=" + mCodecName);
                }
            }
            catch (Exception e) {
                YMFLog.error((Object)"YYSDK", "[Decoder]DecoderInfo: Load Error " + e.getMessage());
            }
        }
    }
}

