/*
 * Decompiled with CFR 0.152.
 */
package com.yy.videoplayer.decoder;

import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import com.yy.videoplayer.VideoPlayer;
import com.yy.videoplayer.decoder.VideoConstant;
import com.yy.videoplayer.stat.PlayerExceptionDataStat;
import com.yy.videoplayer.stat.VideoDataStatHelper;
import com.yy.videoplayer.stat.VideoPlayerDataStat;
import com.yy.videoplayer.utils.YMFLog;
import com.yy.videoplayer.videoview.VideoPosition;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;

public class StateMonitor
implements Runnable {
    private static final String TAG = "[StateMonitor]";
    private static final int mStaticsCycle = 10;
    private static StateMonitor mInstance = null;
    private StateMonitorHandler mHandler;
    private static final byte[] SYNC_FLAG = new byte[1];
    private AtomicBoolean mReady = new AtomicBoolean(false);
    private HashMap<Long, PlayerState> mPlayerStateMap = new HashMap();
    private static final int MSG_QUIT = 0;
    private static final int MSG_ADD_DECODER = 1;
    private static final int MSG_DEL_DECODER = 2;
    private static final int MSG_ADD_RENDER = 3;
    private static final int MSG_DEL_RENDER = 4;
    private static final int MSG_ADD_VIEW = 5;
    private static final int MSG_DEL_VIEW = 6;
    private static final int MSG_STREAM_START = 7;
    private static final int MSG_STREAM_END = 8;
    private static final int MSG_TRANS_FRAMERATE = 9;
    private static final int MSG_FIRST_FRAME_ARRIVE = 10;
    private static final int MSG_RENDER_FRAMERATE = 11;
    private static final int MSG_FIRST_FRAME_RENDER = 12;
    private static final int MSG_DEC_OUT_FRAMERATE = 13;
    private static final int MSG_RESOLUTION = 14;
    private static final int MSG_NotifyPts = 15;
    private static final int MSG_Notify_Clear_Pts = 16;
    private static final int MSG_MULTIVIDEO_ORIGIN_POSITION = 17;
    private static final int MSG_MULTIVIDEO_SURFACE_CHANGE_POSITION = 18;
    private static final int MSG_LAST_FRAME_NOT_RENDER_STATISTIC = 19;
    private static final int MSG_LOST_RENDER_FRAME_STATISTIC = 20;
    private static final int MSG_IS_BLUE_RAY_STATISTIC = 21;
    private static final int MSG_SET_BITRATE_STATISTIC = 22;
    private static final int MSG_SET_DECODE_DELAY_FRAME_COUNT_STATISTIC = 23;
    private static final int MSG_FRAMERATE = 24;
    private static final int DEC_TYPE_H264_HW_OFFSCREEEN = 0;
    private static final int DEC_TYPE_H265_HW_OFFSCREEEN = 1;
    private static final int DEC_TYPE_H264_SW_FFMPEG = 2;
    private static final int DEC_TYPE_H265_SW_ITTIAM = 3;
    public int mCurrentFps = 0;
    public String mCurrentDecoderType = "";
    public int mCurrentWidth = 0;
    public int mCurrentHeight = 0;

    public static void NotifyCreateDecoder(long streamId, int type, long curTime) {
        String name = "UNKNOWN";
        switch (type) {
            case 0: {
                name = "DEC_TYPE_H264_HW_OFFSCREEEN";
                break;
            }
            case 1: {
                name = "DEC_TYPE_H265_HW_OFFSCREEEN";
                break;
            }
            case 2: {
                name = "DEC_TYPE_H264_SW_FFMPEG";
                break;
            }
            case 3: {
                name = "DEC_TYPE_H265_SW_ITTIAM";
                break;
            }
        }
        StateMonitor.instance().addDecoder(streamId, type, name, curTime);
        VideoPlayerDataStat.getInstance().putVideoDecodeIdToStat(streamId, StateMonitor.wrapperLocalDecodeId2HiidoDecodeId(type));
        PlayerExceptionDataStat.getInstance().putVideoDecodeIdToStat(streamId, StateMonitor.wrapperLocalDecodeId2HiidoDecodeId(type));
    }

    private static int wrapperLocalDecodeId2HiidoDecodeId(int type) {
        int hiiDecodeId = -1;
        switch (type) {
            case 0: {
                hiiDecodeId = 1;
                break;
            }
            case 1: {
                hiiDecodeId = 3;
                break;
            }
            case 2: {
                hiiDecodeId = 0;
                break;
            }
            case 3: {
                hiiDecodeId = 2;
                break;
            }
        }
        return hiiDecodeId;
    }

    public static void NotifyReleaseDecoder(long streamId) {
        StateMonitor.instance().removeDecoder(streamId);
    }

    public static void NotifyVideoStreamStart(long streamId, long groupId, int micPos, int fps, int bhard, int vType) {
        StateMonitor.instance().streamStart(streamId, groupId, micPos, fps, bhard, vType);
    }

    public static void NotifyVideoStreamEnd(long streamId) {
        StateMonitor.instance().streamEnd(streamId);
    }

    public static void NotifyCreateRender(long streamId, int type) {
        String name = "UNKNOWN";
        switch (type) {
            case 0: {
                name = "MediaCodec-H264DecRender";
                break;
            }
            case 1: {
                name = "MediaCodec-H265DecRender";
                break;
            }
            case 2: {
                name = "RenderFramebuffer";
                break;
            }
            case 3: {
                name = "Canvas";
                break;
            }
        }
        StateMonitor.instance().addRender(streamId, type, name);
    }

    public static void NotifyReleaseRender(long streamId) {
        StateMonitor.instance().removeRender(streamId);
    }

    public static void NotifyDecoderFrameRate(long streamId, int frameRateI, int frameRateO) {
        StateMonitor.instance().NotifyFrameRate(streamId, frameRateI, frameRateO);
    }

    public static void NotifyDecoderFrameRateOUT(long streamId, int frameRate) {
        StateMonitor.instance().notifyDecoderFrameRateO(streamId, frameRate);
    }

    public static void NotifyPts(long streamId, long pts) {
        StateMonitor.instance().notifyPts(streamId, pts);
    }

    public static void NotifyClearPts(long streamId) {
        StateMonitor.instance().notifyClearPts(streamId);
    }

    public static void NotifyFirstFrameArrived(long streamid, long curTime) {
        StateMonitor.instance().notifyFirstFrameArrived(streamid, curTime);
    }

    public static void NotifyFirstFrameRendered(long streamId, long firstRenderTime) {
        StateMonitor.instance().notifyFirstFrameRendered(streamId, firstRenderTime);
    }

    public void NotifyRenderFrameRate(long streamId, int frameRate) {
        StateMonitor.instance().notifyRenderFrameRate(streamId, frameRate);
    }

    public static void NotifyResolution(long streamId, int width, int height) {
        StateMonitor.instance().notifyResolution(streamId, width, height);
    }

    public static void NotifyRenderLostRate(long streamId, float frameRate) {
        StateMonitor.instance().notifyRenderLostRate(streamId, frameRate);
    }

    public void NotifyBlueRayInfo(long streamId, int isBlueRay) {
        StateMonitor.instance().notifyBlueRayInfo(streamId, isBlueRay);
    }

    public void NotifyBiteRateInfo(long streamId, String bitRate) {
        StateMonitor.instance().notifyBiteRateInfo(streamId, bitRate);
    }

    public void NotifyDecodeDelayFrameCountInfo(long streamId, int count) {
        StateMonitor.instance().notifyDecodeDelayFrameCountInfo(streamId, count);
    }

    public static void NotifyMultiVideoOriginPosition(VideoPosition[] params, VideoPosition background) {
        StateMonitor.instance().notifyMultiVideoOriginPosition(params, background);
    }

    public static void NotifyMultiVideoSurfaceChangePosition(VideoPosition[] params, VideoPosition background) {
        StateMonitor.instance().notifyMultiVideoSurfaceChangePosition(params, background);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static StateMonitor instance() {
        if (mInstance != null) return mInstance;
        byte[] byArray = SYNC_FLAG;
        synchronized (SYNC_FLAG) {
            if (mInstance != null) return mInstance;
            mInstance = new StateMonitor();
            // ** MonitorExit[var0] (shouldn't be in output)
            return mInstance;
        }
    }

    public static void NotifyLastFrameNotRenderStatistic(long streamId, int count) {
        StateMonitor.instance().notifyLastFrameNotRenderStatistic(streamId, count);
    }

    public StateMonitor() {
        this.InitThread();
    }

    public void init() {
        YMFLog.info(this, "[StateMonitor] Init .");
    }

    public void deInit() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void InitThread() {
        Thread mThread = new Thread(this);
        mThread.setName("YYVideoLib-StateMonitor");
        byte[] byArray = SYNC_FLAG;
        synchronized (SYNC_FLAG) {
            try {
                mThread.start();
            }
            catch (Throwable e) {
                YMFLog.error((Object)this, e.getMessage());
            }
            YMFLog.info(this, "[StateMonitor]construct done .");
            return;
        }
    }

    @Override
    public void run() {
        try {
            Looper.prepare();
            this.mHandler = new StateMonitorHandler(this);
            this.mReady.set(true);
            Looper.loop();
            this.mReady.set(false);
        }
        catch (Throwable t) {
            YMFLog.error((Object)this, "[StateMonitor] end looper throwable " + t.getMessage() + " " + t.toString());
            t.printStackTrace();
        }
        finally {
            YMFLog.info(this, "[StateMonitor] end !");
            this.deInit();
        }
    }

    private PlayerState getPlayerState(long streamId) {
        PlayerState playerState;
        if (this.mPlayerStateMap.containsKey(streamId)) {
            playerState = this.mPlayerStateMap.get(streamId);
        } else {
            YMFLog.warn(this, "StateMonitor:new PlayerState, streamId:" + streamId);
            playerState = new PlayerState(streamId);
            this.mPlayerStateMap.put(streamId, playerState);
        }
        return playerState;
    }

    private void removePlayerState(long streamId) {
        if (this.mPlayerStateMap.containsKey(streamId)) {
            YMFLog.warn(this, "Monitor:remove PlayerState, streamId:" + streamId);
            this.mPlayerStateMap.remove(streamId);
        }
    }

    private void notifyRenderLostRate(long streamId, float frameRate) {
        if (!this.mReady.get() || null == this.mHandler) {
            return;
        }
        LostRenderInfo renderInfo = new LostRenderInfo();
        renderInfo.mStreamId = streamId;
        renderInfo.mFrameRate = frameRate;
        this.mHandler.sendMessage(this.mHandler.obtainMessage(20, renderInfo));
    }

    private void notifyBlueRayInfo(long streamId, int isBlueRay) {
        if (!this.mReady.get() || null == this.mHandler) {
            return;
        }
        BlueRayInfo blueRayInfo = new BlueRayInfo();
        blueRayInfo.mStreamId = streamId;
        blueRayInfo.mIsBlueRay = isBlueRay;
        this.mHandler.sendMessage(this.mHandler.obtainMessage(21, blueRayInfo));
    }

    private void notifyBiteRateInfo(long streamId, String bitRate) {
        if (!this.mReady.get() || null == this.mHandler) {
            return;
        }
        BitRateInfo bitRateInfo = new BitRateInfo();
        bitRateInfo.mStreamId = streamId;
        bitRateInfo.mBitRate = bitRate;
        this.mHandler.sendMessage(this.mHandler.obtainMessage(22, bitRateInfo));
    }

    private void notifyDecodeDelayFrameCountInfo(long streamId, int count) {
        if (!this.mReady.get() || null == this.mHandler) {
            return;
        }
        DecodeDelayFrameInfo delayFrameInfo = new DecodeDelayFrameInfo();
        delayFrameInfo.mStreamId = streamId;
        delayFrameInfo.mCount = count;
        this.mHandler.sendMessage(this.mHandler.obtainMessage(23, delayFrameInfo));
    }

    private void notifyResolution(long streamId, int width, int height) {
        if (!this.mReady.get() || null == this.mHandler) {
            return;
        }
        resolutionInfo info = new resolutionInfo();
        info.mStreamId = streamId;
        info.mWidth = width;
        info.mHeight = height;
        this.mHandler.sendMessage(this.mHandler.obtainMessage(14, info));
    }

    private void handleResolution(long streamId, int width, int height) {
        PlayerState playerState = this.getPlayerState(streamId);
        if (null == playerState) {
            return;
        }
        DecoderState decoderState = playerState.mDecoderState;
        if (null == decoderState) {
            return;
        }
        decoderState.mWidth = width;
        decoderState.mHeight = height;
        VideoPlayer.getInstance().pushVideoPlayerInfo(streamId, width, height, -1);
        YMFLog.warn(this, "[StateMonitor]streamId " + streamId + " Resolution " + decoderState.mWidth + "x" + decoderState.mHeight);
    }

    private void notifyFirstFrameArrived(long streamId, long curTime) {
        if (!this.mReady.get() || null == this.mHandler) {
            return;
        }
        StreamTimeInfo streamTimeInfo = new StreamTimeInfo(streamId, curTime);
        this.mHandler.sendMessage(this.mHandler.obtainMessage(10, streamTimeInfo));
    }

    private void notifyFirstFrameRendered(long streamId, long firstRenderTime) {
        if (!this.mReady.get() || null == this.mHandler) {
            return;
        }
        PlayerState playerState = this.getPlayerState(streamId);
        if (null == playerState) {
            return;
        }
        playerState.mFirstFrameRendedTime = firstRenderTime;
        this.mHandler.sendMessage(this.mHandler.obtainMessage(12, streamId));
    }

    private void handleNofityFirstFrameRendered(long streamId) {
        PlayerState playerState = this.getPlayerState(streamId);
        if (null == playerState) {
            return;
        }
        DecoderState decoderState = playerState.mDecoderState;
        if (null == decoderState) {
            return;
        }
        playerState.mFirstFrameRendered = true;
        long deltaDecoderCreate2Arrived = playerState.mFirstFrameArrivedTime - decoderState.mCreateDecoderTime;
        long deltaStreamArrive2Renderd = playerState.mFirstFrameRendedTime - decoderState.mCreateDecoderTime;
        YMFLog.warn(this, "[StateMonitor]streamId " + streamId + " First Frame Rendered. firstArrive - createDecoder " + deltaDecoderCreate2Arrived + " firstRender - createDecoder:" + deltaStreamArrive2Renderd);
        VideoPlayerDataStat.getInstance().setFirstFrameDeltaTime(streamId, deltaDecoderCreate2Arrived, deltaStreamArrive2Renderd);
    }

    private void handleNotifyFirstFrameArrive(StreamTimeInfo streamTimeInfo) {
        PlayerState playerState = this.getPlayerState(streamTimeInfo.mStreamId);
        if (null == playerState) {
            return;
        }
        playerState.mFirstFrameArrivedTime = streamTimeInfo.mTimeStamp;
        playerState.mFristFrameArrived = true;
        YMFLog.warn(this, "[StateMonitor]streamId " + streamTimeInfo.mStreamId + " First Frame Arrived . " + playerState.mFristFrameArrived);
    }

    private void notifyDecoderFrameRateO(long streamId, int frameRate) {
        if (!this.mReady.get() || null == this.mHandler) {
            return;
        }
        frameRateInfo info = new frameRateInfo();
        info.mStreamId = streamId;
        info.mFrameRate = frameRate;
        this.mHandler.sendMessage(this.mHandler.obtainMessage(13, info));
    }

    private void notifyPts(long streamId, long pts) {
        if (!this.mReady.get() || null == this.mHandler) {
            return;
        }
        FramePtsInfo info = new FramePtsInfo();
        info.mStreamId = streamId;
        info.pts = pts;
        this.mHandler.sendMessage(this.mHandler.obtainMessage(15, info));
    }

    private void notifyClearPts(long streamId) {
        if (!this.mReady.get() || null == this.mHandler) {
            return;
        }
        this.mHandler.sendMessage(this.mHandler.obtainMessage(16, streamId));
    }

    private void handleDecoderFrameRateO(long streamId, int frameRate) {
        PlayerState playerState = this.getPlayerState(streamId);
        if (null == playerState) {
            return;
        }
        DecoderState State2 = playerState.mDecoderState;
        if (null == State2) {
            return;
        }
        List list = State2.mFrameOList;
        if (null != list) {
            list.add(frameRate);
        }
    }

    private void handlePts(long streamId, long pts) {
        VideoDataStatHelper.addPtsToList(streamId, pts);
    }

    private void handleClearPts(long streamId) {
        VideoDataStatHelper.clearPtsTimes(streamId);
    }

    private void notifyRenderFrameRate(long streamId, int frameRate) {
        if (!this.mReady.get() || null == this.mHandler) {
            return;
        }
        frameRateInfo info = new frameRateInfo();
        info.mStreamId = streamId;
        info.mFrameRate = frameRate;
        this.mHandler.sendMessage(this.mHandler.obtainMessage(11, info));
    }

    private void handleRenderFrameRate(long streamId, int frameRate) {
        VideoPlayerDataStat.getInstance().putRenderFrameRateToStat(streamId, frameRate);
        VideoPlayer.getInstance().pushVideoPlayerInfo(streamId, -1, -1, frameRate);
        PlayerState playerState = this.getPlayerState(streamId);
        if (null == playerState) {
            return;
        }
        this.mCurrentFps = frameRate;
        this.mCurrentDecoderType = playerState.mDecoderState != null ? playerState.mDecoderState.mName : "UNKOWN";
        this.mCurrentWidth = playerState.mDecoderState != null ? (int)playerState.mDecoderState.mWidth : 0;
        this.mCurrentHeight = playerState.mDecoderState != null ? (int)playerState.mDecoderState.mHeight : 0;
        RenderState renderState = playerState.mRenderState;
        if (null == renderState) {
            return;
        }
        List list = renderState.mFrameRateList;
        if (null != list) {
            list.add(frameRate);
        }
    }

    private void NotifyFrameRate(long streamId, int frameRateI, int frameRateO) {
        if (!this.mReady.get() || null == this.mHandler) {
            return;
        }
        frameRateInfo info = new frameRateInfo();
        info.mStreamId = streamId;
        info.mFrameRate = frameRateI;
        info.mFrameRateDecoder = frameRateO;
        this.mHandler.sendMessage(this.mHandler.obtainMessage(24, info));
    }

    private void PrintFrameRate(long streamId, String type, List<Integer> list) {
        if (null == list) {
            return;
        }
        String str = " ";
        for (int i = 0; i < list.size(); ++i) {
            str = str + list.get(i) + ",";
        }
        YMFLog.warn(this, "[StateMonitor]streamId " + streamId + " " + type + "[" + str + "]");
    }

    private void handleTransInputFrameRate(long streamId, int frameRate, int frameRateDecoder) {
        PlayerState playerState = this.getPlayerState(streamId);
        if (null == playerState) {
            return;
        }
        DecoderState decoderState = playerState.mDecoderState;
        if (null == decoderState) {
            return;
        }
        List list = decoderState.mFrameIList;
        List listDec = decoderState.mFrameOList;
        if (null != list) {
            list.add(frameRate);
            if (frameRateDecoder != -1) {
                listDec.add(frameRateDecoder);
            }
            if (list.size() >= 10) {
                List renderList;
                RenderState renderState;
                this.PrintFrameRate(streamId, "TransfFrameRate", list);
                list.clear();
                List DecOutList = decoderState.mFrameOList;
                if (null != DecOutList) {
                    this.PrintFrameRate(streamId, "DecOutFrameRate", DecOutList);
                    DecOutList.clear();
                }
                if ((renderState = playerState.mRenderState) != null && null != (renderList = renderState.mFrameRateList)) {
                    this.PrintFrameRate(streamId, "RenderFrameRate", renderList);
                    renderList.clear();
                }
            }
        }
    }

    private void addDecoder(long streamId, int type, String name, long curTime) {
        if (!this.mReady.get() || null == this.mHandler) {
            return;
        }
        DecoderState state = new DecoderState();
        state.mStreamId = streamId;
        state.mType = type;
        state.mName = name;
        state.mCreateDecoderTime = curTime;
        this.mHandler.sendMessage(this.mHandler.obtainMessage(1, state));
    }

    private void handleAddDecoder(long streamId, int type, String name, long createDecoderTime) {
        DecoderState decoderState = new DecoderState();
        decoderState.mName = name;
        decoderState.mType = type;
        decoderState.mStreamId = streamId;
        decoderState.mCreateDecoderTime = createDecoderTime;
        if (this.mPlayerStateMap.containsKey(streamId)) {
            this.mPlayerStateMap.get(streamId).mDecoderState = null;
        }
        this.getPlayerState(streamId).mDecoderState = decoderState;
        YMFLog.warn(this, "[StateMonitor]addDecoder, streamId:" + streamId + " Decoder " + name + " type " + type + " addDecoderTime " + createDecoderTime);
    }

    private void removeDecoder(long streamId) {
        if (!this.mReady.get() || null == this.mHandler) {
            return;
        }
        this.mHandler.sendMessage(this.mHandler.obtainMessage(2, streamId));
    }

    private void handleRemoveDecoder(long streamId) {
        if (this.mPlayerStateMap.containsKey(streamId)) {
            PlayerState playerState = this.mPlayerStateMap.get(streamId);
            if (playerState == null) {
                return;
            }
            DecoderState decoderState = playerState.mDecoderState;
            if (decoderState != null) {
                YMFLog.warn(this, "[StateMonitor]removeDecoder, streamId:" + streamId + " Decoder " + decoderState.mName);
                playerState.mDecoderState = null;
            }
            if (playerState.mViewState == null && playerState.mRenderState == null) {
                this.removePlayerState(streamId);
            }
        }
    }

    private void addRender(long streamId, int type, String name) {
        if (!this.mReady.get() || null == this.mHandler) {
            return;
        }
        RenderState renderState = new RenderState();
        renderState.mName = name;
        renderState.mType = type;
        renderState.mStreamId = streamId;
        this.mHandler.sendMessage(this.mHandler.obtainMessage(3, renderState));
    }

    private void handleAddRender(long streamId, int type, String name) {
        RenderState renderState = new RenderState();
        renderState.mName = name;
        renderState.mType = type;
        renderState.mStreamId = streamId;
        if (this.mPlayerStateMap.containsKey(streamId)) {
            this.handlerPrintfFramRate(streamId);
            this.mPlayerStateMap.get(streamId).mRenderState = null;
        }
        this.getPlayerState(streamId).mRenderState = renderState;
        YMFLog.warn(this, "[StateMonitor]addRender, streamId:" + streamId + " Render " + name + " type " + type + " (0-MediaCodec-H264DecRender 1.MediaCodec-H265DecRender 2-RenderFramebuffer 3-Canvas)");
    }

    private void removeRender(long streamId) {
        if (!this.mReady.get() || null == this.mHandler) {
            return;
        }
        this.mHandler.sendMessage(this.mHandler.obtainMessage(4, streamId));
    }

    private void handlerPrintfFramRate(long streamId) {
        if (this.mPlayerStateMap.containsKey(streamId)) {
            List renderList;
            RenderState renderState;
            PlayerState playerState = this.mPlayerStateMap.get(streamId);
            if (playerState == null) {
                return;
            }
            DecoderState decoderState = playerState.mDecoderState;
            if (null == decoderState) {
                return;
            }
            List list = decoderState.mFrameIList;
            this.PrintFrameRate(streamId, "TransfFrameRate", list);
            list.clear();
            List DecOutList = decoderState.mFrameOList;
            if (null != DecOutList) {
                this.PrintFrameRate(streamId, "DecOutFrameRate", DecOutList);
                DecOutList.clear();
            }
            if ((renderState = playerState.mRenderState) != null && null != (renderList = renderState.mFrameRateList)) {
                this.PrintFrameRate(streamId, "RenderFrameRate", renderList);
                renderList.clear();
            }
        }
    }

    private void handleRemoveRender(long streamId) {
        if (this.mPlayerStateMap.containsKey(streamId)) {
            PlayerState playerState = this.mPlayerStateMap.get(streamId);
            if (playerState == null) {
                return;
            }
            this.handlerPrintfFramRate(streamId);
            RenderState renderState = playerState.mRenderState;
            if (renderState != null) {
                YMFLog.warn(this, "[StateMonitor]removeRender, streamId:" + streamId + " Render " + renderState.mName + " type " + renderState.mType + " (0-MediaCodec-H264DecRender 1.MediaCodec-H265DecRender 2-RenderFramebuffer 3-Canvas)");
                playerState.mRenderState = null;
            }
            if (playerState.mViewState == null && playerState.mDecoderState == null) {
                this.removePlayerState(streamId);
            }
        }
    }

    private String getViewTypeName(VideoConstant.ViewType type) {
        switch (type) {
            case SURFACE_VIDEO_VIEW: {
                return " YSurfaceVideoViewExt ";
            }
            case NO_GL_VIDEO_VIEW: {
                return " YVideoViewExt ";
            }
            case NO_GL_VIDEO_VIEW_MULTIVIDEO: {
                return " YVideoViewMultiVideo ";
            }
            case CUSTOM_GL_VIDEO_VIEW_LOW: {
                return " YCustomGLVideoViewLowEGLExt ";
            }
            case CUSTOM_GL_VIDEO_VIEW_LOW_MULTIVIDEO: {
                return " YCustomGLVideoViewLowEGLMultiVideo ";
            }
            case CUSTOM_GL_VIDEO_VIEW_HIGH: {
                return " YCustomGLVideoViewHighEGLExt ";
            }
            case CUSTOM_GL_VIDEO_VIEW_HIGH_MULTIVIDEO: {
                return " YCustomGLVideoViewHighEGLMultiVideo";
            }
            case GL_VIDEO_VIEW: {
                return " YGLVideoViewExt ";
            }
            case GL_VIDEO_VIEW_MULTIVIDEO: {
                return " YGLVideoViewMutiVideo ";
            }
        }
        return " unknow view type ";
    }

    public void NotifyAddView(long streamId, int VideoIndex, VideoConstant.ViewType type, String name) {
        if (!this.mReady.get() || null == this.mHandler) {
            return;
        }
        ViewState viewState = new ViewState();
        viewState.mName = name;
        viewState.mType = type;
        viewState.mStreamId = streamId;
        viewState.mVideoIndex = VideoIndex;
        this.mHandler.sendMessage(this.mHandler.obtainMessage(5, viewState));
    }

    private void handleAddView(long streamId, int videoIndex, VideoConstant.ViewType type, String name) {
        ViewState viewState = new ViewState();
        viewState.mName = name;
        viewState.mType = type;
        viewState.mStreamId = streamId;
        viewState.mVideoIndex = videoIndex;
        if (this.mPlayerStateMap.containsKey(streamId)) {
            this.mPlayerStateMap.get(streamId).mViewState = null;
        }
        this.getPlayerState(streamId).mViewState = viewState;
        YMFLog.warn(this, "[StateMonitor]addView, streamId:" + streamId + " mVideoIndex " + videoIndex + " View " + name + " type : " + this.getViewTypeName(type));
    }

    public void NotifyRemoveView(long streamId) {
        if (!this.mReady.get() || null == this.mHandler) {
            return;
        }
        this.mHandler.sendMessage(this.mHandler.obtainMessage(6, streamId));
    }

    private void handleRemoveView(long streamId) {
        if (this.mPlayerStateMap.containsKey(streamId)) {
            PlayerState playerState = this.mPlayerStateMap.get(streamId);
            if (playerState == null) {
                return;
            }
            ViewState viewState = playerState.mViewState;
            if (viewState != null) {
                YMFLog.warn(this, "[StateMonitor]removeView, streamId:" + streamId + " View " + viewState.mName + " type : " + this.getViewTypeName(viewState.mType));
                playerState.mViewState = null;
            }
            if (playerState.mRenderState == null && playerState.mDecoderState == null) {
                this.removePlayerState(streamId);
            }
        }
    }

    private void streamStart(long streamId, long groupId, int micPos, int fps, int bHardDecoder, int vType) {
        if (!this.mReady.get() || null == this.mHandler) {
            return;
        }
        streamInfo info = new streamInfo();
        info.mStreamId = streamId;
        info.mGroupId = groupId;
        info.micPos = micPos;
        info.fps = fps;
        info.bHardDecoder = bHardDecoder;
        info.vType = vType;
        this.mHandler.sendMessage(this.mHandler.obtainMessage(7, info));
    }

    private void handleStreamStart(streamInfo info) {
        PlayerState playState = this.getPlayerState(info.mStreamId);
        if (null == playState) {
            return;
        }
        playState.mStreamID = info.mStreamId;
        playState.mGroupId = info.mGroupId;
        playState.mMicPos = info.micPos;
        playState.mFps = info.fps;
        if (info.vType == 2) {
            playState.mFormat = 2;
        } else if (info.vType == 5) {
            playState.mFormat = 5;
        }
        playState.mHardDecoder = info.bHardDecoder;
        YMFLog.warn(this, "[StateMonitor]handleStreamStart, streamId " + playState.mStreamID + " groupId " + playState.mGroupId + " micPos " + playState.mMicPos + " fps " + playState.mFps + " bHardDec " + playState.mHardDecoder + " vType:" + playState.mFormat + " [H.264(2) H.265(5)]");
    }

    private void streamEnd(long streamId) {
        if (!this.mReady.get() || null == this.mHandler) {
            return;
        }
        this.mHandler.sendMessage(this.mHandler.obtainMessage(8, streamId));
    }

    private void handleStreamEnd(long streamId) {
        YMFLog.warn(this, "[StateMonitor]handleStreamEnd, streamId " + streamId);
    }

    private void notifyLastFrameNotRenderStatistic(long streamId, int count) {
        LostFrameRender frameRender = new LostFrameRender(streamId, count);
        this.mHandler.sendMessage(this.mHandler.obtainMessage(19, frameRender));
    }

    private void handleLastFrameNotRenderStatistic(long streamId, int count) {
        YMFLog.warn(this, "[StateMonitor]LastFrameNotRenderStatistic:" + streamId + ",last Frame have not be Rendered, count : " + count);
    }

    private void notifyMultiVideoOriginPosition(VideoPosition[] params, VideoPosition background) {
        if (!this.mReady.get() || null == this.mHandler) {
            return;
        }
        MutiVideoPositionInfo info = new MutiVideoPositionInfo();
        info.videoPositions = params;
        info.backgroundPosition = background;
        this.mHandler.sendMessage(this.mHandler.obtainMessage(17, info));
    }

    private void handleMultiVideoOriginPosition(VideoPosition[] mDrawPosition, VideoPosition background) {
        if (mDrawPosition != null) {
            for (int i = 0; i < mDrawPosition.length; ++i) {
                YMFLog.info(this, "[StateMonitor]MultiVideo origin TotalVideoCnt:" + mDrawPosition.length + " :index = " + i + " ( " + mDrawPosition[i].mX + "," + mDrawPosition[i].mY + "," + mDrawPosition[i].mWidth + "," + mDrawPosition[i].mHeight + ")");
            }
        }
        if (background != null) {
            YMFLog.info(this, "[StateMonitor]MultiVideo origin background:( " + background.mX + "," + background.mY + "," + background.mWidth + "," + background.mHeight + ")");
        }
    }

    private void notifyMultiVideoSurfaceChangePosition(VideoPosition[] params, VideoPosition background) {
        if (!this.mReady.get() || null == this.mHandler) {
            return;
        }
        MutiVideoPositionInfo info = new MutiVideoPositionInfo();
        info.videoPositions = params;
        info.backgroundPosition = background;
        this.mHandler.sendMessage(this.mHandler.obtainMessage(18, info));
    }

    private void handleMultiVideoSurfaceChangePosition(VideoPosition[] mDrawPosition, VideoPosition background) {
        if (mDrawPosition != null) {
            for (int i = 0; i < mDrawPosition.length; ++i) {
                YMFLog.info(this, "[StateMonitor]MultiVideo Surface change TotalVideoCnt:" + mDrawPosition.length + ":index = " + i + " (" + mDrawPosition[i].mX + "," + mDrawPosition[i].mY + "," + mDrawPosition[i].mWidth + "," + mDrawPosition[i].mHeight + ")");
            }
        }
        if (background != null) {
            YMFLog.info(this, "[StateMonitor]MultiVideo surface change background:( " + background.mX + "," + background.mY + "," + background.mWidth + "," + background.mHeight + ")");
        }
    }

    private static class StateMonitorHandler
    extends Handler {
        private WeakReference<StateMonitor> mWeakWay;

        private StateMonitorHandler(StateMonitor stateMonitor) {
            this.mWeakWay = new WeakReference<StateMonitor>(stateMonitor);
        }

        public void handleMessage(Message msg) {
            int what = msg.what;
            if (0 == what) {
                Looper loop = Looper.myLooper();
                if (null != loop) {
                    loop.quit();
                    this.removeCallbacksAndMessages(null);
                }
                return;
            }
            StateMonitor stateMonitor = (StateMonitor)this.mWeakWay.get();
            if (stateMonitor == null) {
                YMFLog.warn((Object)this, "StateManager Handler.handleMessage: stateManager is null");
                return;
            }
            switch (what) {
                case 1: {
                    DecoderState state = (DecoderState)msg.obj;
                    if (null == state) break;
                    stateMonitor.handleAddDecoder(state.mStreamId, state.mType, state.mName, state.mCreateDecoderTime);
                    break;
                }
                case 2: {
                    stateMonitor.handleRemoveDecoder((Long)msg.obj);
                    break;
                }
                case 3: {
                    RenderState renderState = (RenderState)msg.obj;
                    if (null == renderState) break;
                    stateMonitor.handleAddRender(renderState.mStreamId, renderState.mType, renderState.mName);
                    break;
                }
                case 4: {
                    stateMonitor.handleRemoveRender((Long)msg.obj);
                    VideoPlayer.getInstance().deleteVideoPlayerInfo((Long)msg.obj);
                    break;
                }
                case 5: {
                    ViewState viewState = (ViewState)msg.obj;
                    if (null == viewState) break;
                    stateMonitor.handleAddView(viewState.mStreamId, viewState.mVideoIndex, viewState.mType, viewState.mName);
                    break;
                }
                case 6: {
                    stateMonitor.handleRemoveView((Long)msg.obj);
                    break;
                }
                case 7: {
                    stateMonitor.handleStreamStart((streamInfo)msg.obj);
                    break;
                }
                case 8: {
                    stateMonitor.handleStreamEnd((Long)msg.obj);
                    break;
                }
                case 9: {
                    frameRateInfo info = (frameRateInfo)msg.obj;
                    if (null == info) break;
                    stateMonitor.handleTransInputFrameRate(info.mStreamId, info.mFrameRate, -1);
                    break;
                }
                case 24: {
                    frameRateInfo infos = (frameRateInfo)msg.obj;
                    if (null == infos) break;
                    stateMonitor.handleTransInputFrameRate(infos.mStreamId, infos.mFrameRate, infos.mFrameRateDecoder);
                    break;
                }
                case 10: {
                    stateMonitor.handleNotifyFirstFrameArrive((StreamTimeInfo)msg.obj);
                    break;
                }
                case 11: {
                    frameRateInfo renderInfo = (frameRateInfo)msg.obj;
                    if (null == renderInfo) break;
                    stateMonitor.handleRenderFrameRate(renderInfo.mStreamId, renderInfo.mFrameRate);
                    break;
                }
                case 12: {
                    stateMonitor.handleNofityFirstFrameRendered((Long)msg.obj);
                    break;
                }
                case 13: {
                    frameRateInfo decinfo = (frameRateInfo)msg.obj;
                    if (null == decinfo) break;
                    stateMonitor.handleDecoderFrameRateO(decinfo.mStreamId, decinfo.mFrameRate);
                    break;
                }
                case 15: {
                    FramePtsInfo ptsInfo = (FramePtsInfo)msg.obj;
                    if (null == ptsInfo) break;
                    stateMonitor.handlePts(ptsInfo.mStreamId, ptsInfo.pts);
                    break;
                }
                case 16: {
                    long streamId = (Long)msg.obj;
                    if (streamId == 0L) break;
                    stateMonitor.handleClearPts(streamId);
                    break;
                }
                case 14: {
                    resolutionInfo resinfo = (resolutionInfo)msg.obj;
                    if (null == resinfo) break;
                    stateMonitor.handleResolution(resinfo.mStreamId, resinfo.mWidth, resinfo.mHeight);
                    break;
                }
                case 17: {
                    MutiVideoPositionInfo originParams = (MutiVideoPositionInfo)msg.obj;
                    if (null == originParams) break;
                    stateMonitor.handleMultiVideoOriginPosition(originParams.videoPositions, originParams.backgroundPosition);
                    break;
                }
                case 18: {
                    MutiVideoPositionInfo changeParams = (MutiVideoPositionInfo)msg.obj;
                    if (null == changeParams) break;
                    stateMonitor.handleMultiVideoSurfaceChangePosition(changeParams.videoPositions, changeParams.backgroundPosition);
                    break;
                }
                case 19: {
                    LostFrameRender lostFrameRender = (LostFrameRender)msg.obj;
                    stateMonitor.handleLastFrameNotRenderStatistic(lostFrameRender.mStreamID, lostFrameRender.mCount);
                    break;
                }
                case 20: {
                    break;
                }
                case 21: {
                    BlueRayInfo isblueray = (BlueRayInfo)msg.obj;
                    VideoPlayerDataStat.getInstance().setIsBlueRay(isblueray.mStreamId, isblueray.mIsBlueRay);
                    break;
                }
                case 22: {
                    BitRateInfo bitRateInfo = (BitRateInfo)msg.obj;
                    VideoPlayerDataStat.getInstance().setBitRate(bitRateInfo.mStreamId, bitRateInfo.mBitRate);
                    break;
                }
                case 23: {
                    DecodeDelayFrameInfo decodeDelayFrameInfo = (DecodeDelayFrameInfo)msg.obj;
                    VideoPlayerDataStat.getInstance().setDecodeDelayFrameCount(decodeDelayFrameInfo.mStreamId, decodeDelayFrameInfo.mCount);
                    break;
                }
            }
        }
    }

    private class LostFrameRender {
        private long mStreamID;
        private int mCount;

        private LostFrameRender(long streamID, int count) {
            this.mStreamID = streamID;
            this.mCount = count;
        }
    }

    private class StreamTimeInfo {
        private long mStreamId;
        private long mTimeStamp;

        public StreamTimeInfo(long streamId, long timeStamp) {
            this.mStreamId = streamId;
            this.mTimeStamp = timeStamp;
        }
    }

    private class PlayerState {
        private long mStreamID;
        private long mGroupId;
        private long mMicPos;
        private int mFps;
        private boolean mFristFrameArrived;
        private boolean mFirstFrameRendered;
        private long mFirstFrameArrivedTime;
        private long mFirstFrameRendedTime;
        private int mHardDecoder;
        private int mFormat;
        private DecoderState mDecoderState;
        private RenderState mRenderState;
        private ViewState mViewState;

        private PlayerState(long streamID) {
            this.mStreamID = streamID;
            this.mDecoderState = null;
            this.mRenderState = null;
            this.mViewState = null;
        }
    }

    private class ViewState {
        private String mName;
        private VideoConstant.ViewType mType;
        private long mStreamId;
        private int mVideoIndex;

        private ViewState() {
        }
    }

    private class RenderState {
        private String mName;
        private int mType;
        private long mStreamId;
        private List<Integer> mFrameRateList = new ArrayList<Integer>(20);
        private List<Integer> mMissFrameList;
        private long mTotalI;
        private long mTotalO;
        private long mException;

        private RenderState() {
        }
    }

    private class DecoderState {
        private String mName;
        private int mType;
        private long mStreamId;
        private long mCreateDecoderTime;
        private long mFirstDecodeOutTime;
        private List<Integer> mFrameIList = new ArrayList<Integer>(10);
        private List<Integer> mFrameOList = new ArrayList<Integer>(10);
        private long mTotalI;
        private long mTotalO;
        private long mWidth;
        private long mHeight;
        private long mProfile;
        private long mLevel;
        private long mException;

        private DecoderState() {
        }
    }

    private class RenderTimeInfo {
        long mStreamId;
        String mRenderTime;
        String mRenderMaxTime;

        private RenderTimeInfo() {
        }
    }

    private class DecodeDelayFrameInfo {
        long mStreamId;
        int mCount;

        private DecodeDelayFrameInfo() {
        }
    }

    private class BitRateInfo {
        long mStreamId;
        String mBitRate;

        private BitRateInfo() {
        }
    }

    private class BlueRayInfo {
        long mStreamId;
        int mIsBlueRay;

        private BlueRayInfo() {
        }
    }

    private class LostRenderInfo {
        long mStreamId;
        float mFrameRate;

        private LostRenderInfo() {
        }
    }

    private class resolutionInfo {
        long mStreamId;
        int mWidth;
        int mHeight;

        private resolutionInfo() {
        }
    }

    private class FramePtsInfo {
        long mStreamId;
        long pts;

        private FramePtsInfo() {
        }
    }

    private class frameRateInfo {
        long mStreamId;
        int mFrameRate;
        int mFrameRateDecoder;

        private frameRateInfo() {
        }
    }

    private class MutiVideoPositionInfo {
        VideoPosition[] videoPositions;
        VideoPosition backgroundPosition;

        private MutiVideoPositionInfo() {
        }
    }

    private class streamInfo {
        long mStreamId;
        long mGroupId;
        int micPos;
        int fps;
        int bHardDecoder;
        int vType;

        private streamInfo() {
        }
    }

    public static interface DecoderType {
        public static final int DEFAULT = -1;
        public static final int SOFT_DECODER_H264 = 0;
        public static final int HARD_DECODER_H264 = 1;
        public static final int SOFT_DECODER_H265 = 2;
        public static final int HARD_DECODER_H265 = 3;
    }
}

