/*
 * Decompiled with CFR 0.152.
 */
package com.yy.videoplayer.decoder;

import android.opengl.GLES20;
import com.yy.videoplayer.decoder.Coordinate;
import com.yy.videoplayer.decoder.VBO;
import com.yy.videoplayer.decoder.VideoConstant;
import com.yy.videoplayer.videoview.YSpVideoView;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.ShortBuffer;

public final class ScreenSoft {
    private int mTexIdY = -1;
    private int mTexIdU = -1;
    private int mTexIdV = -1;
    private Coordinate mCoordinate = null;
    private VBO mPosVBO = null;
    private VBO mDrawListVBO = null;
    private int mStride = 20;
    private int mTexOffset = 12;
    private TextureRecord mTexY = null;
    private TextureRecord mTexU = null;
    private TextureRecord mTexV = null;

    public ScreenSoft(float[] vertex, int positionVertexHandle, int textureVertexHandle) {
        this.mCoordinate = new Coordinate(vertex);
        short[] drawOrder = new short[]{0, 1, 2, 2, 3, 0};
        ByteBuffer dlb = ByteBuffer.allocateDirect(drawOrder.length * 2);
        dlb.order(ByteOrder.nativeOrder());
        ShortBuffer drawList = dlb.asShortBuffer();
        drawList.put(drawOrder);
        drawList.position(0);
        this.mPosVBO = new VBO(34962, this.mCoordinate.getBufferSize(), this.mCoordinate.mVertexBuffer, 35048);
        this.mDrawListVBO = new VBO(34963, drawOrder.length * 2, drawList, 35044);
        GLES20.glEnableVertexAttribArray((int)positionVertexHandle);
        GLES20.glEnableVertexAttribArray((int)textureVertexHandle);
        this.createTextures();
        this.mTexY = new TextureRecord(0, 0, 6409);
        this.mTexU = new TextureRecord(0, 0, 6409);
        this.mTexV = new TextureRecord(0, 0, 6409);
    }

    public void setSize(int width, int height, VideoConstant.ScaleMode scaleMode) {
        this.mCoordinate.setSize(width, height, scaleMode);
        if (this.mCoordinate.applySizeRatio()) {
            this.mPosVBO.subBuffer(34962, this.mCoordinate.getBufferSize(), this.mCoordinate.mVertexBuffer);
        }
    }

    public void setOrientation(YSpVideoView.OrientationType orientationType, int rotateAngle, boolean adjustImmediately) {
        this.mCoordinate.setOrientation(orientationType, rotateAngle, adjustImmediately);
    }

    public void updateRenderSizeIfNeed(int width, int height, int imageWidth, VideoConstant.ScaleMode scaleMode) {
        if (this.mCoordinate.applyRatioIfNeed(width, height, imageWidth, scaleMode)) {
            this.mPosVBO.subBuffer(34962, this.mCoordinate.getBufferSize(), this.mCoordinate.mVertexBuffer);
        }
    }

    public void updateRenderSizeIfNeedMultiVideo(int imageW, int imageH, int viewW, int viewH, VideoConstant.ScaleMode scaleMode) {
        if (this.mCoordinate.applyRatioIfNeedMultiVideo(imageW, imageH, viewW, viewH, scaleMode)) {
            this.mPosVBO.subBuffer(34962, this.mCoordinate.getBufferSize(), this.mCoordinate.mVertexBuffer);
        }
    }

    public void updateY(int width, int height, int format, int type, Buffer data) {
        GLES20.glActiveTexture((int)33984);
        this.mTexY.update(width, height, format, type, data);
    }

    public void updateU(int width, int height, int format, int type, Buffer data) {
        GLES20.glActiveTexture((int)33985);
        this.mTexU.update(width, height, format, type, data);
    }

    public void updateV(int width, int height, int format, int type, Buffer data) {
        GLES20.glActiveTexture((int)33986);
        this.mTexV.update(width, height, format, type, data);
    }

    public void refresh(int positionVertexHandle, int textureVertexHandle, int samplerY, int samplerU, int samplerV) {
        GLES20.glBindBuffer((int)34962, (int)this.mPosVBO.getId());
        GLES20.glVertexAttribPointer((int)positionVertexHandle, (int)3, (int)5126, (boolean)false, (int)this.mStride, (int)0);
        GLES20.glVertexAttribPointer((int)textureVertexHandle, (int)2, (int)5126, (boolean)false, (int)this.mStride, (int)this.mTexOffset);
        GLES20.glUniform1i((int)samplerY, (int)0);
        GLES20.glUniform1i((int)samplerU, (int)1);
        GLES20.glUniform1i((int)samplerV, (int)2);
        GLES20.glBindBuffer((int)34963, (int)this.mDrawListVBO.getId());
        GLES20.glDrawElements((int)4, (int)6, (int)5123, (int)0);
        GLES20.glBindBuffer((int)34962, (int)0);
    }

    public void destroy(int positionVertexHandle, int textureVertexHandle) {
        GLES20.glDisableVertexAttribArray((int)positionVertexHandle);
        GLES20.glDisableVertexAttribArray((int)textureVertexHandle);
        GLES20.glActiveTexture((int)33984);
        this.deleteTexture(this.mTexIdY);
        GLES20.glActiveTexture((int)33985);
        this.deleteTexture(this.mTexIdU);
        GLES20.glActiveTexture((int)33986);
        this.deleteTexture(this.mTexIdV);
        this.mPosVBO.delete();
        this.mDrawListVBO.delete();
        this.mTexIdV = -1;
        this.mTexIdU = -1;
        this.mTexIdY = -1;
    }

    private void createTextures() {
        int[] ids = new int[3];
        GLES20.glGenTextures((int)3, (int[])ids, (int)0);
        this.mTexIdY = ids[0];
        this.mTexIdU = ids[1];
        this.mTexIdV = ids[2];
        int[] GL_TEXTURES = new int[]{33984, 33985, 33986};
        for (int i = 0; i < 3; ++i) {
            GLES20.glActiveTexture((int)GL_TEXTURES[i]);
            GLES20.glBindTexture((int)3553, (int)ids[i]);
            GLES20.glTexParameteri((int)3553, (int)10241, (int)9728);
            GLES20.glTexParameteri((int)3553, (int)10240, (int)9729);
            GLES20.glTexParameteri((int)3553, (int)10242, (int)33071);
            GLES20.glTexParameteri((int)3553, (int)10243, (int)33071);
        }
    }

    private void deleteTexture(int id) {
        if (-1 != id) {
            int[] ids = new int[]{id};
            GLES20.glDeleteTextures((int)1, (int[])ids, (int)0);
        }
    }

    private class TextureRecord {
        public int mWidth;
        public int mHeight;
        public int mFormat;

        public TextureRecord(int width, int height, int format) {
            this.mWidth = width;
            this.mHeight = height;
            this.mFormat = format;
        }

        public void update(int width, int height, int format, int type, Buffer data) {
            if (width == this.mWidth && height == this.mHeight && format == this.mFormat) {
                GLES20.glTexSubImage2D((int)3553, (int)0, (int)0, (int)0, (int)width, (int)height, (int)format, (int)type, (Buffer)data);
                return;
            }
            GLES20.glTexImage2D((int)3553, (int)0, (int)format, (int)width, (int)height, (int)0, (int)format, (int)type, (Buffer)data);
            this.mWidth = width;
            this.mHeight = height;
            this.mFormat = format;
        }
    }
}

