/*
 * Decompiled with CFR 0.152.
 */
package com.yy.videoplayer.decoder;

import android.util.Log;
import com.yy.videoplayer.decoder.YYVideoLibMgr;
import com.yy.videoplayer.utils.TimeUtil;
import com.yy.videoplayer.utils.YMFLog;
import java.lang.ref.WeakReference;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;

public class PlayNotify {
    private boolean mIsRunNotifyThread = true;
    WeakReference<PlayListner> mWpl = null;
    int lastStatus = 1;
    long lastDraw = System.currentTimeMillis();
    BlockingQueue<ViewNotifyEvent> eveq = new LinkedBlockingQueue<ViewNotifyEvent>(10);
    Timer playTimer;
    NotifyTask nTaskRua;
    Thread notifyThread;
    long mUserGroupId;
    long mStreamId;

    public void Init() {
        try {
            this.playTimer = new Timer();
            this.playTimer.schedule((TimerTask)new PlayCheckingTask(), 10L, 1000L);
            this.nTaskRua = new NotifyTask();
            this.notifyThread = new Thread(null, this.nTaskRua, "PlayNotify", 262144L);
            this.notifyThread.start();
        }
        catch (Exception e) {
            YMFLog.error((Object)this, "[call] failed to init notifier");
        }
    }

    public void Release() {
        try {
            this.eveq.clear();
            this.playTimer.cancel();
            this.eveq.put(new ViewNotifyEvent(-1, System.currentTimeMillis() - this.lastDraw, TimeUtil.getTickCountLong()));
            this.mIsRunNotifyThread = false;
            this.notifyThread.interrupt();
        }
        catch (Exception e) {
            YMFLog.error((Object)this, e);
        }
    }

    public void DrawNotify() {
        if ((this.lastStatus == 2 || this.lastStatus == 1) && this.eveq.remainingCapacity() > 0) {
            this.lastStatus ^= 1;
            try {
                if (this.eveq.remainingCapacity() > 0) {
                    this.eveq.put(new ViewNotifyEvent(this.lastStatus, System.currentTimeMillis() - this.lastDraw, TimeUtil.getTickCountLong()));
                }
            }
            catch (Exception e) {
                YMFLog.error(this, "[call] Failed to put START ViewNotifyEvent %s", e);
            }
        }
        this.lastDraw = System.currentTimeMillis();
    }

    public void NoFrameNotify(int cnt) {
        try {
            this.eveq.put(new ViewNotifyEvent(-2, cnt));
        }
        catch (Exception e) {
            YMFLog.error(this, "[call] Failed to put NOFRAME ViewNotifyEvent %s", e);
        }
    }

    public void EndPlay(boolean notify) {
        this.lastStatus = 1;
        if (notify) {
            try {
                if (this.eveq.remainingCapacity() > 0) {
                    this.eveq.put(new ViewNotifyEvent(this.lastStatus, System.currentTimeMillis() - this.lastDraw, TimeUtil.getTickCountLong()));
                }
            }
            catch (Exception e) {
                YMFLog.error(this, "[call] Failed to put END ViewNotifyEvent %s", e);
            }
        }
    }

    public void setVideoIds(long userGroupId, long streamId) {
        this.mUserGroupId = userGroupId;
        this.mStreamId = streamId;
    }

    public long getUserGroupId() {
        return this.mUserGroupId;
    }

    public long getStreamId() {
        return this.mStreamId;
    }

    public void setPlayListner(PlayListner pl) {
        this.mWpl = new WeakReference<PlayListner>(pl);
    }

    static class ViewNotifyEvent {
        public static final int NOFRAME = -2;
        private static final int EXIT = -1;
        public static final int START = 0;
        public static final int END = 1;
        public static final int PAUSE = 2;
        public static final int RESUME = 3;
        int type;
        long interval;
        long happenTime;
        int noFrameCnt;

        ViewNotifyEvent(int type, long interval, long happenTime) {
            this.type = type;
            this.interval = interval;
            this.happenTime = happenTime;
        }

        ViewNotifyEvent(int type, int cnt) {
            this.type = type;
            this.noFrameCnt = cnt;
        }
    }

    public static interface PlayListner {
        public void OnPlayStart(long var1);

        public void OnPlayEnd();

        public void OnNoFrameCnt(int var1);

        public void OnPlayPause(long var1);

        public void OnPlayResume(long var1);
    }

    private class NotifyTask
    implements Runnable {
        private NotifyTask() {
        }

        @Override
        public void run() {
            while (PlayNotify.this.mIsRunNotifyThread) {
                try {
                    ViewNotifyEvent ev = PlayNotify.this.eveq.take();
                    YMFLog.info(this, "[videoPlay] videoview notify eventType %d", ev.type);
                    YYVideoLibMgr.instance().onViewPlayEventNotify(PlayNotify.this.mUserGroupId, PlayNotify.this.mStreamId, ev.type, ev.happenTime);
                    if (ev.type == -1) {
                        YMFLog.info(this, "[videoPlay] view notify exit");
                        return;
                    }
                    if (PlayNotify.this.mWpl == null) {
                        YMFLog.info(this, "[videoPlay] view notify no event listner");
                        continue;
                    }
                    PlayListner pl = (PlayListner)PlayNotify.this.mWpl.get();
                    if (pl == null) continue;
                    switch (ev.type) {
                        case 2: {
                            YMFLog.info(this, "[videoPlay] view notify PAUSE %d", ev.interval);
                            pl.OnPlayPause(ev.interval);
                            break;
                        }
                        case 3: {
                            YMFLog.info(this, "[videoPlay] view notify RESUME %d", ev.interval);
                            pl.OnPlayResume(ev.interval);
                            break;
                        }
                        case 0: {
                            YMFLog.info(this, "[videoPlay] view notify START");
                            pl.OnPlayStart(ev.happenTime);
                            break;
                        }
                        case 1: {
                            YMFLog.info(this, "[videoPlay] view notify END");
                            pl.OnPlayEnd();
                            break;
                        }
                        case -2: {
                            YMFLog.info(this, "[videoPlay] view notify NOFRAME");
                            pl.OnNoFrameCnt(ev.noFrameCnt);
                            break;
                        }
                    }
                }
                catch (Exception e1) {
                    Log.e((String)"YVideoView", (String)"[call] Failed to take ViewNotifyEvent", (Throwable)e1);
                }
            }
        }
    }

    private class PlayCheckingTask
    extends TimerTask {
        private PlayCheckingTask() {
        }

        @Override
        public void run() {
            if (System.currentTimeMillis() - PlayNotify.this.lastDraw > 2000L && (PlayNotify.this.lastStatus == 3 || PlayNotify.this.lastStatus == 0)) {
                PlayNotify.this.lastStatus = 2;
                try {
                    if (PlayNotify.this.eveq.remainingCapacity() > 0) {
                        PlayNotify.this.eveq.put(new ViewNotifyEvent(PlayNotify.this.lastStatus, System.currentTimeMillis() - PlayNotify.this.lastDraw, TimeUtil.getTickCountLong()));
                    }
                }
                catch (Exception e) {
                    YMFLog.error(this, "[call] [videoPlay] Failed to put START ViewNotifyEvent %s", e);
                }
            }
        }
    }
}

