/*
 * Decompiled with CFR 0.152.
 */
package com.yy.videoplayer.decoder;

import android.annotation.TargetApi;
import android.media.MediaCodecInfo;
import android.media.MediaCodecList;
import com.yy.videoplayer.utils.YMFLog;
import java.util.Arrays;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;

public class OMXDecoderRank {
    private static final String TAG = "OMXDecoderRank";
    public static final String CODEC_H264_MIME = "video/avc";
    private static OMXDecoderRank mInstance;
    private static final int RANK_TESTED = 500;
    public static final int RANK_UNKNOWN = 400;
    private static final int RANK_SECURE = 300;
    private static final int RANK_SOFTWARE = 200;
    private static final int RANK_NOT_STANDARD = 100;
    private static final int RANK_NO_SENSE = 0;
    private Map<String, Integer> mKnownCodecList;
    private DecoderInfo mBestDecoder;
    private boolean mBestDecoderInitialized = false;

    public static synchronized OMXDecoderRank instance() {
        if (mInstance == null) {
            mInstance = new OMXDecoderRank();
        }
        return mInstance;
    }

    private OMXDecoderRank() {
        this.init();
    }

    private void init() {
        this.mKnownCodecList = new TreeMap<String, Integer>(String.CASE_INSENSITIVE_ORDER);
        this.mKnownCodecList.put("OMX.qcom.video.decoder.avc", 500);
        this.mKnownCodecList.put("OMX.ittiam.video.decoder.avc", 0);
        this.mKnownCodecList.put("OMX.MTK.VIDEO.DECODER.AVC", 500);
        this.mKnownCodecList.put("OMX.IMG.MSVDX.Decoder.AVC", 500);
        this.mKnownCodecList.put("OMX.k3.video.decoder.avc", 500);
        this.mKnownCodecList.put("OMX.Nvidia.h264.decode", 500);
        this.mKnownCodecList.put("OMX.Nvidia.h264.decode.secure", 300);
        this.mKnownCodecList.put("OMX.Exynos.avc.dec", 500);
        this.mKnownCodecList.put("OMX.Exynos.AVC.Decoder", 499);
        this.mKnownCodecList.put("OMX.MARVELL.VIDEO.HW.CODA7542DECODER", 500);
        this.mKnownCodecList.put("OMX.MARVELL.VIDEO.HW.HANTRODECODER", 500);
        this.mKnownCodecList.put("OMX.SEC.avc.dec", 500);
        this.mKnownCodecList.put("OMX.SEC.AVC.Decoder", 499);
        this.mKnownCodecList.put("OMX.SEC.avcdec", 498);
        this.mKnownCodecList.put("OMX.SEC.avc.sw.dec", 200);
        this.mKnownCodecList.put("OMX.Intel.VideoDecoder.AVC", 500);
        this.mKnownCodecList.put("OMX.Intel.hw_vd.h264", 501);
        this.mKnownCodecList.put("OMX.rk.video_decoder.avc", 500);
        this.mKnownCodecList.put("OMX.TI.DUCATI1.VIDEO.DECODER", 500);
        this.mKnownCodecList.put("OMX.amlogic.avc.decoder.awesome", 500);
        this.mKnownCodecList.put("OMX.ffmpeg.h264.decoder", 200);
        this.mKnownCodecList.put("OMX.bluestacks.hw.decoder", 0);
        this.mKnownCodecList.remove("OMX.hantro.81x0.video.decoder");
        this.mKnownCodecList.remove("OMX.sprd.h264.decoder");
        this.mKnownCodecList.remove("OMX.BRCM.vc4.decoder.avc");
        this.mKnownCodecList.remove("OMX.allwinner.video.decoder.avc");
        this.mKnownCodecList.remove("OMX.brcm.video.h264.hw.decoder");
        this.mKnownCodecList.remove("OMX.ST.VFM.H264Dec");
        this.mKnownCodecList.remove("OMX.Action.Video.Decoder");
        this.mKnownCodecList.remove("OMX.MS.AVC.Decoder");
        this.mKnownCodecList.remove("OMX.hisi.video.decoder");
        this.mKnownCodecList.remove("OMX.Infotm.Video.Decoder");
        this.mKnownCodecList.remove("OMX.NU.Video.Decoder");
        this.mKnownCodecList.remove("OMX.brcm.video.h264.decoder");
        this.mKnownCodecList.remove("OMX.hisi.video.decoder.avc");
        this.mKnownCodecList.put("OMX.google.h264.decoder", 200);
        this.mKnownCodecList.put("OMX.google.h264.lc.decoder", 200);
        this.mKnownCodecList.put("OMX.k3.ffmpeg.decoder", 200);
        this.mKnownCodecList.put("OMX.ffmpeg.video.decoder", 200);
        this.mKnownCodecList.put("OMX.sprd.soft.h264.decoder", 200);
        YMFLog.info(TAG, "[Decoder]OMXDecoderRank knownCodecList " + Arrays.toString(this.mKnownCodecList.keySet().toArray()));
    }

    public DecoderInfo getRank(String codecName) {
        Integer knownRank;
        if (codecName == null || "".equals(codecName)) {
            return new DecoderInfo(codecName, 0);
        }
        String name = codecName.toLowerCase(Locale.US);
        int rank = !name.startsWith("omx.") ? 100 : (name.startsWith("omx.pv") ? 200 : (name.startsWith("omx.google.") ? 200 : (name.startsWith("omx.ffmpeg.") ? 200 : (name.startsWith("omx.k3.ffmpeg.") ? 200 : (name.startsWith("omx.avcodec.") ? 200 : (name.startsWith("omx.ittiam.") ? 0 : ((knownRank = this.mKnownCodecList.get(name)) != null ? knownRank : 400)))))));
        return new DecoderInfo(codecName, rank);
    }

    @TargetApi(value=16)
    public DecoderInfo getBestDecoder() {
        if (this.mBestDecoderInitialized) {
            return this.mBestDecoder;
        }
        try {
            DecoderInfo decoderInfo = null;
            int currentRank = 400;
            YMFLog.debug((Object)TAG, "[Decoder]OMXDecoderRank Codec supported count " + MediaCodecList.getCodecCount());
            for (int i = MediaCodecList.getCodecCount() - 1; i >= 0; --i) {
                MediaCodecInfo info = MediaCodecList.getCodecInfoAt((int)i);
                if (info.isEncoder() || !this.isSupportMime(info, CODEC_H264_MIME)) continue;
                DecoderInfo decoderRankInfo = OMXDecoderRank.instance().getRank(info.getName());
                int rank = decoderRankInfo.rank();
                YMFLog.debug(TAG, "[Decoder]OMXDecoderRank codec: %s, rank: %d", info.getName(), rank);
                if (rank < 400 || rank < currentRank) continue;
                currentRank = rank;
                decoderInfo = decoderRankInfo;
                YMFLog.info(TAG, "[Decoder]OMXDecoderRank codec match: %s, rank: %d", info.getName(), rank);
            }
            this.mBestDecoder = decoderInfo;
            this.mBestDecoderInitialized = true;
            return decoderInfo;
        }
        catch (Throwable e) {
            YMFLog.error((Object)TAG, "[Decoder]OMXDecoderRank getBestDecoder throwable" + e.getMessage());
            return null;
        }
    }

    @TargetApi(value=16)
    private boolean isSupportMime(MediaCodecInfo info, String mime) {
        String[] types = info.getSupportedTypes();
        for (int j = 0; j < types.length; ++j) {
            if (!mime.equalsIgnoreCase(types[j])) continue;
            return true;
        }
        return false;
    }

    public static class DecoderInfo {
        private String mName;
        private int mRank;

        public DecoderInfo(String name, int rank) {
            this.mName = name;
            this.mRank = rank;
        }

        public int rank() {
            return this.mRank;
        }

        public String name() {
            return this.mName;
        }
    }
}

