/*
 * Decompiled with CFR 0.152.
 */
package com.yy.videoplayer.decoder;

import android.opengl.GLES20;
import com.yy.videoplayer.decoder.ScreenSoft;
import com.yy.videoplayer.decoder.VideoConstant;
import com.yy.videoplayer.render.YYRenderFrameBuffer;
import com.yy.videoplayer.videoview.YSpVideoView;
import java.nio.ByteBuffer;

public class Monitor {
    private ScreenSoft mScreen;

    public Monitor(int positionVertexHandle, int textureVertexHandle, float top, float bottom, float z) {
        float[] vertex = new float[]{-1.0f, top, z, 0.0f, 1.0f, -1.0f, bottom, z, 0.0f, 0.0f, 1.0f, bottom, z, 1.0f, 0.0f, 1.0f, top, z, 1.0f, 1.0f};
        this.mScreen = new ScreenSoft(vertex, positionVertexHandle, textureVertexHandle);
    }

    public void setSize(int width, int height, VideoConstant.ScaleMode scaleMode) {
        this.mScreen.setSize(width, height, scaleMode);
    }

    public void setOrientation(YSpVideoView.OrientationType orientationType, int rotateAngle, boolean adjustImmediately) {
        this.mScreen.setOrientation(orientationType, rotateAngle, adjustImmediately);
    }

    public void setRenderFormat(int formatHandle, int format) {
        GLES20.glUniform1i((int)formatHandle, (int)format);
    }

    public void updateRenderSizeIfNeed(int width, int height, int imageWidth, VideoConstant.ScaleMode scaleMode) {
        this.mScreen.updateRenderSizeIfNeed(width, height, imageWidth, scaleMode);
    }

    public void updateRenderSizeIfNeedMultiVideo(int imageW, int imageH, int viewW, int viewH, VideoConstant.ScaleMode scaleMode) {
        this.mScreen.updateRenderSizeIfNeedMultiVideo(imageW, imageH, viewW, viewH, scaleMode);
    }

    public void updateAsRGB(int width, int height, int type, ByteBuffer data) {
        this.mScreen.updateY(width, height, 6407, type, data);
    }

    public void updateAsYUV(YYRenderFrameBuffer buffer) {
        int format = 1 == buffer.getFrameFormat() ? 6410 : 6409;
        ByteBuffer frame = buffer.getFrame();
        if (null == frame) {
            return;
        }
        this.mScreen.updateY(buffer.getWidthY(), buffer.getHeightY(), 6409, 5121, frame.position(buffer.getOffsetY()));
        this.mScreen.updateU(buffer.getWidthUV(), buffer.getHeightUV(), format, 5121, frame.position(buffer.getOffsetU()));
        this.mScreen.updateV(buffer.getWidthUV(), buffer.getHeightUV(), format, 5121, frame.position(buffer.getOffsetV()));
    }

    public void refresh(int positionVertexHandle, int textureVertexHandle, int samplerY, int samplerU, int samplerV) {
        this.mScreen.refresh(positionVertexHandle, textureVertexHandle, samplerY, samplerU, samplerV);
    }

    public void destroy(int positionVertexHandle, int textureVertexHandle) {
        this.mScreen.destroy(positionVertexHandle, textureVertexHandle);
    }
}

