/*
 * Decompiled with CFR 0.152.
 */
package com.yy.videoplayer.decoder;

import android.graphics.Bitmap;
import android.view.Surface;
import android.view.View;
import com.yy.videoplayer.decoder.H264DecRender;
import com.yy.videoplayer.decoder.H265DecRender;
import com.yy.videoplayer.decoder.HardDecRender;
import com.yy.videoplayer.decoder.HardDecodeWay;
import com.yy.videoplayer.decoder.PlayNotify;
import com.yy.videoplayer.decoder.StateMonitor;
import com.yy.videoplayer.decoder.VP8DecRender;
import com.yy.videoplayer.decoder.VideoConstant;
import com.yy.videoplayer.decoder.VideoDecoderCenterExt;
import com.yy.videoplayer.decoder.ViewLiveStatManager;
import com.yy.videoplayer.decoder.YYVideoLibMgr;
import com.yy.videoplayer.utils.ByteVector;
import com.yy.videoplayer.utils.ImageUtil;
import com.yy.videoplayer.utils.YMFLog;
import com.yy.videoplayer.videoview.IVideoInfoCallback;
import com.yy.videoplayer.videoview.YSpVideoView;
import com.yy.videoplayer.videoview.YspVideoViewInfo;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicBoolean;

public class HardDecodeWayBuffer
implements Runnable,
HardDecodeWay,
HardDecRender.IDecoderDataOutCallBack,
HardDecRender.OnDecoderYUVListener {
    private boolean mIsDecoderNeedReconfig = false;
    private AtomicBoolean mReady = new AtomicBoolean(false);
    private HardDecRender mOuterDecoder = null;
    private long mUserGroupId = 0L;
    private long mStreamId = 0L;
    private boolean mFirstFrameOut = false;
    private int mFrames = 0;
    private long mVideoDataCnt = 0L;
    private boolean mRecIFrame = false;
    private static final int VIDEO_DATA_LOG = 500;
    public ByteVector mBytesVector = null;
    public ByteVector mTmpBytesVector = null;

    @Override
    public void Start() {
    }

    @Override
    public void OnSurfaceCreated() {
    }

    @Override
    public void OnSurfaceChanged(View videoView, Surface surface, int surfaceWidth, int surfaceHeight, int parentWidth, int parentHeight, int rotateAngle, YSpVideoView.OrientationType orientationType, VideoConstant.ScaleMode scaleMode) {
    }

    @Override
    public void OnSurfaceDestroyed(Surface surface) {
    }

    @Override
    public void OnSurfaceRedraw() {
    }

    @Override
    public boolean IsDecoderNeedReconfig() {
        return this.mIsDecoderNeedReconfig;
    }

    @Override
    public void SetPlayNotify(PlayNotify playNotify) {
    }

    @Override
    public void SetVideoIds(long userGroupId, long streamId) {
        YMFLog.info(this, "[Decoder]HardDecodeWayGpu SetVideoIds userGroupId: " + userGroupId + ", streamId: " + streamId);
        this.mUserGroupId = userGroupId;
        this.mStreamId = streamId;
    }

    @Override
    public void OnStreamEnd() {
    }

    @Override
    public Bitmap GetScreenShot() {
        return null;
    }

    @Override
    public void OnDecoderYUVListener(int width, int height, ByteBuffer data, int bufferLen, long pts, int frameFlag, int colorFormat) {
        if (this.mBytesVector == null) {
            this.mBytesVector = new ByteVector(bufferLen);
        }
        this.mBytesVector.reserve(bufferLen);
        if (colorFormat == 21) {
            if (this.mTmpBytesVector == null) {
                this.mTmpBytesVector = new ByteVector(bufferLen);
            }
            this.mTmpBytesVector.reserve(bufferLen);
            data.rewind();
            data.get(this.mTmpBytesVector.getBytes(), 0, bufferLen);
            ImageUtil.NV12ToYUV420(this.mTmpBytesVector.getBytes(), this.mBytesVector.getBytes(), width, height);
        } else {
            data.rewind();
            data.get(this.mBytesVector.getBytes(), 0, bufferLen);
        }
        YYVideoLibMgr.instance().onDecodedFrameData(this.mStreamId >> 32, width, height, this.mBytesVector.getBytes(), bufferLen, pts);
    }

    private String bin2hex(byte[] data) {
        String hex = null;
        int len = data == null ? 0 : data.length;
        for (int i = 0; i < len; ++i) {
            hex = hex != null ? hex + String.format("%02x ", data[i]) : String.format("%02x ", data[i]);
        }
        return hex;
    }

    @Override
    public void OnVideoConfig(byte[] header, int width, int height, String mime) {
        YMFLog.info(this, "[Decoder]HardDecodeWayGpu OnVideoConfig width " + width + " height " + height + " mime " + mime + ", streamId:" + this.mStreamId + ", data:" + this.bin2hex(header));
        if (this.mOuterDecoder == null) {
            if ("video/hevc".equals(mime)) {
                this.mOuterDecoder = new H265DecRender(null, width, height, this.mUserGroupId, this.mStreamId);
                StateMonitor.NotifyCreateRender(this.mStreamId, 1);
            } else if ("video/avc".equals(mime)) {
                this.mOuterDecoder = new H264DecRender(null, width, height, this.mUserGroupId, this.mStreamId);
                StateMonitor.NotifyCreateRender(this.mStreamId, 0);
            } else if ("video/x-vnd.on2.vp8".equals(mime)) {
                this.mOuterDecoder = new VP8DecRender(null, width, height);
            }
            this.mOuterDecoder.setStreamId(this.mStreamId);
            this.mOuterDecoder.setOnDecoderYUVListener(this);
        } else {
            this.mOuterDecoder.reset(null, width, height);
        }
        this.mOuterDecoder.PushFrame(null, header, 0L, true);
        this.mOuterDecoder.ConfigDone();
        if (this.mOuterDecoder.GetAndClearExceptionFlag()) {
            this.mIsDecoderNeedReconfig = true;
            this.mOuterDecoder.EndofStream();
        }
        this.mFirstFrameOut = false;
        ViewLiveStatManager.getInstace().notifyEventTime(1, 0, new ViewLiveStatManager.StatVideoHeaderInfo(width, height));
    }

    @Override
    public void OnVideoDataArrived(byte[] data, long pts) {
        if (this.mVideoDataCnt++ % 500L == 0L || (!this.mFirstFrameOut || !this.mRecIFrame) && this.mFrames <= 50) {
            YMFLog.info(this, "[Decoder]HardDecodeWayGpu OnVideoDataArrived streamId:" + this.mStreamId + ", pts = " + pts);
        }
        if (this.mOuterDecoder != null) {
            if (!(this.mFirstFrameOut && this.mRecIFrame || this.mFrames > 50)) {
                int type = 0;
                if (!(this.mOuterDecoder instanceof VP8DecRender)) {
                    type = data == null ? 255 : (data[0] == 0 && data[1] == 0 && data[2] == 1 ? data[3] & 0x1F : (data[0] == 0 && data[1] == 0 && data[2] == 0 && data[3] == 1 ? data[4] & 0x1F : -1));
                }
                if (type == 5) {
                    this.mRecIFrame = true;
                }
                YMFLog.info(this, "[Decoder][fastVideo]HardDecodeWayGpu handleOuterVideoData streamId:" + this.mStreamId + ", frames:" + this.mFrames + ", type:" + type + ", len:" + (data == null ? 0 : data.length) + ", pts:" + pts);
            }
            if (this.mOuterDecoder.PushFrame(null, data, pts, false) <= 0L) {
                if (this.mOuterDecoder.GetAndClearExceptionFlag()) {
                    YMFLog.warn(this, "[Decoder]HardDecodeWayGpu handleOuterVideoData decoder exception! Need to recconfig!");
                    this.mIsDecoderNeedReconfig = true;
                    this.mOuterDecoder.EndofStream();
                }
            } else {
                if (!this.mFirstFrameOut) {
                    StateMonitor.instance().NotifyDecodeDelayFrameCountInfo(this.mStreamId, this.mFrames);
                    YMFLog.info(this, "[Decoder][fastVideo]HardDecodeWayGpu handleOuterVideoData first frame out, frames = " + this.mFrames);
                }
                this.mFirstFrameOut = true;
            }
        }
    }

    @Override
    public void Quit() {
        if (this.mOuterDecoder != null) {
            StateMonitor.NotifyReleaseRender(this.mStreamId);
            this.mOuterDecoder.release();
            this.mOuterDecoder.EndofStream();
            this.mOuterDecoder = null;
        }
    }

    @Override
    public void setVrStream(boolean vrStream) {
    }

    @Override
    public VideoDecoderCenterExt.HardDecoderStaffVersion getHardDecodeType() {
        return VideoDecoderCenterExt.HardDecoderStaffVersion.YUVBUFFER;
    }

    @Override
    public long getUserGroupId() {
        return 0L;
    }

    @Override
    public void setVideoInfoCallback(IVideoInfoCallback callback) {
    }

    @Override
    public YspVideoViewInfo getVideoViewInfo(long streamid) {
        return null;
    }

    @Override
    public void onFirstDecodedDataOut() {
    }

    @Override
    public void run() {
    }
}

