/*
 * Decompiled with CFR 0.152.
 */
package com.yy.videoplayer.decoder;

import android.media.MediaCodec;
import android.media.MediaCodecInfo;
import android.media.MediaCodecList;
import android.media.MediaFormat;
import android.os.Build;
import android.os.SystemClock;
import android.view.Surface;
import com.yy.videoplayer.VideoPlayer;
import com.yy.videoplayer.decoder.HardDecodeMonitorThread;
import com.yy.videoplayer.decoder.YYVideoLibMgr;
import com.yy.videoplayer.stat.PlayerExceptionDataStat;
import com.yy.videoplayer.utils.YMFLog;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public abstract class HardDecRender {
    private static final String TAG = "HardDecRender";
    protected MediaCodec mDecoder = null;
    protected Surface mSurface;
    protected MediaFormat mFormat;
    protected boolean mNeedConfig = true;
    protected int mWidth = 720;
    protected int mHeight = 1280;
    protected boolean mInitialized = false;
    protected ByteBuffer[] mInputBuffers;
    protected ByteBuffer[] mOutputBuffers;
    protected MediaCodec.BufferInfo mInfo;
    protected AtomicBoolean mSecondTsWriten;
    protected String mCrashTsFirst;
    protected String mCrashTsSecond;
    protected int mNoFrameCnt = 0;
    protected boolean mIsExceptionOccured = false;
    protected long mStreamId = 0L;
    protected long mGroupId = 0L;
    protected AtomicBoolean mMediaCodecStopState = new AtomicBoolean(false);
    protected byte[] mDumpSpsPps = null;
    protected byte[] mDumpIDRFrame = null;
    protected String mDumpFrameName = null;
    private long mLastInputPts = -1L;
    private long mLastOutputPts = -1L;
    private long mOutFrameNum = -1L;
    protected int mInputIndex = 0;
    private long mNoFrameCount = 0L;
    private int mColorFormat = 0;
    private HashMap<String, Object> mDecoderInfoMap = new HashMap();
    private static final int MEDIA_CODEC_RELEASE_TIMEOUT_MS = 4000;
    private OnDecoderYUVListener mOnDecoderYUVListener;
    final Object mForceFlushLock = new Object();
    private boolean mFirstDecodedDataOut = false;
    private IDecoderDataOutCallBack decoderDataOutCallBack = null;
    private boolean mEndOfStream = false;

    protected HardDecRender() {
    }

    public boolean IsNeedConfig() {
        return this.mNeedConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ConfigDone() {
        HardDecRender hardDecRender = this;
        synchronized (hardDecRender) {
            this.mNeedConfig = false;
        }
    }

    public AtomicBoolean getMediaCodecStopState() {
        return this.mMediaCodecStopState;
    }

    public void EndofStream() {
        this.mNoFrameCnt = 0;
        HardDecodeMonitorThread.instance().unRegisterMediaCodecMonitorClient(this.mStreamId);
    }

    public boolean GetAndClearExceptionFlag() {
        boolean occured = this.mIsExceptionOccured;
        this.mIsExceptionOccured = false;
        return occured;
    }

    protected static boolean IsAvailable(String codecName) {
        if (Build.VERSION.SDK_INT < 17) {
            return false;
        }
        return null != codecName;
    }

    protected void dumpIDRFrame(String codecType, byte[] bf, long outPts) {
        this.mDumpIDRFrame = new byte[bf.length];
        System.arraycopy(bf, 0, this.mDumpIDRFrame, 0, bf.length);
        this.mDumpFrameName = (codecType.equalsIgnoreCase("video/avc") ? "H264" : "H265") + "_" + outPts;
        YMFLog.error((Object)TAG, "IDRFrame direct decoded!");
        HardDecodeMonitorThread.instance().dumpDecodeIDRFrameData(this.mStreamId, this.mDumpFrameName, this.mDumpSpsPps, this.mDumpIDRFrame);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long PushFrameWithoutSurface(String codecName, String codecType, byte[] bf, long pts, boolean isHeader) {
        HardDecRender hardDecRender = this;
        synchronized (hardDecRender) {
            int inIndex;
            long outPts;
            block22: {
                if (this.mNeedConfig && !isHeader) {
                    this.mIsExceptionOccured = true;
                    return 0L;
                }
                if (bf == null) {
                    YMFLog.error((Object)this, "[Decoder]HardDecRender  bf is null!!!");
                    return 0L;
                }
                if (!this.mInitialized) {
                    this.reset(this.mSurface, codecName, codecType, this.mWidth, this.mHeight);
                    this.mIsExceptionOccured = true;
                }
                outPts = 0L;
                inIndex = -1;
                int outIndex = 0;
                this.mLastInputPts = pts;
                if (isHeader) {
                    this.mDumpSpsPps = new byte[bf.length];
                    System.arraycopy(bf, 0, this.mDumpSpsPps, 0, bf.length);
                }
                try {
                    ByteBuffer buffer;
                    inIndex = this.mDecoder.dequeueInputBuffer(200000L);
                    if (inIndex >= 0) {
                        buffer = this.mInputBuffers[inIndex];
                        buffer.clear();
                        buffer.put(bf);
                        if (isHeader) {
                            YMFLog.info(this, "[Decoder]HardDecRender PushFrame config video");
                            this.mDecoder.queueInputBuffer(inIndex, 0, bf.length, pts * 1000L, 2);
                            this.mInputIndex = 0;
                        } else {
                            this.mDecoder.queueInputBuffer(inIndex, 0, bf.length, pts * 1000L, 0);
                            ++this.mInputIndex;
                        }
                    }
                    while (true) {
                        if ((outIndex = this.mDecoder.dequeueOutputBuffer(this.mInfo, 0L)) >= 0) {
                            outPts = this.mInfo.presentationTimeUs / 1000L;
                            this.mNoFrameCnt = 0;
                            this.mLastOutputPts = outPts;
                            ++this.mOutFrameNum;
                            if (this.mInputIndex == 1) {
                                this.dumpIDRFrame(codecType, bf, outPts);
                            }
                            buffer = null;
                            buffer = this.mOutputBuffers[outIndex];
                            this.mOnDecoderYUVListener.OnDecoderYUVListener(this.mWidth, this.mHeight, buffer, this.mInfo.size, outPts, this.mInfo.flags, this.mColorFormat);
                            this.mDecoder.releaseOutputBuffer(outIndex, false);
                            break block22;
                        }
                        if (outIndex == -3) {
                            this.mOutputBuffers = this.mDecoder.getOutputBuffers();
                            YMFLog.info(this, "[Decoder]HardDecRender PushFrame INFO_OUTPUT_BUFFERS_CHANGED");
                            continue;
                        }
                        if (outIndex != -2) break;
                        this.mFormat = this.mDecoder.getOutputFormat();
                        this.mWidth = this.mFormat.getInteger("width");
                        this.mHeight = this.mFormat.getInteger("height");
                        long resolution = VideoPlayer.getInstance().getPlayerInfo(this.mStreamId, VideoPlayer.VideoPlayerInfoEnum.RESOLUTION);
                        PlayerExceptionDataStat.getInstance().setDecoderResolution(resolution);
                        YMFLog.info(this, "[Decoder]HardDecRender PushFrame INFO_OUTPUT_FORMAT_CHANGED format " + this.mDecoder.getOutputFormat() + " width " + this.mWidth + " height " + this.mHeight);
                    }
                    if (outIndex == -1) {
                        ++this.mNoFrameCnt;
                        if (this.mNoFrameCnt % 100 == 0) {
                            YMFLog.error((Object)this, "[Decoder]HardDecRender PushFrame noFrameCnt " + this.mNoFrameCnt);
                            PlayerExceptionDataStat.getInstance().pushPlayerExceptionDataStat(this.mStreamId, "1", "4", "HardDecRender PushFrame noFrameCnt " + this.mNoFrameCnt);
                            YYVideoLibMgr.instance().onHardwareDecodeErrorNotify(this.mGroupId, this.mStreamId, 1);
                        }
                        YMFLog.info(this, "[Decoder]HardDecRender PushFrame INFO_TRY_AGAIN_LATER, no frame count:" + this.mNoFrameCnt);
                    } else {
                        YMFLog.info(this, "[Decoder]HardDecRender.....");
                    }
                }
                catch (Exception e) {
                    ++this.mNoFrameCnt;
                    this.mIsExceptionOccured = true;
                    PlayerExceptionDataStat.getInstance().pushPlayerExceptionDataStat(this.mStreamId, "1", "1", e.toString());
                    YMFLog.error((Object)this, "[Decoder]HardDecRender PushFrame exception " + YMFLog.stackTraceOf(e));
                    YYVideoLibMgr.instance().onHardwareDecodeErrorNotify(this.mGroupId, this.mStreamId, 4);
                }
            }
            if (inIndex < 0) {
                YMFLog.warn(this, "[Decoder]HardDecRender PushFrame will skip current frame pts:" + pts + " size:" + bf.length);
                ++this.mNoFrameCount;
                if (this.mNoFrameCount % 50L == 0L) {
                    PlayerExceptionDataStat.getInstance().pushPlayerExceptionDataStat(this.mStreamId, "1", "5", "dequeue buffer error");
                }
                if (this.mNoFrameCount % 99L == 0L) {
                    this.mNoFrameCount = 0L;
                    YYVideoLibMgr.instance().onHardwareDecodeErrorNotify(this.mGroupId, this.mStreamId, 2);
                }
            }
            return outPts;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long PushFrame(Surface surface, String codecName, String codecType, byte[] bf, long pts, boolean isHeader) {
        if (surface == null) {
            return this.PushFrameWithoutSurface(codecName, codecType, bf, pts, isHeader);
        }
        HardDecRender hardDecRender = this;
        synchronized (hardDecRender) {
            int inIndex;
            long outPts;
            block24: {
                if (this.mNeedConfig && !isHeader) {
                    this.mIsExceptionOccured = true;
                    return 0L;
                }
                if (bf == null) {
                    YMFLog.error((Object)this, "[Decoder]HardDecRender  bf is null!!!");
                    return 0L;
                }
                this.mSurface = surface;
                if (!this.mInitialized) {
                    this.reset(this.mSurface, codecName, codecType, this.mWidth, this.mHeight);
                    this.mIsExceptionOccured = true;
                }
                outPts = 0L;
                inIndex = -1;
                int outIndex = 0;
                this.mLastInputPts = pts;
                if (isHeader) {
                    this.mDumpSpsPps = new byte[bf.length];
                    System.arraycopy(bf, 0, this.mDumpSpsPps, 0, bf.length);
                }
                try {
                    inIndex = this.mDecoder.dequeueInputBuffer(200000L);
                    if (inIndex >= 0) {
                        ByteBuffer buffer = this.mInputBuffers[inIndex];
                        buffer.clear();
                        buffer.put(bf);
                        if (isHeader) {
                            YMFLog.info(this, "[Decoder]HardDecRender PushFrame config video");
                            this.mDecoder.queueInputBuffer(inIndex, 0, bf.length, pts * 1000L, 2);
                            this.mInputIndex = 0;
                        } else {
                            this.mDecoder.queueInputBuffer(inIndex, 0, bf.length, pts * 1000L, 0);
                            ++this.mInputIndex;
                        }
                    }
                    while (true) {
                        if ((outIndex = this.mDecoder.dequeueOutputBuffer(this.mInfo, 0L)) >= 0) {
                            if (!this.mFirstDecodedDataOut && this.decoderDataOutCallBack != null) {
                                this.mFirstDecodedDataOut = true;
                                this.decoderDataOutCallBack.onFirstDecodedDataOut();
                            }
                            this.mDecoder.releaseOutputBuffer(outIndex, true);
                            outPts = this.mInfo.presentationTimeUs / 1000L;
                            this.mNoFrameCnt = 0;
                            this.mLastOutputPts = outPts;
                            ++this.mOutFrameNum;
                            if (this.mInputIndex == 1) {
                                this.dumpIDRFrame(codecType, bf, outPts);
                            }
                            break block24;
                        }
                        if (outIndex == -3) {
                            YMFLog.info(this, "[Decoder]HardDecRender PushFrame INFO_OUTPUT_BUFFERS_CHANGED");
                            continue;
                        }
                        if (outIndex != -2) break;
                        this.mFormat = this.mDecoder.getOutputFormat();
                        this.mWidth = this.mFormat.getInteger("width");
                        this.mHeight = this.mFormat.getInteger("height");
                        long resolution = VideoPlayer.getInstance().getPlayerInfo(this.mStreamId, VideoPlayer.VideoPlayerInfoEnum.RESOLUTION);
                        PlayerExceptionDataStat.getInstance().setDecoderResolution(resolution);
                        YMFLog.info(this, "[Decoder]HardDecRender PushFrame INFO_OUTPUT_FORMAT_CHANGED format " + this.mDecoder.getOutputFormat() + " width " + this.mWidth + " height " + this.mHeight);
                    }
                    if (outIndex == -1) {
                        ++this.mNoFrameCnt;
                        if (this.mNoFrameCnt % 100 == 0) {
                            YMFLog.error((Object)this, "[Decoder]HardDecRender PushFrame noFrameCnt " + this.mNoFrameCnt);
                            PlayerExceptionDataStat.getInstance().pushPlayerExceptionDataStat(this.mStreamId, "1", "4", "HardDecRender PushFrame noFrameCnt " + this.mNoFrameCnt);
                            YYVideoLibMgr.instance().onHardwareDecodeErrorNotify(this.mGroupId, this.mStreamId, 1);
                        }
                        YMFLog.info(this, "[Decoder]HardDecRender PushFrame INFO_TRY_AGAIN_LATER, no frame count:" + this.mNoFrameCnt);
                    } else {
                        YMFLog.info(this, "[Decoder]HardDecRender.....");
                    }
                }
                catch (Exception e) {
                    ++this.mNoFrameCnt;
                    this.mIsExceptionOccured = true;
                    PlayerExceptionDataStat.getInstance().pushPlayerExceptionDataStat(this.mStreamId, "1", "1", e.toString());
                    YMFLog.error((Object)this, "[Decoder]HardDecRender PushFrame exception " + YMFLog.stackTraceOf(e));
                    YYVideoLibMgr.instance().onHardwareDecodeErrorNotify(this.mGroupId, this.mStreamId, 4);
                }
            }
            if (inIndex < 0) {
                YMFLog.warn(this, "[Decoder]HardDecRender PushFrame will skip current frame pts:" + pts + " size:" + bf.length);
                ++this.mNoFrameCount;
                if (this.mNoFrameCount % 50L == 0L) {
                    PlayerExceptionDataStat.getInstance().pushPlayerExceptionDataStat(this.mStreamId, "1", "5", "dequeue buffer error");
                }
                if (this.mNoFrameCount % 99L == 0L) {
                    this.mNoFrameCount = 0L;
                    YYVideoLibMgr.instance().onHardwareDecodeErrorNotify(this.mGroupId, this.mStreamId, 2);
                }
            }
            return outPts;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int resetWithoutSurface(String codecName, String codecType, int width, int height) {
        HardDecRender hardDecRender = this;
        synchronized (hardDecRender) {
            try {
                if (!HardDecRender.IsAvailable(codecName)) {
                    YMFLog.error((Object)this, "[Decoder]HardDecRender reset codecType " + codecType + "codecName" + codecName + " hardware decoder is not available");
                    return -1;
                }
                this.release();
                YMFLog.info(this, "[Decoder]HardDecRender reset");
                this.mWidth = width;
                this.mHeight = height;
                long resolution = VideoPlayer.getInstance().getPlayerInfo(this.mStreamId, VideoPlayer.VideoPlayerInfoEnum.RESOLUTION);
                PlayerExceptionDataStat.getInstance().setDecoderResolution(resolution);
                this.mFormat = MediaFormat.createVideoFormat((String)codecType, (int)this.mWidth, (int)this.mHeight);
                this.mDecoder = codecName != null && !codecName.isEmpty() ? MediaCodec.createByCodecName((String)codecName) : MediaCodec.createDecoderByType((String)codecType);
                if (Build.VERSION.SDK_INT >= 21) {
                    MediaCodecInfo.CodecCapabilities codecCapabilities = this.mDecoder.getCodecInfo().getCapabilitiesForType(codecType);
                    this.mColorFormat = 0;
                    int colorFormat2 = 0;
                    for (int c : codecCapabilities.colorFormats) {
                        if (c == 19) {
                            this.mColorFormat = 19;
                            break;
                        }
                        if (c == 21) {
                            colorFormat2 = 21;
                        }
                        YMFLog.info(TAG, "[th] color-format :" + c);
                    }
                    if (this.mColorFormat == 0) {
                        this.mColorFormat = colorFormat2;
                    }
                    this.mFormat.setInteger("color-format", this.mColorFormat);
                    YMFLog.info(this, " used color-format :" + this.mColorFormat);
                }
                this.mDecoder.configure(this.mFormat, null, null, 0);
                this.mDecoder.start();
                this.mInputBuffers = this.mDecoder.getInputBuffers();
                this.mOutputBuffers = this.mDecoder.getOutputBuffers();
                this.mInfo = new MediaCodec.BufferInfo();
                this.mInitialized = true;
                this.mNeedConfig = true;
                this.mFirstDecodedDataOut = false;
                this.mEndOfStream = false;
                YMFLog.info(this, "[Decoder]HardDecRender reset create yuv codec=" + codecName + " start success.");
            }
            catch (Exception e) {
                PlayerExceptionDataStat.getInstance().pushPlayerExceptionDataStat(this.mStreamId, "1", "2", e.toString());
                YMFLog.error((Object)this, "[Decoder]HardDecRender reset codec " + codecName + " exception " + e.getMessage());
                YYVideoLibMgr.instance().onHardwareDecodeErrorNotify(this.mGroupId, this.mStreamId, 0);
            }
            if (!this.mInitialized) {
                return -1;
            }
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int reset(Surface surface, String codecName, String codecType, int width, int height) {
        if (surface == null) {
            return this.resetWithoutSurface(codecName, codecType, width, height);
        }
        HardDecRender hardDecRender = this;
        synchronized (hardDecRender) {
            try {
                if (!HardDecRender.IsAvailable(codecName)) {
                    YMFLog.error((Object)this, "[Decoder]HardDecRender reset codecType " + codecType + "codecName" + codecName + " hardware decoder is not available");
                    return -1;
                }
                this.release();
                YMFLog.info(this, "[Decoder]HardDecRender reset");
                this.mWidth = width;
                this.mHeight = height;
                long resolution = VideoPlayer.getInstance().getPlayerInfo(this.mStreamId, VideoPlayer.VideoPlayerInfoEnum.RESOLUTION);
                PlayerExceptionDataStat.getInstance().setDecoderResolution(resolution);
                this.mSurface = surface;
                this.mFormat = MediaFormat.createVideoFormat((String)codecType, (int)this.mWidth, (int)this.mHeight);
                this.mDecoder = codecName != null && !codecName.isEmpty() ? MediaCodec.createByCodecName((String)codecName) : MediaCodec.createDecoderByType((String)codecType);
                this.mDecoder.configure(this.mFormat, this.mSurface, null, 0);
                this.mDecoder.start();
                this.mInputBuffers = this.mDecoder.getInputBuffers();
                this.mInfo = new MediaCodec.BufferInfo();
                this.mInitialized = true;
                this.mNeedConfig = true;
                this.mFirstDecodedDataOut = false;
                this.mEndOfStream = false;
                YMFLog.info(this, "[Decoder]HardDecRender reset create codec=" + codecName + " start success.");
            }
            catch (Exception e) {
                PlayerExceptionDataStat.getInstance().pushPlayerExceptionDataStat(this.mStreamId, "1", "2", e.toString());
                YMFLog.error((Object)this, "[Decoder]HardDecRender reset codec " + codecName + " exception " + e.getMessage());
                YYVideoLibMgr.instance().onHardwareDecodeErrorNotify(this.mGroupId, this.mStreamId, 0);
            }
            if (!this.mInitialized) {
                return -1;
            }
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void UnBlockingForceFlush() {
        Thread tmp = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    HardDecRender.this.mDecoder.flush();
                    YMFLog.info(this, "[Decoder]HardDecRender UnBlockingForceFlush flushed normally");
                }
                catch (Throwable t) {
                    YMFLog.error((Object)this, "[Decoder]HardDecRender UnBlockingForceFlush flushed with errors, maybe blocked, throwable " + t.getMessage());
                }
                finally {
                    Object object = HardDecRender.this.mForceFlushLock;
                    synchronized (object) {
                        HardDecRender.this.mForceFlushLock.notifyAll();
                    }
                }
            }
        }, "YY_yylivesdk_HardDecRenderForceFlush_Thread");
        try {
            Object object = this.mForceFlushLock;
            synchronized (object) {
                tmp.start();
                this.mForceFlushLock.wait(1000L);
                tmp.interrupt();
            }
        }
        catch (Throwable t) {
            YMFLog.error((Object)this, "[Decoder]HardDecRender UnBlockingForceFlush thread start throwable" + t.getMessage());
        }
    }

    public void release() {
        final CountDownLatch releaseDone = new CountDownLatch(1);
        Runnable runMediaCodecRelease = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                2 var1_1 = this;
                synchronized (var1_1) {
                    YMFLog.info(this, "begin stop mediacodec : " + HardDecRender.this.mDecoder + "LastOutputPts:" + HardDecRender.this.mLastInputPts + "/" + HardDecRender.this.mLastOutputPts + " num:" + HardDecRender.this.mInputIndex + "/" + HardDecRender.this.mOutFrameNum);
                    try {
                        if (HardDecRender.this.mDecoder != null) {
                            HardDecRender.this.mInitialized = false;
                            HardDecRender.this.statDecoderInfoForStop();
                            HardDecRender.this.mDecoder.stop();
                            HardDecRender.this.mInputBuffers = null;
                        }
                    }
                    catch (Throwable e) {
                        YMFLog.error((Object)this, "[Decoder]HardDecRender decoder stop throwable " + YMFLog.stackTraceOf(e));
                    }
                    finally {
                        if (HardDecRender.this.mDecoder != null) {
                            try {
                                HardDecRender.this.mDecoder.release();
                                HardDecRender.this.mDecoder = null;
                            }
                            catch (Exception e1) {
                                YMFLog.error((Object)this, "[Decoder]HardDecRender decoder release exception " + YMFLog.stackTraceOf(e1));
                            }
                        }
                        releaseDone.countDown();
                        YMFLog.info(this, "release mediacodec end");
                    }
                }
            }
        };
        Thread releaseThread = new Thread(runMediaCodecRelease);
        releaseThread.start();
        YMFLog.error((Object)this, "release mediacodec thread start !");
        if (!HardDecRender.awaitUninterruptibly(releaseThread, releaseDone, 4000L)) {
            HardDecodeMonitorThread.instance().stopMediaCodec(this.mStreamId);
            YYVideoLibMgr.instance().onHardwareDecodeErrorNotify(this.mGroupId, this.mStreamId, 3);
        } else {
            YMFLog.error((Object)this, "release mediacodec success !");
        }
    }

    public static boolean awaitUninterruptibly(Thread thread, CountDownLatch barrier, long timeoutMs) {
        long startTimeMs = SystemClock.elapsedRealtime();
        long timeRemainingMs = timeoutMs;
        boolean wasInterrupted = false;
        boolean result = false;
        while (true) {
            try {
                result = barrier.await(timeRemainingMs, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                long elapsedTimeMs;
                wasInterrupted = true;
                if ((timeRemainingMs = timeoutMs - (elapsedTimeMs = SystemClock.elapsedRealtime() - startTimeMs)) > 0L) continue;
            }
            break;
        }
        if (wasInterrupted) {
            Thread.currentThread().interrupt();
        }
        return result;
    }

    public abstract int reset();

    public abstract int reset(Surface var1, int var2, int var3);

    public abstract long PushFrame(Surface var1, byte[] var2, long var3, boolean var5);

    protected static String findCodecName(String mime, String[] supportedPrefixes, String[] unSupportedPrefixes, boolean isIgnoreCodecWhiteList) {
        YMFLog.info(TAG, "[Decoder]HardDecRender findCodecName mime " + mime + " supportedPrefixes " + Arrays.toString(supportedPrefixes) + " unSupportedPrefixes " + Arrays.toString(unSupportedPrefixes) + " isIgnoreCodecWhiteList " + isIgnoreCodecWhiteList);
        if (Build.VERSION.SDK_INT < 16) {
            YMFLog.error((Object)TAG, "[Decoder]HardDecRender findCodecName failed!! SDK version " + Build.VERSION.SDK_INT);
            return null;
        }
        ArrayList<String> codecNames = new ArrayList<String>();
        for (int i = MediaCodecList.getCodecCount() - 1; i >= 0; --i) {
            MediaCodecInfo mInfo = MediaCodecList.getCodecInfoAt((int)i);
            if (mInfo.isEncoder() || !HardDecRender.isSupportMime(mInfo, mime) || HardDecRender.isDisabledCodec(mInfo.getName())) continue;
            codecNames.add(mInfo.getName());
        }
        for (String cname : codecNames) {
            int i;
            for (i = 0; i < unSupportedPrefixes.length && !cname.startsWith(unSupportedPrefixes[i]); ++i) {
            }
            if (i < unSupportedPrefixes.length) continue;
            for (String supportedPrefix : supportedPrefixes) {
                if (!cname.startsWith(supportedPrefix)) continue;
                YMFLog.info(TAG, "[Decoder]HardDecRender findCodecName codecName=" + cname);
                return cname;
            }
        }
        if (!isIgnoreCodecWhiteList) {
            return null;
        }
        if (codecNames.size() == 0) {
            YMFLog.error((Object)TAG, "[Decoder]HardDecRender findCodecName failed!! codecNames empty!");
            return null;
        }
        String cname = (String)codecNames.get(codecNames.size() - 1);
        YMFLog.info(TAG, "[Decoder]HardDecRender findCodecName codecName=" + cname);
        return cname;
    }

    private static boolean isDisabledCodec(String name) {
        if (name.startsWith("OMX.google.")) {
            return true;
        }
        if (name.startsWith("OMX.PV.")) {
            return true;
        }
        if (name.startsWith("OMX.ittiam")) {
            return true;
        }
        if (name.endsWith(".sw.dec")) {
            return true;
        }
        return !name.startsWith("OMX.");
    }

    private static boolean isSupportMime(MediaCodecInfo mInfo, String mime) {
        String[] types = mInfo.getSupportedTypes();
        for (int j = 0; j < types.length; ++j) {
            if (!mime.equalsIgnoreCase(types[j])) continue;
            return true;
        }
        return false;
    }

    public void setStreamId(long streamId) {
        this.mStreamId = streamId;
    }

    private void statDecoderInfoForStop() {
        this.mDecoderInfoMap.put("dr9", this.mLastOutputPts);
        this.mDecoderInfoMap.put("dr15", this.mLastInputPts);
        this.mDecoderInfoMap.put("dr7", this.mStreamId);
        this.mDecoderInfoMap.put("dr0", this.mMediaCodecStopState);
        HardDecodeMonitorThread.instance().registerMediaCodecMonitorClient(this.mDecoderInfoMap);
    }

    public void setGroupId(long groupId) {
        this.mGroupId = groupId;
    }

    public void setDecoderDataOutCallBack(IDecoderDataOutCallBack decoderDataOutCallBack) {
        this.decoderDataOutCallBack = decoderDataOutCallBack;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getCacheFrame() {
        long outPts = 0L;
        HardDecRender hardDecRender = this;
        synchronized (hardDecRender) {
            block14: {
                if (this.mNeedConfig && !this.mInitialized) {
                    this.mIsExceptionOccured = true;
                    YMFLog.info(this, "[Decoder][th] HardDecRender getCacheFrame mNeedConfig");
                    return outPts;
                }
                int inIndex = -1;
                int outIndex = 0;
                int reTryTime = 0;
                try {
                    block15: {
                        inIndex = this.mDecoder.dequeueInputBuffer(150000L);
                        if (inIndex >= 0 && !this.mEndOfStream) {
                            this.mDecoder.queueInputBuffer(inIndex, 0, 0, 0L, 4);
                            YMFLog.info(this, "[Decoder][th] HardDecRender getCacheFrame BUFFER_FLAG_END_OF_STREAM ");
                            this.mEndOfStream = true;
                        }
                        while (true) {
                            if ((outIndex = this.mDecoder.dequeueOutputBuffer(this.mInfo, 10000L)) >= 0) {
                                this.mDecoder.releaseOutputBuffer(outIndex, true);
                                outPts = this.mInfo.presentationTimeUs / 1000L;
                                this.mNoFrameCnt = 0;
                                this.mLastOutputPts = outPts;
                                ++this.mOutFrameNum;
                                if (this.mInfo.flags == 4) {
                                    YMFLog.info(this, "[Decoder]HardDecRender getCacheFrame flags BUFFER_FLAG_END_OF_STREAM " + this.mLastOutputPts);
                                }
                                YMFLog.info(this, "[Decoder][th] HardDecRender getCacheFrame outPts " + outPts + " flag:" + this.mInfo.flags);
                                break block14;
                            }
                            if (outIndex == -3) {
                                YMFLog.info(this, "[Decoder][th] HardDecRender getCacheFrame INFO_OUTPUT_BUFFERS_CHANGED");
                                continue;
                            }
                            if (outIndex == -2) {
                                this.mFormat = this.mDecoder.getOutputFormat();
                                this.mWidth = this.mFormat.getInteger("width");
                                this.mHeight = this.mFormat.getInteger("height");
                                long resolution = VideoPlayer.getInstance().getPlayerInfo(this.mStreamId, VideoPlayer.VideoPlayerInfoEnum.RESOLUTION);
                                PlayerExceptionDataStat.getInstance().setDecoderResolution(resolution);
                                YMFLog.info(this, "[Decoder][th] HardDecRender getCacheFrame INFO_OUTPUT_FORMAT_CHANGED format " + this.mDecoder.getOutputFormat() + " width " + this.mWidth + " height " + this.mHeight);
                                continue;
                            }
                            if (outIndex != -1) break block15;
                            if (++reTryTime >= 3) break;
                        }
                        YMFLog.error((Object)this, "[Decoder]HardDecRender getCacheFrame INFO_TRY_AGAIN_LATER 30ms");
                        break block14;
                    }
                    if (outIndex == 4) {
                        YMFLog.info(this, "[Decoder]HardDecRender getCacheFrame BUFFER_FLAG_END_OF_STREAM " + this.mLastOutputPts);
                    } else {
                        YMFLog.info(this, "[Decoder]HardDecRender getCacheFrame outIndex =" + outIndex);
                    }
                }
                catch (Exception e) {
                    ++this.mNoFrameCnt;
                    this.mIsExceptionOccured = true;
                    PlayerExceptionDataStat.getInstance().pushPlayerExceptionDataStat(this.mStreamId, "1", "1", e.toString());
                    YMFLog.error((Object)this, "[Decoder]HardDecRender getCacheFrame exception " + YMFLog.stackTraceOf(e));
                    YYVideoLibMgr.instance().onHardwareDecodeErrorNotify(this.mGroupId, this.mStreamId, 4);
                }
            }
            return outPts;
        }
    }

    public void setOnDecoderYUVListener(OnDecoderYUVListener listener) {
        this.mOnDecoderYUVListener = listener;
    }

    public static interface OnDecoderYUVListener {
        public void OnDecoderYUVListener(int var1, int var2, ByteBuffer var3, int var4, long var5, int var7, int var8);
    }

    public static interface IDecoderDataOutCallBack {
        public void onFirstDecodedDataOut();
    }

    public static class MediaCodecErrorType {
        public static final int MEDIA_CODEC_RESET_ERROR = 0;
        public static final int MEDIA_CODEC_INIT_ERROR = 1;
        public static final int MEDIA_CODEC_DECODING_ERROR = 2;
        public static final int MEDIA_CODEC_STOP_BLOCK_ERROR = 3;
        public static final int MEDIA_CODEC_QUEUEINPUTBUFFER_ERROR = 4;
    }
}

