/*
 * Decompiled with CFR 0.152.
 */
package com.yy.videoplayer.decoder;

import android.view.Surface;
import com.yy.videoplayer.decoder.HardDecRender;
import com.yy.videoplayer.decoder.OMXDecoderRank;
import com.yy.videoplayer.utils.YMFLog;
import java.util.concurrent.atomic.AtomicBoolean;

public class H264DecRender
extends HardDecRender {
    static final String mCodecType = "video/avc";
    static String mCodecName = "";
    public static final String crashTsFirst = "H264DecRenderCrashTsFirst";
    public static final String crashTsSecond = "H264DecRenderCrashTsSecond";
    private static final String[] supportedH264HwCodecPrefixes = new String[]{"OMX.qcom.video.", "OMX.TI.", "OMX.SEC.", "OMX.Exynos.", "OMX.Nvidia.", "OMX.IMG.", "OMX.amlogic", "OMX.MTK.", "OMX.k3."};
    private static final String[] unSupportedH264HwCodecPrefixes = new String[]{"OMX.Nvidia.h264.decode.secure", "OMX.SEC.avcdec", "OMX.TI.DUCATI1.VIDEO.DECODER", "OMX.SEC.AVC.Decoder"};

    public static void getDecodeInfoAsync() {
        DecodeInfoThread decodeInfoThread = new DecodeInfoThread();
        Thread thread = new Thread((Runnable)decodeInfoThread, "YY_yylivesdk_H264DecRenderDecodeInfo_Thread");
        thread.start();
    }

    public H264DecRender(Surface surface, int width, int height) {
        this.mSurface = surface;
        this.mWidth = width;
        this.mHeight = height;
        this.InitFields();
        this.reset(this.mSurface, this.mWidth, this.mHeight);
    }

    public H264DecRender(Surface surface, int width, int height, long groupId, long streamId) {
        this.mSurface = surface;
        this.mWidth = width;
        this.mHeight = height;
        this.InitFields();
        this.setGroupId(groupId);
        this.setStreamId(streamId);
        this.reset(this.mSurface, this.mWidth, this.mHeight);
    }

    public H264DecRender(Surface surface) {
        this.mSurface = surface;
        this.InitFields();
        this.reset(this.mSurface, this.mWidth, this.mHeight);
    }

    public static boolean upDateCodecIgnoreCodecWhiteList() {
        mCodecName = H264DecRender.findCodecName(mCodecType, supportedH264HwCodecPrefixes, unSupportedH264HwCodecPrefixes, true);
        return null != mCodecName;
    }

    public static boolean IsAvailable() {
        return H264DecRender.IsAvailable(mCodecName);
    }

    public static String getCodecName() {
        return mCodecName;
    }

    void InitFields() {
        this.mSecondTsWriten = new AtomicBoolean(false);
        this.mCrashTsFirst = crashTsFirst;
        this.mCrashTsSecond = crashTsSecond;
        this.mNoFrameCnt = 0;
    }

    @Override
    public int reset() {
        return this.reset(this.mSurface, this.mWidth, this.mHeight);
    }

    @Override
    public int reset(Surface surface, int width, int height) {
        return this.reset(surface, mCodecName, mCodecType, width, height);
    }

    @Override
    public long PushFrame(Surface surface, byte[] bf, long pts, boolean isHeader) {
        return this.PushFrame(surface, mCodecName, mCodecType, bf, pts, isHeader);
    }

    static {
        H264DecRender.getDecodeInfoAsync();
    }

    static class DecodeInfoThread
    implements Runnable {
        DecodeInfoThread() {
        }

        @Override
        public void run() {
            try {
                OMXDecoderRank.DecoderInfo decoderInfo = OMXDecoderRank.instance().getBestDecoder();
                if (decoderInfo != null) {
                    mCodecName = decoderInfo.name();
                    YMFLog.info("H264DecRender", "[Decoder]DecoderInfo mCodecName: " + mCodecName);
                }
            }
            catch (Exception e) {
                YMFLog.error((Object)"H264DecRender", "[Decoder]DecoderInfo: Load Error " + e.getMessage());
            }
        }
    }
}

