/*
 * Decompiled with CFR 0.152.
 */
package com.yy.videoplayer.decoder;

import com.yy.videoplayer.decoder.VideoConstant;
import com.yy.videoplayer.utils.YMFLog;
import com.yy.videoplayer.videoview.YSpVideoView;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.util.Arrays;

public class Coordinate {
    private static final int FLOAT_SIZE = 4;
    private int mWidth = 0;
    private int mHeight = 0;
    private int mCurrentWidth = 0;
    private int mCurrentHeight = 0;
    private int mCurrentImageWidth = 0;
    YSpVideoView.OrientationType mOrientationType = YSpVideoView.OrientationType.Normal;
    int mRotateAngle = 0;
    private boolean mUnReSized = false;
    VideoConstant.ScaleMode mScaleMode = VideoConstant.ScaleMode.AspectFit;
    private float[] mVertex;
    private float[] mVertexRotate;
    protected FloatBuffer mVertexBuffer;
    float[] FULL_RECTANGLE_COORDS = new float[]{-1.0f, 1.0f, 0.0f, 0.0f, 1.0f, -1.0f, -1.0f, 0.0f, 0.0f, 0.0f, 1.0f, -1.0f, 0.0f, 1.0f, 0.0f, 1.0f, 1.0f, 0.0f, 1.0f, 1.0f};

    protected Coordinate(float[] vertex) {
        this.mVertex = vertex;
        this.mVertexRotate = new float[vertex.length];
        this.rotateInDegree(0, this.mVertex, this.mVertexRotate);
        ByteBuffer bb = ByteBuffer.allocateDirect(this.mVertex.length * 4);
        bb.order(ByteOrder.nativeOrder());
        this.mVertexBuffer = bb.asFloatBuffer();
        this.mVertexBuffer.put(this.mVertex);
        this.mVertexBuffer.position(0);
    }

    protected int getBufferSize() {
        return this.mVertex.length * 4;
    }

    protected void setSize(int width, int height, VideoConstant.ScaleMode scaleMode) {
        if (width == this.mWidth && height == this.mHeight) {
            this.mUnReSized = true;
            return;
        }
        this.mUnReSized = false;
        this.mWidth = width;
        this.mHeight = height;
        this.mScaleMode = scaleMode;
    }

    public void setOrientation(YSpVideoView.OrientationType orientationType, int rotateAngle, boolean adjustImmediately) {
        this.mOrientationType = orientationType;
        this.mRotateAngle = rotateAngle;
        this.mUnReSized = false;
        this.applyRatioIfNeed(this.mCurrentWidth, this.mCurrentHeight, this.mCurrentImageWidth, this.mScaleMode);
    }

    private void rotateInDegree(int angle, float[] vertex20, float[] dst20) {
        int offsetx = 0;
        int offsety = 1;
        System.arraycopy(vertex20, 0, dst20, 0, vertex20.length);
        for (int i = 0; i < 20; i += 5) {
            dst20[offsetx] = vertex20[offsetx] * (float)Math.cos(Math.PI * (double)(-angle) / 180.0) + vertex20[offsety] * (float)Math.sin(Math.PI * (double)(-angle) / 180.0);
            dst20[offsety] = -vertex20[offsetx] * (float)Math.sin(Math.PI * (double)(-angle) / 180.0) + vertex20[offsety] * (float)Math.cos(Math.PI * (double)(-angle) / 180.0);
            offsetx += 5;
            offsety += 5;
        }
    }

    protected boolean applySizeRatio() {
        return this.applyRatioIfNeed(this.mCurrentWidth, this.mCurrentHeight, this.mCurrentImageWidth, this.mScaleMode);
    }

    protected boolean applyRatioIfNeedMultiVideo(int imageWidth, int imageHeight, int viewWidth, int viewHight, VideoConstant.ScaleMode scaleType) {
        float widthRatio;
        float heightRatio;
        float inputAspect = (float)imageWidth / (float)imageHeight;
        float outputAspect = (float)viewWidth / (float)viewHight;
        float[] newPosVer = new float[this.mVertex.length];
        System.arraycopy(this.FULL_RECTANGLE_COORDS, 0, newPosVer, 0, this.FULL_RECTANGLE_COORDS.length);
        if (scaleType == VideoConstant.ScaleMode.ClipToBounds) {
            if (inputAspect < outputAspect) {
                heightRatio = outputAspect / inputAspect;
                newPosVer[1] = newPosVer[1] * heightRatio;
                newPosVer[6] = newPosVer[6] * heightRatio;
                newPosVer[11] = newPosVer[11] * heightRatio;
                newPosVer[16] = newPosVer[16] * heightRatio;
            } else {
                widthRatio = inputAspect / outputAspect;
                newPosVer[0] = newPosVer[0] * widthRatio;
                newPosVer[5] = newPosVer[5] * widthRatio;
                newPosVer[10] = newPosVer[10] * widthRatio;
                newPosVer[15] = newPosVer[15] * widthRatio;
            }
        } else if (scaleType == VideoConstant.ScaleMode.AspectFit) {
            if (inputAspect < outputAspect) {
                widthRatio = inputAspect / outputAspect;
                newPosVer[0] = newPosVer[0] * widthRatio;
                newPosVer[5] = newPosVer[5] * widthRatio;
                newPosVer[10] = newPosVer[10] * widthRatio;
                newPosVer[15] = newPosVer[15] * widthRatio;
            } else {
                heightRatio = outputAspect / inputAspect;
                newPosVer[1] = newPosVer[1] * heightRatio;
                newPosVer[6] = newPosVer[6] * heightRatio;
                newPosVer[11] = newPosVer[11] * heightRatio;
                newPosVer[16] = newPosVer[16] * heightRatio;
            }
        }
        this.mVertexBuffer.clear();
        ByteBuffer bb = ByteBuffer.allocateDirect(newPosVer.length * 4);
        bb.order(ByteOrder.nativeOrder());
        this.mVertexBuffer = bb.asFloatBuffer();
        this.mVertexBuffer.put(newPosVer);
        this.mVertexBuffer.position(0);
        return true;
    }

    protected boolean applyRatioIfNeed(int width, int height, int imageWidth, VideoConstant.ScaleMode scaleMode) {
        float hr;
        float wr;
        Size dstSize;
        if (this.mUnReSized && width == this.mCurrentWidth && height == this.mCurrentHeight && imageWidth == this.mCurrentImageWidth && this.mScaleMode == scaleMode) {
            return false;
        }
        if (0 == this.mWidth || 0 == this.mHeight) {
            YMFLog.info("GLVideo_size", "width %d height %d", this.mWidth, this.mHeight);
            return false;
        }
        if (0 == imageWidth || 0 == height || 0 == width) {
            YMFLog.info("GLVideo_size", "imageWidth %d width %d height %d zero", imageWidth, width, height);
            return false;
        }
        YMFLog.info(this, "adjustScale: orientationType = " + (Object)((Object)this.mOrientationType) + ", scaleMode = " + (Object)((Object)this.mScaleMode) + ", picHeight = %d, picWidth = %d, surfaceHeight = %d, surfaceWidth = %d", height, imageWidth, this.mHeight, this.mWidth);
        this.mUnReSized = true;
        this.mCurrentWidth = width;
        this.mCurrentHeight = height;
        this.mCurrentImageWidth = imageWidth--;
        this.mScaleMode = scaleMode;
        float[] newPosVer = new float[this.mVertex.length];
        if (this.mOrientationType == YSpVideoView.OrientationType.Force || this.mOrientationType == YSpVideoView.OrientationType.Auto && imageWidth < height != this.mWidth < this.mHeight) {
            if (this.mRotateAngle != 0 && this.mRotateAngle != 180) {
                dstSize = this.CalcFitSize(imageWidth, height, this.mHeight, this.mWidth, this.mScaleMode);
                wr = 1.0f * (float)dstSize.getHeight() / (float)this.mWidth;
                hr = 1.0f * (float)dstSize.getWidth() / (float)this.mHeight;
            } else {
                dstSize = this.CalcFitSize(imageWidth, height, this.mWidth, this.mHeight, this.mScaleMode);
                wr = 1.0f * (float)dstSize.getWidth() / (float)this.mWidth;
                hr = 1.0f * (float)dstSize.getHeight() / (float)this.mHeight;
            }
            this.rotateInDegree(this.mRotateAngle, this.mVertex, this.mVertexRotate);
        } else {
            dstSize = this.CalcFitSize(imageWidth, height, this.mWidth, this.mHeight, this.mScaleMode);
            wr = 1.0f * (float)dstSize.getWidth() / (float)this.mWidth;
            hr = 1.0f * (float)dstSize.getHeight() / (float)this.mHeight;
            this.rotateInDegree(0, this.mVertex, this.mVertexRotate);
        }
        System.arraycopy(this.mVertexRotate, 0, newPosVer, 0, this.mVertexRotate.length);
        newPosVer[0] = newPosVer[0] * wr;
        newPosVer[5] = newPosVer[5] * wr;
        newPosVer[10] = newPosVer[10] * wr;
        newPosVer[15] = newPosVer[15] * wr;
        newPosVer[1] = newPosVer[1] * hr;
        newPosVer[6] = newPosVer[6] * hr;
        newPosVer[11] = newPosVer[11] * hr;
        newPosVer[16] = newPosVer[16] * hr;
        if (this.mCurrentImageWidth != this.mCurrentWidth) {
            float dif = 1.0f * (float)(this.mCurrentWidth - imageWidth) / (float)this.mCurrentWidth;
            newPosVer[13] = newPosVer[13] - dif;
            newPosVer[18] = newPosVer[18] - dif;
        }
        this.mVertexBuffer.clear();
        ByteBuffer bb = ByteBuffer.allocateDirect(newPosVer.length * 4);
        bb.order(ByteOrder.nativeOrder());
        this.mVertexBuffer = bb.asFloatBuffer();
        this.mVertexBuffer.put(newPosVer);
        this.mVertexBuffer.position(0);
        YMFLog.info("GLVideo_size", "renderWidth " + dstSize.getWidth() + " renderHeight " + dstSize.getHeight() + " array " + Arrays.toString(newPosVer));
        return true;
    }

    Size CalcFitSize(int imageWidth, int imageHeight, int frameWidth, int frameHeight, VideoConstant.ScaleMode scaleMode) {
        Size rs = new Size(imageWidth, imageHeight);
        if (VideoConstant.ScaleMode.AspectFit == scaleMode) {
            double f = frameHeight * imageWidth < frameWidth * imageHeight ? 1.0 * (double)frameHeight / (double)imageHeight : 1.0 * (double)frameWidth / (double)imageWidth;
            rs = new Size((int)((double)imageWidth * f), (int)((double)imageHeight * f));
        } else if (VideoConstant.ScaleMode.ClipToBounds == scaleMode) {
            double f = frameHeight * imageWidth < frameWidth * imageHeight ? 1.0 * (double)frameWidth / (double)imageWidth : 1.0 * (double)frameHeight / (double)imageHeight;
            rs = new Size((int)((double)imageWidth * f), (int)((double)imageHeight * f));
        } else if (VideoConstant.ScaleMode.FillParent == scaleMode) {
            rs = new Size(frameWidth, frameHeight);
        }
        return rs;
    }

    public static class Size {
        private int width;
        private int height;

        public Size(int width, int height) {
            this.width = width;
            this.height = height;
        }

        public Size() {
            this.width = 0;
            this.height = 0;
        }

        public int getWidth() {
            return this.width;
        }

        public void setWidth(int width) {
            this.width = width;
        }

        public int getHeight() {
            return this.height;
        }

        public void setHeight(int height) {
            this.height = height;
        }
    }
}

