/*
 * Decompiled with CFR 0.152.
 */
package com.yy.videoplayer;

import com.yy.videoplayer.IVideoPlayerInfo;
import com.yy.videoplayer.VideoPlayerInfo;
import java.util.HashMap;

public class VideoPlayer
implements IVideoPlayerInfo {
    private static VideoPlayer mInstance;
    private HashMap<Long, VideoPlayerInfo> mHashMap = new HashMap();

    public static VideoPlayer getInstance() {
        if (mInstance == null) {
            mInstance = new VideoPlayer();
        }
        return mInstance;
    }

    private VideoPlayer() {
    }

    public long getPlayerInfo(long streamId, VideoPlayerInfoEnum info) {
        long playerInfo = -1L;
        VideoPlayerInfo videoPlayerInfo = this.mHashMap.get(streamId);
        if (videoPlayerInfo == null) {
            return playerInfo;
        }
        if (VideoPlayerInfoEnum.FRAME.ordinal() == info.ordinal()) {
            playerInfo = videoPlayerInfo.mFramerate;
        } else if (VideoPlayerInfoEnum.RESOLUTION.ordinal() == info.ordinal()) {
            playerInfo = videoPlayerInfo.mWidth << 16 | videoPlayerInfo.mHeight;
        } else if (VideoPlayerInfoEnum.BITRATE.ordinal() == info.ordinal()) {
            // empty if block
        }
        return playerInfo;
    }

    @Override
    public void pushVideoPlayerInfo(long streamId, int width, int height, int framerate) {
        VideoPlayerInfo videoPlayerInfo = this.mHashMap.get(streamId);
        if (videoPlayerInfo == null) {
            videoPlayerInfo = new VideoPlayerInfo(width, height, framerate);
        }
        if (height != -1) {
            videoPlayerInfo.mHeight = height;
        }
        if (width != -1) {
            videoPlayerInfo.mWidth = width;
        }
        if (framerate != -1) {
            videoPlayerInfo.mFramerate = framerate;
        }
        this.mHashMap.put(streamId, videoPlayerInfo);
    }

    @Override
    public void deleteVideoPlayerInfo(long streamId) {
        this.mHashMap.remove(streamId);
    }

    public static enum VideoPlayerInfoEnum {
        RESOLUTION,
        FRAME,
        BITRATE;

    }
}

