/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mediaframework.utils;

import com.yy.mediaframework.Constant;
import com.yy.mediaframework.utils.YMFLog;
import java.util.Locale;

public class VideoSizeUtils {
    private static final String TAG = "VideoSizeUtils";

    public static Size CalcFitSize(int imageWidth, int imageHeight, int frameWidth, int frameHeight, Constant.ScaleMode scaleMode) {
        YMFLog.info(null, "[Util    ]", String.format(Locale.getDefault(), "imageWidth:%d, imageHeight:%d, frameWidth:%d, frameHeight:%d", imageWidth, imageHeight, frameWidth, frameHeight) + " scaleMode:" + (Object)((Object)scaleMode));
        Size rs = new Size(imageWidth, imageHeight);
        if (Constant.ScaleMode.AspectFit == scaleMode) {
            if (frameHeight * imageWidth < frameWidth * imageHeight) {
                double f = 1.0 * (double)frameHeight / (double)imageHeight;
                rs.width = (int)(f * (double)imageWidth + 0.5);
                rs.height = frameHeight;
                rs.x = (frameWidth - rs.width) / 2;
                rs.y = 0;
            } else {
                double f = 1.0 * (double)frameWidth / (double)imageWidth;
                rs.width = frameWidth;
                rs.height = (int)(f * (double)imageHeight + 0.5);
                rs.x = 0;
                rs.y = (frameHeight - rs.height) / 2;
            }
        } else if (Constant.ScaleMode.AspectFill == scaleMode) {
            if (frameHeight * imageWidth < frameWidth * imageHeight) {
                double f = 1.0 * (double)frameWidth / (double)imageWidth;
                rs.width = frameWidth;
                rs.height = (int)(f * (double)imageHeight + 0.5);
                rs.x = 0;
                rs.y = (frameHeight - rs.height) / 2;
            } else {
                double f = 1.0 * (double)frameHeight / (double)imageHeight;
                rs.width = (int)(f * (double)imageWidth + 0.5);
                rs.height = frameHeight;
                rs.x = (frameWidth - rs.width) / 2;
                rs.y = 0;
            }
        } else if (Constant.ScaleMode.ScacleToFill == scaleMode) {
            rs.height = frameHeight;
            rs.width = frameWidth;
            rs.x = 0;
            rs.y = 0;
        }
        return rs;
    }

    public static Size CalcFitSize(int srcW, int srcH, int expectedW, int expectedH) {
        Size res = new Size();
        if (srcH > 0 && srcW > 0 && expectedH > 0 && expectedW > 0) {
            if (expectedW > srcW || expectedH > srcH) {
                double realRate = 1.0 * (double)srcW / (double)srcH;
                double nRate = 1.0 * (double)expectedW / (double)expectedH;
                if (realRate > nRate) {
                    res.height = srcH;
                    res.width = srcH * expectedW / expectedH;
                } else {
                    res.width = srcW;
                    res.height = srcW * expectedH / expectedW;
                }
                res.width &= 0xFFFFFFF0;
                res.height &= 0xFFFFFFF0;
            } else {
                res.width = expectedW;
                res.height = expectedH;
            }
        }
        return res;
    }

    public static class Size {
        public int width;
        public int height;
        public int x;
        public int y;

        public Size(int width, int height) {
            this.width = width;
            this.height = height;
        }

        public Size() {
            this.width = 0;
            this.height = 0;
        }
    }
}

