/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mediaframework.utils;

import android.graphics.Bitmap;
import android.opengl.GLES20;
import android.os.Environment;
import com.yy.mediaframework.gles.GlUtil;
import com.yy.mediaframework.gpuimage.util.GLShaderProgram;
import com.yy.mediaframework.gpuimage.util.TextureRotationUtil;
import com.yy.mediaframework.utils.GLUtil;
import com.yy.mediaframework.utils.YMFLog;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.util.Locale;

public class OESTO2DTool {
    private int mFrameBuffer = -1;
    private int mTexture2d = -1;
    private ByteBuffer snapByteBuffer = null;
    private GLShaderProgram mShaderProgram;
    private FloatBuffer mMasterVertexBuffer;
    private FloatBuffer mGLTextureBuffer;
    private int mSnapIndex = 0;
    private String mSnapShotPath = Environment.getExternalStorageDirectory().getPath() + "/YYImage";
    private String mFileNamePrefix = "snap";
    private int mQuality = 50;
    public static final String vertexShader = "attribute vec4 aPosition;          \nattribute vec4 aTextureCoord;      \nvarying vec2 vTexCoord;            \nvoid main()                        \n{                                  \n    gl_Position = aPosition;       \n    vTexCoord = aTextureCoord.xy;  \n}";
    public static String fragmentShader = "#extension GL_OES_EGL_image_external : require                     \nprecision mediump float;                                           \nvarying vec2 vTexCoord;                                            \nuniform samplerExternalOES uTexture0;                              \nvoid main()                                                        \n{                                                                  \n    vec4 color = texture2D(uTexture0, vTexCoord);                  \n    gl_FragColor = color; //vec4(color.y, color.y, color.y, 1.0);  \n}";
    private final float[] CUBE = new float[]{-1.0f, -1.0f, 1.0f, -1.0f, -1.0f, 1.0f, 1.0f, 1.0f};

    public OESTO2DTool() {
        File file;
        int[] framebuffer = new int[1];
        GLES20.glGenFramebuffers((int)1, (int[])framebuffer, (int)0);
        this.mFrameBuffer = framebuffer[0];
        this.mShaderProgram = new GLShaderProgram();
        this.mShaderProgram.setProgram(vertexShader, fragmentShader);
        this.mMasterVertexBuffer = ByteBuffer.allocateDirect(this.CUBE.length * 4).order(ByteOrder.nativeOrder()).asFloatBuffer();
        this.mMasterVertexBuffer.put(this.CUBE).position(0);
        FloatBuffer GLTextureBuffer = ByteBuffer.allocateDirect(TextureRotationUtil.FULL_RECTANGLE_TEX_COORDS.length * 4).order(ByteOrder.nativeOrder()).asFloatBuffer();
        GLTextureBuffer.put(TextureRotationUtil.TEXTURE_ROTATED_90).position(0);
        this.mGLTextureBuffer = GlUtil.setFlipY(GLTextureBuffer);
        if (!(null == this.mSnapShotPath || (file = new File(this.mSnapShotPath)).exists() && file.isDirectory() || file.mkdirs())) {
            YMFLog.error((Object)this, "[Util    ]", "mkdirs " + this.mSnapShotPath + " failed !");
        }
    }

    public void release() {
        if (this.mFrameBuffer != -1) {
            int[] framebuffer = new int[]{this.mFrameBuffer};
            GLES20.glDeleteFramebuffers((int)1, (int[])framebuffer, (int)0);
            this.mFrameBuffer = -1;
        }
        if (this.mShaderProgram != null) {
            this.mShaderProgram.destory();
            this.mShaderProgram = null;
        }
        if (this.mMasterVertexBuffer != null) {
            this.mMasterVertexBuffer.clear();
            this.mMasterVertexBuffer = null;
        }
        if (this.mGLTextureBuffer != null) {
            this.mGLTextureBuffer.clear();
            this.mGLTextureBuffer = null;
        }
        if (this.mTexture2d != -1) {
            int[] texture = new int[]{this.mTexture2d};
            GLES20.glDeleteTextures((int)1, (int[])texture, (int)0);
            this.mTexture2d = -1;
        }
        if (this.snapByteBuffer != null) {
            this.snapByteBuffer.clear();
            this.snapByteBuffer = null;
        }
    }

    public void saveOESTextureToJPEG(int TextureId_OES, int width, int height) {
        GLES20.glViewport((int)0, (int)0, (int)width, (int)height);
        GLES20.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
        GLES20.glClear((int)16384);
        if (this.mTexture2d == -1) {
            this.mTexture2d = GLUtil.genTexture(3553, width, height);
        }
        if (this.snapByteBuffer == null) {
            this.snapByteBuffer = ByteBuffer.allocate(width * height * 4);
            this.snapByteBuffer.order(ByteOrder.nativeOrder());
        }
        GLES20.glBindFramebuffer((int)36160, (int)this.mFrameBuffer);
        GLES20.glFramebufferTexture2D((int)36160, (int)36064, (int)3553, (int)this.mTexture2d, (int)0);
        this.mShaderProgram.useProgram();
        this.mShaderProgram.setUniformTexture("uTexture0", 0, TextureId_OES, 36197);
        this.mMasterVertexBuffer.position(0);
        this.mGLTextureBuffer.position(0);
        this.mShaderProgram.setVertexAttribPointer("aPosition", 2, 5126, false, 0, this.mMasterVertexBuffer);
        this.mShaderProgram.setVertexAttribPointer("aTextureCoord", 2, 5126, false, 0, this.mGLTextureBuffer);
        GLES20.glDrawArrays((int)5, (int)0, (int)4);
        if (this.snapByteBuffer != null) {
            this.snapByteBuffer.clear();
            this.snapByteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            GLES20.glReadPixels((int)0, (int)0, (int)width, (int)height, (int)6408, (int)5121, (Buffer)this.snapByteBuffer);
            Bitmap bitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            bitmap.copyPixelsFromBuffer((Buffer)this.snapByteBuffer);
            this.saveToFile(bitmap);
        }
        GLES20.glBindTexture((int)3553, (int)0);
        GLES20.glBindFramebuffer((int)36160, (int)0);
    }

    private void saveToFile(final Bitmap bmp) {
        Thread taskTreadk = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                FileOutputStream out = null;
                OESTO2DTool.this.mSnapIndex++;
                String indexStr = String.format("%03d", OESTO2DTool.this.mSnapIndex);
                String FilePath = OESTO2DTool.this.mSnapShotPath + File.separator + OESTO2DTool.this.mFileNamePrefix + indexStr + ".jpg";
                try {
                    out = new FileOutputStream(FilePath);
                }
                catch (FileNotFoundException e) {
                    YMFLog.error((Object)this, "[Util    ]", String.format(Locale.getDefault(), "%s not found, exception:%s", FilePath, e.toString()));
                }
                if (out == null) {
                    return;
                }
                bmp.compress(Bitmap.CompressFormat.JPEG, OESTO2DTool.this.mQuality, (OutputStream)out);
                try {
                    out.flush();
                    out.close();
                }
                catch (IOException e) {
                    YMFLog.error((Object)this, "[Util    ]", "save to file exception:" + e.toString());
                }
                finally {
                    bmp.recycle();
                }
            }
        });
        taskTreadk.start();
    }

    public int ConvertOES(int TextureId_OES, int width, int height) {
        GLES20.glViewport((int)0, (int)0, (int)width, (int)height);
        GLES20.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
        GLES20.glClear((int)16384);
        int texture_2d = GLUtil.genTexture(3553, width, height);
        GLES20.glBindFramebuffer((int)36160, (int)this.mFrameBuffer);
        GLES20.glFramebufferTexture2D((int)36160, (int)36064, (int)3553, (int)texture_2d, (int)0);
        this.mShaderProgram.useProgram();
        this.mShaderProgram.setUniformTexture("uTexture0", 0, TextureId_OES, 36197);
        this.mMasterVertexBuffer.position(0);
        this.mGLTextureBuffer.position(0);
        this.mShaderProgram.setVertexAttribPointer("aPosition", 2, 5126, false, 0, this.mMasterVertexBuffer);
        this.mShaderProgram.setVertexAttribPointer("aTextureCoord", 2, 5126, false, 0, this.mGLTextureBuffer);
        GLES20.glDrawArrays((int)5, (int)0, (int)4);
        GLES20.glFlush();
        GLES20.glBindTexture((int)3553, (int)0);
        GLES20.glBindFramebuffer((int)36160, (int)0);
        return texture_2d;
    }

    public int ConvertOES(int TextureId_OES, int width, int height, int texture_2d) {
        GLES20.glViewport((int)0, (int)0, (int)width, (int)height);
        GLES20.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
        GLES20.glClear((int)16384);
        GLES20.glBindFramebuffer((int)36160, (int)this.mFrameBuffer);
        GLES20.glFramebufferTexture2D((int)36160, (int)36064, (int)3553, (int)texture_2d, (int)0);
        this.mShaderProgram.useProgram();
        this.mShaderProgram.setUniformTexture("uTexture0", 0, TextureId_OES, 36197);
        this.mMasterVertexBuffer.position(0);
        this.mGLTextureBuffer.position(0);
        this.mShaderProgram.setVertexAttribPointer("aPosition", 2, 5126, false, 0, this.mMasterVertexBuffer);
        this.mShaderProgram.setVertexAttribPointer("aTextureCoord", 2, 5126, false, 0, this.mGLTextureBuffer);
        GLES20.glDrawArrays((int)5, (int)0, (int)4);
        GLES20.glFlush();
        GLES20.glBindTexture((int)3553, (int)0);
        GLES20.glBindFramebuffer((int)36160, (int)0);
        return texture_2d;
    }
}

