/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mediaframework.stat;

import com.yy.mediaframework.stat.VideoDataStatistic;
import com.yy.mediaframework.utils.VideoStatisticTool;
import com.yy.mediaframework.utils.YMFLog;
import java.util.HashMap;

public class YMFLiveStatisticManager {
    public static final String TAG = "VideoStatisticManager ";
    private static volatile YMFLiveStatisticManager mInstance;
    private VideoDataStatistic mVideoDataStatistic = new VideoDataStatistic();
    private static final byte[] SYNC_FLAG;
    private VideoStatisticTool mCaptureDataStatistic = null;
    private VideoStatisticTool mPreProcessStatistic = null;
    private VideoStatisticTool mRealEncodeBitrateStatic = null;
    private VideoStatisticTool mRealEncodeFpsStatistic = null;
    private VideoStatisticTool mEncodeLatencyStatistic = null;
    private VideoStatisticTool mPtsStatistic = null;
    private VideoStatisticTool mPtsDtsStatistic = null;
    private VideoStatisticTool mVideoCapture2EncodeLatencyStatistic = null;
    private VideoStatisticTool mEncodeDiffStatistic = null;
    private HashMap<Long, Long> mEncodeLatency = new HashMap();
    private HashMap<Long, Long> mVideoCapture2EncodeLatency = new HashMap();
    private boolean isResetVideoEncodeTimeDiff = false;
    private int mResetVideoPtsMaxDiffFrameCount = 0;
    private int mResetVideoPtsDtsMaxDiffFrameCount = 0;
    private long mLastCameraCaptureTime = 0L;
    private long mDesiredEncodeBitrate = 0L;
    private long mLastPts = 0L;
    private long mLastPrintTime = 0L;
    private int mMaxDeltaPts = 0;
    protected static final int RESET_DATA_COUNT = 10;
    protected static final int RESET_DATA_TIME = 5000;
    private long mStartResetTime = -1L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static synchronized YMFLiveStatisticManager getInstance() {
        if (mInstance != null) return mInstance;
        byte[] byArray = SYNC_FLAG;
        synchronized (SYNC_FLAG) {
            if (mInstance != null) return mInstance;
            mInstance = new YMFLiveStatisticManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return mInstance;
        }
    }

    private YMFLiveStatisticManager() {
        this.init();
    }

    private void init() {
        this.mCaptureDataStatistic = new VideoStatisticTool();
        this.mPreProcessStatistic = new VideoStatisticTool();
        this.mRealEncodeBitrateStatic = new VideoStatisticTool();
        this.mRealEncodeFpsStatistic = new VideoStatisticTool();
        this.mEncodeLatencyStatistic = new VideoStatisticTool();
        this.mPtsStatistic = new VideoStatisticTool();
        this.mPtsDtsStatistic = new VideoStatisticTool();
        this.mVideoCapture2EncodeLatencyStatistic = new VideoStatisticTool();
        this.mEncodeDiffStatistic = new VideoStatisticTool();
    }

    public synchronized void reset() {
        YMFLog.info(this, "[Preview ]", "resetData\uff0cmEncodeLatency count\uff1a" + this.mEncodeLatency.size() + " mVideoCapture2EncodeLatency count\uff1a" + this.mVideoCapture2EncodeLatency.size());
        this.mEncodeLatency.clear();
        this.mVideoCapture2EncodeLatency.clear();
        this.isResetVideoEncodeTimeDiff = true;
        this.mResetVideoPtsMaxDiffFrameCount = 10;
        this.mResetVideoPtsDtsMaxDiffFrameCount = 10;
        this.mLastCameraCaptureTime = 0L;
        this.mStartResetTime = System.currentTimeMillis();
    }

    public void setGpuDeviceName(String name) {
        this.mVideoDataStatistic.setGpuDeviceName(name);
    }

    public void setCameraCaptureFrameRate() {
        if (this.mCaptureDataStatistic != null) {
            long mCurrentTime = System.currentTimeMillis();
            if (this.mLastCameraCaptureTime == 0L) {
                this.mLastCameraCaptureTime = System.currentTimeMillis();
                return;
            }
            int deal = (int)(mCurrentTime - this.mLastCameraCaptureTime);
            this.mLastCameraCaptureTime = mCurrentTime;
            this.mCaptureDataStatistic.triggerStatisticCalcBySecond(deal);
        }
    }

    public void calcPreProcessLatency(long startTime) {
        if (this.mPreProcessStatistic != null) {
            long t = System.currentTimeMillis() - startTime;
            this.mPreProcessStatistic.triggerStatisticCalcBySecond((int)t);
        }
    }

    public void setPmDesiredParam(int publishId, int encodeWidth, int encodeHeight, int bitrate, int fps) {
        this.mVideoDataStatistic.setPmDesiredParam(publishId, encodeWidth, encodeHeight, bitrate, fps);
    }

    public void setVideoEncodeTypeId(int publishId, int videoEncodeTypeId) {
        this.mVideoDataStatistic.setVideoEncodeTypeId(publishId, videoEncodeTypeId);
    }

    public void setVideoEncodeWidth(int publishId, int videoEncodeTypeId) {
        this.mVideoDataStatistic.setVideoEncodeWidth(publishId, videoEncodeTypeId);
    }

    public void setVideoEncodeHeight(int publishId, int videoEncodeTypeId) {
        this.mVideoDataStatistic.setVideoEncodeHeight(publishId, videoEncodeTypeId);
    }

    public void setVideoEncodeDesiredFps(int publishId, int fps) {
        this.mVideoDataStatistic.setVideoEncodeDesiredFps(publishId, fps);
    }

    public void setVideoRealEncodeFps(int publishId, int realFps) {
        if (this.mRealEncodeFpsStatistic != null) {
            this.mRealEncodeFpsStatistic.triggerStatisticCalcBySecond(realFps);
        }
    }

    public void setVideoDesiredEncodeBitrate(int publishId, int bitrate) {
        this.mDesiredEncodeBitrate = bitrate / 1000;
        this.mVideoDataStatistic.setVideoDesiredEncodeBitrate(publishId, bitrate / 1000);
    }

    public void setVideoRealBitrate(int publishId, int bitrate) {
        if (this.mRealEncodeBitrateStatic != null) {
            this.mRealEncodeBitrateStatic.triggerStatisticCalcBySecond(bitrate);
        }
    }

    public void setCaptureType(int type) {
        this.mVideoDataStatistic.setCaptureType(type);
    }

    public synchronized void beginEncode(long pts) {
        long beginTs = System.currentTimeMillis();
        this.mEncodeLatency.put(pts, beginTs);
    }

    public synchronized void endEncode(int publishId, long pts) {
        int latency;
        if (this.mEncodeLatency.get(pts) != null) {
            latency = (int)(System.currentTimeMillis() - this.mEncodeLatency.get(pts));
            this.mEncodeLatencyStatistic.triggerStatistic(latency);
            this.mEncodeLatency.remove(pts);
            if (this.mEncodeLatency.size() > 1000) {
                this.mEncodeLatency.clear();
            }
        }
        if (this.mVideoCapture2EncodeLatency.get(pts) != null) {
            latency = (int)(System.currentTimeMillis() - this.mVideoCapture2EncodeLatency.get(pts));
            this.mVideoCapture2EncodeLatencyStatistic.triggerStatistic(latency);
            this.mVideoCapture2EncodeLatency.remove(pts);
            if (this.mVideoCapture2EncodeLatency.size() > 1000) {
                this.mVideoCapture2EncodeLatency.clear();
            }
        }
    }

    public synchronized void beginCapture2Encode(long pts) {
        long beginCaptureTs = System.currentTimeMillis();
        this.mVideoCapture2EncodeLatency.put(pts, beginCaptureTs);
    }

    public void setVideoPtsMaxDiff(int publishId, long pts) {
        if (this.mPtsStatistic != null) {
            long now = System.currentTimeMillis();
            if (this.mLastPts == 0L) {
                this.mLastPrintTime = now;
                this.mLastPts = pts;
            } else {
                int delta = (int)(pts - this.mLastPts);
                this.mLastPts = pts;
                if (this.mStartResetTime != -1L && System.currentTimeMillis() - this.mStartResetTime < 5000L) {
                    return;
                }
                int n = this.mMaxDeltaPts = this.mMaxDeltaPts < delta ? delta : this.mMaxDeltaPts;
                if (now - this.mLastPrintTime >= 1000L) {
                    this.mLastPrintTime = now;
                    this.mPtsStatistic.triggerStatisticCalcStalling(this.mMaxDeltaPts);
                    this.mMaxDeltaPts = 0;
                }
            }
        }
    }

    public void setVideoPtsDtsMaxDiff(int publishId, int videoPtsDtsMaxDiff) {
        if (this.mPtsDtsStatistic != null) {
            if (this.mStartResetTime != -1L && System.currentTimeMillis() - this.mStartResetTime < 5000L) {
                return;
            }
            this.mPtsDtsStatistic.triggerStatistic(videoPtsDtsMaxDiff);
            if (this.mMaxDeltaPts > 500) {
                YMFLog.info(TAG, "[Procedur]", "setVideoPtsDtsMaxDiff:%d", videoPtsDtsMaxDiff);
            }
        }
    }

    public void setVideoEncodeTimeDiff(int publishId, int videoEncodeTimeDiff) {
        if (this.mEncodeDiffStatistic != null) {
            if (this.isResetVideoEncodeTimeDiff) {
                this.isResetVideoEncodeTimeDiff = false;
                YMFLog.info(TAG, "[Procedur]", "isResetVideoEncodeTimeDiff==true,give up the data");
                return;
            }
            this.mEncodeDiffStatistic.triggerStatistic(videoEncodeTimeDiff);
        }
    }

    public String getUploadVideoStatistics(boolean bKeyStat, int publishId) {
        String result = "";
        if (this.mVideoDataStatistic != null) {
            this.flush(bKeyStat, publishId);
            result = VideoDataStatistic.getUploadVideoStatistics(bKeyStat, publishId);
        }
        return result;
    }

    public String getBaseUploadVideoStatistics(int sendSeq) {
        if (this.mVideoDataStatistic != null) {
            return VideoDataStatistic.getBaseUploadVideoStatistics(sendSeq);
        }
        return "";
    }

    private void flush(boolean bKeyStat, int publishId) {
        if (bKeyStat) {
            VideoStatisticTool.VideoStatisticResult statisticResult;
            if (this.mCaptureDataStatistic != null) {
                this.mCaptureDataStatistic.flush();
                statisticResult = this.mCaptureDataStatistic.getStatisticResult();
                this.mVideoDataStatistic.setCameraCaptureFrameRate(statisticResult.meanCount);
                this.mVideoDataStatistic.setCameraCaptureMeanLatency(statisticResult.meanDeal);
            }
            if (this.mPreProcessStatistic != null) {
                this.mPreProcessStatistic.flush();
                statisticResult = this.mPreProcessStatistic.getStatisticResult();
                this.mVideoDataStatistic.setPreProcessMeanLatency(statisticResult.meanDeal);
                this.mVideoDataStatistic.setPreProcessMaxLatency(statisticResult.maxDeal);
            }
            if (this.mRealEncodeFpsStatistic != null) {
                this.mRealEncodeFpsStatistic.flush();
                statisticResult = this.mRealEncodeFpsStatistic.getStatisticResult();
                this.mVideoDataStatistic.setVideoRealEncodeFps(publishId, statisticResult.meanDeal);
                this.mVideoDataStatistic.setVideoRealMinEncodeFps(publishId, statisticResult.minDeal);
            }
            if (this.mRealEncodeBitrateStatic != null) {
                this.mRealEncodeBitrateStatic.flush();
                statisticResult = this.mRealEncodeBitrateStatic.getStatisticResult();
                this.mVideoDataStatistic.setVideoRealMaxBitrate(publishId, statisticResult.maxDeal);
                this.mVideoDataStatistic.setVideoRealMeanBitrate(publishId, statisticResult.meanDeal);
            }
            if (this.mEncodeLatencyStatistic != null) {
                this.mEncodeLatencyStatistic.flush();
                statisticResult = this.mEncodeLatencyStatistic.getStatisticResult();
                this.mVideoDataStatistic.setVideoEncodeMeanLatency(publishId, statisticResult.meanDeal);
                this.mVideoDataStatistic.setVideoEncodeMaxLatency(publishId, statisticResult.maxDeal);
            }
            if (this.mVideoCapture2EncodeLatencyStatistic != null) {
                this.mVideoCapture2EncodeLatencyStatistic.flush();
                this.mVideoDataStatistic.setVideoCapture2EncodeLatency(publishId, this.mVideoCapture2EncodeLatencyStatistic.getStatisticResult().meanDeal);
            }
            if (this.mPtsStatistic != null) {
                this.mPtsStatistic.flush();
                statisticResult = this.mPtsStatistic.getStatisticResult();
                this.mVideoDataStatistic.setVideoPtsMaxDiff(publishId, statisticResult.maxDeal);
                this.mVideoDataStatistic.setVideoCaptureStallingIndication(publishId, statisticResult.other);
            }
            if (this.mPtsDtsStatistic != null) {
                this.mPtsDtsStatistic.flush();
                this.mVideoDataStatistic.setVideoPtsDtsMaxDiff(publishId, this.mPtsDtsStatistic.getStatisticResult().maxDeal);
            }
            if (this.mEncodeDiffStatistic != null) {
                this.mEncodeDiffStatistic.flush();
                statisticResult = this.mEncodeDiffStatistic.getStatisticResult();
                int diff = -1;
                if (statisticResult.maxDeal > -1 && statisticResult.minDeal > -1) {
                    diff = statisticResult.maxDeal - statisticResult.minDeal;
                }
                this.mVideoDataStatistic.setVideoEncodeTimeDiff(publishId, diff);
            }
        }
    }

    static {
        SYNC_FLAG = new byte[1];
    }
}

