/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mediaframework.stat;

import android.os.Build;
import android.support.annotation.NonNull;
import com.yy.mediaframework.IYYVideoLib2YCloud;
import com.yy.mediaframework.YYVideoSDK;
import com.yy.mediaframework.stat.VideoDataStatUtil;
import com.yy.mediaframework.utils.InfoUtil;
import com.yy.mediaframework.utils.YMFLog;
import java.util.HashMap;
import java.util.LinkedHashMap;

public class VideoLibExceptionDataStat {
    private static final String TAG = "VideoLibExceptionDataStat";
    private static VideoLibExceptionDataStat mInstance;
    private static LinkedHashMap<String, Object> mVideoLibExceptionHashMap;
    private static final String TABLE_NAME = "tableName";
    private static final String TABLE = "mobilevideoexceptionstatist";
    public static final String ENCODE = "0";
    public static final String RENDER = "2";
    private static final String ANCHOR = "0";
    private static final int OS = 1;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static VideoLibExceptionDataStat getInstance() {
        if (mInstance != null) return mInstance;
        Class<VideoLibExceptionDataStat> clazz = VideoLibExceptionDataStat.class;
        synchronized (VideoLibExceptionDataStat.class) {
            if (mInstance != null) return mInstance;
            mInstance = new VideoLibExceptionDataStat();
            // ** MonitorExit[var0] (shouldn't be in output)
            return mInstance;
        }
    }

    private VideoLibExceptionDataStat() {
        this.initInfo();
    }

    @NonNull
    public synchronized void pushDecodeExceptionDataStat(String moduleType, String exceptionID, String exceptionReasion) {
        IYYVideoLib2YCloud iYYVideoLib2YCloud = YYVideoSDK.getInstance().getYYVideoLib2YCloudListener();
        if (iYYVideoLib2YCloud != null) {
            HashMap<String, String> encodeExceptionInfo = new HashMap<String, String>();
            encodeExceptionInfo.put("dr5", exceptionID);
            encodeExceptionInfo.put("dr6", VideoDataStatUtil.toURLEncoded(exceptionReasion));
            mVideoLibExceptionHashMap.put("dr4", VideoDataStatUtil.getVideoEncodeId());
            mVideoLibExceptionHashMap.put("dr7", 1001);
            mVideoLibExceptionHashMap.put("dr3", moduleType);
            mVideoLibExceptionHashMap.put("dr11", VideoDataStatUtil.getCurrentTime());
            mVideoLibExceptionHashMap.put(TABLE_NAME, TABLE);
            mVideoLibExceptionHashMap.putAll(encodeExceptionInfo);
            YMFLog.error((Object)this, "[Procedur]", "exception data:" + mVideoLibExceptionHashMap.toString());
            iYYVideoLib2YCloud.onPassthroughDataUp(2, 1, mVideoLibExceptionHashMap);
        } else {
            YMFLog.error((Object)this, "[Procedur]", "IYYVideoLib2YCloud is null");
        }
    }

    public synchronized void pushDecodeExceptionDataStat(long streamID, HashMap<String, Object> hashMap) {
        IYYVideoLib2YCloud iYYVideoLib2YCloud = YYVideoSDK.getInstance().getYYVideoLib2YCloudListener();
        if (iYYVideoLib2YCloud != null) {
            mVideoLibExceptionHashMap.put("dr4", VideoDataStatUtil.getVideoEncodeId());
            mVideoLibExceptionHashMap.put("dr7", streamID);
            mVideoLibExceptionHashMap.put("dr3", "0");
            mVideoLibExceptionHashMap.put("dr11", VideoDataStatUtil.getCurrentTime());
            mVideoLibExceptionHashMap.put(TABLE_NAME, TABLE);
            mVideoLibExceptionHashMap.putAll(hashMap);
            YMFLog.error((Object)this, "[Procedur]", "exception data:" + mVideoLibExceptionHashMap.toString());
            iYYVideoLib2YCloud.onPassthroughDataUp(2, 1, mVideoLibExceptionHashMap);
        } else {
            YMFLog.error((Object)this, "[Procedur]", "IYYVideoLib2YCloud is null");
        }
    }

    private void initInfo() {
        mVideoLibExceptionHashMap.put("dr1", VideoDataStatUtil.toURLEncoded(VideoDataStatUtil.getAndroidInfo()));
        mVideoLibExceptionHashMap.put("dr2", "0");
        mVideoLibExceptionHashMap.put("dr13", 1);
        mVideoLibExceptionHashMap.put("dr14", InfoUtil.getVersionName());
        mVideoLibExceptionHashMap.put("dr8", VideoDataStatUtil.toURLEncoded(Build.MODEL));
    }

    public void setDecoderPTS(String pts) {
        mVideoLibExceptionHashMap.put("dr9", pts);
    }

    public void setDecoderDTS(String dts) {
        mVideoLibExceptionHashMap.put("dr10", dts);
    }

    public void setDecoderResolution(String resolution) {
        mVideoLibExceptionHashMap.put("dr12", resolution);
    }

    static {
        mVideoLibExceptionHashMap = new LinkedHashMap();
    }

    public static interface RenderExceptionID {
        public static final String INIT_ERROR = "101";
        public static final String RENDER_ERROR = "102";
        public static final String DEINIT_ERROR = "103";
    }

    public static interface EncodeExceptionID {
        public static final String ENCODE_BLOCK = "0";
        public static final String ENCODE_EXCEPTION = "1";
        public static final String ENCODE_INIT_EXCEPTION = "2";
        public static final String ENCODE_RESET_EXCEPTION = "3";
        public static final String ENCODE_PARSE_ERROR = "4";
        public static final String ENCODE_CHANGE_SOFT = "5";
        public static final String ENCODE_STOP_BLOCKED = "6";
    }

    public static interface VideoLibExceptionInfoKey {
        public static final String ENCODER_STATE = "dr0";
        public static final String SYSTEM_INFO = "dr1";
        public static final String VIDEO_TYPE = "dr2";
        public static final String MODULE_TYPE = "dr3";
        public static final String VIDEO_DECODE_ID = "dr4";
        public static final String EXCEPTION_ID = "dr5";
        public static final String EXCEPTION_REASON = "dr6";
        public static final String STREAM_ID = "dr7";
        public static final String MODEL = "dr8";
        public static final String PTS = "dr9";
        public static final String DTS = "dr10";
        public static final String UPLOAD_TIME = "dr11";
        public static final String RESOLUTION = "dr12";
        public static final String OS = "dr13";
        public static final String APP_VERSION = "dr14";
        public static final String LastInputPts = "dr15";
    }
}

