/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mediaframework.stat;

import android.util.SparseArray;
import com.yy.mediaframework.GetAnchorStatInfoInterface;
import com.yy.mediaframework.stat.VideoDataStat;
import com.yy.mediaframework.stat.VideoLibExceptionDataStat;
import com.yy.mediaframework.utils.YMFLog;
import java.util.HashMap;

public class UploadStatManager {
    public static final String TAG = "UploadStatManager ";
    private static volatile UploadStatManager mInstance;
    private long mPreprocessBeginTs = 0L;
    private long mPreprocessTimeMax = 0L;
    private SparseArray<Long> mEncodePts2Begin = new SparseArray();
    private long mEncodeTimeMax = 0L;
    private HashMap<String, Long> mHashMap = new HashMap();
    private static final byte[] SYNC_FLAG;
    private static final int UPLOAD_TIME = 5000;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static synchronized UploadStatManager getInstance() {
        if (mInstance != null) return mInstance;
        byte[] byArray = SYNC_FLAG;
        synchronized (SYNC_FLAG) {
            if (mInstance != null) return mInstance;
            mInstance = new UploadStatManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return mInstance;
        }
    }

    public void startStat() {
        this.mPreprocessTimeMax = 0L;
        this.mEncodeTimeMax = 0L;
        this.mEncodePts2Begin.clear();
        VideoDataStat.getInstance().clear();
    }

    public void stopStat() {
        YMFLog.info(this, "[Encoder ]", "stopStat");
        VideoDataStat.getInstance().clear();
        VideoDataStat.getInstance().clearVideoRenderPtsStatistics();
    }

    public void beginPreprocess() {
        this.mPreprocessBeginTs = System.currentTimeMillis();
    }

    public void endPreprocess() {
        if (this.mPreprocessBeginTs == 0L) {
            return;
        }
        long preprocessTimeTs = System.currentTimeMillis() - this.mPreprocessBeginTs;
        if (preprocessTimeTs > this.mPreprocessTimeMax) {
            this.mPreprocessTimeMax = preprocessTimeTs;
        }
        VideoDataStat.getInstance().putPreprocessTimeArrToStat(preprocessTimeTs);
        VideoDataStat.getInstance().putPreprocessTimeMaxToStat(this.mPreprocessTimeMax);
    }

    public void beginEncode(int pts) {
        long beginTs = System.currentTimeMillis();
        this.mEncodePts2Begin.put(pts, (Object)beginTs);
    }

    public void endEncode(int pts) {
        if (pts <= 0) {
            return;
        }
        Long encodeBeginTs = (Long)this.mEncodePts2Begin.get(pts);
        if (encodeBeginTs == null) {
            return;
        }
        long encodeTimeTs = System.currentTimeMillis() - encodeBeginTs;
        if (encodeTimeTs > this.mEncodeTimeMax) {
            this.mEncodeTimeMax = encodeTimeTs;
        }
        VideoDataStat.getInstance().putTimeAVGToStat(encodeTimeTs);
        VideoDataStat.getInstance().putTimeMAXToStat(this.mEncodeTimeMax);
    }

    public void reportEncException(HashMap<String, Object> hashMap) {
        VideoLibExceptionDataStat.getInstance().pushDecodeExceptionDataStat(1001L, hashMap);
    }

    public void reportException(String moduleType, String exceptionID, String exceptionReasion) {
        long itme;
        Long object;
        if (this.mHashMap != null && (object = this.mHashMap.get(exceptionID)) != null && (itme = System.currentTimeMillis() - object) < 5000L) {
            return;
        }
        this.mHashMap.put(exceptionID, System.currentTimeMillis());
        VideoLibExceptionDataStat.getInstance().pushDecodeExceptionDataStat(moduleType, exceptionID, exceptionReasion);
    }

    public void setDecoderResolution(String resolution) {
        VideoLibExceptionDataStat.getInstance().setDecoderResolution(resolution);
    }

    public void putVideoEncodeIdToStat(int videoEncodeId) {
        VideoDataStat.getInstance().putVideoEncodeIdToStat(videoEncodeId);
    }

    public void putSettingFrameRate(int FrameRate) {
        VideoDataStat.getInstance().putSettingFrameRate(FrameRate);
    }

    public void putSettingBitRate(int BitRate) {
        VideoDataStat.getInstance().putSettingBitRate(BitRate);
    }

    public void putSettingDPI(String RealDPI) {
        VideoDataStat.getInstance().putSettingDPI(RealDPI);
    }

    public void putVideoPsnr(double psnr) {
        VideoDataStat.getInstance().putVideoPsnr(psnr);
    }

    public void setIGetCurrentCameraStatInfo(GetAnchorStatInfoInterface.IGetCurrentCameraEncodeStatInfo iGetCarameStatInfo) {
        VideoDataStat.getInstance().setIGetCurrentCameraStatInfo(iGetCarameStatInfo);
    }

    public void setIGetImageFilterInfo(GetAnchorStatInfoInterface.IGetImageFilterInfo iGetImageFilterInfo) {
        VideoDataStat.getInstance().setIGetImageFilterInfo(iGetImageFilterInfo);
    }

    static {
        SYNC_FLAG = new byte[1];
    }
}

