/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mediaframework.stat;

import com.yy.mediaframework.stat.IEncodeParamListener;
import java.lang.ref.WeakReference;
import java.util.concurrent.atomic.AtomicBoolean;

public class LocalEncodeParamTipsMgr {
    private WeakReference<IEncodeParamListener> mParamListenerRef = new WeakReference<Object>(null);
    private volatile LocalEncodeParamTipsMgr singleton;
    private String mBasicParam = "";
    private AtomicBoolean mHasBFrame = new AtomicBoolean(false);
    private int mCodeRateKbps = 0;

    public void setParamListener(IEncodeParamListener listener) {
        this.mParamListenerRef = new WeakReference<IEncodeParamListener>(listener);
    }

    public void setHasBFrame(boolean enable) {
        if (this.mHasBFrame.getAndSet(enable) != enable) {
            this.notifyParamChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCodeRate(int kbps) {
        boolean update = false;
        LocalEncodeParamTipsMgr localEncodeParamTipsMgr = this;
        synchronized (localEncodeParamTipsMgr) {
            if (this.mCodeRateKbps != kbps) {
                this.mCodeRateKbps = kbps;
                update = true;
            }
        }
        if (update) {
            this.notifyParamChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setEncoderParam(String param) {
        LocalEncodeParamTipsMgr localEncodeParamTipsMgr = this;
        synchronized (localEncodeParamTipsMgr) {
            this.mBasicParam = param;
            this.mHasBFrame.set(false);
            this.mCodeRateKbps = 0;
        }
        this.notifyParamChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNoEncoder() {
        LocalEncodeParamTipsMgr localEncodeParamTipsMgr = this;
        synchronized (localEncodeParamTipsMgr) {
            this.mBasicParam = "no encode";
            this.mHasBFrame.set(false);
            this.mCodeRateKbps = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getParam() {
        StringBuilder sb = new StringBuilder();
        LocalEncodeParamTipsMgr localEncodeParamTipsMgr = this;
        synchronized (localEncodeParamTipsMgr) {
            sb.append(this.mBasicParam);
            if (this.mHasBFrame.get()) {
                sb.append(":haveBFrame:true");
            }
            if (this.mCodeRateKbps != 0) {
                sb.append(":realCodeRate:").append(this.mCodeRateKbps).append("kbps");
            }
        }
        return sb.toString();
    }

    private void notifyParamChanged() {
        IEncodeParamListener listener = (IEncodeParamListener)this.mParamListenerRef.get();
        if (listener != null) {
            listener.encodeParamChanged(this.getParam());
        }
    }
}

