/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mediaframework.screenshot;

import android.content.Context;
import android.graphics.Bitmap;
import android.opengl.GLES20;
import com.yy.mediaframework.filters.VideoLiveFilterContext;
import com.yy.mediaframework.gpuimage.adapter.GlTextureImageReader;
import com.yy.mediaframework.model.YYMediaSample;
import com.yy.mediaframework.screenshot.ScreenShotCallback;
import com.yy.mediaframework.utils.YMFLog;
import java.lang.ref.WeakReference;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import javax.microedition.khronos.opengles.GL10;

public class ScreenShot {
    private int mState;
    private WeakReference<ScreenShotCallback> mScreenShotCallbackRef = null;
    private GlTextureImageReader mImageReader = null;
    private Context mContext = null;
    private VideoLiveFilterContext mVideoLiveFilterContext = null;
    private Object mSyncObject = new Object();

    public ScreenShot(Context ctx, VideoLiveFilterContext videoLiveFilterContext) {
        this.mContext = ctx.getApplicationContext();
        this.mVideoLiveFilterContext = videoLiveFilterContext;
    }

    public void deInit() {
        if (this.mImageReader != null) {
            this.mImageReader.destroy();
            this.mImageReader = null;
        }
    }

    public boolean processMediaSample(YYMediaSample sample) {
        if (this.mState == 2) {
            YMFLog.info(this, "[SCapture]", "processMediaSample take snapshot, width:" + sample.mWidth + " height:" + sample.mHeight);
        }
        if (this.mScreenShotCallbackRef != null) {
            this.take2(sample.mWidth, sample.mHeight);
        }
        return false;
    }

    private void takeWithPbo(YYMediaSample sample) {
        if (this.mState == 2) {
            this.mState = 1;
            try {
                if (this.mImageReader == null) {
                    this.mImageReader = new GlTextureImageReader(this.mContext, sample.mWidth, sample.mHeight);
                }
                this.mImageReader.checkImageSize(sample.mWidth, sample.mHeight);
                byte[] images = this.mImageReader.read(sample.mMasterTextureId, sample.mWidth, sample.mHeight);
                if (images != null) {
                    ByteBuffer imageBuf = ByteBuffer.wrap(images);
                    Bitmap bitmap = Bitmap.createBitmap((int)sample.mWidth, (int)sample.mHeight, (Bitmap.Config)Bitmap.Config.ARGB_8888);
                    bitmap.copyPixelsFromBuffer((Buffer)imageBuf);
                    this.mState = 0;
                    this.notifyBitmap(bitmap);
                }
            }
            catch (Throwable t) {
                YMFLog.error((Object)this, "[SCapture]", "takeWithPbo exception: " + t.toString());
                this.notifyError(t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCallback(ScreenShotCallback callback) {
        Object object = this.mSyncObject;
        synchronized (object) {
            if (callback == null) {
                return;
            }
            this.mScreenShotCallbackRef = new WeakReference<ScreenShotCallback>(callback);
            if (this.mState == 0) {
                this.mState = 2;
            }
            YMFLog.info(this, "[SCapture]", "screenshot start, mScreenShotCallbackRef:" + this.mScreenShotCallbackRef);
        }
    }

    public void take(GL10 gl, int width, int height) {
        if (this.mState == 2) {
            this.mState = 1;
            try {
                int[] bitmapBuffer = new int[width * height];
                int[] bitmapSource = new int[width * height];
                IntBuffer intBuffer = IntBuffer.wrap(bitmapBuffer);
                intBuffer.position(0);
                gl.glReadPixels(0, 0, width, height, 6408, 5121, (Buffer)intBuffer);
                for (int i = 0; i < height; ++i) {
                    for (int j = 0; j < width; ++j) {
                        int pix1;
                        int pix = bitmapBuffer[i * width + j];
                        int pb = pix >> 16 & 0xFF;
                        int pr = pix << 16 & 0xFF0000;
                        bitmapSource[(height - i - 1) * width + j] = pix1 = pix & 0xFF00FF00 | pr | pb;
                    }
                }
                Bitmap bitmap = Bitmap.createBitmap((int[])bitmapSource, (int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
                this.mState = 0;
                this.notifyBitmap(bitmap);
            }
            catch (Throwable e) {
                this.notifyError(e);
            }
        }
    }

    public void take(int width, int height) {
        if (this.mState == 2) {
            this.mState = 1;
            try {
                int[] bitmapBuffer = new int[width * height];
                int[] bitmapSource = new int[width * height];
                IntBuffer intBuffer = IntBuffer.wrap(bitmapBuffer);
                intBuffer.position(0);
                GLES20.glReadPixels((int)0, (int)0, (int)width, (int)height, (int)6408, (int)5121, (Buffer)intBuffer);
                for (int i = 0; i < height; ++i) {
                    for (int j = 0; j < width; ++j) {
                        int pix1;
                        int pix = bitmapBuffer[i * width + j];
                        int pb = pix >> 16 & 0xFF;
                        int pr = pix << 16 & 0xFF0000;
                        bitmapSource[(height - i - 1) * width + j] = pix1 = pix & 0xFF00FF00 | pr | pb;
                    }
                }
                Bitmap bitmap = Bitmap.createBitmap((int[])bitmapSource, (int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
                this.mState = 0;
                this.notifyBitmap(bitmap);
            }
            catch (Throwable e) {
                this.notifyError(e);
            }
        }
    }

    public void take2(int width, int height) {
        if (this.mState == 2) {
            this.mState = 1;
            try {
                ByteBuffer byteBuffer = ByteBuffer.allocateDirect(width * height * 4);
                byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
                GLES20.glReadPixels((int)0, (int)0, (int)width, (int)height, (int)6408, (int)5121, (Buffer)byteBuffer);
                if (this.mScreenShotCallbackRef != null) {
                    Bitmap bitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
                    bitmap.copyPixelsFromBuffer((Buffer)byteBuffer);
                    this.notifyBitmap(bitmap);
                }
                this.mState = 0;
                this.mScreenShotCallbackRef = null;
            }
            catch (Throwable e) {
                this.notifyError(e);
            }
        }
    }

    public void take2RGBA(int width, int height) {
        if (this.mState == 2) {
            this.mState = 1;
            try {
                YMFLog.info(this, "[SCapture]", "faceShot start...");
                byte[] rgbaImgData = new byte[width * height * 4];
                ByteBuffer byteBuffer = ByteBuffer.wrap(rgbaImgData, 0, rgbaImgData.length);
                byteBuffer.position(0);
                byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
                GLES20.glReadPixels((int)0, (int)0, (int)width, (int)height, (int)6408, (int)5121, (Buffer)byteBuffer);
                this.mState = 0;
            }
            catch (Throwable e) {
                this.notifyError(e);
            }
        }
    }

    public void notifyBitmap(Bitmap bitmap) {
        ScreenShotCallback callback;
        if (this.mScreenShotCallbackRef != null && (callback = (ScreenShotCallback)this.mScreenShotCallbackRef.get()) != null) {
            callback.onTaked(bitmap);
        }
    }

    public void notifyError(Throwable e) {
        ScreenShotCallback callback;
        if (this.mScreenShotCallbackRef != null && (callback = (ScreenShotCallback)this.mScreenShotCallbackRef.get()) != null) {
            callback.onError(e);
            YMFLog.info(this, "[SCapture]", "screenshot exception:" + e.toString());
        }
    }
}

