/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mediaframework.screenlive;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Matrix;
import android.graphics.RectF;
import android.hardware.display.VirtualDisplay;
import android.media.projection.MediaProjection;
import android.util.DisplayMetrics;
import android.view.Surface;
import android.view.WindowManager;
import com.yy.mediaframework.IEncoderListener;
import com.yy.mediaframework.ILiveSession;
import com.yy.mediaframework.YYVideoSDK;
import com.yy.mediaframework.base.VideoEncoderConfig;
import com.yy.mediaframework.base.VideoEncoderType;
import com.yy.mediaframework.base.YYUserLiveConfig;
import com.yy.mediaframework.filters.ClipFilter;
import com.yy.mediaframework.filters.GPUPreprocessFilter;
import com.yy.mediaframework.filters.GlLoadImageFilter;
import com.yy.mediaframework.filters.ImageCaptureFilter;
import com.yy.mediaframework.filters.LiveSessionType;
import com.yy.mediaframework.filters.ScreenCaptureFilter;
import com.yy.mediaframework.filters.VideoEncoderGroupFilter;
import com.yy.mediaframework.filters.VideoEndPointFilter;
import com.yy.mediaframework.filters.VideoLiveFilterContext;
import com.yy.mediaframework.inteligence.common.ResolutionModifyConfig;
import com.yy.mediaframework.inteligence.dynamictexture.IDynamicTexture;
import com.yy.mediaframework.screenlive.ScreenSurfaceCallback;
import com.yy.mediaframework.screenshot.ScreenShot;
import com.yy.mediaframework.screenshot.ScreenShotCallback;
import com.yy.mediaframework.stat.UploadStatManager;
import com.yy.mediaframework.utils.YMFLog;
import com.yy.mediaframework.watermark.WaterMark;
import java.lang.ref.WeakReference;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;

@TargetApi(value=21)
public class ScreenLiveSessionYCloud
implements IEncoderListener,
ILiveSession,
ScreenSurfaceCallback {
    private static final String TAG = "[ScreenLiveSessionYCloud]";
    private GPUPreprocessFilter mPreprocessFilter;
    private VideoEncoderGroupFilter mEncoderGroupFilter;
    private VideoLiveFilterContext mFilterContext;
    private WeakReference<IEncoderListener> mEncoderListener = new WeakReference<Object>(null);
    private AtomicBoolean mHardwareEncoderAvailable = new AtomicBoolean(true);
    private long mLastCountTime = 0L;
    private ScreenCaptureFilter mScreenCaptureFilter;
    private ImageCaptureFilter mImageCaptureFilter;
    private ClipFilter mCliperFilter;
    private GlLoadImageFilter mGlLoadImageFilter;
    private VideoEndPointFilter mEndPointFilter;
    private Surface mSurface;
    private VirtualDisplay mVirtualDisplay;
    private MediaProjection mMediaProjection;
    private float mWaterMakeW = 0.0f;
    private float mWaterMakeH = 0.0f;
    private float mWaterMakeX = 0.0f;
    private float mWaterMakeY = 0.0f;
    private Bitmap mWaterMarkBitmap;
    private VideoEncoderConfig mVideoEncoderConfig = new VideoEncoderConfig();

    public ScreenLiveSessionYCloud(Context context, int type) {
        YMFLog.info(this, "[Procedur]", "ScreenLiveSessionYCloud construct begin");
        this.mFilterContext = new VideoLiveFilterContext(context, type);
        this.mFilterContext.setLiveMode(LiveSessionType.LIVE_MODE_SCREEN_RECORD);
        this.mFilterContext.setAndroidContext(context);
        this.mPreprocessFilter = new GPUPreprocessFilter(this.mFilterContext);
        this.mEncoderGroupFilter = new VideoEncoderGroupFilter(this.mFilterContext, this);
        this.mEncoderGroupFilter.setEncoderListener(this);
        this.getScreenBaseInfo(context);
        this.mFilterContext.setScreenShot(new ScreenShot(context, this.mFilterContext));
        this.mScreenCaptureFilter = new ScreenCaptureFilter(this.mFilterContext, context.getApplicationContext());
        this.mScreenCaptureFilter.addScreenSurfaceCallback(this);
        this.mCliperFilter = new ClipFilter();
        this.mGlLoadImageFilter = new GlLoadImageFilter();
        this.mImageCaptureFilter = new ImageCaptureFilter(this.mFilterContext, 3);
        this.mEndPointFilter = new VideoEndPointFilter(this.mFilterContext);
        this.mPreprocessFilter.addDownStream(this.mCliperFilter.addDownStream(this.mEncoderGroupFilter));
        this.mScreenCaptureFilter.addDownStream(this.mPreprocessFilter).addDownStream(this.mEndPointFilter);
        this.mImageCaptureFilter.addDownStream(this.mGlLoadImageFilter.addDownStream(this.mCliperFilter));
        this.mFilterContext.getGlManager().registerFilter(this.mPreprocessFilter);
        this.mFilterContext.getGlManager().registerFilter(this.mEncoderGroupFilter);
        this.mFilterContext.getGlManager().registerFilter(this.mScreenCaptureFilter);
        this.mFilterContext.getGlManager().registerFilter(this.mImageCaptureFilter);
        this.mFilterContext.getGlManager().registerFilter(this.mGlLoadImageFilter);
        this.mFilterContext.getGlManager().registerFilter(this.mPreprocessFilter);
        this.mFilterContext.getGlManager().registerFilter(this.mCliperFilter);
        this.mFilterContext.getGlManager().registerFilter(this.mEncoderGroupFilter);
        this.mFilterContext.getGlManager().registerFilter(this.mEndPointFilter);
        YMFLog.info(this, "[Procedur]", "ScreenLiveSessionYCloud construct done");
    }

    @Override
    public void startEncoder() {
        YMFLog.info(this, "[Encoder ]", "startEncoder...");
        this.mFilterContext.getGLManager().post(new Runnable(){

            @Override
            public void run() {
                YYUserLiveConfig userLiveConfig = ScreenLiveSessionYCloud.this.mFilterContext.getUserLiveConfig();
                if (ScreenLiveSessionYCloud.this.mEncoderGroupFilter.isEnable()) {
                    YMFLog.info(this, "[Encoder ]", "encoder is started already!!");
                } else {
                    boolean res = ScreenLiveSessionYCloud.this.mEncoderGroupFilter.startEncode(ScreenLiveSessionYCloud.this.mFilterContext.getVideoEncoderConfig());
                    if (res) {
                        UploadStatManager.getInstance().startStat();
                    }
                }
            }
        });
    }

    @Override
    public void stopEncoder() {
        YMFLog.info(this, "[Encoder ]", "stopEncoder...");
        this.mFilterContext.getGLManager().post(new Runnable(){

            @Override
            public void run() {
                UploadStatManager.getInstance().stopStat();
                if (ScreenLiveSessionYCloud.this.mEncoderGroupFilter.isEnable()) {
                    ScreenLiveSessionYCloud.this.mEncoderGroupFilter.stopEncode();
                }
            }
        });
    }

    @Override
    public void setEncoderConfig(VideoEncoderConfig config) {
        this.mVideoEncoderConfig = config;
        if (this.mFilterContext.isEmulator()) {
            this.mVideoEncoderConfig.mEncodeType = VideoEncoderType.SOFT_ENCODER_X264;
        }
        this.mFilterContext.getGLManager().post(new Runnable(){

            @Override
            public void run() {
                ScreenLiveSessionYCloud.this.mFilterContext.getVideoEncoderConfig().assign(ScreenLiveSessionYCloud.this.mVideoEncoderConfig);
                YMFLog.info(this, "[Encoder ]", "setEncoderConfig:" + ScreenLiveSessionYCloud.this.mFilterContext.getVideoEncoderConfig().toString());
                ScreenLiveSessionYCloud.this.mFilterContext.getDefaultVideoEncoderConfig().assign(ScreenLiveSessionYCloud.this.mVideoEncoderConfig);
                ScreenLiveSessionYCloud.this.mPreprocessFilter.init(ScreenLiveSessionYCloud.this.mVideoEncoderConfig.getEncodeWidth(), ScreenLiveSessionYCloud.this.mVideoEncoderConfig.getEncodeHeight());
                ScreenLiveSessionYCloud.this.mEncoderGroupFilter.init();
            }
        });
    }

    @Override
    public void setEncoderListener(final IEncoderListener listener) {
        if (listener == null) {
            YMFLog.info(this, "[Encoder ]", "set encodelistener:" + listener);
            this.mEncoderListener = new WeakReference<IEncoderListener>(listener);
            if (listener != null) {
                listener.onEncodeEncParam(this.mFilterContext.getEncodeParamTipsMgr().getParam());
            }
        } else {
            this.mFilterContext.getGLManager().post(new Runnable(){

                @Override
                public void run() {
                    YMFLog.info(this, "[Encoder ]", "set encodelistener:" + listener);
                    ScreenLiveSessionYCloud.this.mEncoderListener = new WeakReference<IEncoderListener>(listener);
                    if (listener != null) {
                        listener.onEncodeEncParam(ScreenLiveSessionYCloud.this.mFilterContext.getEncodeParamTipsMgr().getParam());
                    }
                }
            });
        }
    }

    public void setWaterMark(final WaterMark waterMark) {
        YMFLog.info(this, "[Beauty  ]", "setWaterMark, waterMark==null? " + (waterMark == null ? "y" : "n"));
        this.mFilterContext.getGLManager().post(new Runnable(){

            @Override
            public void run() {
                ScreenLiveSessionYCloud.this.mFilterContext.setWaterMarkTexture(waterMark);
            }
        });
    }

    @Override
    public void setWaterMark(Bitmap bitmap, int offsetX, int offsetY) {
        if (this.mVideoEncoderConfig == null) {
            return;
        }
        YMFLog.info(this, "[Beauty  ]", "setWaterMark, bitmap==null? " + (bitmap == null ? "y" : "n") + "<" + offsetX + "." + offsetY + ">");
        this.mWaterMarkBitmap = bitmap;
        if (bitmap == null) {
            this.setWaterMark(null);
            return;
        }
        if (bitmap != null && bitmap != null && (bitmap.getWidth() + offsetX > this.mVideoEncoderConfig.mEncodeWidth || bitmap.getHeight() + offsetY > this.mVideoEncoderConfig.mEncodeHeight)) {
            YMFLog.error((Object)this, "[Encoder ]", "setWaterMark error:" + bitmap.getWidth() + "+" + offsetX + ">" + this.mVideoEncoderConfig.mEncodeWidth + " OR " + bitmap.getHeight() + "+" + offsetY + ">" + this.mVideoEncoderConfig.mEncodeHeight);
            this.setWaterMark(null);
            return;
        }
        this.mWaterMakeX = (float)offsetX / (float)this.mVideoEncoderConfig.mEncodeWidth;
        this.mWaterMakeY = (float)offsetY / (float)this.mVideoEncoderConfig.mEncodeHeight;
        this.mWaterMakeW = (float)bitmap.getWidth() / (float)this.mVideoEncoderConfig.mEncodeWidth;
        this.mWaterMakeH = (float)bitmap.getHeight() / (float)this.mVideoEncoderConfig.mEncodeHeight;
        int x = (int)((float)this.mVideoEncoderConfig.mEncodeWidth * this.mWaterMakeX);
        int y = (int)((float)this.mVideoEncoderConfig.mEncodeHeight * this.mWaterMakeY);
        int w = (int)((float)this.mVideoEncoderConfig.mEncodeWidth * this.mWaterMakeW);
        int h = (int)((float)this.mVideoEncoderConfig.mEncodeHeight * this.mWaterMakeH);
        float scaleWidth = (float)w / (float)this.mWaterMarkBitmap.getWidth();
        float scaleHeight = (float)h / (float)this.mWaterMarkBitmap.getHeight();
        Matrix matrix = new Matrix();
        matrix.postScale(scaleWidth, scaleHeight);
        Bitmap newBM = Bitmap.createBitmap((Bitmap)this.mWaterMarkBitmap, (int)0, (int)0, (int)this.mWaterMarkBitmap.getWidth(), (int)this.mWaterMarkBitmap.getHeight(), (Matrix)matrix, (boolean)false);
        WaterMark waterMark = new WaterMark(newBM, this.mVideoEncoderConfig.mEncodeWidth, this.mVideoEncoderConfig.mEncodeHeight, x, y, WaterMark.Align.LeftTop);
        this.setWaterMark(waterMark);
    }

    @Override
    public void setDynamicTexture(final IDynamicTexture dynamicTexture) {
        this.mFilterContext.getGLManager().post(new Runnable(){

            @Override
            public void run() {
                ScreenLiveSessionYCloud.this.mFilterContext.setDynamicTexture(dynamicTexture);
            }
        });
    }

    @Override
    public void setNetworkBitrateSuggest(final int bitrate) {
        YMFLog.info(this, "[Encoder ]", "setNetworkBitrateSuggest:" + bitrate);
        this.mFilterContext.getGLManager().post(new Runnable(){

            @Override
            public void run() {
                ScreenLiveSessionYCloud.this.mEncoderGroupFilter.setNetworkBitrateSuggest(bitrate);
            }
        });
    }

    @Override
    public void adjustEncoderBitrate(int bitRate) {
        if (this.mEncoderGroupFilter != null) {
            YMFLog.info(this, "[Encoder ]", "setNetworkBitrateSuggest:" + bitRate);
            this.mEncoderGroupFilter.adjustBitRate((bitRate + 999) / 1000);
        }
    }

    @Override
    public void requestIFrame() {
        YMFLog.info(this, "[Encoder ]", "requestIFrame");
        this.mFilterContext.getGLManager().post(new Runnable(){

            @Override
            public void run() {
                if (ScreenLiveSessionYCloud.this.mEncoderGroupFilter != null) {
                    ScreenLiveSessionYCloud.this.mEncoderGroupFilter.requestSyncFrame();
                }
            }
        });
    }

    @Override
    public void setLowDelayMode(final boolean enable) {
        this.mFilterContext.getGLManager().post(new Runnable(){

            @Override
            public void run() {
                ((ScreenLiveSessionYCloud)ScreenLiveSessionYCloud.this).mFilterContext.getVideoEncoderConfig().mLowDelay = enable;
                YMFLog.info(this, "[Encoder ]", "setLowDelayMode:" + enable + " config:" + ScreenLiveSessionYCloud.this.mFilterContext.getVideoEncoderConfig().toString());
            }
        });
    }

    @Override
    public void setResolutionModifyConfigs(final List<ResolutionModifyConfig> configs, final int intervalSecs) {
        this.mFilterContext.getGlManager().post(new Runnable(){

            @Override
            public void run() {
                if (ScreenLiveSessionYCloud.this.mFilterContext.isEmulator()) {
                    for (ResolutionModifyConfig config : configs) {
                        config.videoEncoderType = VideoEncoderType.SOFT_ENCODER_X264;
                        config.encoderParams = "";
                    }
                }
                ScreenLiveSessionYCloud.this.mEncoderGroupFilter.setResolutionModifyConfigs(configs, intervalSecs);
            }
        });
    }

    @Override
    public void setHardwareEncoderAvailable(boolean available) {
        YMFLog.info(this, "[Encoder ]", "HardwareEncoderAvailable set status:" + available);
        this.mHardwareEncoderAvailable.set(available);
    }

    @Override
    public boolean isHardwareEncoderAvailable() {
        YMFLog.info(this, "[Encoder ]", "HardwareEncoderAvailable get status:" + this.mHardwareEncoderAvailable.get());
        return this.mHardwareEncoderAvailable.get();
    }

    @Override
    public void onEncodeStat(int bitRate, int frameRate) {
        IEncoderListener listener = (IEncoderListener)this.mEncoderListener.get();
        if (listener != null) {
            listener.onEncodeStat(bitRate, frameRate);
        }
    }

    @Override
    public void onEncodeResolution(int width, int height) {
        IEncoderListener listener = (IEncoderListener)this.mEncoderListener.get();
        if (listener != null) {
            listener.onEncodeResolution(width, height);
        }
    }

    @Override
    public void onEncodeFirstFrame() {
        IEncoderListener listener = (IEncoderListener)this.mEncoderListener.get();
        if (listener != null) {
            listener.onEncodeFirstFrame();
        }
    }

    @Override
    public void onEncodeFrameData(byte[] data, int len, long pts, long dts, int frameType, VideoEncoderType encodeType, int svcTid, int svcSid) {
        IEncoderListener listener = (IEncoderListener)this.mEncoderListener.get();
        if (System.currentTimeMillis() - this.mLastCountTime >= 6000L) {
            this.mLastCountTime = System.currentTimeMillis();
            YMFLog.info(this, "[Encoder ]", "onEncodeFrameData, listener:" + listener);
        }
        if (listener != null) {
            listener.onEncodeFrameData(data, len, pts, dts, frameType, encodeType, svcTid, svcSid);
        }
    }

    @Override
    public void onEncodeEncParam(String param) {
        IEncoderListener listener = (IEncoderListener)this.mEncoderListener.get();
        if (listener != null) {
            listener.onEncodeEncParam(param);
        }
    }

    @Override
    public void onHardEncoderError() {
        IEncoderListener listener = (IEncoderListener)this.mEncoderListener.get();
        if (listener != null) {
            listener.onHardEncoderError();
        }
        YMFLog.info(this, "[Encoder ]", "onHardEncoderError in ScreenLiveSessionYCloud");
    }

    @Override
    public void onEncoderSwitch() {
    }

    @Override
    public void onWaterMarkSizeChange(int w, int h) {
        YMFLog.info(this, "[Beauty  ]", "onWaterMarkSizeChange w:" + w + " h:" + h + "(" + this.mWaterMakeX + "," + this.mWaterMakeY + "," + this.mWaterMakeW + "," + this.mWaterMakeH + ")");
        if ((double)this.mWaterMakeH == 0.0 || (double)this.mWaterMakeW == 0.0 || this.mWaterMarkBitmap == null) {
            return;
        }
        int waterX = (int)((float)w * this.mWaterMakeX);
        int waterY = (int)((float)h * this.mWaterMakeY);
        int waterW = (int)((float)w * this.mWaterMakeW);
        int waterH = (int)((float)h * this.mWaterMakeH);
        float scaleWidth = (float)waterW / (float)this.mWaterMarkBitmap.getWidth();
        float scaleHeight = (float)waterH / (float)this.mWaterMarkBitmap.getHeight();
        Matrix matrix = new Matrix();
        matrix.postScale(scaleWidth, scaleHeight);
        Bitmap newBM = Bitmap.createBitmap((Bitmap)this.mWaterMarkBitmap, (int)0, (int)0, (int)this.mWaterMarkBitmap.getWidth(), (int)this.mWaterMarkBitmap.getHeight(), (Matrix)matrix, (boolean)false);
        WaterMark waterMark = new WaterMark(newBM, w, h, waterX, waterY, WaterMark.Align.LeftTop);
        this.setWaterMark(waterMark);
    }

    public void startCapture(MediaProjection mediaProjection) {
        YMFLog.info(this, "[SCapture]", "startCapture...");
        this.mMediaProjection = mediaProjection;
        this.mFilterContext.getGLManager().post(new Runnable(){

            @Override
            public void run() {
                ScreenLiveSessionYCloud.this.mScreenCaptureFilter.init();
                ScreenLiveSessionYCloud.this.mImageCaptureFilter.init();
                ScreenLiveSessionYCloud.this.mScreenCaptureFilter.startCapture();
            }
        });
    }

    public void stopCapture() {
        this.mMediaProjection = null;
        YMFLog.info(this, "[SCapture]", "stopCapture...");
        this.mFilterContext.getGLManager().post(new Runnable(){

            @Override
            public void run() {
                ScreenLiveSessionYCloud.this.mScreenCaptureFilter.deInit();
                ScreenLiveSessionYCloud.this.mImageCaptureFilter.deInit();
                ScreenLiveSessionYCloud.this.mScreenCaptureFilter.stopCapture();
            }
        });
    }

    @Override
    public void stopAndRelease() {
        YMFLog.info(this, "[SCapture]", "ScreenLiveSessionYCloud stopAndRelease begin");
        this.mScreenCaptureFilter.stopCapture();
        this.mFilterContext.getGLManager().getHandler().removeCallbacksAndMessages(null);
        this.mFilterContext.getGLManager().post(new Runnable(){

            @Override
            public void run() {
                if (ScreenLiveSessionYCloud.this.mFilterContext.getScreenShot() != null) {
                    ScreenLiveSessionYCloud.this.mFilterContext.getScreenShot().deInit();
                }
                if (ScreenLiveSessionYCloud.this.mFilterContext.getDynamicTexture() != null) {
                    ScreenLiveSessionYCloud.this.mFilterContext.getDynamicTexture().onRelease();
                    ScreenLiveSessionYCloud.this.mFilterContext.setDynamicTexture(null);
                }
                if (ScreenLiveSessionYCloud.this.mFilterContext.getWaterMarkTexture() != null) {
                    ScreenLiveSessionYCloud.this.mFilterContext.getWaterMarkTexture().destroy();
                    ScreenLiveSessionYCloud.this.mFilterContext.setWaterMarkTexture(null);
                }
                UploadStatManager.getInstance().stopStat();
                ScreenLiveSessionYCloud.this.mFilterContext.getGLManager().quit();
            }
        });
        YMFLog.info(this, "[SCapture]", "ScreenLiveSessionYCloud stopAndRelease done");
    }

    public void setCaptureResolution(final int width, final int height) {
        YMFLog.info(this, "[SCapture]", " setCaptureResolution, width:" + width + " ,height:" + height);
        this.mFilterContext.getGlManager().post(new Runnable(){

            @Override
            public void run() {
                ScreenLiveSessionYCloud.this.mFilterContext.getScreenRecordConfig().setScreenSize(width, height);
            }
        });
    }

    public void imageFrameAvailable(ByteBuffer buffer, int width, int height, int imageFormat) {
        if (this.mImageCaptureFilter != null) {
            buffer.position(0);
            this.mImageCaptureFilter.onImageAvailable(buffer, width, height, imageFormat);
        }
    }

    @Override
    public void takeScreenShot(ScreenShotCallback callback) {
        this.mFilterContext.getScreenShot().setCallback(callback);
    }

    public void setSelfMode(boolean isSelfMode) {
        YMFLog.info(this, "[SCapture]", "setSelfMode,isSelfMode:" + isSelfMode);
        if (!isSelfMode) {
            this.mScreenCaptureFilter.startCapture();
        } else {
            this.mScreenCaptureFilter.stopCapture();
        }
    }

    public void setScreenCropArea(RectF rectF) {
        YMFLog.info(this, "[SCapture]", "setScreenCropArea...rectF:" + rectF + " ,mScreenCaptureFilter:" + this.mScreenCaptureFilter);
        if (this.mScreenCaptureFilter != null) {
            this.mScreenCaptureFilter.setScreenCropArea(rectF);
        }
    }

    public void setDeltaYYPtsMillions(final long deltaPtsDts) {
        YMFLog.info(this, "[Encoder ]", "setDeltaYYPtsMillions:" + deltaPtsDts);
        this.mFilterContext.getGlManager().post(new Runnable(){

            @Override
            public void run() {
                YYVideoSDK.getInstance().setDeltaYYPtsMillions(deltaPtsDts);
            }
        });
    }

    @Override
    public void surfaceCreated(Surface surface) {
        YMFLog.info(this, "[Preview ]", "surfaceCreated");
        this.mSurface = surface;
        if (this.mVirtualDisplay == null) {
            YMFLog.info(this, "[Preview ]", "createVirtualDisplay, width:" + this.mFilterContext.mVirtualDisplayWidth + " , height:" + this.mFilterContext.mVirtualDisplayHeight);
            this.mVirtualDisplay = this.mMediaProjection.createVirtualDisplay(this.getClass().getName(), this.mFilterContext.mVirtualDisplayWidth, this.mFilterContext.mVirtualDisplayHeight, this.mFilterContext.mScreenDensityDpi, 16, this.mSurface, null, null);
        }
    }

    @Override
    public void detachSurface() {
        this.mVirtualDisplay.setSurface(null);
    }

    @Override
    public void attachSurface(Surface surface) {
        this.mVirtualDisplay.setSurface(surface);
    }

    @Override
    public void surfaceChange(Surface surface) {
        this.mVirtualDisplay.resize(this.mFilterContext.mVirtualDisplayWidth, this.mFilterContext.mVirtualDisplayHeight, this.mFilterContext.mScreenDensityDpi);
        YMFLog.info(this, "[Preview ]", "surfaceChange,resize width:" + this.mFilterContext.mVirtualDisplayWidth + " , height:" + this.mFilterContext.mVirtualDisplayHeight);
    }

    @Override
    public void surfaceDestroyed(Surface surface) {
        YMFLog.info(this, "[Preview ]", "surfaceDestroyed");
        if (this.mVirtualDisplay != null) {
            this.mVirtualDisplay.release();
            this.mFilterContext.mVirtualDisplayWidth = 0;
            this.mFilterContext.mVirtualDisplayHeight = 0;
            this.mVirtualDisplay = null;
        }
    }

    private void getScreenBaseInfo(Context context) {
        DisplayMetrics metrics = new DisplayMetrics();
        WindowManager wm = (WindowManager)context.getSystemService("window");
        wm.getDefaultDisplay().getMetrics(metrics);
        this.mFilterContext.mScreenWidth = metrics.widthPixels;
        this.mFilterContext.mScreenHeight = metrics.heightPixels;
        this.mFilterContext.mScreenDensityDpi = metrics.densityDpi;
        YMFLog.info(this, "[SCapture]", "getScreenBaseInfo, mScreenWidth:" + this.mFilterContext.mScreenWidth + " ,mScreenHeight:" + this.mFilterContext.mScreenHeight + " ,mScreenDensityDpi:" + this.mFilterContext.mScreenDensityDpi);
    }

    public void changeScreenLiveMode(final boolean normal, final Bitmap bitmap) {
        if (this.mFilterContext == null) {
            YMFLog.warn(this, "[SCapture]", "changeScreenLiveMode, normal:" + normal + " mFilterContext == null");
            return;
        }
        this.mFilterContext.getGlManager().post(new Runnable(){

            @Override
            public void run() {
                ScreenLiveSessionYCloud.this.mFilterContext.setScreenLiveMode(normal, bitmap);
            }
        });
    }

    public void setAbroadNetWorkStrategy(boolean flag) {
        if (this.mFilterContext != null) {
            this.mFilterContext.setAbroadNetWorkStrategy(flag);
        }
    }
}

