/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mediaframework.opengles;

import com.yy.mediaframework.opengles.YMFProgramBase;

public class YMFProgramNV12
extends YMFProgramBase {
    private boolean mEnableWaterMark = false;
    private static final String VERTEX_SHADER = "uniform mat4 uMVPMatrix;\nuniform mat4 uTexMatrix;\nattribute vec4 aPosition;\nattribute vec4 aTextureCoord;\nattribute vec4 aTextureCoordWater;\nvarying vec2 vTextureCoord;\nvarying vec2 vTextureCoordWater;\nvoid main() {\n    gl_Position = uMVPMatrix * aPosition;\n    vTextureCoord = (uTexMatrix * aTextureCoord).xy;\n    vTextureCoordWater = (aTextureCoordWater).xy;\n}\n";
    private static final String FRAGMENT_SHADER_NV12 = "precision highp float;varying vec2 vTextureCoord;varying vec2 vTextureCoordWater;\nuniform sampler2D tex_y;uniform sampler2D tex_uv;uniform sampler2D uTextureWater;\nuniform int uWaterMarkEnabled;\nvoid main (void) {    vec3 yuv;    yuv.x = texture2D(tex_y, vTextureCoord).r;    yuv.y = texture2D(tex_uv, vTextureCoord).r - 0.5;    yuv.z = texture2D(tex_uv, vTextureCoord).a - 0.5;    yuv.x = 1.1643 * yuv.x - 0.0728;    vec3 rgb = vec3(        yuv.x + 1.5958 * yuv.z,        yuv.x - 0.39173 * yuv.y - 0.8129 * yuv.z,        yuv.x + 2.017 * yuv.y    );    vec4 outputColor = vec4(rgb, 1);    if (uWaterMarkEnabled == 1) {\n        vec4 overlay = texture2D(uTextureWater, vTextureCoordWater);\n        outputColor.r = overlay.r + outputColor.r * outputColor.a * (1.0 - overlay.a);\n        outputColor.g = overlay.g + outputColor.g * outputColor.a * (1.0 - overlay.a);\n        outputColor.b = overlay.b + outputColor.b * outputColor.a * (1.0 - overlay.a);\n        outputColor.a = overlay.a + outputColor.a * (1.0 - overlay.a);\n    }\n    gl_FragColor = outputColor;}";

    public YMFProgramNV12() {
        super(VERTEX_SHADER, FRAGMENT_SHADER_NV12);
    }

    @Override
    public int programType() {
        return 2;
    }

    @Override
    protected void onSetAttributeValue() {
        this.setVertexAttribPointer("aPosition", 2, 5126, false, this.getVertexCoordStride(), this.getVertexCoordData());
        this.setVertexAttribPointer("aTextureCoord", 2, 5126, false, this.getTextureCoordStride(), this.getTextureCoordData());
        this.setVertexAttribPointer("aTextureCoordWater", 2, 5126, false, this.getTextureCoordStride(), this.getWaterMarkCoordData());
    }

    @Override
    protected void onSetUniformValue() {
        this.setUniformMatrix4fv("uMVPMatrix", 1, false, this.getVertexMatrix(), 0);
        this.setUniformMatrix4fv("uTexMatrix", 1, false, this.getTextureMatrix(), 0);
        this.setUniform1i("tex_y", 0);
        this.setUniform1i("tex_uv", 1);
        if (this.mEnableWaterMark) {
            this.setUniform1i("uWaterMarkEnabled", 1);
        } else {
            this.setUniform1i("uWaterMarkEnabled", 0);
        }
        this.setUniform1i("uTextureWater", 3);
    }

    @Override
    public void enableWaterMarker(boolean enable) {
        this.mEnableWaterMark = enable;
    }
}

