/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mediaframework.model;

import android.annotation.SuppressLint;
import com.yy.mediaframework.model.DecodeVideoSample;
import com.yy.mediaframework.utils.YMFLog;
import java.util.NoSuchElementException;
import java.util.concurrent.ConcurrentLinkedQueue;

@SuppressLint(value={"NewApi"})
public class YYPeripheralsVideoSampleAllocator {
    private static volatile YYPeripheralsVideoSampleAllocator s_instance = null;
    private static Object mLock = new Object();
    private ConcurrentLinkedQueue<DecodeVideoSample> mFreeDeque = new ConcurrentLinkedQueue();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static YYPeripheralsVideoSampleAllocator instance() {
        if (s_instance == null) {
            Object object = mLock;
            synchronized (object) {
                if (s_instance == null) {
                    s_instance = new YYPeripheralsVideoSampleAllocator();
                }
            }
        }
        return s_instance;
    }

    private YYPeripheralsVideoSampleAllocator() {
        this.init(30);
    }

    public DecodeVideoSample alloc() {
        DecodeVideoSample sample = null;
        try {
            sample = this.mFreeDeque.poll();
        }
        catch (NoSuchElementException e) {
            YMFLog.info(this, "[Util    ]", "allocate sample buffer exception:" + e.toString());
            sample = null;
        }
        if (sample == null) {
            sample = this.newMediaSample();
            YMFLog.info(this, "[Util    ]", "alloc new sample size:" + this.mFreeDeque.size());
        }
        sample.addRef();
        return sample;
    }

    public void free(DecodeVideoSample sample) {
        YMFLog.debug((Object)this, "[Util    ]", "free");
        this.resetSample(sample);
        this.mFreeDeque.add(sample);
        int free_size = this.mFreeDeque.size();
        if (free_size > 200) {
            // empty if block
        }
    }

    private void resetSample(DecodeVideoSample sample) {
        sample.reset();
    }

    private DecodeVideoSample newMediaSample() {
        DecodeVideoSample sample = new DecodeVideoSample();
        this.resetSample(sample);
        return sample;
    }

    private void init(int capacity) {
        for (int i = 0; i < capacity; ++i) {
            DecodeVideoSample sample = this.newMediaSample();
            this.mFreeDeque.add(sample);
        }
    }

    static {
        YYPeripheralsVideoSampleAllocator.instance();
    }
}

