/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mediaframework.inteligence.resolution;

import com.yy.mediaframework.base.VideoEncoderType;
import com.yy.mediaframework.inteligence.common.ResolutionModifyConfig;
import com.yy.mediaframework.inteligence.common.ResolutionModifyNotFoundException;
import com.yy.mediaframework.inteligence.resolution.IResolutionModify;
import com.yy.mediaframework.inteligence.resolution.ResolutionModifyListener;
import com.yy.mediaframework.utils.YMFLog;
import java.util.Arrays;
import java.util.List;

public class DefaultResolutionModify
implements IResolutionModify {
    public static final String TAG = DefaultResolutionModify.class.getSimpleName();
    protected static final long ONE_SECOND = 1000000000L;
    protected long mLastTimestampNanos;
    protected int mConfigFrameRate;
    protected int mConfigCodeRate;
    protected int mCurrentFrameRate;
    protected int mNetworkCodeRate;
    protected int mIdx;
    protected long mResolutionChangeInterval = 10000000000L;
    protected List<ResolutionModifyConfig> mModifyConfigList;
    protected ResolutionModifyListener mResolutionModifyListener;

    public void init(int configFrameRate, int configCodeRate, int width, int height, int resolutionChangeInterval, List<ResolutionModifyConfig> modifyConfigList, ResolutionModifyListener listener) throws ResolutionModifyNotFoundException {
        this.mConfigFrameRate = configFrameRate;
        this.mConfigCodeRate = configCodeRate;
        this.mCurrentFrameRate = 0;
        this.mModifyConfigList = modifyConfigList;
        this.mIdx = this.findConfigIdx(width, height, configCodeRate);
        this.mLastTimestampNanos = System.nanoTime();
        this.mResolutionModifyListener = listener;
        this.mResolutionChangeInterval = (long)resolutionChangeInterval * 1000000000L;
        YMFLog.info(this, "[Encoder ]", "init cfr:%d ccr:%d idx:%d interval:%d config:%s", this.mConfigFrameRate, this.mConfigCodeRate, this.mIdx, this.mResolutionChangeInterval, Arrays.toString(this.mModifyConfigList.toArray()));
    }

    @Override
    public void publishNetworkCodeRate(int networkCodeRate) {
        this.mNetworkCodeRate = networkCodeRate;
        if (this.mIdx >= this.mModifyConfigList.size()) {
            YMFLog.info(this, "[Encoder ]", "publishNetworkCodeRate index error, index:" + this.mIdx + ", size:" + this.mModifyConfigList.size());
            return;
        }
        ResolutionModifyConfig currentConfig = this.findConfigFromIdx(this.mIdx);
        YMFLog.info(this, "[Encoder ]", "publishNetworkCodeRate config min:" + currentConfig.minCodeRate + ", max:" + currentConfig.maxCodeRate + ", current:" + this.mNetworkCodeRate);
        if (this.mNetworkCodeRate < currentConfig.minCodeRate) {
            if (System.nanoTime() - this.mLastTimestampNanos > this.mResolutionChangeInterval) {
                int lastIdx = this.mIdx;
                this.mIdx = this.findBestConfigIdx(this.mNetworkCodeRate, false, this.mIdx);
                if (this.mIdx != lastIdx) {
                    this.notifyToListener(this.mIdx, this.mNetworkCodeRate);
                    YMFLog.info(this, "[Encoder ]", "publishNetworkCodeRate config index change:" + lastIdx + " -> " + this.mIdx);
                }
            }
        } else if (this.mNetworkCodeRate > currentConfig.maxCodeRate && System.nanoTime() - this.mLastTimestampNanos > this.mResolutionChangeInterval) {
            int lastIdx = this.mIdx;
            this.mIdx = this.findBestConfigIdx(this.mNetworkCodeRate, true, this.mIdx);
            if (this.mIdx != lastIdx) {
                this.notifyToListener(this.mIdx, this.mNetworkCodeRate);
                YMFLog.info(this, "[Encoder ]", "publishNetworkCodeRate config index change:" + lastIdx + " -> " + this.mIdx);
            }
        }
    }

    protected void notifyToListener(int idx, int currentCodeRate) {
        ResolutionModifyConfig config = this.findConfigFromIdx(idx);
        if (config == null) {
            YMFLog.warn(this, "[Encoder ]", "cannot find config idx:%d", idx);
        } else {
            YMFLog.info(this, "[Encoder ]", "notify to modify resolution idx:" + idx + " config:" + config.toString());
            if (this.mResolutionModifyListener != null) {
                this.mResolutionModifyListener.onReceiveSuggestResolution(config.width, config.height, config.maxFrameRate, config.encoderParams, config.videoEncoderType, config.videoEncoderType == VideoEncoderType.SOFT_ENCODER_X264 ? currentCodeRate : config.maxCodeRate);
            }
        }
        this.mLastTimestampNanos = System.nanoTime();
    }

    @Override
    public void publishCurrentFrameRate(int currentFrameRate) {
        this.mCurrentFrameRate = currentFrameRate;
    }

    protected int findBestConfigIdx(int networkCodeRate, boolean isPlus, int idx) {
        if (isPlus) {
            if (idx < this.mModifyConfigList.size() - 2) {
                for (int i = idx + 1; i < this.mModifyConfigList.size(); ++i) {
                    if (networkCodeRate > this.mModifyConfigList.get((int)i).maxCodeRate) continue;
                    return i;
                }
                return this.mModifyConfigList.size() - 1;
            }
            if (idx == this.mModifyConfigList.size() - 2) {
                return idx + 1;
            }
            return idx;
        }
        if (idx > 1) {
            for (int i = idx - 1; i >= 0; --i) {
                if (networkCodeRate < this.mModifyConfigList.get((int)i).minCodeRate) continue;
                return i;
            }
            return 0;
        }
        return 0;
    }

    protected ResolutionModifyConfig findConfigFromIdx(int idx) {
        return this.mModifyConfigList.get(idx);
    }

    protected int findConfigIdx(int width, int height, int codeRate) throws ResolutionModifyNotFoundException {
        ResolutionModifyConfig config;
        int i;
        for (i = 0; i < this.mModifyConfigList.size(); ++i) {
            config = this.mModifyConfigList.get(i);
            if (i == 0 && codeRate <= config.minCodeRate) {
                return i;
            }
            if (codeRate > config.minCodeRate && codeRate <= config.maxCodeRate) {
                return i;
            }
            if (i != this.mModifyConfigList.size() - 1 || codeRate <= config.maxCodeRate) continue;
            return i;
        }
        YMFLog.info(this, "[Encoder ]", "findConfigIdx fail, width:" + width + ", height:" + height + ", codeRate:" + codeRate);
        for (i = 0; i < this.mModifyConfigList.size(); ++i) {
            config = this.mModifyConfigList.get(i);
            YMFLog.info(this, "[Encoder ]", "findConfigIdx fail, config part" + i + ":" + config.toString());
        }
        throw new ResolutionModifyNotFoundException(width, height, codeRate);
    }

    @Override
    public void release() {
        this.mResolutionModifyListener = null;
    }

    public long getLastTimestampNanos() {
        return this.mLastTimestampNanos;
    }

    public void setLastTimestampNanos() {
        this.mLastTimestampNanos = System.nanoTime();
    }
}

