/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mediaframework.inteligence.framerate;

import com.yy.mediaframework.inteligence.framerate.IFrameRateModify;
import com.yy.mediaframework.utils.YMFLog;

public class NewFixedFrameRateModify
implements IFrameRateModify {
    public static final String TAG = NewFixedFrameRateModify.class.getSimpleName();
    protected static final long ONE_SECOND = 1000000000L;
    protected static final int FRAMERATE_FLOOR = 10;
    private long mLastTimestampNanos;
    private long mStepNanos;
    private int mConfigFrameRate;
    private int mConfigCodeRate;
    private int mCurrentFrameRate;
    private float mNewFrameRate;
    private boolean mNeedIntercept = true;
    private int mFixedFrameRate;

    public void init(int configFrameRate, int configCodeRate, int fixedFrameRate) {
        this.mConfigFrameRate = configFrameRate;
        this.mConfigCodeRate = configCodeRate;
        this.mStepNanos = 1000000000L / (long)this.mConfigFrameRate;
        this.mCurrentFrameRate = 0;
        this.mFixedFrameRate = fixedFrameRate;
        YMFLog.info(this, "[Encoder ]", "init cfr:%d ccr:%d ffr:%d", this.mConfigFrameRate, this.mConfigCodeRate, this.mFixedFrameRate);
    }

    @Override
    public boolean onInterceptDoFrame(long timeStampNanos) {
        if (!this.mNeedIntercept) {
            return false;
        }
        long diff = this.mStepNanos - (System.nanoTime() - this.mLastTimestampNanos);
        if (this.mLastTimestampNanos != -1L && diff > 0L) {
            try {
                long sleepTime = diff / 1000000L;
                Thread.sleep(sleepTime);
            }
            catch (InterruptedException e) {
                YMFLog.error(this, "[Encoder ]", "sleep exception:%s", e);
            }
            this.mLastTimestampNanos = System.nanoTime();
            return true;
        }
        this.mLastTimestampNanos = System.nanoTime();
        return true;
    }

    @Override
    public void publishNetworkCodeRate(int networkCodeRate) {
        this.mNewFrameRate = this.mFixedFrameRate;
        if (this.mNewFrameRate < 10.0f) {
            this.mNewFrameRate = 10.0f;
        }
        this.mStepNanos = (long)(1.0E9f / this.mNewFrameRate);
        YMFLog.info(this, "[Encoder ]", "publishNetworkCodeRate nfr:%f ncr:%d sn:%d", Float.valueOf(this.mNewFrameRate), networkCodeRate, this.mStepNanos);
    }

    @Override
    public void publishCurrentFrameRate(int currentFrameRate) {
        this.mCurrentFrameRate = currentFrameRate;
    }

    @Override
    public void publishCurrentResolution(int width, int height, int codeRate) {
    }

    @Override
    public void release() {
    }

    @Override
    public float getLastFrameRate() {
        return 0.0f;
    }

    @Override
    public void setLastFrameRate(float frameRate) {
    }
}

