/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mediaframework.inteligence.framerate;

import com.yy.mediaframework.base.VideoEncoderType;
import com.yy.mediaframework.inteligence.common.ResolutionModifyConfig;
import com.yy.mediaframework.inteligence.common.ResolutionModifyNotFoundException;
import com.yy.mediaframework.inteligence.framerate.AdjustFrameRateModify;
import com.yy.mediaframework.inteligence.framerate.IFrameRateModify;
import com.yy.mediaframework.utils.YMFLog;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class CaptureSyncEncodeFrameRateModify
implements IFrameRateModify {
    private boolean mEnableSyncFps = true;
    private int mSampleEncFpsDiff = 3;
    private int mSyncFpsInterval = 15;
    private int mFrameCount = 0;
    private int mModifiedEncFps = 0;
    private long mLastCountTime = 0L;
    private long mNewTurnTime = 0L;
    private long mStatInterval = 5L;
    private List<Integer> mLastFps = new ArrayList<Integer>();
    private String mConfigStr = null;
    private int mLastBitRateSuggest = 0;
    private int mCurrentBitRateSuggest = 0;
    public AdjustFrameRateModify mAjustFRModify = null;

    @Override
    public boolean onInterceptDoFrame(long timeStampNanos) {
        if (this.mAjustFRModify != null) {
            return this.mAjustFRModify.onInterceptDoFrame(timeStampNanos);
        }
        return true;
    }

    @Override
    public void publishNetworkCodeRate(int networkCodeRate) {
        YMFLog.info(this, "[Encoder ]", "setNetworkBitrateSuggest:" + networkCodeRate + ", last:" + this.mLastBitRateSuggest + " enableSyncFps:" + this.mEnableSyncFps);
        this.mCurrentBitRateSuggest = networkCodeRate;
        if (this.mAjustFRModify != null) {
            this.mAjustFRModify.publishNetworkCodeRate(networkCodeRate);
        }
    }

    @Override
    public void publishCurrentFrameRate(int currentFrameRate) {
        if (this.mAjustFRModify != null) {
            this.mAjustFRModify.publishCurrentFrameRate(currentFrameRate);
        }
    }

    @Override
    public void publishCurrentResolution(int width, int height, int codeRate) {
        if (this.mAjustFRModify != null) {
            this.mAjustFRModify.publishCurrentResolution(width, height, codeRate);
        }
    }

    @Override
    public void release() {
        if (this.mAjustFRModify != null) {
            this.mAjustFRModify.release();
        }
    }

    public void reInit(int configFrameRate, int configCodeRate, int width, int height, List<ResolutionModifyConfig> modifyConfigList) {
        YMFLog.info(this, "[Encoder ]", "reInit");
        this.mLastCountTime = 0L;
        this.mFrameCount = 0;
        this.mNewTurnTime = 0L;
        this.mModifiedEncFps = 0;
        this.release();
        this.init(configFrameRate, configCodeRate, width, height, modifyConfigList);
    }

    public void init(int configFrameRate, int configCodeRate, int width, int height, List<ResolutionModifyConfig> modifyConfigList) {
        YMFLog.info(this, "[Encoder ]", "init FrameRateModify frameRate:" + configFrameRate + ", codeRate:" + configCodeRate + ", width:" + width + ", heigh:" + height + "config:" + Arrays.toString(modifyConfigList.toArray()));
        try {
            this.mAjustFRModify = new AdjustFrameRateModify();
            this.mAjustFRModify.init(configFrameRate, configCodeRate, width, height, modifyConfigList);
        }
        catch (ResolutionModifyNotFoundException e) {
            YMFLog.error(this, "[Encoder ]", "init FrameRateModify exception:%s", e.toString());
            this.mAjustFRModify = null;
        }
    }

    public int checkFrameRate(int currentEncodeFrameRate, String encodeParameter, VideoEncoderType encoderType) {
        this.updateSyncFpsParam(encodeParameter);
        if (this.mEnableSyncFps && (encoderType == VideoEncoderType.HARD_ENCODER_H264 || encoderType == VideoEncoderType.HARD_ENCODER_H265)) {
            return this.checkSyncFps(currentEncodeFrameRate);
        }
        return currentEncodeFrameRate;
    }

    private void updateSyncFpsParam(String configStr) {
        if (configStr == null) {
            return;
        }
        if (this.mConfigStr != null && this.mConfigStr.equals(configStr)) {
            return;
        }
        try {
            String itemDelim = ":";
            String[] tokens = configStr.split(itemDelim);
            String valueDelim = "=";
            for (int i = 0; i < tokens.length; ++i) {
                YMFLog.info(this, "[Encoder ]", "updateSyncFpsParam parse:" + tokens[i]);
                Object[] keyValue = tokens[i].split(valueDelim);
                if (keyValue.length == 2) {
                    YMFLog.info(this, "[Encoder ]", "updateSyncFpsParam param item, name:" + (String)keyValue[0] + ", value:" + (String)keyValue[1]);
                    this.setSyncSampleEncParams((String)keyValue[0], (String)keyValue[1]);
                    continue;
                }
                YMFLog.info(this, "[Encoder ]", "updateSyncFpsParam invalid param item:" + Arrays.toString(keyValue));
            }
            this.mConfigStr = configStr;
        }
        catch (Exception e) {
            YMFLog.info(this, "[Encoder ]", "updateSyncFpsParam parse exception:" + e);
        }
    }

    private void setSyncSampleEncParams(String key, String value) {
        switch (key) {
            case "fpsDiff": {
                this.mSampleEncFpsDiff = Integer.parseInt(value);
                YMFLog.info(this, "[Encoder ]", "setSyncSampleEncParams fpsDiff:" + this.mSampleEncFpsDiff);
                break;
            }
            case "syncFpsInterval": {
                this.mSyncFpsInterval = Integer.parseInt(value);
                YMFLog.info(this, "[Encoder ]", "setSyncSampleEncParams syncFpsInterval:" + this.mSyncFpsInterval);
                break;
            }
            case "enableSyncFps": {
                this.mEnableSyncFps = Boolean.parseBoolean(value);
                YMFLog.info(this, "[Encoder ]", "setSyncSampleEncParams enableSyncFps:" + this.mEnableSyncFps);
                break;
            }
        }
    }

    private int checkSyncFps(int currentEncodeFrameRate) {
        int ret = currentEncodeFrameRate;
        ++this.mFrameCount;
        long now = System.currentTimeMillis();
        if (this.mNewTurnTime == 0L) {
            this.mNewTurnTime = now;
            this.mLastCountTime = now;
            this.mLastFps.clear();
            return ret;
        }
        long inteval = now - this.mLastCountTime;
        if (inteval >= this.mStatInterval * 1000L) {
            this.mLastFps.add((int)((float)this.mFrameCount / ((float)inteval / 1000.0f)));
            if (this.mLastFps.size() > 100) {
                this.mLastFps.remove(0);
            }
            this.mLastCountTime = now;
            this.mFrameCount = 0;
        }
        if (now - this.mNewTurnTime < (long)(this.mSyncFpsInterval * 1000)) {
            return ret;
        }
        if (this.mFrameCount != 0 && inteval > 0L) {
            this.mLastFps.add((int)((float)this.mFrameCount / ((float)inteval / 1000.0f)));
        }
        if (this.mAjustFRModify != null && this.mCurrentBitRateSuggest > 0) {
            this.mAjustFRModify.publishNetworkCodeRate(this.mCurrentBitRateSuggest);
            YMFLog.info(this, "[Encoder ]", "update suggest bitrate, last:" + this.mLastBitRateSuggest + ", now:" + this.mCurrentBitRateSuggest);
        }
        this.mLastBitRateSuggest = this.mCurrentBitRateSuggest;
        this.mNewTurnTime = now;
        if (this.mLastFps.isEmpty()) {
            return ret;
        }
        int sum = 0;
        int lastFps = 0;
        int vibratAmp = 3;
        int vibratCount = 0;
        int len = this.mLastFps.size();
        for (int i = 0; i < len; ++i) {
            int currFps = this.mLastFps.get(i);
            if (i > 0 && Math.abs(currFps - lastFps) > vibratAmp) {
                ++vibratCount;
            }
            lastFps = currFps;
            sum += currFps;
        }
        int fps = sum / len;
        int encFps = currentEncodeFrameRate;
        int minEncFps = 7;
        if (vibratCount <= len / 2 && fps > minEncFps && (fps < encFps - this.mSampleEncFpsDiff || fps > encFps + this.mSampleEncFpsDiff)) {
            int suggestFps = 0;
            if (this.mAjustFRModify != null && this.mAjustFRModify instanceof AdjustFrameRateModify) {
                suggestFps = (int)this.mAjustFRModify.getLastFrameRate();
            }
            YMFLog.info(this, "[Encoder ]", "sample len:" + len + ", vibratCount:" + vibratCount + ", sync camera fps:" + fps + ", old enc fps:" + encFps + ", suggest fps:" + suggestFps);
            int lastModifiedEncFps = this.mModifiedEncFps;
            this.mModifiedEncFps = fps;
            if (this.mModifiedEncFps != lastModifiedEncFps) {
                this.mLastCountTime = 0L;
                this.mFrameCount = 0;
                this.mNewTurnTime = 0L;
                return this.mModifiedEncFps;
            }
        } else {
            YMFLog.info(this, "[Encoder ]", "sample len:" + len + ", vibratCount:" + vibratCount + ", camera fps:" + fps + ", enc fps:" + encFps);
        }
        this.mLastFps.clear();
        return ret;
    }

    @Override
    public float getLastFrameRate() {
        if (this.mAjustFRModify != null) {
            return this.mAjustFRModify.getLastFrameRate();
        }
        return 0.0f;
    }

    @Override
    public void setLastFrameRate(float frameRate) {
        if (this.mAjustFRModify != null) {
            this.mAjustFRModify.setLastFrameRate(frameRate);
        }
    }
}

