/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mediaframework.inteligence.dynamictexture;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import com.yy.mediaframework.inteligence.dynamictexture.AbstractDynamicTexture;

public class TestDynamicTexture
extends AbstractDynamicTexture {
    private static final int DEFAULT_TEXTURE_WIDTH = 720;
    private static final int DEFAULT_TEXTURE_HEIGHT = 1280;
    private static final float DEFAULT_TEXTURE_RATIO = 0.4f;
    private int[] textureIds = new int[15];
    private int frameCount = 0;
    private int textureIndex = 0;
    private Bitmap bitmap;

    public TestDynamicTexture(Context context, int resId) {
        for (int i = 0; i < this.textureIds.length; ++i) {
            this.textureIds[i] = -1;
        }
        this.frameCount = 0;
        this.textureIndex = 0;
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inScaled = false;
        this.bitmap = BitmapFactory.decodeResource((Resources)context.getResources(), (int)resId, (BitmapFactory.Options)options);
    }

    @Override
    public void onDoFrame() {
        this.textureIndex = this.frameCount++ % this.textureIds.length;
        if (this.textureIds[this.textureIndex] < 0) {
            this.textureIds[this.textureIndex] = this.createTexture(this.bitmap, 720, 1280, 1.0f * (float)this.textureIndex / (float)this.textureIds.length, 0.4f);
        }
    }

    @Override
    public int getDynamicTextureId() {
        return this.textureIds[this.textureIndex];
    }

    @Override
    public void onRelease() {
        this.frameCount = 0;
        this.textureIndex = 0;
        for (int i = 0; i < this.textureIds.length; ++i) {
            this.textureIds[i] = -1;
        }
    }
}

