/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mediaframework.gpuimage.util;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.opengl.GLES20;
import android.opengl.GLUtils;

public class GLTexture {
    private int mTextureID = -1;
    private int mTarget = 3553;
    private int mWidth = 0;
    private int mHeight = 0;
    private int mFormat = 6408;

    public GLTexture(int target) {
        this.mTarget = target;
    }

    public void create(int width, int height, int format) {
        this.destory();
        int[] textureHandles = new int[1];
        GLES20.glGenTextures((int)1, (int[])textureHandles, (int)0);
        this.mTextureID = textureHandles[0];
        GLES20.glBindTexture((int)this.mTarget, (int)this.mTextureID);
        GLES20.glTexParameteri((int)this.mTarget, (int)10242, (int)33071);
        GLES20.glTexParameteri((int)this.mTarget, (int)10243, (int)33071);
        GLES20.glTexParameteri((int)this.mTarget, (int)10241, (int)9729);
        GLES20.glTexParameteri((int)this.mTarget, (int)10240, (int)9729);
        GLES20.glTexImage2D((int)this.mTarget, (int)0, (int)format, (int)width, (int)height, (int)0, (int)format, (int)5121, null);
        this.mWidth = width;
        this.mHeight = height;
        this.mFormat = format;
    }

    public void destory() {
        if (this.mTextureID != -1) {
            int[] textureHandles = new int[]{this.mTextureID};
            GLES20.glDeleteTextures((int)1, (int[])textureHandles, (int)0);
            this.mTextureID = -1;
            this.mHeight = 0;
            this.mWidth = 0;
        }
    }

    public void loadTextures(Context context, int resID) {
        Bitmap bitmap = BitmapFactory.decodeResource((Resources)context.getResources(), (int)resID);
        this.mWidth = bitmap.getWidth();
        this.mHeight = bitmap.getHeight();
        GLES20.glBindTexture((int)3553, (int)this.mTextureID);
        GLUtils.texImage2D((int)3553, (int)0, (Bitmap)bitmap, (int)0);
        GLES20.glBindTexture((int)this.mTarget, (int)this.mTextureID);
        GLES20.glTexParameteri((int)this.mTarget, (int)10242, (int)33071);
        GLES20.glTexParameteri((int)this.mTarget, (int)10243, (int)33071);
        GLES20.glTexParameteri((int)this.mTarget, (int)10241, (int)9729);
        GLES20.glTexParameteri((int)this.mTarget, (int)10240, (int)9729);
    }

    public void bindFBO(int framebuffer) {
        GLES20.glBindFramebuffer((int)36160, (int)framebuffer);
        GLES20.glBindTexture((int)this.mTarget, (int)this.mTextureID);
        GLES20.glFramebufferTexture2D((int)36160, (int)36064, (int)this.mTarget, (int)this.mTextureID, (int)0);
    }

    public int getTarget() {
        return this.mTarget;
    }

    public int getTextureId() {
        return this.mTextureID;
    }

    public void setTextureId(int textureId) {
        this.mTextureID = textureId;
    }

    public int getWidth() {
        return this.mWidth;
    }

    public int getHeight() {
        return this.mHeight;
    }
}

