/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mediaframework.gpuimage.adapter;

import android.content.Context;
import android.opengl.GLES20;
import com.yy.mediaframework.gpuimage.adapter.GlPboReader;
import com.yy.mediaframework.utils.CPUTool;
import com.yy.mediaframework.utils.YMFLog;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class GlTextureImageReader {
    private byte[] mPixBytes = null;
    private ByteBuffer mPixBuffer = null;
    public boolean mGlPboSupported = false;
    private GlPboReader mGlPboReader = null;
    private int mReaderFrameBuffer = -1;
    private int mWidth = 0;
    private int mHeight = 0;

    public GlTextureImageReader(Context context, int width, int height) {
        this.mGlPboSupported = GlPboReader.isPboSupport(context);
        if (CPUTool.isEmulator()) {
            this.mGlPboSupported = false;
            YMFLog.warn(this, "[Util    ]", "isEmulator Not used pbo");
        }
        this.init(width, height);
    }

    private void init(int width, int height) {
        int[] frameBuffers = new int[1];
        GLES20.glGenFramebuffers((int)1, (int[])frameBuffers, (int)0);
        this.mReaderFrameBuffer = frameBuffers[0];
        this.mPixBuffer = ByteBuffer.allocateDirect(width * height * 4);
        if (this.mGlPboSupported) {
            this.mGlPboReader = new GlPboReader(width, height);
            this.mPixBytes = new byte[width * height * 4];
        } else {
            this.mPixBuffer.order(ByteOrder.nativeOrder());
        }
        this.mWidth = width;
        this.mHeight = height;
    }

    public void destroy() {
        if (this.mReaderFrameBuffer > 0) {
            int[] framebuffers = new int[]{this.mReaderFrameBuffer};
            GLES20.glDeleteFramebuffers((int)1, (int[])framebuffers, (int)0);
            this.mReaderFrameBuffer = -1;
        }
        if (this.mGlPboSupported && this.mGlPboReader != null) {
            this.mGlPboReader.deinitPBO();
            this.mGlPboReader = null;
        }
    }

    public void checkImageSize(int widht, int height) {
        if (this.mWidth == widht && this.mHeight == height) {
            return;
        }
        this.destroy();
        this.init(widht, height);
    }

    public byte[] read(int texture, int width, int height) {
        if (this.mReaderFrameBuffer <= 0) {
            return null;
        }
        this.checkImageSize(width, height);
        byte[] ret = null;
        GLES20.glBindFramebuffer((int)36160, (int)this.mReaderFrameBuffer);
        GLES20.glBindTexture((int)3553, (int)texture);
        GLES20.glFramebufferTexture2D((int)36160, (int)36064, (int)3553, (int)texture, (int)0);
        if (this.mGlPboSupported && this.mGlPboReader != null) {
            this.mPixBuffer = this.mGlPboReader.downloadGpuBufferWithPbo();
            if (this.mPixBuffer == null) {
                GLES20.glBindTexture((int)3553, (int)0);
                GLES20.glBindFramebuffer((int)36160, (int)0);
                return null;
            }
            if (this.mPixBuffer.hasArray()) {
                ret = this.mPixBuffer.array();
            } else {
                this.mPixBuffer.position(0);
                this.mPixBuffer.get(this.mPixBytes);
                ret = this.mPixBytes;
            }
        } else {
            this.mPixBuffer.clear();
            GLES20.glReadPixels((int)0, (int)0, (int)width, (int)height, (int)6408, (int)5121, (Buffer)this.mPixBuffer);
            ret = this.mPixBuffer.array();
        }
        GLES20.glBindTexture((int)3553, (int)0);
        GLES20.glBindFramebuffer((int)36160, (int)0);
        return ret;
    }
}

