/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mediaframework.gpuimage;

import android.opengl.GLES20;
import com.yy.mediaframework.gpuimage.GPUImageFilter;
import com.yy.mediaframework.gpuimage.IFilterParams;
import java.util.Map;

public class GPUImageSkinWhiteFilter
extends GPUImageFilter
implements IFilterParams {
    public static final String FRAGMENT_SHADER = " precision highp float;\n \n varying highp vec2 textureCoordinate;\n \n uniform sampler2D inputImageTexture;\n uniform float white;\n \n float logCurve(float color)\n {\n     return log(color * (white - 1.0) + 1.0) / log(white);\n }\n \n void main()\n {\n     vec4 textureColor = texture2D(inputImageTexture, textureCoordinate);\n     float r = logCurve(textureColor.r);\n     float g = logCurve(textureColor.g);\n     float b = logCurve(textureColor.b);\n     gl_FragColor = vec4(r, g, b, 1.0);\n }";
    private int mWhiteLocation;
    private float mWhite = 0.2f;

    public GPUImageSkinWhiteFilter(float white) {
        super("attribute vec4 position;\nattribute vec4 inputTextureCoordinate;\n \nuniform mat4 uTexMatrix;\nvarying vec2 textureCoordinate;\n \nvoid main()\n{\n    gl_Position = position;\n    textureCoordinate = (uTexMatrix * inputTextureCoordinate).xy;\n}", FRAGMENT_SHADER);
        this.mWhite = white;
    }

    @Override
    public void onInit() {
        super.onInit();
        this.mWhiteLocation = GLES20.glGetUniformLocation((int)this.getProgram(), (String)"white");
        this.setFloat(this.mWhiteLocation, this.getWhite());
    }

    @Override
    public void setFilterParams(Map<String, String> params) {
        this.mWhite = this.getParamValue(params, "3");
        this.setFloat(this.mWhiteLocation, this.getWhite());
    }

    private float getWhite() {
        return 1.05f + this.mWhite * 2.0f;
    }

    private float getParamValue(Map<String, String> params, String key) {
        String value = params.get(key);
        if (value != null) {
            try {
                return Float.valueOf(value).floatValue();
            }
            catch (NumberFormatException e) {
                return 0.0f;
            }
        }
        return 0.0f;
    }
}

