/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mediaframework.gpuimage;

import android.opengl.GLES20;
import com.yy.mediaframework.gpuimage.GPUImageFilter;
import com.yy.mediaframework.gpuimage.IFilterParams;
import java.nio.FloatBuffer;
import java.util.Map;

public class GPUImageSTBeautyFilter3
extends GPUImageFilter
implements IFilterParams {
    private float mContrast;
    private float mSmooth;
    private int mContrastStrengthLocation;
    private int mSmoothStrengthLocation;
    private int mMidImageTextureLoc;
    private int mMidWareTextureId = -1;

    public GPUImageSTBeautyFilter3(String fragmentShader, float contrast, float smooth) {
        super("attribute vec4 position;\nattribute vec4 inputTextureCoordinate;\n \nuniform mat4 uTexMatrix;\nvarying vec2 textureCoordinate;\n \nvoid main()\n{\n    gl_Position = position;\n    textureCoordinate = (uTexMatrix * inputTextureCoordinate).xy;\n}", fragmentShader);
        this.mContrast = contrast;
        this.mSmooth = smooth;
    }

    @Override
    public void onInit() {
        super.onInit();
        this.mContrastStrengthLocation = GLES20.glGetUniformLocation((int)this.getProgram(), (String)"contrast_strength");
        this.mSmoothStrengthLocation = GLES20.glGetUniformLocation((int)this.getProgram(), (String)"smooth_strength");
        this.mMidImageTextureLoc = GLES20.glGetUniformLocation((int)this.getProgram(), (String)"midImageTexture");
        this.setFloat(this.mContrastStrengthLocation, this.getContrastValue());
        this.setFloat(this.mSmoothStrengthLocation, this.getSmoothValue());
    }

    @Override
    protected void onDrawArraysPre(int textureId, FloatBuffer cubeBuffer, FloatBuffer textureBuffer, int textureTarget, float[] texMatrix) {
        super.onDrawArraysPre(textureId, cubeBuffer, textureBuffer, textureTarget, texMatrix);
        if (this.mMidWareTextureId != -1) {
            GLES20.glActiveTexture((int)33987);
            GLES20.glBindTexture((int)3553, (int)this.mMidWareTextureId);
            GLES20.glUniform1i((int)this.mMidImageTextureLoc, (int)3);
        }
    }

    public void setMidImageTextureId(int textureId) {
        this.mMidWareTextureId = textureId;
    }

    private float getContrastValue() {
        return 4.0f * this.mContrast;
    }

    private float getSmoothValue() {
        return 0.2857143f + this.mSmooth / 2.45f;
    }

    @Override
    public void setFilterParams(Map<String, String> params) {
        this.mSmooth = this.getParamValue(params, "0");
        this.mContrast = this.getParamValue(params, "1");
        this.setFloat(this.mSmoothStrengthLocation, this.getSmoothValue());
        this.setFloat(this.mContrastStrengthLocation, this.getContrastValue());
    }

    private float getParamValue(Map<String, String> params, String key) {
        String value = params.get(key);
        if (value != null) {
            try {
                return Float.valueOf(value).floatValue();
            }
            catch (NumberFormatException e) {
                return 0.0f;
            }
        }
        return 0.0f;
    }
}

