/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mediaframework.gpuimage;

import android.opengl.GLES20;
import com.yy.mediaframework.gpuimage.GPUImageFilter;
import com.yy.mediaframework.gpuimage.IFilterParams;
import java.util.Map;

public class GPUImageSTBeautyFilter1
extends GPUImageFilter
implements IFilterParams {
    private static final float ratio = 0.004f;
    private float mContrast;
    private int mWidthLocation;
    private int mHeightLocation;
    private int mContrastStrengthLocation;

    public GPUImageSTBeautyFilter1(String fragmentShader, float contrast) {
        super("attribute vec4 position;\nattribute vec4 inputTextureCoordinate;\n \nuniform mat4 uTexMatrix;\nvarying vec2 textureCoordinate;\n \nvoid main()\n{\n    gl_Position = position;\n    textureCoordinate = (uTexMatrix * inputTextureCoordinate).xy;\n}", fragmentShader);
        this.mContrast = contrast;
    }

    @Override
    public void onInit() {
        super.onInit();
        this.mWidthLocation = GLES20.glGetUniformLocation((int)this.getProgram(), (String)"width");
        this.mHeightLocation = GLES20.glGetUniformLocation((int)this.getProgram(), (String)"height");
        this.mContrastStrengthLocation = GLES20.glGetUniformLocation((int)this.getProgram(), (String)"contrast_strength");
        this.setFloat(this.mContrastStrengthLocation, this.getContrastValue());
    }

    @Override
    public void onOutputSizeChanged(int width, int height) {
        super.onOutputSizeChanged(width, height);
        this.setFloat(this.mWidthLocation, 0.004f);
        this.setFloat(this.mHeightLocation, 0.004f * (float)width / (float)height);
    }

    private float getContrastValue() {
        return 4.0f * this.mContrast;
    }

    @Override
    public void setFilterParams(Map<String, String> params) {
        this.mContrast = this.getParamValue(params, "1");
        this.setFloat(this.mContrastStrengthLocation, this.getContrastValue());
    }

    private float getParamValue(Map<String, String> params, String key) {
        String value = params.get(key);
        if (value != null) {
            try {
                return Float.valueOf(value).floatValue();
            }
            catch (NumberFormatException e) {
                return 0.0f;
            }
        }
        return 0.0f;
    }
}

