/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mediaframework.gpuimage;

import com.yy.mediaframework.YYVideoSDK;
import com.yy.mediaframework.cryptoutil.FilterCrypto;
import com.yy.mediaframework.cryptoutil.RSACrypto;
import com.yy.mediaframework.gpuimage.GPUImageFilter;
import com.yy.mediaframework.gpuimage.GPUImageFilterGroup;
import com.yy.mediaframework.gpuimage.GPUImageSTBeautyFilter1;
import com.yy.mediaframework.gpuimage.GPUImageSTBeautyFilter2;
import com.yy.mediaframework.gpuimage.GPUImageSTBeautyFilter3;
import com.yy.mediaframework.gpuimage.GPUImageSkinWhiteFilter;
import com.yy.mediaframework.gpuimage.IFilterParams;
import com.yy.mediaframework.utils.YMFLog;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.PrivateKey;
import java.util.Map;

public class GPUImageSTBeautyFilter
extends GPUImageFilterGroup
implements IFilterParams {
    private FilterCrypto decoder = null;

    public GPUImageSTBeautyFilter(float smooth, float contrast, float saturate) {
        this.addFilter(new GPUImageFilter());
        this.addFilter(new GPUImageSTBeautyFilter1(this.getShader("bf1.dat"), contrast));
        this.addFilter(new GPUImageSTBeautyFilter2(this.getShader("bf2.dat")));
        this.addFilter(new GPUImageSTBeautyFilter3(this.getShader("bf3.dat"), contrast, smooth));
        this.addFilter(new GPUImageSkinWhiteFilter(0.2f));
    }

    @Override
    public void setFilterParams(Map<String, String> params) {
        for (GPUImageFilter filter : this.mFilters) {
            if (!(filter instanceof IFilterParams)) continue;
            ((IFilterParams)((Object)filter)).setFilterParams(params);
        }
    }

    private String getShader(String assetDat) {
        if (this.decoder == null) {
            PrivateKey privateKey = null;
            try {
                InputStream pubIs = YYVideoSDK.getInstance().getAppContext().getAssets().open("ek.dat");
                privateKey = (PrivateKey)RSACrypto.createKeyFromObjectData(pubIs);
            }
            catch (IOException e) {
                YMFLog.error(null, "[Beauty  ]", "Cannot find ek.dat:%s", e.toString());
            }
            this.decoder = FilterCrypto.newDecoder(privateKey);
        }
        String shader = "varying highp vec2 textureCoordinate;\n \nuniform sampler2D inputImageTexture;\n \nvoid main()\n{\n     gl_FragColor = texture2D(inputImageTexture, textureCoordinate);\n}";
        try {
            int count;
            InputStream is = YYVideoSDK.getInstance().getAppContext().getAssets().open(assetDat);
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            byte[] data = new byte[1024];
            while ((count = is.read(data)) != -1) {
                buffer.write(data, 0, count);
            }
            buffer.flush();
            byte[] encryptData = buffer.toByteArray();
            byte[] decryptData = this.decoder.decode(encryptData);
            shader = new String(decryptData);
        }
        catch (Exception e) {
            YMFLog.error(null, "[Beauty  ]", "Cannot find ek.dat:%s", e.toString());
        }
        return shader;
    }
}

