/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mediaframework.gpuimage;

import android.opengl.GLES20;
import android.os.Build;
import com.yy.mediaframework.Constant;
import com.yy.mediaframework.gpuimage.GPUImageFilter;
import com.yy.mediaframework.gpuimage.GPUImageSTBeautyFilter3;
import com.yy.mediaframework.gpuimage.GPUImageSingleFilter;
import com.yy.mediaframework.gpuimage.util.Rotation;
import com.yy.mediaframework.gpuimage.util.TextureRotationUtil;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.List;

public class GPUImageFilterGroup
extends GPUImageFilter {
    protected List<GPUImageFilter> mFilters;
    protected List<GPUImageFilter> mMergedFilters;
    private int[] mFrameBuffers;
    private int[] mFrameBufferTextures;
    private final FloatBuffer mGLCubeBuffer;
    private final FloatBuffer mGLTextureBuffer;
    private final FloatBuffer mGLTextureFlipBuffer;

    public GPUImageFilterGroup() {
        this(null);
    }

    public GPUImageFilterGroup(List<GPUImageFilter> filters) {
        this.mFilters = filters;
        if (this.mFilters == null) {
            this.mFilters = new ArrayList<GPUImageFilter>();
        } else {
            this.updateMergedFilters();
        }
        this.mGLCubeBuffer = ByteBuffer.allocateDirect(TextureRotationUtil.CUBE.length * 4).order(ByteOrder.nativeOrder()).asFloatBuffer();
        this.mGLCubeBuffer.put(TextureRotationUtil.CUBE).position(0);
        this.mGLTextureBuffer = ByteBuffer.allocateDirect(TextureRotationUtil.TEXTURE_NO_ROTATION.length * 4).order(ByteOrder.nativeOrder()).asFloatBuffer();
        this.mGLTextureBuffer.put(TextureRotationUtil.TEXTURE_NO_ROTATION).position(0);
        float[] flipTexture = TextureRotationUtil.getRotation(Rotation.NORMAL, false, true);
        this.mGLTextureFlipBuffer = ByteBuffer.allocateDirect(flipTexture.length * 4).order(ByteOrder.nativeOrder()).asFloatBuffer();
        this.mGLTextureFlipBuffer.put(flipTexture).position(0);
    }

    public void addFilter(GPUImageFilter aFilter) {
        if (aFilter == null) {
            return;
        }
        this.mFilters.add(aFilter);
        this.updateMergedFilters();
    }

    @Override
    public void onInit() {
        GPUImageFilter tmp = this.mMergedFilters.get(0);
        while (tmp instanceof GPUImageFilterGroup) {
            List<GPUImageFilter> filters = ((GPUImageFilterGroup)tmp).getMergedFilters();
            tmp = filters.get(0);
        }
        tmp.setFragmentShader(GPUImageSingleFilter.FStoOESFS(tmp.getFragmentShader()));
        super.onInit();
        for (GPUImageFilter filter : this.mFilters) {
            filter.init();
        }
    }

    @Override
    public void onDestroy() {
        this.destroyFramebuffers();
        for (GPUImageFilter filter : this.mFilters) {
            filter.destroy();
        }
        super.onDestroy();
    }

    private void destroyFramebuffers() {
        if (this.mFrameBufferTextures != null) {
            GLES20.glDeleteTextures((int)this.mFrameBufferTextures.length, (int[])this.mFrameBufferTextures, (int)0);
            this.mFrameBufferTextures = null;
        }
        if (this.mFrameBuffers != null) {
            GLES20.glDeleteFramebuffers((int)this.mFrameBuffers.length, (int[])this.mFrameBuffers, (int)0);
            this.mFrameBuffers = null;
        }
    }

    @Override
    public void onOutputSizeChanged(int width, int height) {
        int i;
        super.onOutputSizeChanged(width, height);
        if (this.mFrameBuffers != null) {
            this.destroyFramebuffers();
        }
        int size = this.mFilters.size();
        for (i = 0; i < size; ++i) {
            this.mFilters.get(i).onOutputSizeChanged(width, height);
        }
        if (this.mMergedFilters != null && this.mMergedFilters.size() > 0) {
            size = this.mMergedFilters.size();
            this.mFrameBuffers = new int[size];
            this.mFrameBufferTextures = new int[size];
            for (i = 0; i < size; ++i) {
                GLES20.glGenTextures((int)1, (int[])this.mFrameBufferTextures, (int)i);
                GLES20.glGenFramebuffers((int)1, (int[])this.mFrameBuffers, (int)i);
                GLES20.glBindTexture((int)3553, (int)this.mFrameBufferTextures[i]);
                GLES20.glTexImage2D((int)3553, (int)0, (int)6408, (int)width, (int)height, (int)0, (int)6408, (int)5121, null);
                GLES20.glTexParameterf((int)3553, (int)10240, (float)9729.0f);
                GLES20.glTexParameterf((int)3553, (int)10241, (float)9729.0f);
                GLES20.glTexParameterf((int)3553, (int)10242, (float)33071.0f);
                GLES20.glTexParameterf((int)3553, (int)10243, (float)33071.0f);
                GLES20.glBindFramebuffer((int)36160, (int)this.mFrameBuffers[i]);
                GLES20.glFramebufferTexture2D((int)36160, (int)36064, (int)3553, (int)this.mFrameBufferTextures[i], (int)0);
                GLES20.glBindTexture((int)3553, (int)0);
                GLES20.glBindFramebuffer((int)36160, (int)0);
            }
        }
    }

    @Override
    public void onDraw(int textureId, FloatBuffer cubeBuffer, FloatBuffer textureBuffer, int textureTarget, float[] texMatrix, boolean background) {
        this.runPendingOnDrawTasks();
        if (!this.isInitialized() || this.mFrameBuffers == null || this.mFrameBufferTextures == null) {
            return;
        }
        if (this.mMergedFilters != null) {
            int size = this.mMergedFilters.size();
            int previousTexture = textureId;
            for (int i = 0; i < size; ++i) {
                GPUImageFilter filter = this.mMergedFilters.get(i);
                if (filter instanceof GPUImageSTBeautyFilter3) {
                    ((GPUImageSTBeautyFilter3)filter).setMidImageTextureId(previousTexture);
                    previousTexture = this.mFrameBufferTextures[0];
                }
                GLES20.glBindFramebuffer((int)36160, (int)this.mFrameBuffers[i]);
                GLES20.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
                if (i == 0) {
                    if (Build.VERSION.SDK_INT >= 15) {
                        filter.onDraw(previousTexture, cubeBuffer, textureBuffer, 36197, texMatrix, false);
                    }
                } else if (i == size - 1) {
                    filter.onDraw(previousTexture, this.mGLCubeBuffer, size % 2 == 0 ? this.mGLTextureFlipBuffer : this.mGLTextureBuffer, 3553, Constant.mtxIdentity, false);
                } else {
                    filter.onDraw(previousTexture, this.mGLCubeBuffer, this.mGLTextureBuffer, 3553, Constant.mtxIdentity, false);
                }
                if (i >= size - 1) continue;
                GLES20.glBindFramebuffer((int)36160, (int)0);
                previousTexture = this.mFrameBufferTextures[i];
            }
        }
    }

    public void onPreviewDraw(int textureId, FloatBuffer cubeBuffer, FloatBuffer textureBuffer) {
        this.runPendingOnDrawTasks();
        if (!this.isInitialized() || this.mFrameBuffers == null || this.mFrameBufferTextures == null) {
            return;
        }
        if (this.mMergedFilters != null) {
            int size = this.mMergedFilters.size();
            int previousTexture = textureId;
            for (int i = 0; i < size; ++i) {
                boolean isNotLast;
                GPUImageFilter filter = this.mMergedFilters.get(i);
                boolean bl = isNotLast = i < size - 1;
                if (isNotLast) {
                    GLES20.glBindFramebuffer((int)36160, (int)this.mFrameBuffers[i]);
                    GLES20.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
                }
                if (i == 0) {
                    if (Build.VERSION.SDK_INT >= 15) {
                        filter.onDraw(previousTexture, cubeBuffer, textureBuffer, 36197, Constant.mtxIdentity, false);
                    }
                } else if (i == size - 1) {
                    filter.onDraw(previousTexture, this.mGLCubeBuffer, size % 2 == 0 ? this.mGLTextureFlipBuffer : this.mGLTextureBuffer, 3553, Constant.mtxIdentity, false);
                } else {
                    filter.onDraw(previousTexture, this.mGLCubeBuffer, this.mGLTextureBuffer, 3553, Constant.mtxIdentity, false);
                }
                if (!isNotLast) continue;
                GLES20.glBindFramebuffer((int)36160, (int)0);
                previousTexture = this.mFrameBufferTextures[i];
            }
        }
    }

    @Override
    public int getLastTextureID() {
        if (this.mMergedFilters != null) {
            int size = this.mMergedFilters.size();
            return this.mFrameBufferTextures[size - 1];
        }
        return 0;
    }

    public List<GPUImageFilter> getFilters() {
        return this.mFilters;
    }

    public List<GPUImageFilter> getMergedFilters() {
        return this.mMergedFilters;
    }

    public void updateMergedFilters() {
        if (this.mFilters == null) {
            return;
        }
        if (this.mMergedFilters == null) {
            this.mMergedFilters = new ArrayList<GPUImageFilter>();
        } else {
            this.mMergedFilters.clear();
        }
        for (GPUImageFilter filter : this.mFilters) {
            if (filter instanceof GPUImageFilterGroup) {
                ((GPUImageFilterGroup)filter).updateMergedFilters();
                List<GPUImageFilter> filters = ((GPUImageFilterGroup)filter).getMergedFilters();
                if (filters == null || filters.isEmpty()) continue;
                this.mMergedFilters.addAll(filters);
                continue;
            }
            this.mMergedFilters.add(filter);
        }
    }
}

